/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.communicationpce;

import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.pce.server.NotificationDispatcher;
import es.tid.pce.server.PCEServerParameters;
import es.tid.pce.server.communicationpce.BackupPCESession;
import es.tid.pce.server.communicationpce.CollaborationPCESessionManager;
import es.tid.tedb.TEDB;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupSessionManagerTask
extends TimerTask {
    private PCEServerParameters params;
    private BackupPCESession backupPCESession;
    private TEDB ted;
    private Logger log;
    private LinkedBlockingQueue<PCEPMessage> sendingQueue;
    NotificationDispatcher notificationDispatcher;
    CollaborationPCESessionManager collaborationPCESessionManager;
    PCEPSessionsInformation pcepSessionInformation;

    public BackupSessionManagerTask(PCEServerParameters params, TEDB ted, CollaborationPCESessionManager collaborationPCESessionManager, NotificationDispatcher notificationDispatcher, PCEPSessionsInformation pcepSessionInformation) {
        this.params = params;
        this.ted = ted;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.pcepSessionInformation = pcepSessionInformation;
        this.collaborationPCESessionManager = collaborationPCESessionManager;
        this.notificationDispatcher = notificationDispatcher;
        this.sendingQueue = new LinkedBlockingQueue();
    }

    @Override
    public void run() {
        if (this.backupPCESession != null) {
            if (this.backupPCESession.isAlive()) {
                if (this.backupPCESession.isInterrupted()) {
                    this.log.error("THREAD VIVO... SESION DE BACKUP MUERTA");
                }
                return;
            }
            this.log.error("Session with backup PCE dead, trying to establish new session");
            Timer timer = new Timer();
            this.backupPCESession = new BackupPCESession(this.params.getIpPrimaryPCE(), this.params.getPortPrimaryPCE(), this.params.isNodelay(), this.ted, this.collaborationPCESessionManager, this.notificationDispatcher, timer, this.pcepSessionInformation);
            this.backupPCESession.start();
            return;
        }
        this.log.error("No Session with backup PCE, trying to establish new session");
        Timer timer = new Timer();
        this.backupPCESession = new BackupPCESession(this.params.getIpPrimaryPCE(), this.params.getPortPrimaryPCE(), this.params.isNodelay(), this.ted, this.collaborationPCESessionManager, this.notificationDispatcher, timer, this.pcepSessionInformation);
        this.backupPCESession.start();
        this.log.error("Adding a new session in sessionManagerList");
    }

    public boolean PPCESessionStatus() {
        return this.backupPCESession.isAlive();
    }

    public int PPCESessionState() {
        return this.backupPCESession.getFSMstate();
    }
}

