/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.communicationpce;

import es.tid.pce.pcepsession.GenericPCEPSession;
import es.tid.pce.server.communicationpce.PCESessionInformation;
import java.io.DataOutputStream;
import java.net.Inet4Address;
import java.util.Hashtable;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenedSessionsManager {
    private Logger log;
    private Hashtable<Inet4Address, PCESessionInformation> addressPCESessionInfo = new Hashtable();
    private LinkedList<PCESessionInformation> sessionInfoList = new LinkedList();

    public OpenedSessionsManager() {
        this.log = LoggerFactory.getLogger((String)"PCEServer");
    }

    public void registerNewSession(GenericPCEPSession pceSession, int roll) {
        PCESessionInformation info = new PCESessionInformation();
        info.setRollSession(roll);
        info.setOut(pceSession.getOut());
        this.sessionInfoList.add(info);
    }

    public void registerNewSession(Inet4Address address, DataOutputStream out, int roll) {
        PCESessionInformation info = new PCESessionInformation();
        info.setRollSession(roll);
        info.setOut(out);
        if (address != null) {
            this.log.info("pceId " + address);
            if (this.addressPCESessionInfo.containsKey(address)) {
                this.addressPCESessionInfo.remove(address);
            }
            this.addressPCESessionInfo.put(address, info);
        } else {
            this.log.warn("Address is null, impossible to register a new session");
        }
    }

    public void registerNewSession(DataOutputStream out, int roll) {
        this.log.info("Register new session");
        PCESessionInformation info = new PCESessionInformation();
        info.setRollSession(roll);
        info.setOut(out);
        this.sessionInfoList.add(info);
    }

    public void removeSession(GenericPCEPSession pceSession) {
    }

    public Hashtable<Inet4Address, PCESessionInformation> getAddressPCESessionInfo() {
        return this.addressPCESessionInfo;
    }

    public void setAddressPCESessionInfo(Hashtable<Inet4Address, PCESessionInformation> addressPCESessionInfo) {
        this.addressPCESessionInfo = addressPCESessionInfo;
    }

    public LinkedList<PCESessionInformation> getSessionInfoList() {
        return this.sessionInfoList;
    }

    public void setSessionInfoList(LinkedList<PCESessionInformation> sessionInfoList) {
        this.sessionInfoList = sessionInfoList;
    }
}

