/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.comunicationvntm;

import es.tid.of.DataPathID;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.pcep.objects.EndPointDataPathID;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.SRP;
import es.tid.pce.pcepsession.DeadTimerThread;
import es.tid.pce.pcepsession.GenericPCEPSession;
import es.tid.pce.pcepsession.KeepAliveThread;
import es.tid.pce.pcepsession.PCEPSessionsInformation;
import es.tid.rsvp.objects.subobjects.OpenFlowUnnumberIfIDEROSubobject;
import es.tid.util.UtilsFunctions;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Timer;
import org.slf4j.LoggerFactory;

public class PCEPClientSession
extends GenericPCEPSession {
    String source = null;
    String dest = null;
    private PCEPReport report;
    private int messagetype;
    private String operation;
    private String sourceMAC;
    private String destMAC;
    private int source_interface;
    private int destination_interface;
    private long lspid;

    public PCEPReport getReport() {
        return this.report;
    }

    public PCEPClientSession(Socket s, PCEPSessionsInformation pcepSessionManager) {
        super(pcepSessionManager);
        this.socket = s;
        this.log = LoggerFactory.getLogger((String)"ABNO Controller");
        this.timer = new Timer();
        this.keepAliveLocal = 30;
        this.deadTimerLocal = 180;
    }

    public PCEPClientSession(Socket s, PCEPSessionsInformation pcepSessionManager, String sourceMAC, String destMAC, int source_interface, int destination_interface, String operation, int messagetype) {
        super(pcepSessionManager);
        this.socket = s;
        this.log = LoggerFactory.getLogger((String)"ABNO Controller");
        this.timer = new Timer();
        this.keepAliveLocal = 30;
        this.deadTimerLocal = 180;
        this.sourceMAC = sourceMAC;
        this.destMAC = destMAC;
        this.source_interface = source_interface;
        this.destination_interface = destination_interface;
        this.operation = operation;
        this.messagetype = messagetype;
    }

    @Override
    public void run() {
        this.initializePCEPSession(false, 30, 1000, false, false, null, null, 0);
        this.log.info("VNTM Session succesfully established!!");
        this.deadTimerT = new DeadTimerThread(this, this.deadTimerLocal);
        this.startDeadTimer();
        this.keepAliveT = new KeepAliveThread(this.out, this.keepAliveLocal);
        this.startKeepAlive();
        this.normalWF();
    }

    private void normalWF() {
        PCEPInitiate pr = new PCEPInitiate();
        pr.setMessageType(this.messagetype);
        try {
            OpenFlowUnnumberIfIDEROSubobject eroSubSource = new OpenFlowUnnumberIfIDEROSubobject();
            eroSubSource.setSwitchID(this.sourceMAC);
            eroSubSource.setInterfaceID(0L);
            OpenFlowUnnumberIfIDEROSubobject eroSubDest = new OpenFlowUnnumberIfIDEROSubobject();
            eroSubDest.setSwitchID(this.destMAC);
            eroSubDest.setInterfaceID(0L);
            pr.setPcepIntiatedLSPList(new LinkedList());
            PCEPIntiatedLSP ilsp = new PCEPIntiatedLSP();
            pr.getPcepIntiatedLSPList().add(ilsp);
            ((PCEPIntiatedLSP)pr.getPcepIntiatedLSPList().get(0)).setEro(new ExplicitRouteObject());
            ((PCEPIntiatedLSP)pr.getPcepIntiatedLSPList().get(0)).setLsp(new LSP());
            ((PCEPIntiatedLSP)pr.getPcepIntiatedLSPList().get(0)).setRsp(new SRP());
            ((PCEPIntiatedLSP)pr.getPcepIntiatedLSPList().get(0)).getRsp().setRFlag(false);
            ((PCEPIntiatedLSP)pr.getPcepIntiatedLSPList().get(0)).getLsp().setLspId((int)this.lspid);
            EndPointDataPathID ep = new EndPointDataPathID();
            DataPathID dpid = new DataPathID();
            dpid.setDataPathID(this.sourceMAC);
            DataPathID dpid_d = new DataPathID();
            dpid_d.setDataPathID(this.destMAC);
            ep.setSourceSwitchID(dpid);
            ep.setDestSwitchID(dpid_d);
            ((PCEPIntiatedLSP)pr.getPcepIntiatedLSPList().get(0)).setEndPoint((EndPoints)ep);
            System.out.println("Vamos a enviar" + pr.toString());
            System.out.println("VNTMClient: Sending request...");
            pr.encode();
            this.sendRequest(this.out, (PCEPMessage)pr);
            try {
                System.out.println("VNTMClient: Waiting for Response...");
                byte[] msg = this.readMsg(this.in);
                System.out.println("VNTMClient: DONE!");
                this.report = new PCEPReport(msg);
                this.log.info("Report Receive: " + this.report.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.endConnections();
        }
        catch (Exception e) {
            System.out.println("something happens");
            this.log.info(UtilsFunctions.exceptionToString(e));
        }
    }

    private void sendRequest(DataOutputStream out, PCEPMessage reportconf) {
        try {
            if (out == null) {
                System.out.println("El out es null!!!");
            } else {
                this.log.info("Sending request to VNTM");
                this.log.info("reportconf::" + reportconf.toString());
                out.write(reportconf.getBytes());
                out.flush();
            }
        }
        catch (IOException e) {
            this.log.info(UtilsFunctions.exceptionToString(e));
        }
    }

    @Override
    protected void endSession() {
    }

    @Override
    protected byte[] readMsg(DataInputStream in) throws IOException {
        byte[] ret = null;
        byte[] hdr = new byte[4];
        byte[] temp = null;
        boolean endHdr = false;
        int r = 0;
        int length = 0;
        boolean endMsg = false;
        int offset = 0;
        while (!endMsg) {
            try {
                r = endHdr ? in.read(temp, offset, 1) : in.read(hdr, offset, 1);
            }
            catch (IOException e) {
                this.log.warn("Error reading data: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.log.warn("readMsg Oops: " + e.getMessage());
                throw new IOException();
            }
            if (r > 0) {
                if (offset == 2) {
                    length = (hdr[offset] & 0xFF) << 8;
                }
                if (offset == 3) {
                    temp = new byte[length |= hdr[offset] & 0xFF];
                    endHdr = true;
                    System.arraycopy(hdr, 0, temp, 0, 4);
                }
                if (length > 0 && offset == length - 1) {
                    endMsg = true;
                }
                ++offset;
                continue;
            }
            if (r != -1) continue;
            this.log.warn("End of stream has been reached");
            throw new IOException();
        }
        if (length > 0) {
            ret = new byte[length];
            System.arraycopy(temp, 0, ret, 0, length);
        }
        return ret;
    }
}

