/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.management;

import es.tid.pce.computingEngine.RequestDispatcher;
import es.tid.pce.computingEngine.RequestProcessorThread;
import es.tid.pce.computingEngine.algorithms.ComputingAlgorithmManager;
import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.PCEPIntiatedLSP;
import es.tid.pce.pcep.constructs.Path;
import es.tid.pce.pcep.constructs.Request;
import es.tid.pce.pcep.constructs.StateReport;
import es.tid.pce.pcep.constructs.UpdateRequest;
import es.tid.pce.pcep.messages.PCEPInitiate;
import es.tid.pce.pcep.messages.PCEPMessage;
import es.tid.pce.pcep.messages.PCEPReport;
import es.tid.pce.pcep.messages.PCEPRequest;
import es.tid.pce.pcep.messages.PCEPUpdate;
import es.tid.pce.pcep.objects.Bandwidth;
import es.tid.pce.pcep.objects.BandwidthRequested;
import es.tid.pce.pcep.objects.EndPoints;
import es.tid.pce.pcep.objects.EndPointsIPv4;
import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.LSP;
import es.tid.pce.pcep.objects.ObjectParameters;
import es.tid.pce.pcep.objects.ObjectiveFunction;
import es.tid.pce.pcep.objects.RequestParameters;
import es.tid.pce.pcep.objects.SRP;
import es.tid.pce.pcep.objects.XifiUniCastEndPoints;
import es.tid.pce.pcep.objects.tlvs.IPv4LSPIdentifiersTLV;
import es.tid.pce.pcep.objects.tlvs.LSPDatabaseVersionTLV;
import es.tid.pce.pcep.objects.tlvs.SymbolicPathNameTLV;
import es.tid.pce.server.DomainPCESession;
import es.tid.pce.server.PCEServerParameters;
import es.tid.pce.server.communicationpce.CollaborationPCESessionManager;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import es.tid.tedb.DomainTEDB;
import es.tid.util.UtilsFunctions;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEManagementSession
extends Thread {
    private boolean started = false;
    private Socket socket;
    private Logger log;
    private RequestDispatcher requestDispatcher;
    private PrintStream out;
    private DomainTEDB tedb;
    private ReservationManager reservationManager;
    CollaborationPCESessionManager collaborationPCESessionManager;
    PCEServerParameters params;
    public static ArrayList<DomainPCESession> oneSession = new ArrayList();

    public PCEManagementSession(Socket s, RequestDispatcher requestDispatcher, DomainTEDB tedb, ReservationManager reservationManager, CollaborationPCESessionManager collaborationPCESessionManager) {
        this.socket = s;
        this.requestDispatcher = requestDispatcher;
        this.tedb = tedb;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.reservationManager = reservationManager;
        this.collaborationPCESessionManager = collaborationPCESessionManager;
    }

    public PCEManagementSession(Socket s, RequestDispatcher requestDispatcher, DomainTEDB tedb, ReservationManager reservationManager, CollaborationPCESessionManager collaborationPCESessionManager, PCEServerParameters params) {
        this.socket = s;
        this.requestDispatcher = requestDispatcher;
        this.tedb = tedb;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.reservationManager = reservationManager;
        this.collaborationPCESessionManager = collaborationPCESessionManager;
        this.params = params;
    }

    @Override
    public void run() {
        this.log.info("Starting Management session");
        boolean running = true;
        try {
            this.out = new PrintStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.log.warn("Management session cancelled: " + e.getMessage());
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            while (running) {
                if (!this.started) {
                    this.out.print("\n");
                    this.out.print("   P               ,\r\n");
                    this.out.print("   C               |'.             ,\r\n");
                    this.out.print("   E               |  '-._        / )\r\n");
                    this.out.print("                 .'  .._  ',     /_'-,\r\n");
                    this.out.print("   C            '   /  _'.'_\\   /._)')\r\n");
                    this.out.print("   O           :   /  '_' '_'  /  _.'\r\n");
                    this.out.print("   N           |E |   |Q| |Q| /   /\r\n");
                    this.out.print("   T          .'  _\\  '-' '-'    /\r\n");
                    this.out.print("   R        .'--.(S     ,__` )  /\r\n");
                    this.out.print("   O              '-.     _.'  /\r\n");
                    this.out.print("   L            __.--'----(   /\r\n");
                    this.out.print("   L        _.-'     :   __\\ /\r\n");
                    this.out.print("   E       (      __.' :'  :Y\r\n");
                    this.out.print("   R        '.   '._,  :   :|\r\n");
                    this.out.print("              '.     ) :.__:|\r\n");
                    this.out.print("                \\    \\______/\r\n");
                    this.out.print("                 '._L/_H____]\r\n");
                    this.out.print("                  /_        /\r\n");
                    this.out.print("                 /  '-.__.-')\r\n");
                    this.out.print("                :      /   /\r\n");
                    this.out.print("                :     /   /\r\n");
                    this.out.print("              ,/_____/----;\r\n");
                    this.out.print("              '._____)----'\r\n");
                    this.out.print("              /     /   /\r\n");
                    this.out.print("             /     /   /\r\n");
                    this.out.print("           .'     /    \\\r\n");
                    this.out.print("          (______(-.____)\r\n");
                    this.out.print("***********************************************\n");
                    this.started = true;
                }
                this.out.print("Available commands:\r\n\n");
                this.out.print("\t1) show parent pce\r\n");
                this.out.print("\t2) show algorithms list\r\n");
                this.out.print("\t3) show topology\r\n");
                this.out.print("\t4) queue size\r\n");
                this.out.print("\t5) res size\r\n");
                this.out.print("\t6) show reachability\r\n");
                this.out.print("\t7) show lsps\r\n");
                this.out.print("\t8) send FAKE initiate\r\n");
                this.out.print("\t9) send report\r\n");
                this.out.print("\t10) send update \r\n");
                this.out.print("\n\tENTER) quit\r\n");
                this.out.print("PCE:>");
                String command = null;
                try {
                    command = br.readLine();
                }
                catch (IOException ioe) {
                    this.log.warn("IO error trying to read your command");
                    return;
                }
                if (command == null) continue;
                if (command.equals("quit") || command.equals("")) {
                    this.log.info("Ending Management Session");
                    this.out.println("bye!");
                    try {
                        this.out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        br.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (command.equals("show parent pce") || command.equals("1")) continue;
                if (command.equals("show algorithms list") || command.equals("show algo list") || command.equals("2")) {
                    RequestProcessorThread[] threads = this.requestDispatcher.getThreads();
                    String info = "";
                    if (threads.length > 0) {
                        Hashtable<Integer, ComputingAlgorithmManager> htcaSingle = threads[0].getSingleAlgorithmList();
                        Enumeration<Integer> keys = htcaSingle.keys();
                        while (keys.hasMoreElements()) {
                            Integer inte = keys.nextElement();
                            info = info + "OF =" + inte + "; ";
                        }
                        Hashtable<Integer, ComputingAlgorithmManager> htcaSvec = threads[0].getSvecAlgorithmList();
                        Enumeration<Integer> keys2 = htcaSvec.keys();
                        while (keys2.hasMoreElements()) {
                            Integer inte = keys2.nextElement();
                            info = info + "OF =" + inte + "and SVEC; ";
                        }
                    }
                    this.out.print(info + "\r\n");
                    continue;
                }
                if (command.equals("show topology") || command.equals("3")) {
                    this.out.print(this.tedb.printTopology());
                    continue;
                }
                if (command.equals("queue size") || command.equals("4")) {
                    this.out.println("num pets " + this.requestDispatcher.queueSize());
                    this.out.println("num petsR " + this.requestDispatcher.retryQueueSize());
                    continue;
                }
                if (command.equals("res size") || command.equals("5")) {
                    this.out.println("num perm res " + this.reservationManager.getReservationQueueSize());
                    continue;
                }
                if (command.equals("show reachability") || command.equals("6")) {
                    this.out.println(this.tedb.getReachabilityEntry().getPrefix());
                    continue;
                }
                if (command.equals("show lsps") || command.equals("7")) {
                    this.out.println("Enjoy watching the LSPs the PCE has in his database");
                    continue;
                }
                if (command.equals("send initiate") || command.equals("8")) {
                    this.out.println("Sending between 192.168.1.1 and 192.168.1.4");
                    String string_ip_source = "192.168.1.1";
                    String string_ip_dest = "192.168.1.3";
                    Inet4Address ip_source = (Inet4Address)InetAddress.getByName(string_ip_source);
                    Inet4Address ip_dest = (Inet4Address)InetAddress.getByName(string_ip_dest);
                    PCEPInitiate pceInit = new PCEPInitiate();
                    PCEPIntiatedLSP pcepIntiatedLSPList = new PCEPIntiatedLSP();
                    SRP rsp = new SRP();
                    pcepIntiatedLSPList.setRsp(rsp);
                    LSP lsp = new LSP();
                    lsp.setLspId(0);
                    pcepIntiatedLSPList.setLsp(lsp);
                    EndPointsIPv4 endP_IP = new EndPointsIPv4();
                    endP_IP.setSourceIP(ip_source);
                    endP_IP.setDestIP(ip_dest);
                    pcepIntiatedLSPList.setEndPoint((EndPoints)endP_IP);
                    ExplicitRouteObject ero = new ExplicitRouteObject();
                    UnnumberIfIDEROSubobject eroso1 = new UnnumberIfIDEROSubobject();
                    eroso1.setInterfaceID(1L);
                    eroso1.setRouterID(ip_source);
                    UnnumberIfIDEROSubobject eroso2 = new UnnumberIfIDEROSubobject();
                    eroso2.setInterfaceID(3L);
                    eroso2.setRouterID(ip_dest);
                    IPv4prefixEROSubobject eroso3 = new IPv4prefixEROSubobject();
                    eroso3.setIpv4address((Inet4Address)InetAddress.getByName("192.168.1.4"));
                    eroso3.setPrefix(32);
                    ero.addEROSubobject((EROSubobject)eroso1);
                    ero.addEROSubobject((EROSubobject)eroso2);
                    ero.addEROSubobject((EROSubobject)eroso3);
                    pcepIntiatedLSPList.setEro(ero);
                    pceInit.getPcepIntiatedLSPList().add(pcepIntiatedLSPList);
                    oneSession.get(0).sendPCEPMessage((PCEPMessage)pceInit);
                    continue;
                }
                if (command.equals("send report")) {
                    this.log.info("Sending Repoooort");
                    this.log.info("Sending to :" + oneSession.get(0).getSocket().getInetAddress());
                    PCEPReport rpt = new PCEPReport();
                    rpt.setStateReportList(new LinkedList());
                    rpt.getStateReportList().add(new StateReport());
                    ((StateReport)rpt.getStateReportList().get(0)).setLSP(new LSP());
                    ((StateReport)rpt.getStateReportList().get(0)).setSRP(new SRP());
                    ((StateReport)rpt.getStateReportList().get(0)).setPath(new Path());
                    ((StateReport)rpt.getStateReportList().get(0)).getPath().setEro(new ExplicitRouteObject());
                    try {
                        rpt.encode();
                        oneSession.get(0).sendPCEPMessage((PCEPMessage)rpt);
                    }
                    catch (PCEPProtocolViolationException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (command.equals("send wlan") || command.equals("10")) {
                    PCEPRequest pReq = new PCEPRequest();
                    LinkedList svecList = new LinkedList();
                    pReq.setSvecList(svecList);
                    Request req = new Request();
                    RequestParameters reqParams = new RequestParameters();
                    reqParams.setBidirect(false);
                    reqParams.setPrio(1);
                    reqParams.setRequestID(1L);
                    req.setRequestParameters(reqParams);
                    XifiUniCastEndPoints endP = new XifiUniCastEndPoints();
                    endP.setSwitchSourceID("00:14:2c:59:e5:5e");
                    endP.setSwitchDestinationID("00:14:2c:59:e5:66");
                    req.setEndPoints((EndPoints)endP);
                    ObjectiveFunction obFunc = new ObjectiveFunction();
                    obFunc.setOFcode(1003);
                    req.setObjectiveFunction(obFunc);
                    LinkedList<Request> reqList = new LinkedList<Request>();
                    reqList.add(req);
                    Socket socket = new Socket("localhost", 4444);
                    pReq.setRequestList(reqList);
                    this.requestDispatcher.dispathRequests(pReq, new DataOutputStream(socket.getOutputStream()));
                    this.out.print("PCEPRequest sent to dispatcher!\r\n");
                    continue;
                }
                if (command.equals("help")) {
                    this.out.print("1) show parent pce\r\n");
                    this.out.print("2) show algorithms list\r\n");
                    this.out.print("3) show topology\r\n");
                    this.out.print("4) queue size\r\n");
                    this.out.print("5) res size\r\n");
                    this.out.print("6) show reachability\r\n");
                    this.out.print("7) show lsps\r\n");
                    this.out.print("8) send initiate\r\n");
                    this.out.print("9) send report\r\n");
                    this.out.print("10) send update \r\n");
                    this.out.print("0) quit\r\n");
                    continue;
                }
                this.out.print("invalid command\n");
                this.out.print("\n");
            }
        }
        catch (Exception e) {
            this.log.info(UtilsFunctions.exceptionToString(e));
            return;
        }
    }

    private void easySendUpdate(LSPTEInfo val, DomainPCESession dm) throws UnknownHostException {
        PCEPUpdate update = new PCEPUpdate();
        for (int i = 0; i < val.pcepReport.getStateReportList().size(); ++i) {
            StateReport report = (StateReport)val.pcepReport.getStateReportList().get(i);
            update.getUpdateRequestList().add(new UpdateRequest());
            ((UpdateRequest)update.getUpdateRequestList().get(i)).setLsp(report.getLSP());
            ((UpdateRequest)update.getUpdateRequestList().get(i)).setSrp(report.getSRP());
            ((UpdateRequest)update.getUpdateRequestList().get(i)).setPath(report.getPath());
        }
        dm.sendPCEPMessage((PCEPMessage)update);
        this.out.println("Update message sent!");
    }

    private void sendUpdate(LSPTEInfo val) throws UnknownHostException {
        SRP rsp = new SRP();
        rsp.setSRP_ID_number(1L);
        SymbolicPathNameTLV symPathName = new SymbolicPathNameTLV();
        symPathName.setSymbolicPathNameID(ObjectParameters.redundancyID);
        rsp.setSymPathName(symPathName);
        PCEPUpdate m_update = new PCEPUpdate();
        UpdateRequest state_report = new UpdateRequest();
        LSP lsp = new LSP();
        lsp.setDFlag(true);
        lsp.setSFlag(false);
        lsp.setOpFlags(1);
        lsp.setLspId(1);
        IPv4LSPIdentifiersTLV lspIdTLV = new IPv4LSPIdentifiersTLV();
        lspIdTLV.setTunnelID(1234);
        lspIdTLV.setTunnelSenderIPAddress((Inet4Address)Inet4Address.getLocalHost());
        lsp.setLspIdentifiers_tlv(lspIdTLV);
        SymbolicPathNameTLV symbPathName = new SymbolicPathNameTLV();
        symbPathName.setSymbolicPathNameID(ByteBuffer.allocate(8).putLong(lsp.getLspId()).array());
        lsp.setSymbolicPathNameTLV_tlv(symbPathName);
        LSPDatabaseVersionTLV lspdDTLV = new LSPDatabaseVersionTLV();
        lspdDTLV.setLSPStateDBVersion(2L);
        state_report.setLsp(lsp);
        state_report.setSrp(rsp);
        Path path = new Path();
        ExplicitRouteObject auxERO = new ExplicitRouteObject();
        path.setEro(auxERO);
        BandwidthRequested bw = new BandwidthRequested();
        bw.setBw(1.0f);
        path.setBandwidth((Bandwidth)bw);
        state_report.setPath(path);
        m_update.addStateReport(state_report);
        this.out.println("Sending First PCEPUpdate message");
    }

    public class LSPTEInfo {
        public PCEPReport pcepReport;

        LSPTEInfo(PCEPReport pcepReport) {
            this.pcepReport = pcepReport;
        }
    }
}

