/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.management;

import es.tid.pce.computingEngine.RequestDispatcher;
import es.tid.pce.server.PCEServerParameters;
import es.tid.pce.server.communicationpce.CollaborationPCESessionManager;
import es.tid.pce.server.management.PCEManagementSession;
import es.tid.pce.server.wson.ReservationManager;
import es.tid.tedb.DomainTEDB;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEManagementSever
extends Thread {
    private Logger log = LoggerFactory.getLogger((String)"PCEServer");
    private RequestDispatcher requestDispatcher;
    private DomainTEDB tedb;
    private PCEServerParameters params;
    private ReservationManager reservationManager;
    private CollaborationPCESessionManager collaborationPCESessionManager;
    private ServerSocket serverSocket;
    private boolean listening = true;

    public PCEManagementSever(RequestDispatcher requestDispatcher, DomainTEDB tedb, PCEServerParameters params, ReservationManager reservationManager) {
        this.requestDispatcher = requestDispatcher;
        this.tedb = tedb;
        this.params = params;
        this.reservationManager = reservationManager;
    }

    public PCEManagementSever(RequestDispatcher requestDispatcher, DomainTEDB tedb, PCEServerParameters params, ReservationManager reservationManager, CollaborationPCESessionManager collaborationPCESessionManager) {
        this.requestDispatcher = requestDispatcher;
        this.tedb = tedb;
        this.params = params;
        this.reservationManager = reservationManager;
        this.collaborationPCESessionManager = collaborationPCESessionManager;
    }

    @Override
    public void run() {
        try {
            this.log.info("Listening on port " + this.params.getPCEManagementPort());
            this.serverSocket = new ServerSocket(this.params.getPCEManagementPort(), 0, (Inet4Address)InetAddress.getByName(this.params.getLocalPceAddress()));
        }
        catch (Exception e) {
            this.log.error("Could not listen management on port " + this.params.getPCEManagementPort());
            e.printStackTrace();
            return;
        }
        try {
            while (this.listening) {
                new PCEManagementSession(this.serverSocket.accept(), this.requestDispatcher, this.tedb, this.reservationManager, this.collaborationPCESessionManager, this.params).start();
            }
            this.serverSocket.close();
        }
        catch (SocketException e) {
            if (!this.listening) {
                this.log.info("Socket closed due to controlled close");
            } else {
                this.log.error("Problem with the socket, exiting");
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopServer() {
        this.listening = false;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

