/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.server.wson;

import es.tid.pce.server.wson.DeleteReservationTask;
import es.tid.tedb.DomainTEDB;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservationManager {
    ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private DomainTEDB ted;
    private Logger log;
    private long reservationID;
    private Hashtable<Long, DeleteReservationTask> permanentReservationList;
    private Hashtable<Long, ScheduledFuture> scheduledReservationList;

    public ReservationManager(DomainTEDB ted) {
        this.ted = ted;
        this.log = LoggerFactory.getLogger((String)"PCEServer");
        this.reservationID = 0L;
        this.permanentReservationList = new Hashtable();
    }

    public long reserve(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, long time, boolean bidirectional) {
        this.log.info("Reserving lambda " + wavelength + " for " + time + " miliseconds");
        this.ted.notifyWavelengthReservation(sourceVertexList, targetVertexList, wavelength, bidirectional);
        DeleteReservationTask drt = new DeleteReservationTask();
        drt.setSourceVertexList(sourceVertexList);
        drt.setTargetVertexList(targetVertexList);
        drt.setWavelength(wavelength);
        drt.setBidirectional(bidirectional);
        drt.setTed(this.ted);
        long idReservation = this.getReservationID();
        if (time >= 0xFFFFFFFFL) {
            this.log.info("Permanent Reservation");
            this.permanentReservationList.put(idReservation, drt);
        } else {
            this.log.info("Something will be reserved");
            ScheduledFuture<?> sf = this.executor.schedule(drt, time, TimeUnit.MILLISECONDS);
        }
        return idReservation;
    }

    public long reserve(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, LinkedList<Integer> wlans, long time, boolean bidirectional, int m) {
        this.ted.notifyWavelengthReservationWLAN(sourceVertexList, targetVertexList, wlans, bidirectional);
        DeleteReservationTask drt = new DeleteReservationTask();
        drt.setSourceVertexList(sourceVertexList);
        drt.setTargetVertexList(targetVertexList);
        drt.setM(m);
        drt.setWLANs(wlans);
        drt.setBidirectional(bidirectional);
        drt.setTed(this.ted);
        long idReservation = this.getReservationID();
        if (time >= 0xFFFFFFFFL) {
            this.log.info("Permanent Reservation");
            this.permanentReservationList.put(idReservation, drt);
        } else {
            this.log.info("Derreservar lambda en:" + time);
            ScheduledFuture<?> sf = this.executor.schedule(drt, time, TimeUnit.MILLISECONDS);
        }
        return idReservation;
    }

    public long reserve(LinkedList<Object> sourceVertexList, LinkedList<Object> targetVertexList, int wavelength, long time, boolean bidirectional, int m) {
        this.ted.notifyWavelengthReservationSSON(sourceVertexList, targetVertexList, wavelength, bidirectional, m);
        DeleteReservationTask drt = new DeleteReservationTask();
        drt.setSourceVertexList(sourceVertexList);
        drt.setTargetVertexList(targetVertexList);
        drt.setM(m);
        drt.setWavelength(wavelength);
        drt.setBidirectional(bidirectional);
        drt.setTed(this.ted);
        long idReservation = this.getReservationID();
        if (time >= 0xFFFFFFFFL) {
            this.log.info("Permanent Reservation");
            this.permanentReservationList.put(idReservation, drt);
        } else {
            this.log.info("Derreservar lambda en:" + time);
            ScheduledFuture<?> sf = this.executor.schedule(drt, time, TimeUnit.MILLISECONDS);
        }
        return idReservation;
    }

    public void cancelReservation(long idReservation) {
        DeleteReservationTask drt = this.permanentReservationList.remove(idReservation);
        if (drt != null) {
            drt.run();
        }
    }

    public synchronized long getReservationID() {
        ++this.reservationID;
        return this.reservationID;
    }

    public void cancelAllReservations() {
        Enumeration<DeleteReservationTask> enu = this.permanentReservationList.elements();
        while (enu.hasMoreElements()) {
            DeleteReservationTask drt = enu.nextElement();
            if (drt == null) continue;
            this.executor.execute(drt);
        }
        this.permanentReservationList.clear();
    }

    public long getReservationQueueSize() {
        return this.permanentReservationList.size();
    }

    public DomainTEDB getTed() {
        return this.ted;
    }

    public void setTed(DomainTEDB ted) {
        this.ted = ted;
    }
}

