/*
 * Decompiled with CFR 0.152.
 */
package es.tid.tedb.ospfv2;

import es.tid.ospf.ospfv2.lsa.OSPFTEv2LSA;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSPFSession
extends Thread {
    private DataInputStream in;
    private LinkedBlockingQueue<OSPFTEv2LSA> lsaQueue;
    private Socket ss;
    private Logger log = LoggerFactory.getLogger((String)"OSPFParser");

    public OSPFSession(Socket ss, LinkedBlockingQueue<OSPFTEv2LSA> lsaQueue) {
        this.lsaQueue = lsaQueue;
        this.ss = ss;
    }

    @Override
    public void run() {
        this.log.info("OSPF Socket opened");
        try {
            this.in = new DataInputStream(this.ss.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            while (true) {
                byte[] msg = this.readLSA(this.in);
                this.log.info("OSPF LSA READ");
                OSPFTEv2LSA lsa = new OSPFTEv2LSA(msg, 0);
                this.lsaQueue.put(lsa);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.log.warn("OSPF Socket ends");
            return;
        }
    }

    protected byte[] readLSA(DataInputStream in) throws IOException {
        byte[] ret = null;
        byte[] hdr = new byte[20];
        byte[] temp = null;
        boolean endHdr = false;
        int r = 0;
        int length = 0;
        boolean endMsg = false;
        int offset = 0;
        while (!endMsg) {
            try {
                r = endHdr ? in.read(temp, offset, 1) : in.read(hdr, offset, 1);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException();
            }
            if (r > 0) {
                if (offset == 18) {
                    length = (hdr[offset] & 0xFF) << 8;
                }
                if (offset == 19) {
                    temp = new byte[length |= hdr[offset] & 0xFF];
                    endHdr = true;
                    System.arraycopy(hdr, 0, temp, 0, 20);
                }
                if (length > 0 && offset == length - 1) {
                    endMsg = true;
                }
                ++offset;
                continue;
            }
            if (r != -1) continue;
            throw new IOException();
        }
        if (length > 0) {
            ret = new byte[length];
            System.arraycopy(temp, 0, ret, 0, length);
        }
        return ret;
    }
}

