/*
 * Decompiled with CFR 0.152.
 */
package es.tid.tedb.ospfv2;

import es.tid.ospf.ospfv2.OSPFv2LinkStateUpdatePacket;
import es.tid.ospf.ospfv2.OSPFv2Packet;
import es.tid.rocksaw.net.RawSocket;
import es.tid.tedb.ospfv2.OSPFSession;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSPFSessionServer
extends Thread {
    private LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> ospfv2PacketQueue;
    private LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> redisOspfv2PacketQueue;
    private boolean multicast = false;
    private Inet4Address nodeLocalAddress;
    private static final int TIMEOUT = 0;
    private DataInputStream in;
    private Logger log = LoggerFactory.getLogger((String)"OSPFParser");
    OSPFSession OSPFsession;

    public OSPFSessionServer(LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> ospfv2PacketQueue, Inet4Address NodeLocalAddress) {
        this.ospfv2PacketQueue = ospfv2PacketQueue;
        this.log.info("PCD Address: " + NodeLocalAddress.toString());
        this.nodeLocalAddress = NodeLocalAddress;
    }

    public OSPFSessionServer(LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> ospfv2PacketQueue, LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> redisOspfv2PacketQueue, Inet4Address NodeLocalAddress) {
        this.ospfv2PacketQueue = ospfv2PacketQueue;
        this.redisOspfv2PacketQueue = redisOspfv2PacketQueue;
        this.log.info("PCD Address: " + NodeLocalAddress.toString());
        this.nodeLocalAddress = NodeLocalAddress;
    }

    @Override
    public void run() {
        this.log.info("run ruun");
        boolean tipo = true;
        RawSocket socket = new RawSocket();
        try {
            if (socket.isOpen()) {
                this.log.info("el socket YA esta abierto");
            } else {
                socket.open(RawSocket.PF_INET, 89);
            }
            if (!socket.isOpen()) {
                this.log.info("Error el socket no se ha abierto");
            }
            socket.setUseSelectTimeout(true);
            socket.setSendTimeout(0);
            socket.setReceiveTimeout(0);
            if (this.multicast) {
                String mCast = "224.0.0.5";
                socket.setIPHeaderInclude(false);
                socket.joinGroup(InetAddress.getByName(mCast), (InetAddress)this.nodeLocalAddress);
                this.log.info("OSPF Multicast RAW Socket opened");
            } else {
                socket.bind((InetAddress)this.nodeLocalAddress);
                this.log.info("OSPF Unicast RAW Socket opened");
            }
        }
        catch (IOException e) {
            this.log.error("Exception produced::" + e.toString());
        }
        try {
            while (true) {
                OSPFv2Packet ospfv2Packet;
                if ((ospfv2Packet = this.readOSPFv2Packet(socket)) == null || ospfv2Packet.getType() != 4) {
                    continue;
                }
                this.ospfv2PacketQueue.add((OSPFv2LinkStateUpdatePacket)ospfv2Packet);
                if (this.redisOspfv2PacketQueue == null) continue;
                this.redisOspfv2PacketQueue.add((OSPFv2LinkStateUpdatePacket)ospfv2Packet);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            this.log.warn("OSPF Socket ends::" + e1.toString());
            return;
        }
    }

    public int readVNTMPort() {
        return 7777;
    }

    protected OSPFv2Packet readOSPFv2Packet(RawSocket socket) throws IOException {
        byte[] hdr = new byte[20];
        byte[] temp = null;
        boolean endHdr = false;
        int r = 0;
        int length = 0;
        int offset = 0;
        OSPFv2Packet ospfv2Packet = null;
        length = 1500;
        temp = new byte[length];
        try {
            r = socket.read(temp, 0, length);
        }
        catch (IOException e) {
            this.log.warn("Salgo por excepcion");
            throw e;
        }
        catch (Exception e) {
            throw new IOException();
        }
        offset = 20;
        int type = OSPFv2Packet.getLStype((byte[])temp, (int)offset);
        ospfv2Packet = this.createOSPFPacket(type, offset, temp);
        return ospfv2Packet;
    }

    public OSPFv2Packet createOSPFPacket(int type, int offset, byte[] bytes) {
        OSPFv2LinkStateUpdatePacket ospfv2Packet = null;
        if (type == 1) {
            // empty if block
        }
        if (type == 2) {
            // empty if block
        }
        if (type == 3) {
            // empty if block
        }
        if (type == 4) {
            ospfv2Packet = new OSPFv2LinkStateUpdatePacket(bytes, offset);
        }
        if (type == 5) {
            // empty if block
        }
        return ospfv2Packet;
    }

    public void setMulticast(boolean multicast) {
        this.multicast = multicast;
    }
}

