/*
 * Decompiled with CFR 0.152.
 */
package es.tid.tedb.ospfv2;

import es.tid.ospf.ospfv2.OSPFv2LinkStateUpdatePacket;
import es.tid.ospf.ospfv2.OSPFv2Packet;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSPFTCPSession
extends Thread {
    private DataInputStream in;
    private LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> ospfv2PacketQueue;
    private Socket ss;
    Logger log = LoggerFactory.getLogger((String)"OSPFParser");

    public OSPFTCPSession(Socket ss, LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> ospfv2PacketQueue) {
        this.ospfv2PacketQueue = ospfv2PacketQueue;
        this.ss = ss;
    }

    @Override
    public void run() {
        this.log.info("TCPOSPF Socket opened: " + this.ss);
        try {
            this.in = new DataInputStream(this.ss.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (true) {
            try {
                OSPFv2Packet ospfv2Packet = this.readOSPFv2Packet(this.in);
                if (ospfv2Packet == null) continue;
                if (ospfv2Packet.getType() == 4) {
                    this.ospfv2PacketQueue.add((OSPFv2LinkStateUpdatePacket)ospfv2Packet);
                    this.log.info("OSPF packet send via TCP.");
                    continue;
                }
                this.log.warn("No es un OSPFv2_LINK_STATE_UPDATE");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.log.warn("TCPOSPF Socket ends");
                return;
            }
        }
    }

    protected OSPFv2Packet readOSPFv2Packet(DataInputStream in) throws IOException {
        Object ret = null;
        byte[] hdr = new byte[20];
        byte[] temp = null;
        boolean endHdr = false;
        int r = 0;
        int length = 0;
        boolean endMsg = false;
        int offset = 0;
        OSPFv2Packet ospfv2Packet = null;
        while (!endMsg) {
            try {
                if (endHdr ? (r = in.read(temp, offset, 1)) == -1 : hdr != null && (r = in.read(hdr, offset, 1)) == -1) {
                    return null;
                }
            }
            catch (IOException e) {
                this.log.warn("Error reading data: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                throw new IOException();
            }
            if (r > 0) {
                if (offset == 2) {
                    length = (hdr[offset] & 0xFF) << 8;
                }
                if (offset == 3) {
                    temp = new byte[length |= hdr[offset] & 0xFF];
                }
                if (offset == 19) {
                    endHdr = true;
                    System.arraycopy(hdr, 0, temp, 0, 20);
                }
                if (length > 0 && offset == length - 1) {
                    endMsg = true;
                }
                ++offset;
                continue;
            }
            if (r != -1) continue;
            throw new IOException();
        }
        if (length > 0) {
            offset = 0;
            int type = OSPFv2Packet.getLStype(temp, (int)offset);
            ospfv2Packet = this.createOSPFPacket(type, offset, temp);
        }
        return ospfv2Packet;
    }

    public OSPFv2Packet createOSPFPacket(int type, int offset, byte[] bytes) {
        OSPFv2LinkStateUpdatePacket ospfv2Packet = null;
        if (type == 1) {
            // empty if block
        }
        if (type == 2) {
            // empty if block
        }
        if (type == 3) {
            // empty if block
        }
        if (type == 4) {
            ospfv2Packet = new OSPFv2LinkStateUpdatePacket(bytes, offset);
        }
        if (type == 5) {
            // empty if block
        }
        return ospfv2Packet;
    }
}

