/*
 * Decompiled with CFR 0.152.
 */
package es.tid.tedb.ospfv2;

import es.tid.ospf.ospfv2.OSPFv2LinkStateUpdatePacket;
import es.tid.tedb.ospfv2.OSPFTCPSession;
import java.net.ServerSocket;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSPFTCPSessionServer
extends Thread {
    private int OSPFTCPPort;
    private LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> ospfv2PacketQueue;
    private LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> redisOspfv2PacketQueue;
    private Logger log = LoggerFactory.getLogger((String)"OSPFParser");

    public OSPFTCPSessionServer(LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> ospfv2PacketQueue, LinkedBlockingQueue<OSPFv2LinkStateUpdatePacket> redisOspfv2PacketQueue) {
        this.log.info("In OSPFTCPSessionServer");
        this.ospfv2PacketQueue = ospfv2PacketQueue;
        this.redisOspfv2PacketQueue = redisOspfv2PacketQueue;
    }

    @Override
    public void run() {
        ServerSocket serverSocket = null;
        boolean listening = true;
        try {
            this.log.info("Listening on port OSPF::" + this.OSPFTCPPort);
            serverSocket = new ServerSocket(this.OSPFTCPPort);
        }
        catch (Exception e) {
            this.log.error("Could not listen management on port 8889");
            e.printStackTrace();
            return;
        }
        try {
            while (listening) {
                this.log.info("Accepting socket! OSPF");
                new OSPFTCPSession(serverSocket.accept(), this.ospfv2PacketQueue).start();
            }
            serverSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getOSPFTCPPort() {
        return this.OSPFTCPPort;
    }

    public void setOSPFTCPPort(int oSPFTCPPort) {
        this.OSPFTCPPort = oSPFTCPPort;
    }
}

