/*
 * Decompiled with CFR 0.152.
 */
package es.us.isa.idl.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import es.us.isa.idl.generator.ReservedWords;
import es.us.isa.idl.idl.ArithmeticDependency;
import es.us.isa.idl.idl.ConditionalDependency;
import es.us.isa.idl.idl.Dependency;
import es.us.isa.idl.idl.GeneralClause;
import es.us.isa.idl.idl.GeneralClauseContinuation;
import es.us.isa.idl.idl.GeneralPredefinedDependency;
import es.us.isa.idl.idl.GeneralPredicate;
import es.us.isa.idl.idl.GeneralTerm;
import es.us.isa.idl.idl.Operation;
import es.us.isa.idl.idl.OperationContinuation;
import es.us.isa.idl.idl.Param;
import es.us.isa.idl.idl.ParamValueRelation;
import es.us.isa.idl.idl.RelationalDependency;
import es.us.isa.idl.idl.impl.ArithmeticDependencyImpl;
import es.us.isa.idl.idl.impl.ConditionalDependencyImpl;
import es.us.isa.idl.idl.impl.GeneralPredefinedDependencyImpl;
import es.us.isa.idl.idl.impl.GeneralTermImpl;
import es.us.isa.idl.idl.impl.ParamImpl;
import es.us.isa.idl.idl.impl.RelationalDependencyImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class IDLGenerator
extends AbstractGenerator {
    private final String constraintsFileName = "base_constraints.mzn";
    private final String stringIntMappingFileName = "string_int_mapping.json";
    private String csp;
    private String fullCsp;
    private Integer stringToIntCounter;
    private Map<String, Integer> stringIntMapping = new HashMap<String, Integer>();
    private String folderPath = "./idl_aux_files";

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
        try {
            boolean _not_1;
            boolean _not;
            this.stringIntMapping.clear();
            this.stringToIntCounter = 0;
            this.fullCsp = "constraint (";
            Iterable<Dependency> _iterable = IteratorExtensions.toIterable(Iterators.filter(resource.getAllContents(), Dependency.class));
            for (Dependency dependency : _iterable) {
                this.csp = "(";
                Class<?> _class = dependency.getDep().getClass();
                boolean _equals = Objects.equal(_class, ConditionalDependencyImpl.class);
                if (_equals) {
                    EObject _dep = dependency.getDep();
                    this.writeConditionalDependency((ConditionalDependency)_dep);
                } else {
                    Class<?> _class_1 = dependency.getDep().getClass();
                    boolean _equals_1 = Objects.equal(_class_1, RelationalDependencyImpl.class);
                    if (_equals_1) {
                        EObject _dep_1 = dependency.getDep();
                        this.writeRelationalDependency((RelationalDependency)_dep_1, true);
                    } else {
                        Class<?> _class_2 = dependency.getDep().getClass();
                        boolean _equals_2 = Objects.equal(_class_2, ArithmeticDependencyImpl.class);
                        if (_equals_2) {
                            EObject _dep_2 = dependency.getDep();
                            this.writeArithmeticDependency((ArithmeticDependency)_dep_2, true);
                        } else {
                            Class<?> _class_3 = dependency.getDep().getClass();
                            boolean _equals_3 = Objects.equal(_class_3, GeneralPredefinedDependencyImpl.class);
                            if (_equals_3) {
                                EObject _dep_3 = dependency.getDep();
                                this.writePredefinedDependency((GeneralPredefinedDependency)_dep_3);
                            } else {
                                throw new Exception("The dependency must be a conditional, an arithmetic, a relational or a predefined one");
                            }
                        }
                    }
                }
                String _csp = this.csp;
                this.csp = _csp + ")\n/\\\n";
                String _fullCsp = this.fullCsp;
                this.fullCsp = _fullCsp + this.csp;
            }
            int _length = this.fullCsp.length();
            int _minus = _length - 4;
            String _fullCsp = this.fullCsp = this.fullCsp.substring(0, _minus);
            this.fullCsp = _fullCsp + ");";
            boolean _contains = this.fullCsp.contains("constrai);");
            if (_contains) {
                this.fullCsp = "";
            }
            File file = new File(this.folderPath + "/" + this.constraintsFileName);
            file.delete();
            boolean _exists = file.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileWriter _fileWriter = new FileWriter(file, false);
            BufferedWriter out = new BufferedWriter(_fileWriter);
            out.append(this.fullCsp);
            out.flush();
            out.close();
            File mappingFile = new File(this.folderPath + "/" + this.stringIntMappingFileName);
            mappingFile.delete();
            boolean _exists_1 = mappingFile.exists();
            boolean bl2 = _not_1 = !_exists_1;
            if (_not_1) {
                mappingFile.getParentFile().mkdirs();
                mappingFile.createNewFile();
            }
            FileWriter _fileWriter_1 = new FileWriter(mappingFile, false);
            BufferedWriter mappingOut = new BufferedWriter(_fileWriter_1);
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.stringIntMapping);
            mappingOut.append(json);
            mappingOut.flush();
            mappingOut.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    private String parseIDLParamName(String paramName) {
        String parsedParamName = paramName.replaceAll("^\\[|\\]$", "").replaceAll("[\\.\\-\\/\\:\\[\\]]", "_");
        boolean _contains = ReservedWords.RESERVED_WORDS.contains(parsedParamName);
        if (_contains) {
            String _parsedParamName = parsedParamName;
            parsedParamName = _parsedParamName + "_R";
        }
        return parsedParamName;
    }

    private Integer stringToInt(String stringValue) {
        Integer intMapping = this.stringIntMapping.get(stringValue);
        if (intMapping != null) {
            return intMapping;
        }
        this.stringIntMapping.put(stringValue, this.stringToIntCounter);
        IDLGenerator iDLGenerator = this;
        Integer n = iDLGenerator.stringToIntCounter;
        Integer n2 = iDLGenerator.stringToIntCounter = Integer.valueOf(iDLGenerator.stringToIntCounter + 1);
        return n;
    }

    private String parseDouble(String doubleValue) {
        String doubleWithoutDec = doubleValue.replaceAll("\\.\\d+", "");
        boolean _contains = doubleWithoutDec.contains("-");
        if (_contains) {
            return "(" + doubleWithoutDec + ")";
        }
        return doubleWithoutDec;
    }

    private boolean isParamValueRelation(Param param) {
        return param.getStringValues().size() != 0 || param.getPatternString() != null || param.getBooleanValue() != null || param.getDoubleValue() != null;
    }

    private void writePredicate(GeneralPredicate predicate) {
        try {
            boolean _tripleNotEquals;
            this.writeClause(predicate.getFirstClause());
            GeneralClauseContinuation _clauseContinuation = predicate.getClauseContinuation();
            boolean bl = _tripleNotEquals = _clauseContinuation != null;
            if (_tripleNotEquals) {
                String _logicalOp = predicate.getClauseContinuation().getLogicalOp();
                boolean _equals = Objects.equal(_logicalOp, "AND");
                if (_equals) {
                    String _csp = this.csp;
                    this.csp = _csp + " /\\ ";
                } else {
                    String _logicalOp_1 = predicate.getClauseContinuation().getLogicalOp();
                    boolean _equals_1 = Objects.equal(_logicalOp_1, "OR");
                    if (_equals_1) {
                        String _csp_1 = this.csp;
                        this.csp = _csp_1 + " \\/ ";
                    } else {
                        throw new Exception("The logical operator can only be AND or OR");
                    }
                }
                this.writePredicate(predicate.getClauseContinuation().getAdditionalElements());
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    private void writeClause(GeneralClause clause) {
        block20: {
            try {
                EObject _firstElement;
                boolean _tripleNotEquals_3;
                boolean _tripleNotEquals;
                GeneralPredicate _predicate = clause.getPredicate();
                boolean bl = _tripleNotEquals = _predicate != null;
                if (_tripleNotEquals) {
                    boolean _tripleNotEquals_2;
                    boolean _tripleNotEquals_1;
                    String _not = clause.getNot();
                    boolean bl2 = _tripleNotEquals_1 = _not != null;
                    if (_tripleNotEquals_1) {
                        String _csp = this.csp;
                        this.csp = _csp + "(not ";
                    }
                    String _csp_1 = this.csp;
                    this.csp = _csp_1 + "(";
                    this.writePredicate(clause.getPredicate());
                    String _csp_2 = this.csp;
                    this.csp = _csp_2 + ")";
                    String _not_1 = clause.getNot();
                    boolean bl3 = _tripleNotEquals_2 = _not_1 != null;
                    if (_tripleNotEquals_2) {
                        String _csp_3 = this.csp;
                        this.csp = _csp_3 + ")";
                    }
                }
                boolean bl4 = _tripleNotEquals_3 = (_firstElement = clause.getFirstElement()) != null;
                if (!_tripleNotEquals_3) break block20;
                Class<?> _class = clause.getFirstElement().getClass();
                boolean _equals = Objects.equal(_class, GeneralTermImpl.class);
                if (_equals) {
                    boolean _tripleNotEquals_9;
                    boolean _tripleNotEquals_4;
                    EObject _firstElement_1 = clause.getFirstElement();
                    GeneralTerm term = (GeneralTerm)_firstElement_1;
                    ParamValueRelation _param = term.getParam();
                    Param param = (Param)_param;
                    String _not_2 = term.getNot();
                    boolean bl5 = _tripleNotEquals_4 = _not_2 != null;
                    if (_tripleNotEquals_4) {
                        String _csp_4 = this.csp;
                        this.csp = _csp_4 + "(not ";
                    }
                    String _csp_5 = this.csp;
                    String _csp_6 = this.csp = _csp_5 + "(";
                    String _parseIDLParamName = this.parseIDLParamName(param.getName());
                    String _plus = _parseIDLParamName + "Set==1";
                    this.csp = _csp_6 + _plus;
                    boolean _isParamValueRelation = this.isParamValueRelation(param);
                    if (_isParamValueRelation) {
                        boolean _tripleNotEquals_5;
                        String _csp_7 = this.csp;
                        this.csp = _csp_7 + " /\\ ";
                        String _booleanValue = param.getBooleanValue();
                        boolean bl6 = _tripleNotEquals_5 = _booleanValue != null;
                        if (_tripleNotEquals_5) {
                            String _csp_8 = this.csp;
                            String _parseIDLParamName_1 = this.parseIDLParamName(param.getName());
                            String _plus_1 = _parseIDLParamName_1 + "==";
                            String _booleanValue_1 = param.getBooleanValue();
                            String _plus_2 = _plus_1 + _booleanValue_1;
                            this.csp = _csp_8 + _plus_2;
                        } else {
                            boolean _tripleNotEquals_6;
                            String _doubleValue = param.getDoubleValue();
                            boolean bl7 = _tripleNotEquals_6 = _doubleValue != null;
                            if (_tripleNotEquals_6) {
                                String _csp_9 = this.csp;
                                String _parseIDLParamName_2 = this.parseIDLParamName(param.getName());
                                String _relationalOp = param.getRelationalOp();
                                String _plus_3 = _parseIDLParamName_2 + _relationalOp;
                                String _parseDouble = this.parseDouble(param.getDoubleValue());
                                String _plus_4 = _plus_3 + _parseDouble;
                                this.csp = _csp_9 + _plus_4;
                            } else {
                                boolean _tripleNotEquals_7;
                                int _size = param.getStringValues().size();
                                boolean bl8 = _tripleNotEquals_7 = _size != 0;
                                if (_tripleNotEquals_7) {
                                    String _csp_10 = this.csp;
                                    this.csp = _csp_10 + "(";
                                    EList<String> _stringValues = param.getStringValues();
                                    for (String string : _stringValues) {
                                        String _csp_11 = this.csp;
                                        String _parseIDLParamName_3 = this.parseIDLParamName(param.getName());
                                        String _plus_5 = _parseIDLParamName_3 + "==";
                                        Integer _stringToInt = this.stringToInt(string);
                                        String _plus_6 = _plus_5 + _stringToInt;
                                        String _plus_7 = _plus_6 + " \\/ ";
                                        this.csp = _csp_11 + _plus_7;
                                    }
                                    int _length = this.csp.length();
                                    int _minus = _length - 4;
                                    String _csp_12 = this.csp = this.csp.substring(0, _minus);
                                    this.csp = _csp_12 + ")";
                                } else {
                                    boolean _tripleNotEquals_8;
                                    String _patternString = param.getPatternString();
                                    boolean bl9 = _tripleNotEquals_8 = _patternString != null;
                                    if (_tripleNotEquals_8) {
                                        String _csp_13 = this.csp;
                                        this.csp = _csp_13 + "true";
                                    }
                                }
                            }
                        }
                    }
                    String _csp_14 = this.csp;
                    this.csp = _csp_14 + ")";
                    String _not_3 = term.getNot();
                    boolean bl10 = _tripleNotEquals_9 = _not_3 != null;
                    if (_tripleNotEquals_9) {
                        String _csp_15 = this.csp;
                        this.csp = _csp_15 + ")";
                    }
                    break block20;
                }
                Class<?> _class_1 = clause.getFirstElement().getClass();
                boolean _equals_1 = Objects.equal(_class_1, RelationalDependencyImpl.class);
                if (_equals_1) {
                    EObject _firstElement_2 = clause.getFirstElement();
                    this.writeRelationalDependency((RelationalDependency)_firstElement_2, false);
                    break block20;
                }
                Class<?> _class_2 = clause.getFirstElement().getClass();
                boolean _equals_2 = Objects.equal(_class_2, ArithmeticDependencyImpl.class);
                if (_equals_2) {
                    EObject _firstElement_3 = clause.getFirstElement();
                    this.writeArithmeticDependency((ArithmeticDependency)_firstElement_3, false);
                    break block20;
                }
                Class<?> _class_3 = clause.getFirstElement().getClass();
                boolean _equals_3 = Objects.equal(_class_3, GeneralPredefinedDependencyImpl.class);
                if (_equals_3) {
                    EObject _firstElement_4 = clause.getFirstElement();
                    this.writePredefinedDependency((GeneralPredefinedDependency)_firstElement_4);
                    break block20;
                }
                throw new Exception("The first element of a clause must be a term, an arithmetic dependency, a relational dependency or a predefined dependency");
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow(_e);
            }
        }
    }

    private void writeConditionalDependency(ConditionalDependency dep) {
        String _csp = this.csp;
        this.csp = _csp + "(";
        this.writePredicate(dep.getCondition());
        String _csp_1 = this.csp;
        this.csp = _csp_1 + ") -> (";
        this.writePredicate(dep.getConsequence());
        String _csp_2 = this.csp;
        this.csp = _csp_2 + ")";
    }

    private void writeRelationalDependency(RelationalDependency dep, boolean alone) {
        if (alone) {
            String _csp = this.csp;
            String _parseIDLParamName = this.parseIDLParamName(dep.getParam1().getName());
            String _plus = "((" + _parseIDLParamName;
            String _plus_1 = _plus + "Set==1 /\\ ";
            String _parseIDLParamName_1 = this.parseIDLParamName(dep.getParam2().getName());
            String _plus_2 = _plus_1 + _parseIDLParamName_1;
            String _plus_3 = _plus_2 + "Set==1) -> (";
            String _parseIDLParamName_2 = this.parseIDLParamName(dep.getParam1().getName());
            String _plus_4 = _plus_3 + _parseIDLParamName_2;
            String _relationalOp = dep.getRelationalOp();
            String _plus_5 = _plus_4 + _relationalOp;
            String _parseIDLParamName_3 = this.parseIDLParamName(dep.getParam2().getName());
            String _plus_6 = _plus_5 + _parseIDLParamName_3;
            String _plus_7 = _plus_6 + "))";
            this.csp = _csp + _plus_7;
        } else {
            String _csp_1 = this.csp;
            String _parseIDLParamName_4 = this.parseIDLParamName(dep.getParam1().getName());
            String _plus_8 = "(" + _parseIDLParamName_4;
            String _plus_9 = _plus_8 + "Set==1 /\\ ";
            String _parseIDLParamName_5 = this.parseIDLParamName(dep.getParam2().getName());
            String _plus_10 = _plus_9 + _parseIDLParamName_5;
            String _plus_11 = _plus_10 + "Set==1 /\\ ";
            String _parseIDLParamName_6 = this.parseIDLParamName(dep.getParam1().getName());
            String _plus_12 = _plus_11 + _parseIDLParamName_6;
            String _relationalOp_1 = dep.getRelationalOp();
            String _plus_13 = _plus_12 + _relationalOp_1;
            String _parseIDLParamName_7 = this.parseIDLParamName(dep.getParam2().getName());
            String _plus_14 = _plus_13 + _parseIDLParamName_7;
            String _plus_15 = _plus_14 + ")";
            this.csp = _csp_1 + _plus_15;
        }
    }

    private void writeArithmeticDependency(ArithmeticDependency dep, boolean alone) {
        String _csp = this.csp;
        this.csp = _csp + "((";
        Iterable<Param> _iterable = IteratorExtensions.toIterable(Iterators.filter(dep.eAllContents(), Param.class));
        for (Param param : _iterable) {
            String _csp_1 = this.csp;
            String _parseIDLParamName = this.parseIDLParamName(param.getName());
            String _plus = _parseIDLParamName + "Set==1 /\\ ";
            this.csp = _csp_1 + _plus;
        }
        if (alone) {
            int _length = this.csp.length();
            int _minus = _length - 4;
            String _csp_2 = this.csp = this.csp.substring(0, _minus);
            this.csp = _csp_2 + ") -> (";
        }
        this.writeOperation(dep.getOperation());
        String _csp_3 = this.csp;
        String _relationalOp = dep.getRelationalOp();
        String _csp_4 = this.csp = _csp_3 + _relationalOp;
        String _parseDouble = this.parseDouble(dep.getResult());
        String _csp_5 = this.csp = _csp_4 + _parseDouble;
        this.csp = _csp_5 + "))";
    }

    private void writeOperation(Operation operation) {
        boolean _tripleEquals;
        String _openingParenthesis = operation.getOpeningParenthesis();
        boolean bl = _tripleEquals = _openingParenthesis == null;
        if (_tripleEquals) {
            String _csp = this.csp;
            String _name = operation.getFirstParam().getName();
            this.csp = _csp + _name;
            this.writeOperationContinuation(operation.getOperationContinuation());
        } else {
            boolean _tripleNotEquals;
            String _csp_1 = this.csp;
            this.csp = _csp_1 + "(";
            this.writeOperation(operation.getOperation());
            String _csp_2 = this.csp;
            this.csp = _csp_2 + ")";
            OperationContinuation _operationContinuation = operation.getOperationContinuation();
            boolean bl2 = _tripleNotEquals = _operationContinuation != null;
            if (_tripleNotEquals) {
                this.writeOperationContinuation(operation.getOperationContinuation());
            }
        }
    }

    private void writeOperationContinuation(OperationContinuation opCont) {
        String _csp = this.csp;
        String _arithOp = opCont.getArithOp();
        this.csp = _csp + _arithOp;
        Class<?> _class = opCont.getAdditionalParams().getClass();
        boolean _equals = Objects.equal(_class, ParamImpl.class);
        if (_equals) {
            String _csp_1 = this.csp;
            EObject _additionalParams = opCont.getAdditionalParams();
            String _name = ((Param)_additionalParams).getName();
            this.csp = _csp_1 + _name;
        } else {
            EObject _additionalParams_1 = opCont.getAdditionalParams();
            this.writeOperation((Operation)_additionalParams_1);
        }
    }

    private void writePredefinedDependency(GeneralPredefinedDependency dep) {
        try {
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            String _not = dep.getNot();
            boolean bl = _tripleNotEquals = _not != null;
            if (_tripleNotEquals) {
                String _csp = this.csp;
                this.csp = _csp + "(not ";
            }
            String _csp_1 = this.csp;
            this.csp = _csp_1 + "(";
            EList<GeneralPredicate> _predefDepElements = dep.getPredefDepElements();
            for (GeneralPredicate depElement : _predefDepElements) {
                String _csp_2 = this.csp;
                this.csp = _csp_2 + "(";
                String _predefDepType = dep.getPredefDepType();
                if (_predefDepType != null) {
                    switch (_predefDepType) {
                        case "Or": {
                            this.writePredicate(depElement);
                            String _csp_3 = this.csp;
                            this.csp = _csp_3 + ") \\/ ";
                            break;
                        }
                        case "OnlyOne": {
                            this.writeZeroOrOneOnlyOneElement(depElement, (GeneralPredicate[])Conversions.unwrapArray(dep.getPredefDepElements(), GeneralPredicate.class));
                            String _csp_4 = this.csp;
                            this.csp = _csp_4 + ") /\\ ";
                            break;
                        }
                        case "AllOrNone": {
                            this.writeAllOrNoneElement(depElement, (GeneralPredicate[])Conversions.unwrapArray(dep.getPredefDepElements(), GeneralPredicate.class));
                            String _csp_5 = this.csp;
                            this.csp = _csp_5 + ") /\\ ";
                            break;
                        }
                        case "ZeroOrOne": {
                            this.writeZeroOrOneOnlyOneElement(depElement, (GeneralPredicate[])Conversions.unwrapArray(dep.getPredefDepElements(), GeneralPredicate.class));
                            String _csp_6 = this.csp;
                            this.csp = _csp_6 + ") /\\ ";
                            break;
                        }
                        default: {
                            throw new Exception("The predefined dependency can only be 'Or', 'OnlyOne', 'AllOrNone' or 'ZeroOrOne'");
                        }
                    }
                    continue;
                }
                throw new Exception("The predefined dependency can only be 'Or', 'OnlyOne', 'AllOrNone' or 'ZeroOrOne'");
            }
            boolean _equals = dep.getPredefDepType().equals("OnlyOne");
            if (_equals) {
                String _csp_2 = this.csp;
                this.csp = _csp_2 + "(";
                EList<GeneralPredicate> _predefDepElements_1 = dep.getPredefDepElements();
                for (GeneralPredicate depElement_1 : _predefDepElements_1) {
                    String _csp_3 = this.csp;
                    this.csp = _csp_3 + "(";
                    this.writePredicate(depElement_1);
                    String _csp_4 = this.csp;
                    this.csp = _csp_4 + ") \\/ ";
                }
                int _length = this.csp.length();
                int _minus = _length - 4;
                String _csp_3 = this.csp = this.csp.substring(0, _minus);
                this.csp = _csp_3 + ")";
            } else {
                int _length_1 = this.csp.length();
                int _minus_1 = _length_1 - 4;
                this.csp = this.csp.substring(0, _minus_1);
            }
            String _csp_4 = this.csp;
            this.csp = _csp_4 + ")";
            String _not_1 = dep.getNot();
            boolean bl2 = _tripleNotEquals_1 = _not_1 != null;
            if (_tripleNotEquals_1) {
                String _csp_5 = this.csp;
                this.csp = _csp_5 + ")";
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
        }
    }

    private void writeZeroOrOneOnlyOneElement(GeneralPredicate element, GeneralPredicate[] allElements) {
        this.writeZeroOrOneAllOrNoneElement(element, allElements, false, true);
    }

    private void writeAllOrNoneElement(GeneralPredicate element, GeneralPredicate[] allElements) {
        this.writeZeroOrOneAllOrNoneElement(element, allElements, false, false);
        String _csp = this.csp;
        this.csp = _csp + ") /\\ (";
        this.writeZeroOrOneAllOrNoneElement(element, allElements, true, true);
    }

    private void writeZeroOrOneAllOrNoneElement(GeneralPredicate element, GeneralPredicate[] allElements, boolean negateElement, boolean negateRemainingElements) {
        if (negateElement) {
            String _csp = this.csp;
            this.csp = _csp + "(not (";
            this.writePredicate(element);
            String _csp_1 = this.csp;
            this.csp = _csp_1 + ")) -> (";
        } else {
            GeneralPredicate[] _csp_2 = this.csp;
            this.csp = (String)_csp_2 + "(";
            this.writePredicate(element);
            String _csp_3 = this.csp;
            this.csp = _csp_3 + ") -> (";
        }
        for (GeneralPredicate remainingElement : allElements) {
            boolean _not;
            boolean _equals = remainingElement.equals(element);
            boolean bl = _not = !_equals;
            if (!_not) continue;
            if (negateRemainingElements) {
                String _csp_4 = this.csp;
                this.csp = _csp_4 + "(not (";
                this.writePredicate(remainingElement);
                String _csp_5 = this.csp;
                this.csp = _csp_5 + ")) /\\ ";
                continue;
            }
            String _csp_6 = this.csp;
            this.csp = _csp_6 + "(";
            this.writePredicate(remainingElement);
            String _csp_7 = this.csp;
            this.csp = _csp_7 + ") /\\ ";
        }
        int _length = this.csp.length();
        int _minus = _length - 4;
        String _csp_8 = this.csp = this.csp.substring(0, _minus);
        this.csp = _csp_8 + ")";
    }
}

