/*
 * Decompiled with CFR 0.152.
 */
package es.us.isa.idlreasoner.analyzer;

import es.us.isa.idlreasoner.compiler.Resolutor;
import es.us.isa.idlreasoner.compiler.ResolutorCreator;
import es.us.isa.idlreasoner.mapper.AbstractMapper;
import es.us.isa.idlreasoner.mapper.MapperCreator;
import es.us.isa.idlreasoner.util.CommonResources;
import es.us.isa.idlreasoner.util.FileManager;
import es.us.isa.idlreasoner.util.IDLConfiguration;
import es.us.isa.idlreasoner.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class Analyzer {
    private Resolutor resolutor;
    private AbstractMapper mapper;
    private CommonResources cr = new CommonResources();
    private boolean needReloadConstraintsFile;
    private boolean lastRandomReqWasValid;

    public Analyzer(String specificationType, String idlPath, String apiSpecificationPath, String operationPath, String operationType) {
        IDLConfiguration.initFilesAndConf(this.cr);
        this.needReloadConstraintsFile = true;
        this.lastRandomReqWasValid = false;
        this.resolutor = ResolutorCreator.createResolutor(this.cr);
        this.mapper = MapperCreator.createMapper(this.cr, specificationType, idlPath, apiSpecificationPath, operationPath, operationType);
    }

    public Analyzer(String specificationType, String apiSpecificationPath, String operationPath, String operationType) {
        this(specificationType, null, apiSpecificationPath, operationPath, operationType);
    }

    public List<Map<String, String>> getAllRequests() {
        ArrayList<Map<String, String>> setUpRequests = new ArrayList<Map<String, String>>();
        this.getAllUnSetUpRequests().forEach(r -> setUpRequests.add(this.mapper.setUpRequest((Map<String, String>)r)));
        return setUpRequests;
    }

    private List<Map<String, String>> getAllUnSetUpRequests() {
        this.setupAnalysisOperation();
        this.mapper.appendConstraintsRedundantSolutions();
        this.mapper.finishConstraintsFile();
        return this.resolutor.solveGetAllSolutions();
    }

    public Map<String, String> getPseudoRandomValidRequest() {
        Map<String, String> res = new HashMap<String, String>();
        List<Map<String, String>> allRequests = this.getAllUnSetUpRequests();
        if (allRequests.size() != 0) {
            res = allRequests.get(ThreadLocalRandom.current().nextInt(0, allRequests.size()));
        }
        return this.mapper.setUpRequest(res);
    }

    public Map<String, String> getRandomValidRequest() {
        this.setupRandomRequestOperation(true);
        return this.mapper.setUpRequest(this.resolutor.solve());
    }

    public Map<String, String> getRandomInvalidRequest() {
        this.setupRandomRequestOperation(false);
        if (!this.mapper.hasDeps().booleanValue()) {
            return null;
        }
        return this.mapper.setUpRequest(this.resolutor.solve());
    }

    public Boolean isDeadParameter(String parameter) {
        this.setupAnalysisOperation();
        this.mapper.setParamToValue(Utils.parseSpecParamName(parameter) + "Set", "1");
        this.mapper.finishConstraintsFile();
        return this.resolutor.solve() == null;
    }

    public Boolean isFalseOptional(String parameter) {
        this.setupAnalysisOperation();
        if (this.mapper.isOptionalParameter(parameter).booleanValue()) {
            this.mapper.setParamToValue(Utils.parseSpecParamName(parameter) + "Set", "0");
            this.mapper.finishConstraintsFile();
            return this.resolutor.solve() == null;
        }
        return false;
    }

    public Boolean isValidIDL() {
        String parameter;
        Set<String> parameters = this.mapper.getOperationParameters();
        boolean res = true;
        Iterator<String> iterator = parameters.iterator();
        while (iterator.hasNext() && (res = this.isDeadParameter(parameter = iterator.next()) == false && this.isFalseOptional(parameter) == false)) {
        }
        if (res) {
            res = this.isSolvableIDL();
        }
        return res;
    }

    private Boolean isSolvableIDL() {
        this.setupAnalysisOperation();
        this.mapper.finishConstraintsFile();
        return this.resolutor.solve() != null;
    }

    public Boolean isValidRequest(Map<String, String> parametersSet) {
        return this.isValidRequest(parametersSet, false);
    }

    public Boolean isValidRequest(Map<String, String> parametersSet, boolean useDefaultData) {
        String dataFile = this.cr.DATA_FILE;
        if (useDefaultData) {
            this.cr.DATA_FILE = this.cr.BASE_DATA_FILE;
        }
        this.setupAnalysisOperation();
        Set<String> parametersSetNames = parametersSet.keySet();
        Set<String> operationParameters = this.mapper.getOperationParameters();
        for (String operationParameter : operationParameters) {
            if (parametersSetNames.contains(operationParameter)) {
                this.mapper.setParamToValue(Utils.parseSpecParamName(operationParameter), operationParameter, parametersSet.get(operationParameter));
                this.mapper.setParamToValue(Utils.parseSpecParamName(operationParameter) + "Set", "1");
                continue;
            }
            this.mapper.setParamToValue(Utils.parseSpecParamName(operationParameter) + "Set", "0");
        }
        this.mapper.finishConstraintsFile();
        Boolean result = this.resolutor.solve() != null;
        if (useDefaultData) {
            this.cr.DATA_FILE = dataFile;
        }
        return result;
    }

    public Boolean isValidPartialRequest(Map<String, String> parametersSet) {
        this.setupAnalysisOperation();
        Set<String> parametersSetNames = parametersSet.keySet();
        Set<String> operationParameters = this.mapper.getOperationParameters();
        for (String operationParameter : operationParameters) {
            if (!parametersSetNames.contains(operationParameter)) continue;
            this.mapper.setParamToValue(Utils.parseSpecParamName(operationParameter), operationParameter, parametersSet.get(operationParameter));
            this.mapper.setParamToValue(Utils.parseSpecParamName(operationParameter) + "Set", "1");
        }
        this.mapper.finishConstraintsFile();
        return this.resolutor.solve() != null;
    }

    public Integer numberOfRequest() {
        return this.getAllUnSetUpRequests().size();
    }

    private void setupAnalysisOperation() {
        if (!this.needReloadConstraintsFile) {
            this.needReloadConstraintsFile = true;
        }
        if (this.resolutor.isRandomSearch()) {
            this.resolutor.setRandomSearch(false);
        }
        this.mapper.resetCurrentProblem();
        this.mapper.resetStringIntMapping();
    }

    private void setupRandomRequestOperation(boolean valid) {
        if (this.needReloadConstraintsFile || this.lastRandomReqWasValid != valid) {
            this.setupAnalysisOperation();
            if (!valid) {
                this.mapper.inverseConstraints();
            }
            this.mapper.finishConstraintsFileWithSearch();
            this.resolutor.setRandomSearch(true);
            this.needReloadConstraintsFile = false;
            this.lastRandomReqWasValid = valid;
        }
    }

    public void updateData(Map<String, List<String>> data) {
        FileManager.recreateFile(this.cr.DATA_FILE);
        try {
            this.mapper.initializeStringIntMapping();
            this.mapper.updateDataFile(data);
        }
        catch (IOException e) {
            Utils.terminate("There was an error while creating the data file. Try again.", e);
        }
        this.mapper.fixStringToIntCounter();
    }
}

