/*
 * Decompiled with CFR 0.152.
 */
package es.us.isa.idlreasoner.compiler;

import es.us.isa.idlreasoner.util.CommonResources;
import es.us.isa.idlreasoner.util.IDLConfiguration;
import es.us.isa.idlreasoner.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;

public class Resolutor {
    protected CommonResources cr;
    protected boolean randomSearch;

    public Resolutor(CommonResources cr) {
        this.cr = cr;
    }

    public boolean isRandomSearch() {
        return this.randomSearch;
    }

    public void setRandomSearch(boolean randomSearch) {
        this.randomSearch = randomSearch;
    }

    public String getSeed() {
        return ThreadLocalRandom.current().nextInt(1, 2146) + Long.toString(new Date().getTime() / 1000L).substring(4);
    }

    public List<Map<String, String>> solveGetAllSolutions() {
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>();
        String results = null;
        while (results == null) {
            results = this.callSolver(this.getSolveAllCommand(), false);
        }
        List<String> resultsSplit = Arrays.asList(results.split("----------"));
        if (resultsSplit.size() == 2 && resultsSplit.get(0).equals("")) {
            res.add(new HashMap());
        } else if (resultsSplit.size() > 1) {
            for (String r : resultsSplit) {
                res.add(this.mapSolutions(r));
            }
            res.remove(res.get(res.size() - 1));
        }
        return res;
    }

    public Map<String, String> solve() {
        String solutions = null;
        while (solutions == null) {
            solutions = this.callSolver(this.getSolveCommand(), this.randomSearch);
        }
        return this.mapSolutions(solutions);
    }

    private Map<String, String> mapSolutions(String solutions) {
        HashMap<String, String> res = new HashMap<String, String>();
        List<String> solutionsSplit = Arrays.asList(solutions.split(";"));
        if (solutionsSplit.size() == 1) {
            if (solutionsSplit.get(0).contains("----------")) {
                return res;
            }
            return null;
        }
        for (String sol : solutionsSplit) {
            if (solutionsSplit.get(solutionsSplit.size() - 1).equals(sol)) continue;
            String[] aux = sol.split("=");
            res.put(aux[0].trim(), aux[1].trim());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callSolver(String command, boolean async) {
        String line = "";
        StringBuilder res = new StringBuilder();
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Process process = null;
        String[] commandProcessArgs = Resolutor.getCommandProcessArgs();
        processBuilder.command(commandProcessArgs[0], commandProcessArgs[1], command);
        try {
            process = processBuilder.start();
            if (async && !process.waitFor(IDLConfiguration.TIMEOUT, TimeUnit.MILLISECONDS)) {
                String string = null;
                return string;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                res.append(line).append("\n");
            }
            reader.close();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (process != null && process.isAlive()) {
                Resolutor.killChildProcesses();
            }
        }
        return res.toString();
    }

    private String getSolveCommand() {
        if (this.randomSearch) {
            return this.getMinizincExe() + " -r " + this.getSeed() + " --solver Gecode " + this.cr.BASE_CONSTRAINTS_FILE + " " + this.cr.DATA_FILE;
        }
        return this.getMinizincExe() + " --solver " + IDLConfiguration.SOLVER + " " + this.cr.BASE_CONSTRAINTS_FILE + " " + this.cr.DATA_FILE;
    }

    private String getSolveAllCommand() {
        if (!IDLConfiguration.MAX_RESULTS.trim().equals("")) {
            return this.getMinizincExe() + " -n " + IDLConfiguration.MAX_RESULTS + " --solver " + IDLConfiguration.SOLVER + " " + this.cr.BASE_CONSTRAINTS_FILE + " " + this.cr.DATA_FILE;
        }
        return this.getMinizincExe() + " -a --solver " + IDLConfiguration.SOLVER + " " + this.cr.BASE_CONSTRAINTS_FILE + " " + this.cr.DATA_FILE;
    }

    private String getMinizincExe() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "\"minizinc/windows/minizinc.exe\"";
        }
        if (SystemUtils.IS_OS_MAC) {
            return "./minizinc/mac/minizinc";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return "./minizinc/linux/bin/minizinc";
        }
        Utils.terminate("Operating system " + System.getProperty("os.name") + " not supported.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void killChildProcesses() {
        String[] killCommands;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        Process process = null;
        String[] commandProcessArgs = Resolutor.getCommandProcessArgs();
        for (String killCommand : killCommands = Resolutor.getKillCommands()) {
            processBuilder.command(commandProcessArgs[0], commandProcessArgs[1], killCommand);
            try {
                process = processBuilder.start();
                if (process.waitFor() >= 0) continue;
                System.err.println("WARNING! Some processes called 'minizinc' or 'fzn-gecode' could not be destroyed. Make sure to destroy them manually.");
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                if (process != null && process.isAlive()) {
                    process.destroy();
                    if (process.isAlive()) {
                        process.destroyForcibly();
                    }
                }
            }
        }
    }

    private static String[] getKillCommands() {
        String[] killCommands = new String[2];
        if (SystemUtils.IS_OS_WINDOWS) {
            killCommands[0] = "taskkill /IM \"fzn-gecode.exe\" /F";
            killCommands[1] = "taskkill /IM \"minizinc.exe\" /F";
        } else if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_LINUX) {
            killCommands[0] = "killall -9 fzn-gecode";
            killCommands[1] = "killall -9 minizinc";
        } else {
            Utils.terminate("Operating system " + System.getProperty("os.name") + " not supported.");
        }
        return killCommands;
    }

    private static String[] getCommandProcessArgs() {
        String[] commandProcessArgs = new String[2];
        if (SystemUtils.IS_OS_WINDOWS) {
            commandProcessArgs[0] = "cmd.exe";
            commandProcessArgs[1] = "/c";
        } else if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_LINUX) {
            commandProcessArgs[0] = "/bin/bash";
            commandProcessArgs[1] = "-c";
        } else {
            Utils.terminate("Operating system " + System.getProperty("os.name") + " not supported.");
        }
        return commandProcessArgs;
    }
}

