/*
 * Decompiled with CFR 0.152.
 */
package es.us.isa.idlreasoner.mapper;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import es.us.isa.idlreasoner.mapper.DependenciesMapper;
import es.us.isa.idlreasoner.util.CommonResources;
import es.us.isa.idlreasoner.util.FileManager;
import es.us.isa.idlreasoner.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;

public abstract class AbstractMapper {
    CommonResources cr;
    String specificationPath;
    final int MAX_STRING_INT_MAPPING = 100000;
    Map<String, Map.Entry<String, Boolean>> operationParameters;
    BiMap<String, String> parameterNamesMapping;
    BiMap<String, Integer> stringIntMapping;
    Integer stringToIntCounter;
    Integer STRING_TO_INT_FIXED_COUNTER;
    DependenciesMapper dm;
    String variables = "";
    String variablesData = "";
    String idlConstraints = "";
    String requiredVarsConstraints = "";
    String redundantSolutionsConstraints = "";
    String baseProblem = "";
    String currentProblem = "";
    final String RANDOM_SEARCH = "include \"gecode.mzn\";\nsolve ::int_default_search(random, indomain_random) satisfy;\n";

    public AbstractMapper(CommonResources cr) {
        this.cr = cr;
        this.operationParameters = new HashMap<String, Map.Entry<String, Boolean>>();
        this.parameterNamesMapping = HashBiMap.create();
        this.stringIntMapping = HashBiMap.create();
        this.stringToIntCounter = 0;
    }

    public abstract void mapVariables() throws IOException;

    String origToChangedParamName(String origParamName) {
        String changedParamName = (String)this.parameterNamesMapping.inverse().get(origParamName);
        if (changedParamName != null) {
            return changedParamName;
        }
        String parsedParamName = Utils.parseSpecParamName(origParamName);
        if (!parsedParamName.equals(origParamName)) {
            this.parameterNamesMapping.put(parsedParamName, origParamName);
            return parsedParamName;
        }
        return origParamName;
    }

    private String changedToOrigParamName(String changedParamName) {
        String origParamName = (String)this.parameterNamesMapping.get(changedParamName);
        if (origParamName != null) {
            return origParamName;
        }
        return changedParamName;
    }

    private String origToChangedParamValue(String parameter, String value) {
        Map.Entry<String, Boolean> paramFeatures = this.operationParameters.get(parameter);
        if (paramFeatures != null) {
            if (paramFeatures.getKey().equals("string") || paramFeatures.getKey().equals("array")) {
                Integer n;
                Integer n2;
                Integer intMapping = (Integer)this.stringIntMapping.get(value);
                if (intMapping != null) {
                    return Integer.toString(intMapping);
                }
                while (this.stringIntMapping.inverse().get(this.stringToIntCounter) != null) {
                    n2 = this.stringToIntCounter;
                    n = this.stringToIntCounter = Integer.valueOf(this.stringToIntCounter + 1);
                }
                this.stringIntMapping.put(value, this.stringToIntCounter);
                n2 = this.stringToIntCounter;
                n = this.stringToIntCounter = Integer.valueOf(this.stringToIntCounter + 1);
                return Integer.toString(n2);
            }
            if (paramFeatures.getKey().equals("number")) {
                return value.replaceAll("\\.\\d+", "");
            }
            if (paramFeatures.getKey().equals("boolean")) {
                if (value.equals("true")) {
                    return "1";
                }
                if (value.equals("false")) {
                    return "0";
                }
            }
        }
        return value;
    }

    private String changedToOrigParamValue(String parameter, String value) {
        Map.Entry<String, Boolean> paramFeatures = this.operationParameters.get(this.changedToOrigParamName(parameter));
        if (paramFeatures != null) {
            if (paramFeatures.getKey().equals("string") || paramFeatures.getKey().equals("array")) {
                String newStringMapping;
                String stringMapping;
                try {
                    stringMapping = (String)this.stringIntMapping.inverse().get(new Integer(value));
                }
                catch (NumberFormatException e) {
                    return value;
                }
                if (stringMapping != null) {
                    return stringMapping;
                }
                while (this.stringIntMapping.get(newStringMapping = RandomStringUtils.randomAscii(ThreadLocalRandom.current().nextInt(1, 10))) != null) {
                }
                this.stringIntMapping.put(newStringMapping, new Integer(value));
                return newStringMapping;
            }
            if (paramFeatures.getKey().equals("boolean")) {
                if (value.equals("1")) {
                    return "true";
                }
                if (value.equals("0")) {
                    return "false";
                }
            }
        }
        return value;
    }

    public void setParamToValue(String parameter, String value) {
        this.currentProblem = this.currentProblem + "constraint " + this.origToChangedParamName(parameter) + " = " + this.origToChangedParamValue(parameter, value) + ";\n";
    }

    public void setParamToValue(String changedParamName, String origParamName, String value) {
        this.currentProblem = this.currentProblem + "constraint " + this.origToChangedParamName(changedParamName) + " = " + this.origToChangedParamValue(origParamName, value) + ";\n";
    }

    public void appendConstraintsRedundantSolutions() {
        this.currentProblem = this.currentProblem + this.redundantSolutionsConstraints;
    }

    void mapRedundantConstraint(String changedParamName, String paramValue) {
        this.redundantSolutionsConstraints = this.redundantSolutionsConstraints + "constraint ((" + changedParamName + "Set==0) -> (" + changedParamName + "==" + paramValue + "));\n";
    }

    void mapRequiredVar(String changedParamName) {
        this.requiredVarsConstraints = this.requiredVarsConstraints + "constraint " + changedParamName + "Set = 1;\n";
    }

    public void inverseConstraints() {
        this.currentProblem = this.variables + "\n" + this.idlConstraints.replaceAll("^constraint", "constraint not") + "\n" + this.requiredVarsConstraints;
    }

    public void finishConstraintsFile() {
        this.currentProblem = this.currentProblem + "solve satisfy;\n";
        FileManager.writeContentToFile(this.cr.BASE_CONSTRAINTS_FILE, this.currentProblem);
    }

    public void finishConstraintsFileWithSearch() {
        this.currentProblem = this.currentProblem + "include \"gecode.mzn\";\nsolve ::int_default_search(random, indomain_random) satisfy;\n";
        FileManager.writeContentToFile(this.cr.BASE_CONSTRAINTS_FILE, this.currentProblem);
    }

    public void resetStringIntMapping() {
        this.stringIntMapping = HashBiMap.create(this.stringIntMapping.entrySet().stream().filter(entry -> (Integer)entry.getValue() < this.STRING_TO_INT_FIXED_COUNTER).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        this.stringToIntCounter = this.STRING_TO_INT_FIXED_COUNTER;
    }

    public void fixStringToIntCounter() {
        this.STRING_TO_INT_FIXED_COUNTER = this.stringToIntCounter;
    }

    public Set<String> getOperationParameters() {
        return this.operationParameters.keySet();
    }

    public Boolean isOptionalParameter(String paramName) {
        Map.Entry<String, Boolean> paramFeatures = this.operationParameters.get(paramName);
        if (paramFeatures != null) {
            return paramFeatures.getValue() == false;
        }
        return null;
    }

    public void initializeStringIntMapping() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<HashMap<String, Integer>> typeRef = new TypeReference<HashMap<String, Integer>>(){};
        this.stringIntMapping = HashBiMap.create((Map)mapper.readValue(new File(this.cr.STRING_INT_MAPPING_FILE), typeRef));
        Map.Entry entryWithHighestInt = this.stringIntMapping.entrySet().stream().max(Comparator.comparing(Map.Entry::getValue)).orElse(null);
        this.stringToIntCounter = entryWithHighestInt != null ? Integer.valueOf((Integer)entryWithHighestInt.getValue() + 1) : Integer.valueOf(0);
        this.fixStringToIntCounter();
    }

    void exportStringIntMappingToFile() throws IOException {
        FileManager.recreateFile(this.cr.STRING_INT_MAPPING_FILE);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(this.stringIntMapping);
        FileManager.appendContentToFile(this.cr.STRING_INT_MAPPING_FILE, json);
    }

    public Map<String, String> setUpRequest(Map<String, String> mznSolution) {
        if (mznSolution == null) {
            return null;
        }
        HashMap<String, String> request = new HashMap<String, String>();
        for (Map.Entry<String, String> currentCspVariable : mznSolution.entrySet()) {
            if (mznSolution.get(currentCspVariable.getKey() + "Set") == null || !mznSolution.get(currentCspVariable.getKey() + "Set").equals("1")) continue;
            request.put(this.changedToOrigParamName(currentCspVariable.getKey()), this.changedToOrigParamValue(currentCspVariable.getKey(), currentCspVariable.getValue()));
        }
        return request;
    }

    public void updateDataFile(Map<String, List<String>> data) {
        StringBuilder newVariablesData = new StringBuilder();
        for (Map.Entry<String, Map.Entry<String, Boolean>> operationParameter : this.operationParameters.entrySet()) {
            List<String> paramValues = data.get(operationParameter.getKey());
            String changedParamName = this.origToChangedParamName(operationParameter.getKey());
            StringBuilder varData = new StringBuilder("data_" + changedParamName + " = {");
            if (paramValues != null) {
                for (String paramValue : paramValues) {
                    varData.append(this.origToChangedParamValue(operationParameter.getKey(), paramValue)).append(", ");
                }
                varData = new StringBuilder(varData.substring(0, varData.length() - 2));
                varData.append("};\ndata_").append(changedParamName).append("Set = {0, 1};\n");
            } else {
                varData.append("0};\ndata_").append(changedParamName).append("Set = {0};\n");
            }
            newVariablesData.append((CharSequence)varData);
        }
        this.variablesData = newVariablesData.toString();
        FileManager.appendContentToFile(this.cr.DATA_FILE, this.variablesData);
    }

    public void resetCurrentProblem() {
        this.currentProblem = this.baseProblem;
    }

    public Boolean hasDeps() {
        return !this.idlConstraints.equals("");
    }
}

