/*
 * Decompiled with CFR 0.152.
 */
package es.us.isa.idlreasoner.mapper;

import es.us.isa.idlreasoner.mapper.AbstractMapper;
import es.us.isa.idlreasoner.mapper.DependenciesMapper;
import es.us.isa.idlreasoner.mapper.OAS2MiniZincMapper;
import es.us.isa.idlreasoner.util.CommonResources;
import es.us.isa.idlreasoner.util.FileManager;
import es.us.isa.idlreasoner.util.IDLConfiguration;
import es.us.isa.idlreasoner.util.Utils;
import java.io.IOException;

public class MapperCreator {
    public static AbstractMapper createMapper(CommonResources cr, String specificationType, String idlPath, String apiSpecificationPath, String operationPath, String operationType) {
        OAS2MiniZincMapper mapper = null;
        if (specificationType.toLowerCase().equals("oas")) {
            mapper = new OAS2MiniZincMapper(cr, apiSpecificationPath, operationPath, operationType);
            if (idlPath == null) {
                mapper.generateIDLfromIDL4OAS(apiSpecificationPath, operationPath, operationType);
            }
        } else {
            Utils.terminate("Specification type " + specificationType + " not supported.");
        }
        mapper.dm = new DependenciesMapper(cr, idlPath == null ? cr.IDL_AUX_FILE : "./" + IDLConfiguration.IDL_FILES_FOLDER + "/" + idlPath);
        mapper.idlConstraints = FileManager.readFile(cr.BASE_CONSTRAINTS_FILE);
        try {
            ((AbstractMapper)mapper).mapVariables();
        }
        catch (IOException e) {
            Utils.terminate("There was an error while mapping the variables for analysing dependencies. Try again.", e);
        }
        return mapper;
    }
}

