/*
 * Decompiled with CFR 0.152.
 */
package es.us.isa.idlreasoner.mapper;

import es.us.isa.idlreasoner.mapper.AbstractMapper;
import es.us.isa.idlreasoner.util.CommonResources;
import es.us.isa.idlreasoner.util.FileManager;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OAS2MiniZincMapper
extends AbstractMapper {
    private List<Parameter> parameters;

    public OAS2MiniZincMapper(CommonResources cr, String apiSpecificationPath, String operationPath, String operationType) {
        super(cr);
        this.specificationPath = apiSpecificationPath;
        ParseOptions options = new ParseOptions();
        options.setResolveFully(true);
        OpenAPI openAPISpec = new OpenAPIV3Parser().read(apiSpecificationPath);
        Operation operation = OAS2MiniZincMapper.getOasOperation(openAPISpec, operationPath, operationType);
        this.parameters = operation.getParameters();
        if (operation.getRequestBody() != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<Parameter>();
            }
            this.parameters.addAll(this.getFormDataParameters(operation));
        }
    }

    @Override
    public void mapVariables() throws IOException {
        if (this.parameters == null || this.parameters.size() == 0) {
            return;
        }
        this.operationParameters.clear();
        this.initializeStringIntMapping();
        StringBuilder currentVariables = new StringBuilder();
        this.variables = "";
        StringBuilder currentVariablesData = new StringBuilder();
        this.variablesData = "";
        this.requiredVarsConstraints = "";
        this.redundantSolutionsConstraints = "";
        this.baseProblem = "";
        this.redundantSolutionsConstraints = this.redundantSolutionsConstraints + "%%% The following constraints are to avoid redundant solutions returned by MiniZinc %%%\n";
        for (Parameter parameter : this.parameters) {
            String paramType = parameter.getSchema().getType();
            List paramEnum = parameter.getSchema().getEnum();
            String changedParamName = this.origToChangedParamName(parameter.getName());
            String var = "set of int: data_" + changedParamName + ";\nvar data_" + changedParamName + ": " + changedParamName + ";\n";
            String varSet = "set of int: data_" + changedParamName + "Set;\nvar data_" + changedParamName + "Set: " + changedParamName + "Set;\n";
            StringBuilder varData = new StringBuilder("data_" + changedParamName + " = ");
            String varSetData = "data_" + changedParamName + "Set = {0, 1};\n";
            if (paramType.equals("boolean")) {
                varData.append("{0, 1};\n");
                this.mapRedundantConstraint(changedParamName, "0");
            } else if (paramEnum != null) {
                varData.append("{");
                if (paramType.equals("string")) {
                    for (Object o : paramEnum) {
                        Integer intMapping = (Integer)this.stringIntMapping.get(o.toString());
                        if (intMapping != null) {
                            varData.append(intMapping).append(", ");
                            continue;
                        }
                        this.stringIntMapping.put(o.toString(), this.stringToIntCounter);
                        Integer n = this.stringToIntCounter;
                        Integer n2 = this.stringToIntCounter = Integer.valueOf(this.stringToIntCounter + 1);
                        varData.append(n).append(", ");
                    }
                    this.mapRedundantConstraint(changedParamName, Integer.toString(this.stringToIntCounter - 1));
                } else if (paramType.equals("integer")) {
                    for (Object o : paramEnum) {
                        varData.append(o).append(", ");
                    }
                    this.mapRedundantConstraint(changedParamName, paramEnum.get(0).toString());
                } else {
                    throw new IllegalArgumentException("The enum parameter type '" + paramType + "' is not allowed for IDLReasoner to work.");
                }
                varData = new StringBuilder(varData.substring(0, varData.length() - 2));
                varData.append("};\n");
            } else if (paramType.equals("string") || paramType.equals("array")) {
                varData.append("0..100000;\n");
                this.mapRedundantConstraint(changedParamName, "1");
            } else if (paramType.equals("integer") || paramType.equals("number")) {
                varData.append("-1000..1000;\n");
                this.mapRedundantConstraint(changedParamName, "1");
            } else {
                throw new IllegalArgumentException("The parameter type '" + paramType + "' is not allowed for IDLReasoner to work.");
            }
            currentVariables.append(var);
            currentVariables.append(varSet);
            if (Boolean.TRUE.equals(parameter.getRequired())) {
                this.mapRequiredVar(changedParamName);
            }
            currentVariablesData.append(varData.toString());
            currentVariablesData.append(varSetData);
            this.operationParameters.put(parameter.getName(), new AbstractMap.SimpleEntry<String, Boolean>(paramType, Boolean.TRUE.equals(parameter.getRequired())));
        }
        this.variables = currentVariables.toString();
        this.redundantSolutionsConstraints = this.redundantSolutionsConstraints + "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n\n";
        this.baseProblem = this.variables + "\n" + this.idlConstraints + "\n" + this.requiredVarsConstraints;
        this.variablesData = currentVariablesData.toString();
        FileManager.writeContentToFile(this.cr.BASE_CONSTRAINTS_FILE, this.baseProblem);
        FileManager.writeContentToFile(this.cr.DATA_FILE, this.variablesData);
        FileManager.writeContentToFile(this.cr.BASE_DATA_FILE, this.variablesData);
        this.exportStringIntMappingToFile();
        this.fixStringToIntCounter();
    }

    private static Operation getOasOperation(OpenAPI openAPISpec, String operationPath, String operationType) {
        if (operationType.toLowerCase().equals("get")) {
            return ((PathItem)openAPISpec.getPaths().get(operationPath)).getGet();
        }
        if (operationType.toLowerCase().equals("delete")) {
            return ((PathItem)openAPISpec.getPaths().get(operationPath)).getDelete();
        }
        if (operationType.toLowerCase().equals("post")) {
            return ((PathItem)openAPISpec.getPaths().get(operationPath)).getPost();
        }
        if (operationType.toLowerCase().equals("put")) {
            return ((PathItem)openAPISpec.getPaths().get(operationPath)).getPut();
        }
        if (operationType.toLowerCase().equals("patch")) {
            return ((PathItem)openAPISpec.getPaths().get(operationPath)).getPatch();
        }
        if (operationType.toLowerCase().equals("head")) {
            return ((PathItem)openAPISpec.getPaths().get(operationPath)).getHead();
        }
        if (operationType.toLowerCase().equals("options")) {
            return ((PathItem)openAPISpec.getPaths().get(operationPath)).getOptions();
        }
        return null;
    }

    private Collection<Parameter> getFormDataParameters(Operation operation) {
        Map<String, Schema> formDataBodyProperties;
        Schema formDataBody;
        ArrayList<Parameter> formDataParameters = new ArrayList<Parameter>();
        try {
            formDataBody = ((MediaType)operation.getRequestBody().getContent().get("application/x-www-form-urlencoded")).getSchema();
            formDataBodyProperties = formDataBody.getProperties();
        }
        catch (NullPointerException e) {
            return formDataParameters;
        }
        for (Map.Entry<String, Schema> property : formDataBodyProperties.entrySet()) {
            Parameter parameter = new Parameter().name(property.getKey()).in("formData").required(formDataBody.getRequired().contains(property.getKey()));
            parameter.setSchema(new Schema().type(property.getValue().getType()));
            parameter.getSchema().setEnum(property.getValue().getEnum());
            formDataParameters.add(parameter);
        }
        return formDataParameters;
    }

    public void generateIDLfromIDL4OAS(String apiSpecificationPath, String operationPath, String operationType) {
        ParseOptions options = new ParseOptions();
        options.setResolveFully(true);
        OpenAPI oasSpec = new OpenAPIV3Parser().read(apiSpecificationPath);
        Operation oasOp = OAS2MiniZincMapper.getOasOperation(oasSpec, operationPath, operationType);
        List IDLdeps = null;
        try {
            IDLdeps = (List)oasOp.getExtensions().get("x-dependencies");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (IDLdeps != null && IDLdeps.size() != 0) {
            String allDeps = String.join((CharSequence)"\n", IDLdeps);
            FileManager.appendContentToFile(this.cr.IDL_AUX_FILE, allDeps);
        }
    }
}

