/*
 * Decompiled with CFR 0.152.
 */
package es.us.isa.idlreasoner.util;

import es.us.isa.idlreasoner.util.CommonResources;
import es.us.isa.idlreasoner.util.FileManager;
import es.us.isa.idlreasoner.util.PropertyManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;

public class IDLConfiguration {
    public static final String SOLUTION_SEP = "----------";
    public static final String IDL_AUX_FOLDER = "idl_aux_files";
    public static String SOLVER;
    public static String IDL_FILES_FOLDER;
    public static String MAX_RESULTS;
    public static Long TIMEOUT;

    private static void updateConf() {
        SOLVER = PropertyManager.readProperty("solver");
        IDL_FILES_FOLDER = PropertyManager.readProperty("idlFolder");
        MAX_RESULTS = PropertyManager.readProperty("maxResults");
        TIMEOUT = Long.parseLong(PropertyManager.readProperty("timeout"));
    }

    public static void initFilesAndConf(CommonResources cr) {
        IDLConfiguration.initConfigurationFile();
        IDLConfiguration.updateConf();
        if (!new File(cr.STRING_INT_MAPPING_FILE).exists()) {
            FileManager.createFileIfNotExists(cr.STRING_INT_MAPPING_FILE);
            FileManager.appendContentToFile(cr.STRING_INT_MAPPING_FILE, "{ }");
        }
        FileManager.recreateFile(cr.IDL_AUX_FILE);
        FileManager.recreateFile(cr.BASE_CONSTRAINTS_FILE);
        FileManager.recreateFile(cr.BASE_DATA_FILE);
        FileManager.recreateFile(cr.DATA_FILE);
    }

    private static void initConfigurationFile() {
        String filePath = "src/main/resources/idl-reasoner.properties";
        FileManager.createFileIfNotExists(filePath);
        BufferedReader br = FileManager.openReader(filePath);
        try {
            if (br.readLine() == null) {
                BufferedWriter bw = FileManager.openWriter(filePath);
                bw.append("solver=Gecode\n");
                bw.append("idlFolder=src/test/resources\n");
                bw.append("maxResults=100\n");
                bw.append("timeout=1000\n");
                bw.append("\n");
                bw.flush();
                bw.close();
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

