/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.utils;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Xml;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PropertyModelConverter {
    public Property modelToProperty(Model model) {
        if (model instanceof ModelImpl) {
            ModelImpl m3 = (ModelImpl)model;
            if (m3.getAdditionalProperties() != null) {
                MapProperty mapProperty = new MapProperty();
                mapProperty.setType(m3.getType());
                mapProperty.setAllowEmptyValue(m3.getAllowEmptyValue());
                mapProperty.setDefault((String)m3.getDefaultValue());
                mapProperty.setDescription(m3.getDescription());
                mapProperty.setExample(m3.getExample());
                mapProperty.setFormat(m3.getFormat());
                mapProperty.setName(m3.getName());
                mapProperty.setTitle(m3.getTitle());
                List<String> required = m3.getRequired();
                if (required != null) {
                    for (String name : required) {
                        if (!name.equals(m3.getName())) continue;
                        mapProperty.setRequired(true);
                    }
                }
                mapProperty.setXml(m3.getXml());
                mapProperty.setVendorExtensions(m3.getVendorExtensions());
                mapProperty.setAdditionalProperties(m3.getAdditionalProperties());
                return mapProperty;
            }
            Property property = this.propertyByType(m3);
            if (property instanceof ObjectProperty) {
                ObjectProperty objectProperty = (ObjectProperty)property;
                objectProperty.setProperties(model.getProperties());
                objectProperty.setExample(model.getExample());
                return objectProperty;
            }
            if (property instanceof StringProperty) {
                StringProperty stringProperty = (StringProperty)property;
                ModelImpl modelImpl = (ModelImpl)model;
                stringProperty.setPattern(modelImpl.getPattern());
                stringProperty.setMaxLength(modelImpl.getMaxLength());
                stringProperty.setMinLength(modelImpl.getMinLength());
                return stringProperty;
            }
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty numericProperty = (AbstractNumericProperty)property;
                ModelImpl modelImpl = (ModelImpl)model;
                numericProperty.setMaximum(modelImpl.getMaximum());
                numericProperty.setMinimum(modelImpl.getMinimum());
                numericProperty.setMultipleOf(modelImpl.getMultipleOf());
                numericProperty.setExclusiveMinimum(modelImpl.getExclusiveMinimum());
                numericProperty.setExclusiveMaximum(modelImpl.getExclusiveMaximum());
                return numericProperty;
            }
            return property;
        }
        if (model instanceof ArrayModel) {
            ArrayModel m4 = (ArrayModel)model;
            ArrayProperty property = new ArrayProperty();
            Property inner = m4.getItems();
            property.setItems(inner);
            property.setExample(m4.getExample());
            property.setMaxItems(m4.getMaxItems());
            property.setMinItems(m4.getMinItems());
            property.setDescription(m4.getDescription());
            property.setTitle(m4.getTitle());
            property.setUniqueItems(m4.getUniqueItems());
            return property;
        }
        if (model instanceof RefModel) {
            RefModel ref = (RefModel)model;
            RefProperty refProperty = new RefProperty(ref.get$ref(), ref.getRefFormat());
            return refProperty;
        }
        if (model instanceof ComposedModel) {
            ObjectProperty objectProperty = new ObjectProperty();
            objectProperty.setDescription(model.getDescription());
            objectProperty.setTitle(model.getTitle());
            objectProperty.setExample(model.getExample());
            ComposedModel cm = (ComposedModel)model;
            HashSet<String> requiredProperties = new HashSet<String>();
            for (Model item : cm.getAllOf()) {
                Property itemProperty = this.modelToProperty(item);
                if (itemProperty instanceof RefProperty) {
                    RefProperty refProperty = (RefProperty)itemProperty;
                    objectProperty.property(refProperty.getSimpleRef(), itemProperty);
                    continue;
                }
                if (!(itemProperty instanceof ObjectProperty)) continue;
                ObjectProperty itemPropertyObject = (ObjectProperty)itemProperty;
                if (itemPropertyObject.getProperties() != null) {
                    for (String key : itemPropertyObject.getProperties().keySet()) {
                        objectProperty.property(key, itemPropertyObject.getProperties().get(key));
                    }
                }
                if (itemPropertyObject.getRequiredProperties() == null) continue;
                for (String req : itemPropertyObject.getRequiredProperties()) {
                    requiredProperties.add(req);
                }
            }
            if (requiredProperties.size() > 0) {
                objectProperty.setRequiredProperties(new ArrayList<String>(requiredProperties));
            }
            if (cm.getVendorExtensions() != null) {
                for (String key : cm.getVendorExtensions().keySet()) {
                    objectProperty.vendorExtension(key, cm.getVendorExtensions().get(key));
                }
            }
            return objectProperty;
        }
        return null;
    }

    private Property propertyByType(ModelImpl model) {
        return PropertyBuilder.build(model.getType(), model.getFormat(), this.argsFromModel(model));
    }

    private Map<PropertyBuilder.PropertyId, Object> argsFromModel(ModelImpl model) {
        if (model == null) {
            return Collections.emptyMap();
        }
        EnumMap<PropertyBuilder.PropertyId, Object> args = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
        args.put(PropertyBuilder.PropertyId.DESCRIPTION, model.getDescription());
        args.put(PropertyBuilder.PropertyId.EXAMPLE, model.getExample());
        args.put(PropertyBuilder.PropertyId.ENUM, model.getEnum());
        args.put(PropertyBuilder.PropertyId.TITLE, model.getTitle());
        args.put(PropertyBuilder.PropertyId.DEFAULT, model.getDefaultValue());
        args.put(PropertyBuilder.PropertyId.DESCRIMINATOR, model.getDiscriminator());
        args.put(PropertyBuilder.PropertyId.UNIQUE_ITEMS, model.getUniqueItems());
        args.put(PropertyBuilder.PropertyId.VENDOR_EXTENSIONS, model.getVendorExtensions());
        args.put(PropertyBuilder.PropertyId.PATTERN, model.getPattern());
        args.put(PropertyBuilder.PropertyId.MAXIMUM, model.getMaximum());
        args.put(PropertyBuilder.PropertyId.MINIMUM, model.getMinimum());
        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, model.getExclusiveMaximum());
        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, model.getExclusiveMinimum());
        args.put(PropertyBuilder.PropertyId.MULTIPLE_OF, model.getMultipleOf());
        args.put(PropertyBuilder.PropertyId.MIN_LENGTH, model.getMinLength());
        args.put(PropertyBuilder.PropertyId.MAX_LENGTH, model.getMaxLength());
        return args;
    }

    public Model propertyToModel(Property property) {
        String description = property.getDescription();
        String type = property.getType();
        String format = property.getFormat();
        Object example = null;
        Boolean allowEmptyValue = property.getAllowEmptyValue();
        if (property instanceof RefProperty) {
            RefProperty ref = (RefProperty)property;
            RefModel refModel = new RefModel(ref.getOriginalRef(), ref.getRefFormat());
            return refModel;
        }
        Map<String, Object> extensions = property.getVendorExtensions();
        Property additionalProperties = null;
        if (property instanceof MapProperty) {
            additionalProperties = ((MapProperty)property).getAdditionalProperties();
        }
        String name = property.getName();
        Xml xml = property.getXml();
        Map<String, Property> properties = null;
        if (property instanceof ObjectProperty) {
            ObjectProperty objectProperty = (ObjectProperty)property;
            properties = objectProperty.getProperties();
        }
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            ArrayModel arrayModel = new ArrayModel();
            arrayModel.setItems(arrayProperty.getItems());
            arrayModel.setDescription(description);
            arrayModel.setExample(example);
            arrayModel.setUniqueItems(arrayProperty.getUniqueItems());
            if (extensions != null) {
                arrayModel.setVendorExtensions(extensions);
            }
            if (properties != null) {
                arrayModel.setProperties(properties);
            }
            return arrayModel;
        }
        ModelImpl model = new ModelImpl();
        model.setDescription(description);
        model.setExample(property.getExample());
        model.setName(name);
        model.setXml(xml);
        model.setType(type);
        model.setFormat(format);
        model.setAllowEmptyValue(allowEmptyValue);
        if (property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property;
            model.setPattern(stringProperty.getPattern());
            model.setMinLength(stringProperty.getMinLength());
            model.setMaxLength(stringProperty.getMaxLength());
            model.setEnum(stringProperty.getEnum());
        }
        if (property instanceof AbstractNumericProperty) {
            AbstractNumericProperty numericProperty = (AbstractNumericProperty)property;
            model.setMaximum(numericProperty.getMaximum());
            model.setMinimum(numericProperty.getMinimum());
            model.setExclusiveMaximum(numericProperty.getExclusiveMaximum());
            model.setExclusiveMinimum(numericProperty.getExclusiveMinimum());
            model.setMultipleOf(numericProperty.getMultipleOf());
        }
        if (extensions != null) {
            model.setVendorExtensions(extensions);
        }
        if (additionalProperties != null) {
            model.setAdditionalProperties(additionalProperties);
        }
        if (properties != null) {
            model.setProperties(properties);
        }
        return model;
    }
}

