/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.models.RefType;
import io.swagger.v3.parser.util.RefUtils;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalRefProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalRefProcessor.class);
    private final ResolverCache cache;
    private final OpenAPI openAPI;

    public ExternalRefProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.openAPI = openAPI;
    }

    public String processRefToExternalSchema(String $ref, RefFormat refFormat) {
        Map<String, Schema> schemas;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Schema schema = this.cache.loadRef($ref, refFormat, Schema.class);
        if (schema == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((schemas = this.openAPI.getComponents().getSchemas()) == null) {
            schemas = new LinkedHashMap<String, Schema>();
        }
        String possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref);
        String tryName = null;
        Schema existingModel = schemas.get(possiblyConflictingDefinitionName);
        if (existingModel != null) {
            LOGGER.warn("A model for " + existingModel + " already exists");
            if (existingModel.get$ref() != null) {
                existingModel = null;
            } else if (!schema.equals(existingModel)) {
                int i = 2;
                for (String string : schemas.keySet()) {
                    if (!string.equals(possiblyConflictingDefinitionName)) continue;
                    tryName = possiblyConflictingDefinitionName + "_" + i;
                    existingModel = schemas.get(tryName);
                    ++i;
                }
            }
        }
        String newRef = StringUtils.isNotBlank(tryName) ? tryName : possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingModel == null) {
            this.openAPI.getComponents().addSchemas(newRef, schema);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (schema.get$ref() != null) {
                RefFormat ref = RefUtils.computeRefFormat(schema.get$ref());
                if (RefUtils.isAnExternalRefFormat(ref)) {
                    schema.set$ref(this.processRefToExternalSchema(schema.get$ref(), ref));
                } else {
                    this.processRefToExternalSchema(file + schema.get$ref(), RefFormat.RELATIVE);
                }
            }
            if (schema instanceof ComposedSchema) {
                ComposedSchema composedSchema = (ComposedSchema)schema;
                if (composedSchema.getAllOf() != null) {
                    for (Schema item : composedSchema.getAllOf()) {
                        if (item.get$ref() != null) {
                            this.processRefSchema(item, file);
                            continue;
                        }
                        if (item.getProperties() == null) continue;
                        this.processProperties(item.getProperties(), file);
                    }
                }
                if (composedSchema.getOneOf() != null) {
                    for (Schema item : composedSchema.getOneOf()) {
                        if (item.get$ref() == null || item.get$ref() == null) continue;
                        this.processRefSchema(item, file);
                    }
                }
                if (composedSchema.getAnyOf() != null) {
                    for (Schema item : composedSchema.getAnyOf()) {
                        if (item.get$ref() == null || item.get$ref() == null) continue;
                        this.processRefSchema(item, file);
                    }
                }
            }
            Map<String, Schema> subProps = schema.getProperties();
            this.processProperties(subProps, file);
            this.processDiscriminator(schema.getDiscriminator(), file);
            if (schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema) {
                Schema schema2 = (Schema)schema.getAdditionalProperties();
                if (schema2.get$ref() != null) {
                    this.processRefSchema(schema2, file);
                } else if (schema2 instanceof ArraySchema) {
                    ArraySchema arrayProp = (ArraySchema)schema2;
                    if (arrayProp.getItems() != null && arrayProp.getItems().get$ref() != null && StringUtils.isNotBlank(arrayProp.get$ref())) {
                        this.processRefSchema(arrayProp.getItems(), file);
                    }
                } else if (schema2.getAdditionalProperties() != null && schema2.getAdditionalProperties() instanceof Schema) {
                    Schema mapProp = (Schema)schema2.getAdditionalProperties();
                    if (mapProp.get$ref() != null) {
                        this.processRefSchema(mapProp, file);
                    } else if (mapProp.getAdditionalProperties() instanceof ArraySchema && ((ArraySchema)mapProp).getItems() != null && ((ArraySchema)mapProp).getItems().get$ref() != null && StringUtils.isNotBlank(((ArraySchema)mapProp).getItems().get$ref())) {
                        this.processRefSchema(((ArraySchema)mapProp).getItems(), file);
                    }
                }
            }
            if (schema instanceof ArraySchema && ((ArraySchema)schema).getItems() != null) {
                ArraySchema arraySchema = (ArraySchema)schema;
                if (StringUtils.isNotBlank(arraySchema.getItems().get$ref())) {
                    this.processRefSchema(((ArraySchema)schema).getItems(), file);
                } else {
                    this.processProperties(arraySchema.getItems().getProperties(), file);
                }
            }
        }
        return newRef;
    }

    private void processSchema(Schema property, String file) {
        if (property != null) {
            if (StringUtils.isNotBlank(property.get$ref())) {
                this.processRefSchema(property, file);
            }
            if (property.getProperties() != null) {
                this.processProperties(property.getProperties(), file);
            }
            if (property instanceof ArraySchema) {
                this.processSchema(((ArraySchema)property).getItems(), file);
            }
            if (property.getAdditionalProperties() instanceof Schema) {
                this.processSchema((Schema)property.getAdditionalProperties(), file);
            }
            if (property instanceof ComposedSchema) {
                ComposedSchema composed = (ComposedSchema)property;
                this.processProperties(composed.getAllOf(), file);
                this.processProperties(composed.getAnyOf(), file);
                this.processProperties(composed.getOneOf(), file);
            }
        }
    }

    private void processProperties(Collection<Schema> properties, String file) {
        if (properties != null) {
            for (Schema property : properties) {
                this.processSchema(property, file);
            }
        }
    }

    private void processProperties(Map<String, Schema> properties, String file) {
        if (properties != null) {
            this.processProperties(properties.values(), file);
        }
    }

    public PathItem processRefToExternalPathItem(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        PathItem existingPathItem;
        PathItem pathItem = this.cache.loadRef($ref, refFormat, PathItem.class);
        LinkedHashMap paths = this.openAPI.getPaths();
        if (paths == null) {
            paths = new LinkedHashMap();
        }
        if ((existingPathItem = (PathItem)paths.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingPathItem + " already exists");
            if (existingPathItem.get$ref() != null) {
                existingPathItem = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (pathItem != null && pathItem.readOperationsMap() != null) {
            Map<PathItem.HttpMethod, Operation> operationMap = pathItem.readOperationsMap();
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                ApiResponses responses;
                Operation operation = operationMap.get((Object)httpMethod);
                if (operation.getResponses() != null && (responses = operation.getResponses()) != null) {
                    for (String responseCode : responses.keySet()) {
                        ApiResponse response = (ApiResponse)responses.get(responseCode);
                        if (response == null) continue;
                        Schema schema = null;
                        if (response.getContent() == null) continue;
                        Content content = response.getContent();
                        for (String mediaName : content.keySet()) {
                            MediaType mediaType = (MediaType)content.get(mediaName);
                            if (mediaType.getSchema() == null || (schema = mediaType.getSchema()) == null) continue;
                            this.processRefSchemaObject(mediaType.getSchema(), $ref);
                        }
                    }
                }
                if (operation.getRequestBody() == null) continue;
                RequestBody body = operation.getRequestBody();
                Schema schema = null;
                if (body.getContent() == null) continue;
                Content content = body.getContent();
                for (String mediaName : content.keySet()) {
                    MediaType mediaType = (MediaType)content.get(mediaName);
                    if (mediaType.getSchema() == null || (schema = mediaType.getSchema()) == null) continue;
                    this.processRefSchemaObject(mediaType.getSchema(), $ref);
                }
            }
        }
        return pathItem;
    }

    private void processDiscriminator(Discriminator d, String file) {
        if (d != null && d.getMapping() != null) {
            this.processDiscriminatorMapping(d.getMapping(), file);
        }
    }

    private void processDiscriminatorMapping(Map<String, String> mapping, String file) {
        for (String key : mapping.keySet()) {
            String ref = mapping.get(key);
            Schema subtype = new Schema().$ref(ref);
            this.processSchema(subtype, file);
            mapping.put(key, subtype.get$ref());
        }
    }

    public String processRefToExternalResponse(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        ApiResponse existingResponse;
        Map<String, ApiResponse> responses;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        ApiResponse response = this.cache.loadRef($ref, refFormat, ApiResponse.class);
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((responses = this.openAPI.getComponents().getResponses()) == null) {
            responses = new LinkedHashMap<String, ApiResponse>();
        }
        if ((existingResponse = responses.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingResponse + " already exists");
            if (existingResponse.get$ref() != null) {
                existingResponse = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (response != null) {
            if (response.getContent() != null) {
                this.processRefContent(response.getContent(), $ref);
            }
            if (response.getHeaders() != null) {
                this.processRefHeaders(response.getHeaders(), $ref);
            }
            if (response.getLinks() != null) {
                this.processRefLinks(response.getLinks(), $ref);
            }
        }
        return newRef;
    }

    public String processRefToExternalRequestBody(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        RequestBody existingBody;
        Map<String, RequestBody> bodies;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        RequestBody body = this.cache.loadRef($ref, refFormat, RequestBody.class);
        if (body == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((bodies = this.openAPI.getComponents().getRequestBodies()) == null) {
            bodies = new LinkedHashMap<String, RequestBody>();
        }
        if ((existingBody = bodies.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingBody + " already exists");
            if (existingBody.get$ref() != null) {
                existingBody = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingBody == null) {
            this.openAPI.getComponents().addRequestBodies(newRef, body);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (body.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(body.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    body.set$ref(this.processRefToExternalRequestBody(body.get$ref(), format));
                } else {
                    this.processRefToExternalRequestBody(file + body.get$ref(), RefFormat.RELATIVE);
                }
            } else if (body.getContent() != null) {
                this.processRefContent(body.getContent(), $ref);
            }
        }
        return newRef;
    }

    public String processRefToExternalHeader(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Header existingHeader;
        Map<String, Header> headers;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Header header = this.cache.loadRef($ref, refFormat, Header.class);
        if (header == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((headers = this.openAPI.getComponents().getHeaders()) == null) {
            headers = new LinkedHashMap<String, Header>();
        }
        if ((existingHeader = headers.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingHeader + " already exists");
            if (existingHeader.get$ref() != null) {
                existingHeader = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingHeader == null) {
            this.openAPI.getComponents().addHeaders(newRef, header);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (header.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(header.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    header.set$ref(this.processRefToExternalHeader(header.get$ref(), format));
                } else {
                    this.processRefToExternalHeader(file + header.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        if (header != null) {
            if (header.getContent() != null) {
                this.processRefContent(header.getContent(), $ref);
            }
            if (header.getSchema() != null) {
                this.processRefSchemaObject(header.getSchema(), $ref);
            }
        }
        return newRef;
    }

    public String processRefToExternalSecurityScheme(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        SecurityScheme existingSecurityScheme;
        Map<String, SecurityScheme> securitySchemeMap;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        SecurityScheme securityScheme = this.cache.loadRef($ref, refFormat, SecurityScheme.class);
        if (securityScheme == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((securitySchemeMap = this.openAPI.getComponents().getSecuritySchemes()) == null) {
            securitySchemeMap = new LinkedHashMap<String, SecurityScheme>();
        }
        if ((existingSecurityScheme = securitySchemeMap.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingSecurityScheme + " already exists");
            if (existingSecurityScheme.get$ref() != null) {
                existingSecurityScheme = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingSecurityScheme == null) {
            this.openAPI.getComponents().addSecuritySchemes(newRef, securityScheme);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (securityScheme.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(securityScheme.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    securityScheme.set$ref(this.processRefToExternalSecurityScheme(securityScheme.get$ref(), format));
                } else {
                    this.processRefToExternalSecurityScheme(file + securityScheme.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalLink(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Link existingLink;
        Map<String, Link> links;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Link link = this.cache.loadRef($ref, refFormat, Link.class);
        if (link == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((links = this.openAPI.getComponents().getLinks()) == null) {
            links = new LinkedHashMap<String, Link>();
        }
        if ((existingLink = links.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingLink + " already exists");
            if (existingLink.get$ref() != null) {
                existingLink = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingLink == null) {
            this.openAPI.getComponents().addLinks(newRef, link);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (link.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(link.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    link.set$ref(this.processRefToExternalLink(link.get$ref(), format));
                } else {
                    this.processRefToExternalLink(file + link.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalExample(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Example existingExample;
        Map<String, Example> examples;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Example example = this.cache.loadRef($ref, refFormat, Example.class);
        if (example == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((examples = this.openAPI.getComponents().getExamples()) == null) {
            examples = new LinkedHashMap<String, Example>();
        }
        if ((existingExample = examples.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingExample + " already exists");
            if (existingExample.get$ref() != null) {
                existingExample = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingExample == null) {
            this.openAPI.getComponents().addExamples(newRef, example);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (example.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(example.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    example.set$ref(this.processRefToExternalExample(example.get$ref(), format));
                } else {
                    this.processRefToExternalExample(file + example.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    public String processRefToExternalParameter(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Parameter existingParameters;
        Map<String, Parameter> parameters;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Parameter parameter = this.cache.loadRef($ref, refFormat, Parameter.class);
        if (parameter == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((parameters = this.openAPI.getComponents().getParameters()) == null) {
            parameters = new LinkedHashMap<String, Parameter>();
        }
        if ((existingParameters = parameters.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingParameters + " already exists");
            if (existingParameters.get$ref() != null) {
                existingParameters = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingParameters == null) {
            this.openAPI.getComponents().addParameters(newRef, parameter);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (parameter.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(parameter.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    parameter.set$ref(this.processRefToExternalParameter(parameter.get$ref(), format));
                } else {
                    this.processRefToExternalParameter(file + parameter.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        if (parameter != null) {
            if (parameter.getContent() != null) {
                this.processRefContent(parameter.getContent(), $ref);
            }
            if (parameter.getSchema() != null) {
                this.processRefSchemaObject(parameter.getSchema(), $ref);
            }
        }
        return newRef;
    }

    public String processRefToExternalCallback(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Callback existingCallback;
        Map<String, Callback> callbacks;
        String renamedRef = this.cache.getRenamedRef($ref);
        if (renamedRef != null) {
            return renamedRef;
        }
        Callback callback = this.cache.loadRef($ref, refFormat, Callback.class);
        if (callback == null) {
            LOGGER.warn("unable to load model reference from `" + $ref + "`.  It may not be available or the reference isn't a valid model schema");
            return $ref;
        }
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        if ((callbacks = this.openAPI.getComponents().getCallbacks()) == null) {
            callbacks = new LinkedHashMap<String, Callback>();
        }
        if ((existingCallback = callbacks.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingCallback + " already exists");
            if (existingCallback.get$ref() != null) {
                existingCallback = null;
            }
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        if (existingCallback == null) {
            this.openAPI.getComponents().addCallbacks(newRef, callback);
            this.cache.addReferencedKey(newRef);
            String file = $ref.split("#/")[0];
            if (callback.get$ref() != null && callback.get$ref() != null) {
                RefFormat format = RefUtils.computeRefFormat(callback.get$ref());
                if (RefUtils.isAnExternalRefFormat(format)) {
                    callback.set$ref(this.processRefToExternalCallback(callback.get$ref(), format));
                } else {
                    this.processRefToExternalCallback(file + callback.get$ref(), RefFormat.RELATIVE);
                }
            }
        }
        return newRef;
    }

    private void processRefContent(Map<String, MediaType> content, String $ref) {
        for (MediaType mediaType : content.values()) {
            if (mediaType.getSchema() != null) {
                this.processRefSchemaObject(mediaType.getSchema(), $ref);
            }
            if (mediaType.getExamples() == null) continue;
            this.processRefExamples(mediaType.getExamples(), $ref);
        }
    }

    private void processRefExamples(Map<String, Example> examples, String $ref) {
        String file = $ref.split("#/")[0];
        for (Example example : examples.values()) {
            if (example.get$ref() == null) continue;
            RefFormat ref = RefUtils.computeRefFormat(example.get$ref());
            if (RefUtils.isAnExternalRefFormat(ref)) {
                this.processRefExample(example, $ref);
                continue;
            }
            this.processRefToExternalExample(file + example.get$ref(), RefFormat.RELATIVE);
        }
    }

    private void processRefExample(Example example, String externalFile) {
        RefFormat format = RefUtils.computeRefFormat(example.get$ref());
        if (!RefUtils.isAnExternalRefFormat(format)) {
            example.set$ref(RefType.SCHEMAS.getInternalPrefix() + this.processRefToExternalSchema(externalFile + example.get$ref(), RefFormat.RELATIVE));
            return;
        }
        String $ref = example.get$ref();
        String subRefExternalPath = RefUtils.getExternalPath(example.get$ref()).orElse(null);
        if (format.equals((Object)RefFormat.RELATIVE) && !Objects.equals(subRefExternalPath, externalFile)) {
            $ref = ExternalRefProcessor.join(externalFile, example.get$ref());
            example.set$ref($ref);
        } else {
            this.processRefToExternalExample($ref, format);
        }
    }

    private void processRefSchemaObject(Schema schema, String $ref) {
        String file = $ref.split("#/")[0];
        if (schema.get$ref() != null) {
            RefFormat ref = RefUtils.computeRefFormat(schema.get$ref());
            if (RefUtils.isAnExternalRefFormat(ref)) {
                this.processRefSchema(schema, $ref);
            } else {
                this.processRefToExternalSchema(file + schema.get$ref(), RefFormat.RELATIVE);
            }
        } else {
            this.processSchema(schema, file);
        }
    }

    private void processRefHeaders(Map<String, Header> headers, String $ref) {
        String file = $ref.split("#/")[0];
        for (Header header : headers.values()) {
            if (header.get$ref() == null) continue;
            RefFormat ref = RefUtils.computeRefFormat(header.get$ref());
            if (RefUtils.isAnExternalRefFormat(ref)) {
                this.processRefHeader(header, $ref);
                continue;
            }
            this.processRefToExternalHeader(file + header.get$ref(), RefFormat.RELATIVE);
        }
    }

    private void processRefLinks(Map<String, Link> links, String $ref) {
        String file = $ref.split("#/")[0];
        for (Link link : links.values()) {
            if (link.get$ref() == null) continue;
            RefFormat ref = RefUtils.computeRefFormat(link.get$ref());
            if (RefUtils.isAnExternalRefFormat(ref)) {
                this.processRefLink(link, $ref);
                continue;
            }
            this.processRefToExternalLink(file + link.get$ref(), RefFormat.RELATIVE);
        }
    }

    private void processRefSchema(Schema subRef, String externalFile) {
        RefFormat format = RefUtils.computeRefFormat(subRef.get$ref());
        if (!RefUtils.isAnExternalRefFormat(format)) {
            subRef.set$ref(RefType.SCHEMAS.getInternalPrefix() + this.processRefToExternalSchema(externalFile + subRef.get$ref(), RefFormat.RELATIVE));
            return;
        }
        String $ref = subRef.get$ref();
        String subRefExternalPath = RefUtils.getExternalPath(subRef.get$ref()).orElse(null);
        if (format.equals((Object)RefFormat.RELATIVE) && !Objects.equals(subRefExternalPath, externalFile)) {
            $ref = this.constructRef(subRef, externalFile);
            subRef.set$ref($ref);
        } else {
            this.processRefToExternalSchema($ref, format);
        }
    }

    protected String constructRef(Schema refProperty, String rootLocation) {
        String ref = refProperty.get$ref();
        return ExternalRefProcessor.join(rootLocation, ref);
    }

    private void processRefHeader(Header subRef, String externalFile) {
        RefFormat format = RefUtils.computeRefFormat(subRef.get$ref());
        if (!RefUtils.isAnExternalRefFormat(format)) {
            subRef.set$ref(RefType.SCHEMAS.getInternalPrefix() + this.processRefToExternalSchema(externalFile + subRef.get$ref(), RefFormat.RELATIVE));
            return;
        }
        String $ref = subRef.get$ref();
        String subRefExternalPath = RefUtils.getExternalPath(subRef.get$ref()).orElse(null);
        if (format.equals((Object)RefFormat.RELATIVE) && !Objects.equals(subRefExternalPath, externalFile)) {
            $ref = ExternalRefProcessor.join(externalFile, subRef.get$ref());
            subRef.set$ref($ref);
        } else {
            this.processRefToExternalHeader($ref, format);
        }
    }

    private void processRefLink(Link subRef, String externalFile) {
        RefFormat format = RefUtils.computeRefFormat(subRef.get$ref());
        if (!RefUtils.isAnExternalRefFormat(format)) {
            subRef.set$ref(RefType.SCHEMAS.getInternalPrefix() + this.processRefToExternalSchema(externalFile + subRef.get$ref(), RefFormat.RELATIVE));
            return;
        }
        String $ref = subRef.get$ref();
        String subRefExternalPath = RefUtils.getExternalPath(subRef.get$ref()).orElse(null);
        if (format.equals((Object)RefFormat.RELATIVE) && !Objects.equals(subRefExternalPath, externalFile)) {
            $ref = ExternalRefProcessor.join(externalFile, subRef.get$ref());
            subRef.set$ref($ref);
        } else {
            this.processRefToExternalLink($ref, format);
        }
    }

    public static String join(String source, String fragment) {
        try {
            boolean isRelative = false;
            if (source.startsWith("/") || source.startsWith(".")) {
                isRelative = true;
            }
            URI uri = new URI(source);
            if (!source.endsWith("/") && fragment.startsWith("./") && "".equals(uri.getPath())) {
                uri = new URI(source + "/");
            } else if ("".equals(uri.getPath()) && !fragment.startsWith("/")) {
                uri = new URI(source + "/");
            }
            URI f = new URI(fragment);
            URI resolved = uri.resolve(f);
            URI normalized = resolved.normalize();
            if (Character.isAlphabetic(normalized.toString().charAt(0)) && isRelative) {
                return "./" + normalized.toString();
            }
            return normalized.toString();
        }
        catch (Exception e) {
            return source;
        }
    }
}

