/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.osgi.framework.util.FilePath;
import org.eclipse.osgi.framework.util.ObjectPool;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.framework.EquinoxContainerAdaptor;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.eclipse.osgi.internal.hookregistry.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.internal.hookregistry.StorageHookFactory;
import org.eclipse.osgi.internal.location.LocationHelper;
import org.eclipse.osgi.internal.log.EquinoxLogServices;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.FrameworkExtensionInstaller;
import org.eclipse.osgi.storage.PermissionData;
import org.eclipse.osgi.storage.StorageUtil;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapperChain;
import org.eclipse.osgi.storage.bundlefile.DirBundleFile;
import org.eclipse.osgi.storage.bundlefile.MRUBundleFileList;
import org.eclipse.osgi.storage.bundlefile.NestedDirBundleFile;
import org.eclipse.osgi.storage.bundlefile.ZipBundleFile;
import org.eclipse.osgi.storage.url.reference.Handler;
import org.eclipse.osgi.storage.url.reference.ReferenceInputStream;
import org.eclipse.osgi.storagemanager.ManagedOutputStream;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.resource.Requirement;

public class Storage {
    public static final int VERSION = 5;
    private static final int MR_JAR_VERSION = 4;
    private static final int CACHED_SYSTEM_CAPS_VERION = 5;
    private static final int LOWEST_VERSION_SUPPORTED = 3;
    public static final String BUNDLE_DATA_DIR = "data";
    public static final String BUNDLE_FILE_NAME = "bundleFile";
    public static final String FRAMEWORK_INFO = "framework.info";
    public static final String ECLIPSE_SYSTEMBUNDLE = "Eclipse-SystemBundle";
    public static final String DELETE_FLAG = ".delete";
    public static final String LIB_TEMP = "libtemp";
    private static final String JAVASE = "JavaSE";
    private static final String PROFILE_EXT = ".profile";
    private static final String NUL = new String(new byte[1]);
    private static final String INITIAL_LOCATION = "initial@";
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private final EquinoxContainer equinoxContainer;
    private final String installPath;
    private final Location osgiLocation;
    private final File childRoot;
    private final File parentRoot;
    private final PermissionData permissionData;
    private final SecurityAdmin securityAdmin;
    private final EquinoxContainerAdaptor adaptor;
    private final ModuleDatabase moduleDatabase;
    private final ModuleContainer moduleContainer;
    private final Object saveMonitor = new Object();
    private long lastSavedTimestamp = -1L;
    private final MRUBundleFileList mruList;
    private final FrameworkExtensionInstaller extensionInstaller;
    private final List<String> cachedHeaderKeys = Arrays.asList("Bundle-SymbolicName", "Bundle-ActivationPolicy", "Service-Component");
    private final boolean allowRestrictedProvides;
    private final AtomicBoolean refreshMRBundles = new AtomicBoolean(false);
    private final Version runtimeVersion;
    private final String javaSpecVersion;

    public static Storage createStorage(EquinoxContainer container) throws IOException, BundleException {
        String[] cachedInfo = new String[3];
        Storage storage = new Storage(container, cachedInfo);
        storage.checkSystemBundle(cachedInfo);
        storage.refreshStaleBundles();
        storage.installExtensions();
        storage.getModuleContainer().setInitialModuleStates();
        return storage;
    }

    private Storage(EquinoxContainer container, String[] cachedInfo) throws IOException {
        InputStream info;
        Location parent;
        Version javaVersion = Version.valueOf("1.7");
        String javaSpecVersionProp = System.getProperty("java.specification.version");
        StringTokenizer st = new StringTokenizer(javaSpecVersionProp, " _-");
        javaSpecVersionProp = st.nextToken();
        try {
            String[] vComps = javaSpecVersionProp.split("\\.");
            int major = vComps.length > 0 ? Integer.parseInt(vComps[0]) : 0;
            int minor = vComps.length > 1 ? Integer.parseInt(vComps[1]) : 0;
            int micro = vComps.length > 2 ? Integer.parseInt(vComps[2]) : 0;
            javaVersion = new Version(major, minor, micro);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.runtimeVersion = javaVersion;
        this.javaSpecVersion = javaSpecVersionProp;
        this.mruList = new MRUBundleFileList(this.getBundleFileLimit(container.getConfiguration()), container.getConfiguration().getDebug());
        this.equinoxContainer = container;
        this.extensionInstaller = new FrameworkExtensionInstaller(container.getConfiguration());
        this.allowRestrictedProvides = Boolean.parseBoolean(container.getConfiguration().getConfiguration("osgi.equinox.allow.restricted.provides"));
        Location installLoc = container.getLocations().getInstallLocation();
        URL installURL = installLoc.getURL();
        this.installPath = installURL.getPath();
        Location configLocation = container.getLocations().getConfigurationLocation();
        Location parentConfigLocation = configLocation.getParentLocation();
        Location osgiParentLocation = null;
        if (parentConfigLocation != null) {
            osgiParentLocation = parentConfigLocation.createLocation(null, parentConfigLocation.getDataArea("org.eclipse.osgi"), true);
        }
        this.osgiLocation = configLocation.createLocation(osgiParentLocation, configLocation.getDataArea("org.eclipse.osgi"), configLocation.isReadOnly());
        this.childRoot = new File(this.osgiLocation.getURL().getPath());
        if (Boolean.valueOf(container.getConfiguration().getConfiguration("osgi.clean")).booleanValue()) {
            this.cleanOSGiStorage(this.osgiLocation, this.childRoot);
        }
        if (!this.osgiLocation.isReadOnly()) {
            this.childRoot.mkdirs();
        }
        File file = this.parentRoot = (parent = this.osgiLocation.getParentLocation()) == null ? null : new File(parent.getURL().getPath());
        if (container.getConfiguration().getConfiguration("org.osgi.framework.storage") == null) {
            container.getConfiguration().setConfiguration("org.osgi.framework.storage", this.childRoot.getParentFile().getAbsolutePath());
        }
        DataInputStream data = (info = this.getInfoInputStream()) == null ? null : new DataInputStream(new BufferedInputStream(info));
        try {
            Map<Long, BundleInfo.Generation> generations;
            try {
                generations = this.loadGenerations(data, cachedInfo);
            }
            catch (IllegalArgumentException e) {
                this.equinoxContainer.getLogServices().log("org.eclipse.osgi", 2, "The persistent format for the framework data has changed.  The framework will be reinitialized: " + e.getMessage(), null);
                generations = new HashMap<Long, BundleInfo.Generation>(0);
                data = null;
                this.cleanOSGiStorage(this.osgiLocation, this.childRoot);
            }
            this.permissionData = Storage.loadPermissionData(data);
            this.securityAdmin = new SecurityAdmin(null, this.permissionData);
            this.adaptor = new EquinoxContainerAdaptor(this.equinoxContainer, this, generations);
            this.moduleDatabase = new ModuleDatabase(this.adaptor);
            this.moduleContainer = new ModuleContainer(this.adaptor, this.moduleDatabase);
            if (data != null) {
                try {
                    this.moduleDatabase.load(data);
                    this.lastSavedTimestamp = this.moduleDatabase.getTimestamp();
                }
                catch (IllegalArgumentException e) {
                    this.equinoxContainer.getLogServices().log("org.eclipse.osgi", 2, "Incompatible version.  Starting with empty framework.", e);
                    this.cleanOSGiStorage(this.osgiLocation, this.childRoot);
                    generations.clear();
                }
            }
        }
        catch (Throwable throwable) {
            if (data != null) {
                try {
                    data.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (data != null) {
            try {
                data.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Version getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public MRUBundleFileList getMRUBundleFileList() {
        return this.mruList;
    }

    private int getBundleFileLimit(EquinoxConfiguration configuration) {
        int propValue = 100;
        try {
            String prop = configuration.getConfiguration("osgi.bundlefile.limit");
            if (prop != null) {
                propValue = Integer.parseInt(prop);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return propValue;
    }

    private void installExtensions() {
        ModuleWiring systemWiring;
        Module systemModule = this.moduleContainer.getModule(0L);
        ModuleRevision systemRevision = systemModule == null ? null : systemModule.getCurrentRevision();
        ModuleWiring moduleWiring = systemWiring = systemRevision == null ? null : systemRevision.getWiring();
        if (systemWiring == null) {
            return;
        }
        ArrayList<ModuleRevision> fragments = new ArrayList<ModuleRevision>();
        for (ModuleWire hostWire : systemWiring.getProvidedModuleWires("osgi.wiring.host")) {
            fragments.add(hostWire.getRequirer());
        }
        try {
            this.getExtensionInstaller().addExtensionContent(fragments, null);
        }
        catch (BundleException e) {
            this.getLogServices().log("org.eclipse.osgi", 4, e.getMessage(), e);
        }
    }

    private static PermissionData loadPermissionData(DataInputStream in) throws IOException {
        PermissionData permData = new PermissionData();
        if (in != null) {
            permData.readPermissionData(in);
        }
        return permData;
    }

    private void refreshStaleBundles() throws BundleException {
        ArrayList<Module> needsRefresh = new ArrayList<Module>(0);
        for (Module module : this.moduleContainer.getModules()) {
            ModuleRevision revision;
            BundleInfo.Generation generation;
            if (module.getId() == 0L || !this.needsDiscarding(generation = (BundleInfo.Generation)(revision = module.getCurrentRevision()).getRevisionInfo())) continue;
            needsRefresh.add(module);
            this.moduleContainer.uninstall(module);
            generation.delete();
        }
        if (this.refreshMRBundles.get()) {
            needsRefresh.addAll(this.refreshMRJarBundles());
        }
        if (!needsRefresh.isEmpty()) {
            this.moduleContainer.refresh(needsRefresh);
        }
    }

    private boolean needsDiscarding(BundleInfo.Generation generation) {
        for (StorageHookFactory.StorageHook<?, ?> hook : generation.getStorageHooks()) {
            try {
                hook.validate();
            }
            catch (IllegalStateException e) {
                this.equinoxContainer.getLogServices().log("org.eclipse.osgi", 2, "Error validating installed bundle.", e);
                return true;
            }
        }
        File content = generation.getContent();
        if (this.getConfiguration().inCheckConfigurationMode()) {
            if (generation.isDirectory()) {
                content = new File(content, "META-INF/MANIFEST.MF");
            }
            return generation.getLastModified() != secureAction.lastModified(content);
        }
        return !content.exists();
    }

    private void checkSystemBundle(String[] cachedInfo) {
        Module systemModule = this.moduleContainer.getModule(0L);
        BundleInfo.Generation newGeneration = null;
        try {
            try {
                ModuleRevision currentRevision;
                String extraExports;
                String extraCapabilities;
                if (systemModule == null) {
                    BundleInfo info = new BundleInfo(this, 0L, "System Bundle", 0L);
                    newGeneration = info.createGeneration();
                    File contentFile = this.getSystemContent();
                    newGeneration.setContent(contentFile, false);
                    this.loadVMProfile(newGeneration);
                    extraCapabilities = this.getSystemExtraCapabilities();
                    extraExports = this.getSystemExtraPackages();
                    ModuleRevisionBuilder builder = this.getBuilder(newGeneration, extraCapabilities, extraExports);
                    systemModule = this.moduleContainer.install(null, "System Bundle", builder, newGeneration);
                    this.moduleContainer.resolve(Collections.singletonList(systemModule), false);
                } else {
                    BundleInfo.Generation currentGeneration;
                    currentRevision = systemModule.getCurrentRevision();
                    BundleInfo.Generation generation = currentGeneration = currentRevision == null ? null : (BundleInfo.Generation)currentRevision.getRevisionInfo();
                    if (currentGeneration == null) {
                        throw new IllegalStateException("No current revision for system bundle.");
                    }
                    try {
                        this.loadVMProfile(currentGeneration);
                        extraCapabilities = this.getSystemExtraCapabilities();
                        extraExports = this.getSystemExtraPackages();
                        File contentFile = currentGeneration.getContent();
                        if (this.systemNeedsUpdate(contentFile, currentRevision, currentGeneration, extraCapabilities, extraExports, cachedInfo)) {
                            newGeneration = currentGeneration.getBundleInfo().createGeneration();
                            newGeneration.setContent(contentFile, false);
                            ModuleRevisionBuilder newBuilder = this.getBuilder(newGeneration, extraCapabilities, extraExports);
                            this.moduleContainer.update(systemModule, newBuilder, newGeneration);
                            this.moduleContainer.refresh(Collections.singleton(systemModule));
                        } else if (currentRevision.getWiring() == null) {
                            this.moduleContainer.resolve(Collections.singleton(systemModule), true);
                        }
                    }
                    catch (BundleException e) {
                        throw new IllegalStateException("Could not create a builder for the system bundle.", e);
                    }
                }
                currentRevision = systemModule.getCurrentRevision();
                List<ModuleCapability> nativeEnvironments = currentRevision.getModuleCapabilities("osgi.native");
                Map<String, Object> configMap = this.equinoxContainer.getConfiguration().getInitialConfig();
                for (ModuleCapability nativeEnvironment : nativeEnvironments) {
                    nativeEnvironment.setTransientAttrs(configMap);
                }
                Version frameworkVersion = null;
                if (newGeneration != null) {
                    frameworkVersion = this.findFrameworkVersion();
                } else {
                    String sVersion = cachedInfo[0];
                    Version version = frameworkVersion = sVersion == null ? this.findFrameworkVersion() : Version.parseVersion(sVersion);
                }
                if (frameworkVersion != null) {
                    this.equinoxContainer.getConfiguration().setConfiguration("org.osgi.framework.version", frameworkVersion.toString());
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Error occurred while checking the system module.", e);
            }
        }
        finally {
            if (newGeneration != null) {
                newGeneration.getBundleInfo().unlockGeneration(newGeneration);
            }
        }
    }

    private Version findFrameworkVersion() {
        Requirement osgiPackageReq = ModuleContainer.createRequirement("osgi.wiring.package", Collections.singletonMap("filter", "(osgi.wiring.package=org.osgi.framework)"), Collections.emptyMap());
        Collection<BundleCapability> osgiPackages = this.moduleContainer.getFrameworkWiring().findProviders(osgiPackageReq);
        for (BundleCapability packageCapability : osgiPackages) {
            Version v;
            if (packageCapability.getRevision().getBundle().getBundleId() != 0L || (v = (Version)packageCapability.getAttributes().get("version")) == null) continue;
            return v;
        }
        return null;
    }

    private Collection<Module> refreshMRJarBundles() throws BundleException {
        ArrayList<Module> mrJarBundles = new ArrayList<Module>();
        for (Module m3 : this.moduleContainer.getModules()) {
            BundleInfo.Generation generation = (BundleInfo.Generation)m3.getCurrentRevision().getRevisionInfo();
            if (!Boolean.parseBoolean(generation.getRawHeaders().get("Multi-Release"))) continue;
            this.refresh(m3);
            mrJarBundles.add(m3);
        }
        return mrJarBundles;
    }

    public void close() {
        try {
            this.save();
        }
        catch (IOException e) {
            this.getLogServices().log("org.eclipse.osgi", 4, "Error saving on shutdown", e);
        }
        List<Module> modules = this.moduleContainer.getModules();
        for (Module module : modules) {
            for (ModuleRevision revision : module.getRevisions().getModuleRevisions()) {
                BundleInfo.Generation generation = (BundleInfo.Generation)revision.getRevisionInfo();
                if (generation == null) continue;
                generation.close();
            }
        }
        for (ModuleRevision removalPending : this.moduleContainer.getRemovalPending()) {
            BundleInfo.Generation generation = (BundleInfo.Generation)removalPending.getRevisionInfo();
            if (generation == null) continue;
            generation.close();
        }
        this.mruList.shutdown();
        this.adaptor.shutdownExecutors();
    }

    private boolean systemNeedsUpdate(File systemContent, ModuleRevision currentRevision, BundleInfo.Generation existing, String extraCapabilities, String extraExports, String[] cachedInfo) throws BundleException {
        if (!extraCapabilities.equals(cachedInfo[1])) {
            return true;
        }
        if (!extraExports.equals(cachedInfo[2])) {
            return true;
        }
        if (systemContent == null) {
            ModuleRevisionBuilder newBuilder = this.getBuilder(existing, extraCapabilities, extraExports);
            return !currentRevision.getVersion().equals(newBuilder.getVersion());
        }
        if (existing.isDirectory()) {
            systemContent = new File(systemContent, "META-INF/MANIFEST.MF");
        }
        return existing.getLastModified() != secureAction.lastModified(systemContent);
    }

    private void cleanOSGiStorage(Location location, File root) {
        if (location.isReadOnly() || !StorageUtil.rm(root, this.getConfiguration().getDebug().DEBUG_STORAGE)) {
            this.equinoxContainer.getLogServices().log("org.eclipse.osgi", 4, "The -clean (osgi.clean) option was not successful. Unable to clean the storage area: " + root.getAbsolutePath(), null);
        }
        if (!location.isReadOnly()) {
            root.mkdirs();
        }
    }

    public ModuleDatabase getModuleDatabase() {
        return this.moduleDatabase;
    }

    public ModuleContainerAdaptor getAdaptor() {
        return this.adaptor;
    }

    public ModuleContainer getModuleContainer() {
        return this.moduleContainer;
    }

    public EquinoxConfiguration getConfiguration() {
        return this.equinoxContainer.getConfiguration();
    }

    public EquinoxLogServices getLogServices() {
        return this.equinoxContainer.getLogServices();
    }

    public FrameworkExtensionInstaller getExtensionInstaller() {
        return this.extensionInstaller;
    }

    public boolean isReadOnly() {
        return this.osgiLocation.isReadOnly();
    }

    public URLConnection getContentConnection(Module module, String bundleLocation, final InputStream in) throws IOException {
        List<StorageHookFactory<?, ?, ?>> storageHooks = this.getConfiguration().getHookRegistry().getStorageHookFactories();
        for (StorageHookFactory<?, ?, ?> storageHook : storageHooks) {
            URLConnection hookContent = storageHook.handleContentConnection(module, bundleLocation, in);
            if (hookContent == null) continue;
            return hookContent;
        }
        if (in != null) {
            return new URLConnection(null){

                @Override
                public void connect() throws IOException {
                    this.connected = true;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return in;
                }
            };
        }
        if (module == null) {
            if (bundleLocation == null) {
                throw new IllegalArgumentException("Module and location cannot be null");
            }
            return this.getContentConnection(bundleLocation);
        }
        return this.getContentConnection(this.getUpdateLocation(module));
    }

    private String getUpdateLocation(final Module module) {
        if (System.getSecurityManager() == null) {
            return this.getUpdateLocation0(module);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Storage.this.getUpdateLocation0(module);
            }
        });
    }

    String getUpdateLocation0(Module module) {
        ModuleRevision current = module.getCurrentRevision();
        BundleInfo.Generation generation = (BundleInfo.Generation)current.getRevisionInfo();
        String updateLocation = generation.getHeaders().get("Bundle-UpdateLocation");
        if (updateLocation == null) {
            updateLocation = module.getLocation();
        }
        if (updateLocation.startsWith(INITIAL_LOCATION)) {
            updateLocation = updateLocation.substring(INITIAL_LOCATION.length());
        }
        return updateLocation;
    }

    private URLConnection getContentConnection(final String spec) throws IOException {
        if (System.getSecurityManager() == null) {
            return LocationHelper.getConnection(this.createURL(spec));
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URLConnection>(){

                @Override
                public URLConnection run() throws IOException {
                    return LocationHelper.getConnection(Storage.this.createURL(spec));
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    URL createURL(String spec) throws MalformedURLException {
        if (spec.startsWith("reference")) {
            return new URL(null, spec, new Handler(this.equinoxContainer.getConfiguration().getConfiguration("osgi.install.area")));
        }
        return new URL(spec);
    }

    public BundleInfo.Generation install(Module origin, String bundleLocation, URLConnection content) throws BundleException {
        InputStream in;
        if (this.osgiLocation.isReadOnly()) {
            throw new BundleException("The framework storage area is read only.", 2);
        }
        URL sourceURL = content.getURL();
        try {
            in = content.getInputStream();
        }
        catch (Throwable e) {
            throw new BundleException("Error reading bundle content.", e);
        }
        Module existingLocation = this.moduleContainer.getModule(bundleLocation);
        if (existingLocation != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            if (origin != null) {
                BundleContext context;
                Bundle bundle = origin.getBundle();
                BundleContext bundleContext = context = bundle == null ? null : bundle.getBundleContext();
                if (context != null && context.getBundle(existingLocation.getId()) == null) {
                    Bundle b = existingLocation.getBundle();
                    throw new BundleException(NLS.bind(Msg.ModuleContainer_NameCollisionWithLocation, new Object[]{b.getSymbolicName(), b.getVersion(), bundleLocation}), 12);
                }
            }
            return (BundleInfo.Generation)existingLocation.getCurrentRevision().getRevisionInfo();
        }
        boolean isReference = in instanceof ReferenceInputStream;
        File staged = this.stageContent(in, sourceURL);
        BundleInfo.Generation generation = null;
        try {
            Long nextID = this.moduleDatabase.getAndIncrementNextId();
            BundleInfo info = new BundleInfo(this, nextID, bundleLocation, 0L);
            generation = info.createGeneration();
            File contentFile = this.getContentFile(staged, isReference, nextID, generation.getGenerationId());
            generation.setContent(contentFile, isReference);
            generation.getBundleFile().open();
            this.setStorageHooks(generation);
            ModuleRevisionBuilder builder = this.getBuilder(generation);
            builder.setId(nextID);
            Module m3 = this.moduleContainer.install(origin, bundleLocation, builder, generation);
            if (!nextID.equals(m3.getId())) {
                generation.delete();
                BundleInfo.Generation generation2 = (BundleInfo.Generation)m3.getCurrentRevision().getRevisionInfo();
                return generation2;
            }
            BundleInfo.Generation generation3 = generation;
            return generation3;
        }
        catch (Throwable t) {
            if (!isReference) {
                try {
                    this.delete(staged);
                }
                catch (IOException iOException) {}
            }
            if (generation != null) {
                generation.delete();
                generation.getBundleInfo().delete();
            }
            if (t instanceof SecurityException) {
                if (t.getCause() instanceof BundleException) {
                    throw (BundleException)t.getCause();
                }
                throw (SecurityException)t;
            }
            if (t instanceof BundleException) {
                throw (BundleException)t;
            }
            throw new BundleException("Error occurred installing a bundle.", t);
        }
        finally {
            if (generation != null) {
                generation.getBundleInfo().unlockGeneration(generation);
            }
        }
    }

    private void setStorageHooks(BundleInfo.Generation generation) throws BundleException {
        if (generation.getBundleInfo().getBundleId() == 0L) {
            return;
        }
        ArrayList factories = new ArrayList(this.getConfiguration().getHookRegistry().getStorageHookFactories());
        ArrayList hooks = new ArrayList(factories.size());
        for (StorageHookFactory storageHookFactory : factories) {
            Object hook = storageHookFactory.createStorageHookAndValidateFactoryClass(generation);
            if (hook == null) continue;
            hooks.add(hook);
        }
        generation.setStorageHooks(Collections.unmodifiableList(hooks), true);
        for (StorageHookFactory.StorageHook hook : hooks) {
            hook.initialize(generation.getHeaders());
        }
    }

    public ModuleRevisionBuilder getBuilder(BundleInfo.Generation generation) throws BundleException {
        return this.getBuilder(generation, null, null);
    }

    public ModuleRevisionBuilder getBuilder(BundleInfo.Generation generation, String extraCapabilities, String extraExports) throws BundleException {
        HashMap<String, String> mapHeaders;
        Dictionary<String, String> headers = generation.getHeaders();
        if (headers instanceof Map) {
            Map unchecked = (Map)((Object)headers);
            mapHeaders = unchecked;
        } else {
            mapHeaders = new HashMap();
            Enumeration<String> eKeys = headers.keys();
            while (eKeys.hasMoreElements()) {
                String key = eKeys.nextElement();
                mapHeaders.put(key, headers.get(key));
            }
        }
        if (generation.getBundleInfo().getBundleId() != 0L) {
            ModuleRevisionBuilder builder;
            ModuleRevisionBuilder moduleRevisionBuilder = builder = this.allowRestrictedProvides ? OSGiManifestBuilderFactory.createBuilder(mapHeaders, null, null, "") : OSGiManifestBuilderFactory.createBuilder(mapHeaders);
            if ((builder.getTypes() & 1) != 0) {
                for (ModuleRevisionBuilder.GenericInfo reqInfo : builder.getRequirements()) {
                    if (!"osgi.wiring.host".equals(reqInfo.getNamespace()) || !"bootclasspath".equals(reqInfo.getDirectives().get("extension"))) continue;
                    throw new BundleException("Boot classpath extensions are not supported.", 1, new UnsupportedOperationException());
                }
            }
            return builder;
        }
        return OSGiManifestBuilderFactory.createBuilder(mapHeaders, "system.bundle", extraExports, extraCapabilities);
    }

    private String getSystemExtraCapabilities() {
        String extraSystemCapabilities;
        EquinoxConfiguration equinoxConfig = this.equinoxContainer.getConfiguration();
        StringBuilder result = new StringBuilder();
        String systemCapabilities = equinoxConfig.getConfiguration("org.osgi.framework.system.capabilities");
        if (systemCapabilities != null && systemCapabilities.trim().length() > 0) {
            result.append(systemCapabilities).append(", ");
        }
        if ((extraSystemCapabilities = equinoxConfig.getConfiguration("org.osgi.framework.system.capabilities.extra")) != null && extraSystemCapabilities.trim().length() > 0) {
            result.append(extraSystemCapabilities).append(", ");
        }
        result.append("eclipse.platform").append("; ");
        result.append("osgi.os").append("=").append(equinoxConfig.getOS()).append("; ");
        result.append("osgi.ws").append("=").append(equinoxConfig.getWS()).append("; ");
        result.append("osgi.arch").append("=").append(equinoxConfig.getOSArch()).append("; ");
        result.append("osgi.nl").append("=").append(equinoxConfig.getNL());
        String osName = equinoxConfig.getConfiguration("org.osgi.framework.os.name");
        osName = osName == null ? null : osName.toLowerCase();
        String processor = equinoxConfig.getConfiguration("org.osgi.framework.processor");
        processor = processor == null ? null : processor.toLowerCase();
        String osVersion = equinoxConfig.getConfiguration("org.osgi.framework.os.version");
        osVersion = osVersion == null ? null : osVersion.toLowerCase();
        String language = equinoxConfig.getConfiguration("org.osgi.framework.language");
        language = language == null ? null : language.toLowerCase();
        result.append(", ");
        result.append("osgi.native").append("; ");
        if (osName != null) {
            osName = this.getAliasList(equinoxConfig.getAliasMapper().getOSNameAliases(osName));
            result.append("osgi.native.osname").append(":List<String>=").append(osName).append("; ");
        }
        if (processor != null) {
            processor = this.getAliasList(equinoxConfig.getAliasMapper().getProcessorAliases(processor));
            result.append("osgi.native.processor").append(":List<String>=").append(processor).append("; ");
        }
        result.append("osgi.native.osversion").append(":Version").append("=\"").append(osVersion).append("\"; ");
        result.append("osgi.native.language").append("=\"").append(language).append('\"');
        return result.toString();
    }

    String getAliasList(Collection<String> aliases) {
        if (aliases.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        for (String alias : aliases) {
            builder.append(alias).append(',');
        }
        builder.setLength(builder.length() - 1);
        builder.append('\"');
        return builder.toString();
    }

    private String getSystemExtraPackages() {
        String extraSystemPackages;
        EquinoxConfiguration equinoxConfig = this.equinoxContainer.getConfiguration();
        StringBuilder result = new StringBuilder();
        String systemPackages = equinoxConfig.getConfiguration("org.osgi.framework.system.packages");
        if (systemPackages != null) {
            result.append(systemPackages);
        }
        if ((extraSystemPackages = equinoxConfig.getConfiguration("org.osgi.framework.system.packages.extra")) != null && extraSystemPackages.trim().length() > 0) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(extraSystemPackages);
        }
        return result.toString();
    }

    private void refresh(Module module) throws BundleException {
        URLConnection contentConn;
        ModuleRevision current = module.getCurrentRevision();
        BundleInfo.Generation currentGen = (BundleInfo.Generation)current.getRevisionInfo();
        File content = currentGen.getContent();
        String spec = String.valueOf(currentGen.isReference() ? "reference:" : "") + content.toURI().toString();
        try {
            contentConn = this.getContentConnection(spec);
        }
        catch (IOException e) {
            throw new BundleException("Error reading bundle content.", e);
        }
        this.update(module, contentConn);
    }

    public BundleInfo.Generation update(Module module, URLConnection content) throws BundleException {
        InputStream in;
        if (this.osgiLocation.isReadOnly()) {
            throw new BundleException("The framework storage area is read only.", 2);
        }
        URL sourceURL = content.getURL();
        try {
            in = content.getInputStream();
        }
        catch (Throwable e) {
            throw new BundleException("Error reading bundle content.", e);
        }
        boolean isReference = in instanceof ReferenceInputStream;
        File staged = this.stageContent(in, sourceURL);
        ModuleRevision current = module.getCurrentRevision();
        BundleInfo.Generation currentGen = (BundleInfo.Generation)current.getRevisionInfo();
        BundleInfo bundleInfo = currentGen.getBundleInfo();
        BundleInfo.Generation newGen = bundleInfo.createGeneration();
        try {
            try {
                File contentFile = this.getContentFile(staged, isReference, bundleInfo.getBundleId(), newGen.getGenerationId());
                newGen.setContent(contentFile, isReference);
                newGen.getBundleFile().open();
                this.setStorageHooks(newGen);
                ModuleRevisionBuilder builder = this.getBuilder(newGen);
                this.moduleContainer.update(module, builder, newGen);
            }
            catch (Throwable t) {
                if (!isReference) {
                    try {
                        this.delete(staged);
                    }
                    catch (IOException iOException) {}
                }
                newGen.delete();
                if (t instanceof SecurityException) {
                    if (t.getCause() instanceof BundleException) {
                        throw (BundleException)t.getCause();
                    }
                    throw (SecurityException)t;
                }
                if (t instanceof BundleException) {
                    throw (BundleException)t;
                }
                throw new BundleException("Error occurred updating a bundle.", t);
            }
        }
        finally {
            bundleInfo.unlockGeneration(newGen);
        }
        return newGen;
    }

    private File getContentFile(final File staged, final boolean isReference, final long bundleID, final long generationID) throws BundleException {
        if (System.getSecurityManager() == null) {
            return this.getContentFile0(staged, isReference, bundleID, generationID);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws BundleException {
                    return Storage.this.getContentFile0(staged, isReference, bundleID, generationID);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof BundleException) {
                throw (BundleException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    File getContentFile0(File staged, boolean isReference, long bundleID, long generationID) throws BundleException {
        File contentFile;
        if (!isReference) {
            File generationRoot = new File(this.childRoot, String.valueOf(bundleID) + "/" + generationID);
            generationRoot.mkdirs();
            if (!generationRoot.isDirectory()) {
                throw new BundleException("Could not create generation directory: " + generationRoot.getAbsolutePath());
            }
            contentFile = new File(generationRoot, BUNDLE_FILE_NAME);
            if (!StorageUtil.move(staged, contentFile, this.getConfiguration().getDebug().DEBUG_STORAGE)) {
                throw new BundleException("Error while renaming bundle file to final location: " + contentFile);
            }
        } else {
            contentFile = staged;
        }
        return contentFile;
    }

    private static String getBundleFilePath(long bundleID, long generationID) {
        return String.valueOf(bundleID) + "/" + generationID + "/" + BUNDLE_FILE_NAME;
    }

    public File getFile(String path, boolean checkParent) throws StorageException {
        return this.getFile(null, path, checkParent);
    }

    public File getFile(String base, String path, boolean checkParent) throws StorageException {
        File childPath = Storage.getFile(this.childRoot, base, path);
        if (checkParent && this.parentRoot != null) {
            if (childPath.exists()) {
                return childPath;
            }
            File parentPath = Storage.getFile(this.parentRoot, base, path);
            if (parentPath.exists()) {
                return parentPath;
            }
        }
        return childPath;
    }

    private static File getFile(File root, String base, String path) {
        if (base == null) {
            return new File(root, path);
        }
        root = new File(root, base);
        File result = new File(root, path);
        try {
            String resultCanonical = result.getCanonicalPath();
            String rootCanonical = root.getCanonicalPath();
            if (!resultCanonical.startsWith(String.valueOf(rootCanonical) + File.separator) && !resultCanonical.equals(rootCanonical)) {
                throw new StorageException("Invalid path: " + path);
            }
        }
        catch (IOException e) {
            throw new StorageException("Invalid path: " + path, e);
        }
        return result;
    }

    private File stageContent(final InputStream in, final URL sourceURL) throws BundleException {
        if (System.getSecurityManager() == null) {
            return this.stageContent0(in, sourceURL);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws BundleException {
                    return Storage.this.stageContent0(in, sourceURL);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof BundleException) {
                throw (BundleException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    File stageContent0(InputStream in, URL sourceURL) throws BundleException {
        File outFile = null;
        try {
            String protocol;
            if (in instanceof ReferenceInputStream) {
                return ((ReferenceInputStream)in).getReference();
            }
            outFile = File.createTempFile(BUNDLE_FILE_NAME, ".tmp", this.childRoot);
            String string = protocol = sourceURL == null ? null : sourceURL.getProtocol();
            if ("file".equals(protocol)) {
                File inFile = new File(sourceURL.getPath());
                if ((inFile = LocationHelper.decodePath(inFile)).isDirectory()) {
                    outFile.delete();
                    StorageUtil.copyDir(inFile, outFile);
                } else {
                    StorageUtil.readFile(in, outFile);
                }
            } else {
                StorageUtil.readFile(in, outFile);
            }
            return outFile;
        }
        catch (IOException e) {
            if (outFile != null) {
                outFile.delete();
            }
            throw new BundleException(Msg.BUNDLE_READ_EXCEPTION, 11, e);
        }
    }

    public void setPermissions(File file) {
        String commandProp = this.getConfiguration().getConfiguration("osgi.filepermissions.command");
        if (commandProp == null) {
            commandProp = this.getConfiguration().getConfiguration("org.osgi.framework.command.execpermission");
        }
        if (commandProp == null) {
            return;
        }
        String[] commandComponents = ManifestElement.getArrayFromList(commandProp, " ");
        ArrayList<String> command = new ArrayList<String>(commandComponents.length + 1);
        boolean foundFullPath = false;
        String[] stringArray = commandComponents;
        int n = commandComponents.length;
        int n2 = 0;
        while (n2 < n) {
            String commandComponent = stringArray[n2];
            if ("[fullpath]".equals(commandComponent) || "${abspath}".equals(commandComponent)) {
                command.add(file.getAbsolutePath());
                foundFullPath = true;
            } else {
                command.add(commandComponent);
            }
            ++n2;
        }
        if (!foundFullPath) {
            command.add(file.getAbsolutePath());
        }
        try {
            Runtime.getRuntime().exec(command.toArray(new String[command.size()])).waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BundleFile createBundleFile(File content, BundleInfo.Generation generation, boolean isDirectory, boolean isBase) {
        BundleFile result;
        try {
            if (isDirectory) {
                boolean strictPath = Boolean.parseBoolean(this.equinoxContainer.getConfiguration().getConfiguration("osgi.strictBundleEntryPath", Boolean.FALSE.toString()));
                result = new DirBundleFile(content, strictPath);
            } else {
                result = new ZipBundleFile(content, generation, this.mruList, this.getConfiguration().getDebug());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create bundle file.", e);
        }
        return this.wrapBundleFile(result, generation, isBase);
    }

    public BundleFile createNestedBundleFile(String nestedDir, BundleFile bundleFile, BundleInfo.Generation generation) {
        return this.createNestedBundleFile(nestedDir, bundleFile, generation, Collections.emptyList());
    }

    public BundleFile createNestedBundleFile(String nestedDir, BundleFile bundleFile, BundleInfo.Generation generation, Collection<String> filterPrefixes) {
        return this.wrapBundleFile(new NestedDirBundleFile(bundleFile, nestedDir, filterPrefixes), generation, false);
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, BundleInfo.Generation generation, boolean isBase) {
        List<BundleFileWrapperFactoryHook> wrapperFactories = this.getConfiguration().getHookRegistry().getBundleFileWrapperFactoryHooks();
        BundleFileWrapperChain wrapped = wrapperFactories.isEmpty() ? null : new BundleFileWrapperChain(bundleFile, null);
        for (BundleFileWrapperFactoryHook wrapperFactory : wrapperFactories) {
            BundleFileWrapper wrapperBundle = wrapperFactory.wrapBundleFile(bundleFile, generation, isBase);
            if (wrapperBundle == null || wrapperBundle == bundleFile) continue;
            wrapped = new BundleFileWrapperChain(wrapperBundle, wrapped);
            bundleFile = wrapped;
        }
        return bundleFile;
    }

    public void compact() {
        if (!this.osgiLocation.isReadOnly()) {
            this.compact(this.childRoot);
        }
    }

    private void compact(File directory) {
        String[] list;
        if (this.getConfiguration().getDebug().DEBUG_STORAGE) {
            Debug.println("compact(" + directory.getPath() + ")");
        }
        if ((list = directory.list()) == null) {
            return;
        }
        int len = list.length;
        int i = 0;
        while (i < len) {
            File target;
            if (!BUNDLE_DATA_DIR.equals(list[i]) && (target = new File(directory, list[i])).isDirectory()) {
                File delete = new File(target, DELETE_FLAG);
                if (delete.exists()) {
                    if (!StorageUtil.rm(target, this.getConfiguration().getDebug().DEBUG_STORAGE) && !delete.exists()) {
                        try {
                            FileOutputStream out = new FileOutputStream(delete);
                            out.close();
                        }
                        catch (IOException e) {
                            if (this.getConfiguration().getDebug().DEBUG_STORAGE) {
                                Debug.println("Unable to write " + delete.getPath() + ": " + e.getMessage());
                            }
                        }
                    }
                } else {
                    this.compact(target);
                }
            }
            ++i;
        }
    }

    void delete(final File delete) throws IOException {
        if (System.getSecurityManager() == null) {
            this.delete0(delete);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        Storage.this.delete0(delete);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof IOException) {
                    throw (IOException)e.getException();
                }
                throw (RuntimeException)e.getException();
            }
        }
    }

    void delete0(File delete) throws IOException {
        if (!StorageUtil.rm(delete, this.getConfiguration().getDebug().DEBUG_STORAGE)) {
            FileOutputStream out = new FileOutputStream(new File(delete, DELETE_FLAG));
            out.close();
        }
    }

    public void save() throws IOException {
        if (this.isReadOnly()) {
            return;
        }
        if (System.getSecurityManager() == null) {
            this.save0();
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        Storage.this.save0();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof IOException) {
                    throw (IOException)e.getException();
                }
                throw (RuntimeException)e.getException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void save0() throws IOException {
        StorageManager childStorageManager = null;
        ManagedOutputStream mos = null;
        FilterOutputStream out = null;
        boolean success = false;
        this.moduleDatabase.readLock();
        try {
            block21: {
                block22: {
                    Object object = this.saveMonitor;
                    // MONITORENTER : object
                    if (this.lastSavedTimestamp != this.moduleDatabase.getTimestamp()) break block21;
                    // MONITOREXIT : object
                    if (!success && mos != null) {
                        mos.abort();
                    }
                    if (out == null) break block22;
                    {
                        catch (Throwable throwable) {
                            // MONITOREXIT : object
                            throw throwable;
                        }
                    }
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                if (childStorageManager != null) {
                    childStorageManager.close();
                }
                this.moduleDatabase.readUnlock();
                return;
            }
            childStorageManager = this.getChildStorageManager();
            mos = childStorageManager.getOutputStream(FRAMEWORK_INFO);
            out = new DataOutputStream(new BufferedOutputStream(mos));
            this.saveGenerations((DataOutputStream)out);
            this.savePermissionData((DataOutputStream)out);
            this.moduleDatabase.store((DataOutputStream)out, true);
            this.lastSavedTimestamp = this.moduleDatabase.getTimestamp();
            success = true;
            // MONITOREXIT : object
        }
        catch (Throwable throwable) {
            if (!success && mos != null) {
                mos.abort();
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (childStorageManager != null) {
                childStorageManager.close();
            }
            this.moduleDatabase.readUnlock();
            throw throwable;
        }
        if (!success && mos != null) {
            mos.abort();
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        if (childStorageManager != null) {
            childStorageManager.close();
        }
        this.moduleDatabase.readUnlock();
    }

    private void savePermissionData(DataOutputStream out) throws IOException {
        this.permissionData.savePermissionData(out);
    }

    private void saveGenerations(DataOutputStream out) throws IOException {
        List<Module> modules = this.moduleContainer.getModules();
        ArrayList<BundleInfo.Generation> generations = new ArrayList<BundleInfo.Generation>();
        for (Module module : modules) {
            BundleInfo.Generation generation;
            ModuleRevision revision = module.getCurrentRevision();
            if (revision == null || (generation = (BundleInfo.Generation)revision.getRevisionInfo()) == null) continue;
            generations.add(generation);
        }
        out.writeInt(5);
        out.writeUTF(this.runtimeVersion.toString());
        Version curFrameworkVersion = this.findFrameworkVersion();
        out.writeUTF(curFrameworkVersion == null ? Version.emptyVersion.toString() : curFrameworkVersion.toString());
        this.saveLongString(out, this.getSystemExtraCapabilities());
        this.saveLongString(out, this.getSystemExtraPackages());
        out.writeInt(this.cachedHeaderKeys.size());
        for (String headerKey : this.cachedHeaderKeys) {
            out.writeUTF(headerKey);
        }
        out.writeInt(generations.size());
        for (BundleInfo.Generation generation : generations) {
            BundleInfo bundleInfo = generation.getBundleInfo();
            out.writeLong(bundleInfo.getBundleId());
            out.writeUTF(bundleInfo.getLocation());
            out.writeLong(bundleInfo.getNextGenerationId());
            out.writeLong(generation.getGenerationId());
            out.writeBoolean(generation.isDirectory());
            out.writeBoolean(generation.isReference());
            out.writeBoolean(generation.hasPackageInfo());
            if (bundleInfo.getBundleId() == 0L) {
                out.writeUTF("");
            } else if (generation.isReference()) {
                out.writeUTF(new FilePath(this.installPath).makeRelative(new FilePath(generation.getContent().getAbsolutePath())));
            } else {
                out.writeUTF(Storage.getBundleFilePath(bundleInfo.getBundleId(), generation.getGenerationId()));
            }
            out.writeLong(generation.getLastModified());
            Dictionary<String, String> headers = generation.getHeaders();
            for (String headerKey : this.cachedHeaderKeys) {
                String value = headers.get(headerKey);
                if (value != null) {
                    out.writeUTF(value);
                    continue;
                }
                out.writeUTF(NUL);
            }
            out.writeBoolean(generation.isMRJar());
        }
        this.saveStorageHookData(out, generations);
    }

    private void saveLongString(DataOutputStream out, String value) throws IOException {
        if (value == null) {
            out.writeInt(0);
        } else {
            byte[] data = value.getBytes(StandardCharsets.UTF_8);
            out.writeInt(data.length);
            out.write(data);
        }
    }

    private String readLongString(DataInputStream in) throws IOException {
        int length = in.readInt();
        byte[] data = new byte[length];
        in.readFully(data);
        return new String(data, StandardCharsets.UTF_8);
    }

    private void saveStorageHookData(DataOutputStream out, List<BundleInfo.Generation> generations) throws IOException {
        List<StorageHookFactory<?, ?, ?>> factories = this.getConfiguration().getHookRegistry().getStorageHookFactories();
        out.writeInt(factories.size());
        for (StorageHookFactory<?, ?, ?> factory : factories) {
            out.writeUTF(factory.getKey());
            out.writeInt(factory.getStorageVersion());
            ByteArrayOutputStream tempBytes = new ByteArrayOutputStream();
            try (DataOutputStream temp = new DataOutputStream(tempBytes);){
                Object saveContext = factory.createSaveContext();
                for (BundleInfo.Generation generation : generations) {
                    Object hook;
                    if (generation.getBundleInfo().getBundleId() == 0L || (hook = generation.getStorageHook(factory.getClass())) == null) continue;
                    ((StorageHookFactory.StorageHook)hook).save(saveContext, temp);
                }
            }
            out.writeInt(tempBytes.size());
            out.write(tempBytes.toByteArray());
        }
    }

    private Map<Long, BundleInfo.Generation> loadGenerations(DataInputStream in, String[] cachedInfo) throws IOException {
        Version savedRuntimeVersion;
        if (in == null) {
            return new HashMap<Long, BundleInfo.Generation>(0);
        }
        int version = in.readInt();
        if (version > 5 || version < 3) {
            throw new IllegalArgumentException("Found persistent version \"" + version + "\" expecting \"" + 5 + "\"");
        }
        Version version2 = savedRuntimeVersion = version >= 4 ? Version.parseVersion(in.readUTF()) : null;
        if (savedRuntimeVersion == null || !savedRuntimeVersion.equals(this.runtimeVersion)) {
            this.refreshMRBundles.set(true);
        }
        cachedInfo[0] = version >= 5 ? in.readUTF() : null;
        cachedInfo[1] = version >= 5 ? this.readLongString(in) : null;
        cachedInfo[2] = version >= 5 ? this.readLongString(in) : null;
        int numCachedHeaders = in.readInt();
        ArrayList<String> storedCachedHeaderKeys = new ArrayList<String>(numCachedHeaders);
        int i = 0;
        while (i < numCachedHeaders) {
            storedCachedHeaderKeys.add(ObjectPool.intern(in.readUTF()));
            ++i;
        }
        int numInfos = in.readInt();
        HashMap<Long, BundleInfo.Generation> result = new HashMap<Long, BundleInfo.Generation>(numInfos);
        ArrayList<BundleInfo.Generation> generations = new ArrayList<BundleInfo.Generation>(numInfos);
        int i2 = 0;
        while (i2 < numInfos) {
            File content;
            boolean isMRJar;
            long infoId = in.readLong();
            String infoLocation = ObjectPool.intern(in.readUTF());
            long nextGenId = in.readLong();
            long generationId = in.readLong();
            boolean isDirectory = in.readBoolean();
            boolean isReference = in.readBoolean();
            boolean hasPackageInfo = in.readBoolean();
            String contentPath = in.readUTF();
            long lastModified = in.readLong();
            HashMap<String, String> cachedHeaders = new HashMap<String, String>(storedCachedHeaderKeys.size());
            for (String headerKey : storedCachedHeaderKeys) {
                String value = in.readUTF();
                value = NUL.equals(value) ? null : ObjectPool.intern(value);
                cachedHeaders.put(headerKey, value);
            }
            boolean bl = isMRJar = version >= 4 ? in.readBoolean() : false;
            if (infoId == 0L) {
                content = this.getSystemContent();
                isDirectory = content != null ? content.isDirectory() : false;
            } else {
                content = new File(contentPath);
                if (!content.isAbsolute()) {
                    content = isReference ? new File(this.installPath, contentPath) : this.getFile(contentPath, true);
                }
            }
            BundleInfo info = new BundleInfo(this, infoId, infoLocation, nextGenId);
            BundleInfo.Generation generation = info.restoreGeneration(generationId, content, isDirectory, isReference, hasPackageInfo, cachedHeaders, lastModified, isMRJar);
            result.put(infoId, generation);
            generations.add(generation);
            ++i2;
        }
        this.loadStorageHookData(generations, in);
        return result;
    }

    private void loadStorageHookData(List<BundleInfo.Generation> generations, DataInputStream in) throws IOException {
        ArrayList factories = new ArrayList(this.getConfiguration().getHookRegistry().getStorageHookFactories());
        HashMap hookMap = new HashMap();
        int numFactories = in.readInt();
        int i = 0;
        while (i < numFactories) {
            String string = in.readUTF();
            int version = in.readInt();
            StorageHookFactory factory = null;
            Iterator iFactories = factories.iterator();
            while (iFactories.hasNext()) {
                StorageHookFactory next = (StorageHookFactory)iFactories.next();
                if (!next.getKey().equals(string)) continue;
                factory = next;
                iFactories.remove();
                break;
            }
            int dataSize = in.readInt();
            byte[] bytes = new byte[dataSize];
            in.readFully(bytes);
            if (factory != null) {
                try (DataInputStream temp = new DataInputStream(new ByteArrayInputStream(bytes));){
                    try {
                        if (factory.isCompatibleWith(version)) {
                            Object loadContext = factory.createLoadContext(version);
                            for (BundleInfo.Generation generation : generations) {
                                Object hook;
                                if (generation.getBundleInfo().getBundleId() == 0L || (hook = factory.createStorageHookAndValidateFactoryClass(generation)) == null) continue;
                                ((StorageHookFactory.StorageHook)hook).load(loadContext, temp);
                                Storage.getHooks(hookMap, generation).add((StorageHookFactory.StorageHook<?, ?>)hook);
                            }
                        } else {
                            for (BundleInfo.Generation generation : generations) {
                                Object hook;
                                if (generation.getBundleInfo().getBundleId() == 0L || (hook = factory.createStorageHookAndValidateFactoryClass(generation)) == null) continue;
                                ((StorageHookFactory.StorageHook)hook).initialize(generation.getHeaders());
                                Storage.getHooks(hookMap, generation).add((StorageHookFactory.StorageHook<?, ?>)hook);
                            }
                        }
                    }
                    catch (BundleException e) {
                        throw new IOException(e);
                    }
                }
            }
            ++i;
        }
        for (StorageHookFactory storageHookFactory : factories) {
            for (BundleInfo.Generation generation : generations) {
                Object hook;
                if (generation.getBundleInfo().getBundleId() == 0L || (hook = storageHookFactory.createStorageHookAndValidateFactoryClass(generation)) == null) continue;
                try {
                    ((StorageHookFactory.StorageHook)hook).initialize(generation.getHeaders());
                    Storage.getHooks(hookMap, generation).add((StorageHookFactory.StorageHook<?, ?>)hook);
                }
                catch (BundleException e) {
                    throw new IOException(e);
                }
            }
        }
        for (BundleInfo.Generation generation : generations) {
            generation.setStorageHooks(Collections.unmodifiableList(Storage.getHooks(hookMap, generation)), false);
        }
    }

    private static List<StorageHookFactory.StorageHook<?, ?>> getHooks(Map<BundleInfo.Generation, List<StorageHookFactory.StorageHook<?, ?>>> hookMap, BundleInfo.Generation generation) {
        List<StorageHookFactory.StorageHook<?, ?>> result = hookMap.get(generation);
        if (result == null) {
            result = new ArrayList();
            hookMap.put(generation, result);
        }
        return result;
    }

    private File getSystemContent() {
        String frameworkValue = this.equinoxContainer.getConfiguration().getConfiguration("osgi.framework");
        if (frameworkValue == null || !frameworkValue.startsWith("file:")) {
            return null;
        }
        File result = new File(frameworkValue.substring(5)).getAbsoluteFile();
        if (!result.exists()) {
            throw new IllegalStateException("Configured framework location does not exist: " + result.getAbsolutePath());
        }
        return result;
    }

    private void loadVMProfile(BundleInfo.Generation systemGeneration) {
        String systemCapabilities;
        String ee;
        EquinoxConfiguration equinoxConfig = this.equinoxContainer.getConfiguration();
        Properties profileProps = this.findVMProfile(systemGeneration);
        String systemExports = equinoxConfig.getConfiguration("org.osgi.framework.system.packages");
        if (systemExports == null && (systemExports = profileProps.getProperty("org.osgi.framework.system.packages")) != null) {
            equinoxConfig.setConfiguration("org.osgi.framework.system.packages", systemExports);
        }
        String type = equinoxConfig.getConfiguration("osgi.java.profile.bootdelegation");
        String profileBootDelegation = profileProps.getProperty("org.osgi.framework.bootdelegation");
        if ("override".equals(type)) {
            if (profileBootDelegation == null) {
                equinoxConfig.clearConfiguration("org.osgi.framework.bootdelegation");
            } else {
                equinoxConfig.setConfiguration("org.osgi.framework.bootdelegation", profileBootDelegation);
            }
        } else if ("none".equals(type)) {
            equinoxConfig.clearConfiguration("org.osgi.framework.bootdelegation");
        }
        if (equinoxConfig.getConfiguration("org.osgi.framework.executionenvironment") == null && (ee = profileProps.getProperty("org.osgi.framework.executionenvironment", profileProps.getProperty("osgi.java.profile.name"))) != null) {
            equinoxConfig.setConfiguration("org.osgi.framework.executionenvironment", ee);
        }
        if (equinoxConfig.getConfiguration("org.osgi.framework.system.capabilities") == null && (systemCapabilities = profileProps.getProperty("org.osgi.framework.system.capabilities")) != null) {
            equinoxConfig.setConfiguration("org.osgi.framework.system.capabilities", systemCapabilities);
        }
    }

    private Properties findVMProfile(BundleInfo.Generation systemGeneration) {
        Properties result;
        block36: {
            result = this.readConfiguredJavaProfile(systemGeneration);
            String vmProfile = null;
            try {
                String javaProfile;
                File release;
                String javaHome;
                if (result != null) {
                    Properties properties = result;
                    return properties;
                }
                if (Version.valueOf("9").compareTo(this.runtimeVersion) <= 0 && (result = this.calculateVMProfile(this.runtimeVersion)) != null) {
                    Properties properties = result;
                    return properties;
                }
                String embeddedProfileName = "-";
                if (this.runtimeVersion != null && Version.valueOf("1.8").compareTo(this.runtimeVersion) <= 0 && (javaHome = System.getProperty("java.home")) != null && (release = new File(javaHome, "release")).exists()) {
                    Properties releaseProps = new Properties();
                    try {
                        Throwable throwable = null;
                        Object var9_13 = null;
                        try (FileInputStream releaseStream = new FileInputStream(release);){
                            releaseProps.load(releaseStream);
                            String releaseName = releaseProps.getProperty("JAVA_PROFILE");
                            if (releaseName != null) {
                                releaseName = releaseName.replaceAll("^\\s*\"?|\"?\\s*$", "");
                                embeddedProfileName = "_" + releaseName + "-";
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {}
                }
                result = new Properties();
                vmProfile = JAVASE + embeddedProfileName + this.javaSpecVersion;
                InputStream profileIn = null;
                if (vmProfile != null && (profileIn = this.findInSystemBundle(systemGeneration, javaProfile = String.valueOf(vmProfile) + PROFILE_EXT)) == null) {
                    profileIn = this.getNextBestProfile(systemGeneration, JAVASE, this.runtimeVersion, embeddedProfileName);
                }
                if (profileIn == null) {
                    profileIn = this.findInSystemBundle(systemGeneration, "JavaSE-1.7.profile");
                }
                if (profileIn == null) break block36;
                try {
                    try {
                        result.load(new BufferedInputStream(profileIn));
                    }
                    catch (IOException iOException) {
                        try {
                            profileIn.close();
                        }
                        catch (IOException iOException2) {}
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        profileIn.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    profileIn.close();
                }
                catch (IOException iOException) {}
            }
            finally {
                if (result != null && result.getProperty("osgi.java.profile.name") == null) {
                    if (vmProfile != null) {
                        result.put("osgi.java.profile.name", vmProfile.replace('_', '/'));
                    } else {
                        result.put("osgi.java.profile.name", "JavaSE-1.7");
                    }
                }
            }
        }
        return result;
    }

    private Properties readConfiguredJavaProfile(BundleInfo.Generation systemGeneration) {
        String propJavaProfile = this.equinoxContainer.getConfiguration().getConfiguration("osgi.java.profile");
        if (propJavaProfile != null) {
            InputStream profileIn = null;
            try {
                profileIn = new URL(propJavaProfile).openStream();
            }
            catch (IOException iOException) {
                profileIn = this.findInSystemBundle(systemGeneration, propJavaProfile);
            }
            if (profileIn != null) {
                Properties result;
                block15: {
                    result = new Properties();
                    try {
                        try {
                            result.load(new BufferedInputStream(profileIn));
                        }
                        catch (IOException iOException) {
                            try {
                                profileIn.close();
                            }
                            catch (IOException iOException2) {}
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            profileIn.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        profileIn.close();
                    }
                    catch (IOException iOException) {}
                }
                return result;
            }
        }
        return null;
    }

    private Properties calculateVMProfile(Version javaVersion) {
        String systemPackages = this.calculateVMPackages();
        if (systemPackages == null) {
            return null;
        }
        String executionEnvs = this.calculateVMExecutionEnvs(javaVersion);
        String eeCapabilities = this.calculateEECapabilities(javaVersion);
        Properties result = new Properties();
        result.put("org.osgi.framework.system.packages", systemPackages);
        result.put("org.osgi.framework.executionenvironment", executionEnvs);
        result.put("org.osgi.framework.system.capabilities", eeCapabilities);
        return result;
    }

    private String calculateVMExecutionEnvs(Version javaVersion) {
        StringBuilder result = new StringBuilder("OSGi/Minimum-1.0, OSGi/Minimum-1.1, OSGi/Minimum-1.2, JavaSE/compact1-1.8, JavaSE/compact2-1.8, JavaSE/compact3-1.8, JRE-1.1, J2SE-1.2, J2SE-1.3, J2SE-1.4, J2SE-1.5, JavaSE-1.6, JavaSE-1.7, JavaSE-1.8");
        Version v = new Version(9, 0, 0);
        while (v.compareTo(javaVersion) <= 0) {
            result.append(',').append(' ').append(JAVASE).append('-').append(v.getMajor());
            if (v.getMinor() > 0) {
                result.append('.').append(v.getMinor());
            }
            v = v.getMajor() == javaVersion.getMajor() ? new Version(v.getMajor(), v.getMinor() + 1, 0) : new Version(v.getMajor() + 1, 0, 0);
        }
        return result.toString();
    }

    private String calculateEECapabilities(Version javaVersion) {
        Version v = new Version(9, 0, 0);
        StringBuilder versionsBulder = new StringBuilder();
        while (v.compareTo(javaVersion) <= 0) {
            versionsBulder.append(',').append(' ').append(v.getMajor()).append('.').append(v.getMinor());
            v = v.getMajor() == javaVersion.getMajor() ? new Version(v.getMajor(), v.getMinor() + 1, 0) : new Version(v.getMajor() + 1, 0, 0);
        }
        String versionsList = versionsBulder.toString();
        StringBuilder result = new StringBuilder("osgi.ee; osgi.ee=\"OSGi/Minimum\"; version:List<Version>=\"1.0, 1.1, 1.2\", osgi.ee; osgi.ee=\"JRE\"; version:List<Version>=\"1.0, 1.1\", osgi.ee; osgi.ee=\"JavaSE\"; version:List<Version>=\"1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8");
        result.append(versionsList).append("\"");
        result.append(",osgi.ee; osgi.ee=\"JavaSE/compact1\"; version:List<Version>=\"1.8");
        result.append(versionsList).append("\"");
        result.append(",osgi.ee; osgi.ee=\"JavaSE/compact2\"; version:List<Version>=\"1.8");
        result.append(versionsList).append("\"");
        result.append(",osgi.ee; osgi.ee=\"JavaSE/compact3\"; version:List<Version>=\"1.8");
        result.append(versionsList).append("\"");
        return result.toString();
    }

    private String calculateVMPackages() {
        try {
            ArrayList<String> packages = new ArrayList<String>();
            Class<?> moduleLayerClass = Class.forName("java.lang.ModuleLayer");
            Method boot = moduleLayerClass.getMethod("boot", new Class[0]);
            Method modules = moduleLayerClass.getMethod("modules", new Class[0]);
            Class<?> moduleClass = Class.forName("java.lang.Module");
            Method getDescriptor = moduleClass.getMethod("getDescriptor", new Class[0]);
            Class<?> moduleDescriptorClass = Class.forName("java.lang.module.ModuleDescriptor");
            Method exports = moduleDescriptorClass.getMethod("exports", new Class[0]);
            Method isAutomatic = moduleDescriptorClass.getMethod("isAutomatic", new Class[0]);
            Method packagesMethod = moduleDescriptorClass.getMethod("packages", new Class[0]);
            Class<?> exportsClass = Class.forName("java.lang.module.ModuleDescriptor$Exports");
            Method isQualified = exportsClass.getMethod("isQualified", new Class[0]);
            Method source = exportsClass.getMethod("source", new Class[0]);
            Object bootLayer = boot.invoke(null, new Object[0]);
            Set bootModules = (Set)modules.invoke(bootLayer, new Object[0]);
            for (Object m3 : bootModules) {
                Object descriptor = getDescriptor.invoke(m3, new Object[0]);
                if (((Boolean)isAutomatic.invoke(descriptor, new Object[0])).booleanValue()) {
                    packages.addAll((Set)packagesMethod.invoke(descriptor, new Object[0]));
                    continue;
                }
                for (Object export : (Set)exports.invoke(descriptor, new Object[0])) {
                    String pkg = (String)source.invoke(export, new Object[0]);
                    if (((Boolean)isQualified.invoke(export, new Object[0])).booleanValue()) continue;
                    packages.add(pkg);
                }
            }
            Collections.sort(packages);
            StringBuilder result = new StringBuilder();
            for (String pkg : packages) {
                if (result.length() != 0) {
                    result.append(',').append(' ');
                }
                result.append(pkg);
            }
            return result.toString();
        }
        catch (Exception e) {
            this.equinoxContainer.getLogServices().log("org.eclipse.osgi", 4, "Error determining system packages.", e);
            return null;
        }
    }

    private InputStream getNextBestProfile(BundleInfo.Generation systemGeneration, String javaEdition, Version javaVersion, String embeddedProfileName) {
        if (javaVersion == null || javaEdition != JAVASE) {
            return null;
        }
        InputStream bestProfile = this.findNextBestProfile(systemGeneration, javaEdition, javaVersion, embeddedProfileName);
        if (bestProfile == null && !"-".equals(embeddedProfileName)) {
            return this.getNextBestProfile(systemGeneration, javaEdition, javaVersion, "-");
        }
        return bestProfile;
    }

    private InputStream findNextBestProfile(BundleInfo.Generation systemGeneration, String javaEdition, Version javaVersion, String embeddedProfileName) {
        InputStream result = null;
        int major = javaVersion.getMajor();
        int minor = javaVersion.getMinor();
        do {
            String profileResourceName = String.valueOf(javaEdition) + embeddedProfileName + major + (minor > 0 ? "." + minor : "") + PROFILE_EXT;
            result = this.findInSystemBundle(systemGeneration, profileResourceName);
            if (minor > 0) {
                --minor;
                continue;
            }
            if (major > 9) {
                --major;
                continue;
            }
            if (major <= 9 && major > 1) {
                minor = 8;
                major = 1;
                continue;
            }
            return result;
        } while (result == null && minor >= 0);
        return result;
    }

    private InputStream findInSystemBundle(BundleInfo.Generation systemGeneration, String entry) {
        BundleFile systemContent = systemGeneration.getBundleFile();
        BundleEntry systemEntry = systemContent != null ? systemContent.getEntry(entry) : null;
        InputStream result = null;
        if (systemEntry != null) {
            try {
                result = systemEntry.getInputStream();
            }
            catch (IOException iOException) {}
        }
        if (result == null) {
            ClassLoader loader = this.getClass().getClassLoader();
            result = loader == null ? ClassLoader.getSystemResourceAsStream(entry) : loader.getResourceAsStream(entry);
        }
        return result;
    }

    public static Enumeration<URL> findEntries(List<BundleInfo.Generation> generations, String path, String filePattern, int options) {
        ArrayList<BundleFile> bundleFiles = new ArrayList<BundleFile>(generations.size());
        for (BundleInfo.Generation generation : generations) {
            bundleFiles.add(generation.getBundleFile());
        }
        List<String> pathList = Storage.listEntryPaths(bundleFiles, path, filePattern, options);
        if (pathList.size() == 0) {
            return null;
        }
        final String[] pathArray = pathList.toArray(new String[pathList.size()]);
        final BundleInfo.Generation[] generationArray = generations.toArray(new BundleInfo.Generation[generations.size()]);
        return new Enumeration<URL>(){
            private int curPathIndex = 0;
            private int curDataIndex = 0;
            private URL nextElement = null;

            @Override
            public boolean hasMoreElements() {
                if (this.nextElement != null) {
                    return true;
                }
                this.getNextElement();
                return this.nextElement != null;
            }

            @Override
            public URL nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                URL result = this.nextElement;
                this.getNextElement();
                return result;
            }

            /*
             * Unable to fully structure code
             */
            private void getNextElement() {
                this.nextElement = null;
                if (this.curPathIndex < pathArray.length) ** GOTO lbl11
                return;
lbl-1000:
                // 1 sources

                {
                    curPath = pathArray[this.curPathIndex];
                    while (this.nextElement == null && this.curDataIndex < generationArray.length) {
                        this.nextElement = generationArray[this.curDataIndex++].getEntry(curPath);
                    }
                    if (this.curDataIndex < generationArray.length) continue;
                    ++this.curPathIndex;
                    this.curDataIndex = 0;
lbl11:
                    // 3 sources

                    ** while (this.nextElement == null && this.curPathIndex < pathArray.length)
                }
lbl12:
                // 1 sources

            }
        };
    }

    public static List<String> listEntryPaths(List<BundleFile> bundleFiles, String path, String filePattern, int options) {
        LinkedHashSet<String> pathList = new LinkedHashSet<String>();
        FilterImpl patternFilter = null;
        Hashtable patternProps = null;
        if (filePattern != null) {
            if ((options & 1) == 0 && filePattern.indexOf(42) == -1 && filePattern.indexOf(92) == -1) {
                path = path.length() == 0 ? filePattern : String.valueOf(path) + (path.charAt(path.length() - 1) == '/' ? filePattern : String.valueOf('/') + filePattern);
                for (BundleFile bundleFile : bundleFiles) {
                    if (bundleFile.getEntry(path) == null || pathList.contains(path)) continue;
                    pathList.add(path);
                }
                return new ArrayList<String>(pathList);
            }
            try {
                patternFilter = FilterImpl.newInstance("(filename=" + Storage.sanitizeFilterInput(filePattern) + ")");
                patternProps = new Hashtable(2);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                return new ArrayList<String>(pathList);
            }
        }
        for (BundleFile bundleFile : bundleFiles) {
            Storage.listEntryPaths(bundleFile, path, patternFilter, patternProps, options, pathList);
        }
        return new ArrayList<String>(pathList);
    }

    public static String sanitizeFilterInput(String filePattern) throws InvalidSyntaxException {
        StringBuilder buffer = null;
        boolean foundEscape = false;
        int i = 0;
        while (i < filePattern.length()) {
            char c = filePattern.charAt(i);
            switch (c) {
                case '\\': {
                    boolean bl = foundEscape = !foundEscape;
                    if (buffer == null) break;
                    buffer.append(c);
                    break;
                }
                case '(': 
                case ')': {
                    if (!foundEscape) {
                        if (buffer == null) {
                            buffer = new StringBuilder(filePattern.length() + 16);
                            buffer.append(filePattern.substring(0, i));
                        }
                        buffer.append('\\');
                    } else {
                        foundEscape = false;
                    }
                    if (buffer == null) break;
                    buffer.append(c);
                    break;
                }
                default: {
                    foundEscape = false;
                    if (buffer == null) break;
                    buffer.append(c);
                }
            }
            ++i;
        }
        if (foundEscape) {
            throw new InvalidSyntaxException("Trailing escape characters must be escaped.", filePattern);
        }
        return buffer == null ? filePattern : buffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static LinkedHashSet<String> listEntryPaths(BundleFile bundleFile, String path, Filter patternFilter, Hashtable<String, String> patternProps, int options, LinkedHashSet<String> pathList) {
        if (pathList == null) {
            pathList = new LinkedHashSet<E>();
        }
        if ((entryPaths = (options & 1) != 0 ? bundleFile.getEntryPaths(path, true) : bundleFile.getEntryPaths(path)) != null) ** GOTO lbl24
        return pathList;
lbl-1000:
        // 1 sources

        {
            entry = entryPaths.nextElement();
            lastSlash = entry.lastIndexOf(47);
            if (patternProps != null) {
                secondToLastSlash = entry.lastIndexOf(47, lastSlash - 1);
                fileEnd = entry.length();
                if (lastSlash < 0) {
                    fileStart = 0;
                } else if (lastSlash != entry.length() - 1) {
                    fileStart = lastSlash + 1;
                } else {
                    fileEnd = lastSlash;
                    fileStart = secondToLastSlash < 0 ? 0 : secondToLastSlash + 1;
                }
                fileName = entry.substring(fileStart, fileEnd);
                patternProps.put("filename", fileName);
            }
            if (pathList.contains(entry) || patternFilter != null && !patternFilter.matchCase(patternProps)) continue;
            pathList.add(entry);
lbl24:
            // 3 sources

            ** while (entryPaths.hasMoreElements())
        }
lbl25:
        // 1 sources

        return pathList;
    }

    public String copyToTempLibrary(BundleInfo.Generation generation, String absolutePath) {
        File libTempDir = new File(this.childRoot, LIB_TEMP);
        File realLib = new File(absolutePath);
        String libName = realLib.getName();
        File bundleTempDir = null;
        File libTempFile = null;
        Long bundleID = new Long(generation.getBundleInfo().getBundleId());
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            bundleTempDir = new File(libTempDir, String.valueOf(bundleID.toString()) + "_" + Integer.valueOf(i).toString());
            libTempFile = new File(bundleTempDir, libName);
            if (!bundleTempDir.exists() || !libTempFile.exists()) break;
            ++i;
        }
        if (!bundleTempDir.isDirectory()) {
            bundleTempDir.mkdirs();
            bundleTempDir.deleteOnExit();
            File deleteFlag = new File(libTempDir, DELETE_FLAG);
            if (!deleteFlag.exists()) {
                try {
                    FileOutputStream out = new FileOutputStream(deleteFlag);
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            FileInputStream in = new FileInputStream(realLib);
            StorageUtil.readFile(in, libTempFile);
            this.setPermissions(libTempFile);
            libTempFile.deleteOnExit();
            return libTempFile.getAbsolutePath();
        }
        catch (IOException e) {
            this.equinoxContainer.getLogServices().log("org.eclipse.osgi", 4, e.getMessage(), e);
            return null;
        }
    }

    public SecurityAdmin getSecurityAdmin() {
        return this.securityAdmin;
    }

    protected StorageManager getChildStorageManager() throws IOException {
        String locking = this.getConfiguration().getConfiguration("osgi.locking", "java.nio");
        StorageManager sManager = new StorageManager(this.childRoot, this.isReadOnly() ? "none" : locking, this.isReadOnly());
        try {
            sManager.open(!this.isReadOnly());
        }
        catch (IOException ex) {
            if (this.getConfiguration().getDebug().DEBUG_STORAGE) {
                Debug.println("Error reading framework.info: " + ex.getMessage());
                Debug.printStackTrace(ex);
            }
            String message = NLS.bind(Msg.ECLIPSE_STARTUP_FILEMANAGER_OPEN_ERROR, ex.getMessage());
            this.equinoxContainer.getLogServices().log("org.eclipse.osgi", 4, message, ex);
            this.getConfiguration().setProperty("eclipse.exitcode", "15");
            String errorDialog = "<title>" + Msg.ADAPTOR_STORAGE_INIT_FAILED_TITLE + "</title>" + NLS.bind(Msg.ADAPTOR_STORAGE_INIT_FAILED_MSG, this.childRoot) + "\n" + ex.getMessage();
            this.getConfiguration().setProperty("eclipse.exitdata", errorDialog);
            throw ex;
        }
        return sManager;
    }

    private InputStream getInfoInputStream() throws IOException {
        InputStream storageStream;
        block14: {
            StorageManager storageManager = this.getChildStorageManager();
            storageStream = null;
            try {
                try {
                    storageStream = storageManager.getInputStream(FRAMEWORK_INFO);
                }
                catch (IOException ex) {
                    if (this.getConfiguration().getDebug().DEBUG_STORAGE) {
                        Debug.println("Error reading framework.info: " + ex.getMessage());
                        Debug.printStackTrace(ex);
                    }
                    storageManager.close();
                    break block14;
                }
            }
            catch (Throwable throwable) {
                storageManager.close();
                throw throwable;
            }
            storageManager.close();
        }
        if (storageStream == null && this.parentRoot != null) {
            try (StorageManager parentStorageManager = null;){
                try {
                    parentStorageManager = new StorageManager(this.parentRoot, "none", true);
                    parentStorageManager.open(false);
                    storageStream = parentStorageManager.getInputStream(FRAMEWORK_INFO);
                }
                catch (IOException iOException) {
                    if (parentStorageManager != null) {
                        parentStorageManager.close();
                    }
                }
            }
        }
        return storageStream;
    }

    public static class StorageException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StorageException() {
        }

        public StorageException(String message, Throwable cause) {
            super(message, cause);
        }

        public StorageException(String message) {
            super(message);
        }

        public StorageException(Throwable cause) {
            super(cause);
        }
    }
}

