/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.impl.IClassMirror;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractClassMirror
implements IClassMirror {
    private static final Logger logger = Logger.getLogger(AbstractClassMirror.class);
    private boolean isEmptynessLogged = false;
    protected TypeResourceServices typeResourceServices;

    public AbstractClassMirror() {
    }

    public AbstractClassMirror(TypeResourceServices typeResourceServices) {
        this.typeResourceServices = typeResourceServices;
    }

    @Override
    public String getFragment(EObject obj, IFragmentProvider.Fallback fallback) {
        if (obj instanceof JvmTypeParameter) {
            return this.getFragment(obj.eContainer(), fallback) + "/" + ((JvmTypeParameter)obj).getName();
        }
        if (obj instanceof JvmTypeReference || obj instanceof JvmFormalParameter) {
            return fallback.getFragment(obj);
        }
        if (obj instanceof JvmIdentifiableElement) {
            if (obj instanceof JvmArrayType) {
                if (obj.eContainer() instanceof JvmGenericArrayTypeReference) {
                    return fallback.getFragment(obj);
                }
                if (obj.eContainer() instanceof JvmIdentifiableElement) {
                    return this.getFragment(obj.eContainer(), fallback) + "[]";
                }
            }
            return ((JvmIdentifiableElement)obj).getIdentifier();
        }
        return fallback.getFragment(obj);
    }

    @Override
    public EObject getEObject(Resource resource, String fragment, IFragmentProvider.Fallback fallback) {
        if (fragment.endsWith("[]")) {
            return this.getArrayEObject(resource, fragment, fallback);
        }
        int slash = fragment.indexOf(47);
        if (slash != -1) {
            if (slash == 0) {
                return fallback.getEObject(fragment);
            }
            String containerFragment = fragment.substring(0, slash);
            EObject container = this.getEObject(resource, containerFragment, fallback);
            if (container != null) {
                String parameterName = fragment.substring(slash + 1);
                if (container instanceof JvmTypeParameterDeclarator) {
                    JvmTypeParameterDeclarator executable = (JvmTypeParameterDeclarator)container;
                    for (JvmTypeParameter parameter : executable.getTypeParameters()) {
                        if (!parameter.getName().equals(parameterName)) continue;
                        return parameter;
                    }
                }
            }
        } else {
            if (resource.getContents().isEmpty()) {
                if (this.typeResourceServices != null) {
                    this.typeResourceServices.outdatedStateManager.checkCanceled(resource.getResourceSet());
                }
                if (!this.isEmptynessLogged) {
                    this.isEmptynessLogged = true;
                    logger.error("resource is empty: " + resource.getURI(), new IllegalStateException());
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.getClass().getName(), new Exception());
                    }
                }
                return null;
            }
            EObject type = (EObject)resource.getContents().get(0);
            if (type instanceof JvmType) {
                EObject member;
                String typeName = this.getTypeName((JvmType)type);
                if (typeName.equals(fragment)) {
                    return type;
                }
                if (fragment.startsWith(typeName) && (member = this.findMember(type, fragment)) != null) {
                    return member;
                }
            }
        }
        return fallback.getEObject(fragment);
    }

    protected String getTypeName(JvmType type) {
        return this.getTypeName();
    }

    protected EObject findMember(EObject container, String fragment) {
        if (container instanceof JvmDeclaredType) {
            String name;
            EList<JvmMember> members = ((JvmDeclaredType)container).getMembers();
            for (JvmMember member : members) {
                name = member.getIdentifier();
                if (!Strings.equal(fragment, name)) continue;
                return member;
            }
            for (JvmMember member : members) {
                EObject match;
                name = member.getIdentifier();
                if (!fragment.startsWith(name) || (match = this.findMember(member, fragment)) == null) continue;
                return match;
            }
        }
        return null;
    }

    protected EObject getArrayEObject(Resource resource, String fragment, IFragmentProvider.Fallback fallback) {
        JvmComponentType component = (JvmComponentType)this.getEObject(resource, fragment.substring(0, fragment.length() - 2), fallback);
        if (component == null) {
            return null;
        }
        return component.getArrayType();
    }

    protected abstract String getTypeName();
}

