/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.findReferences;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.util.IAcceptor;

public class ReferenceAcceptor
implements IReferenceFinder.Acceptor {
    private final IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    private final IAcceptor<IReferenceDescription> delegate;
    private Resource currentResource;
    private Map<EObject, URI> exportedContainersInCurrentResource;

    public ReferenceAcceptor(IResourceServiceProvider.Registry resourceServiceProviderRegistry, IAcceptor<IReferenceDescription> delegate) {
        this.resourceServiceProviderRegistry = resourceServiceProviderRegistry;
        this.delegate = delegate;
    }

    @Override
    public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
        if (this.currentResource == null || source.eResource() != this.currentResource) {
            this.computeExportedObjectsMap(source);
            this.currentResource = source.eResource();
        }
        this.accept(this.createReferenceDescription(EcoreUtil2.getFragmentPathURI(source), targetURI, eReference, index, this.findExportedContainer(source)));
    }

    @Override
    public void accept(IReferenceDescription description) {
        this.delegate.accept(description);
    }

    protected void computeExportedObjectsMap(EObject source) {
        Resource resource = source.eResource();
        IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(resource.getURI());
        if (resourceServiceProvider != null) {
            this.exportedContainersInCurrentResource = new HashMap<EObject, URI>();
            Iterable<IEObjectDescription> exportedObjects = resourceServiceProvider.getResourceDescriptionManager().getResourceDescription(resource).getExportedObjects();
            for (IEObjectDescription description : exportedObjects) {
                EObject instance = description.getEObjectOrProxy();
                if (instance.eIsProxy()) {
                    instance = resource.getEObject(description.getEObjectURI().fragment());
                }
                this.exportedContainersInCurrentResource.put(instance, description.getEObjectURI());
            }
        } else {
            this.exportedContainersInCurrentResource = Collections.emptyMap();
        }
    }

    protected URI findExportedContainer(EObject obj) {
        if (this.exportedContainersInCurrentResource.isEmpty()) {
            return null;
        }
        EObject source = obj;
        URI result = this.exportedContainersInCurrentResource.get(source);
        while (result == null) {
            if (this.exportedContainersInCurrentResource.containsKey(source)) {
                return result;
            }
            if ((source = source.eContainer()) == null) {
                return null;
            }
            result = this.exportedContainersInCurrentResource.get(source);
        }
        this.exportedContainersInCurrentResource.put(source, result);
        return result;
    }

    protected IReferenceDescription createReferenceDescription(URI sourceURI, URI targetURI, EReference eReference, int index, URI containerURI) {
        return new DefaultReferenceDescription(sourceURI, targetURI, eReference, index, containerURI);
    }
}

