/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting.IElementMatcherProvider;
import org.eclipse.xtext.formatting.impl.AbstractFormattingConfig;
import org.eclipse.xtext.formatting.impl.BaseTokenStream;
import org.eclipse.xtext.formatting.impl.FormattingConfig;
import org.eclipse.xtext.formatting.impl.FormattingConfig2;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenStringBuffer;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class FormattingConfigBasedStream
extends BaseTokenStream {
    protected Set<AbstractFormattingConfig.ElementLocator> activeRangeLocators = Sets.newHashSet();
    protected FormattingConfig cfg;
    protected Line currentLine = null;
    protected IHiddenTokenHelper hiddenTokenHelper;
    protected int indentationLevel = 0;
    protected String indentationPrefix = "";
    protected EObject last = null;
    protected IElementMatcherProvider.IElementMatcher<AbstractFormattingConfig.ElementPattern> matcher;
    protected String preservedWS = "";
    protected boolean preserveSpaces;

    public FormattingConfigBasedStream(ITokenStream out, String initialIndentation, FormattingConfig cfg, IElementMatcherProvider.IElementMatcher<AbstractFormattingConfig.ElementPattern> matcher, IHiddenTokenHelper hiddenTokenHelper, boolean preserveSpaces) {
        super(out);
        this.cfg = cfg;
        this.matcher = matcher;
        this.hiddenTokenHelper = hiddenTokenHelper;
        this.preserveSpaces = preserveSpaces;
        this.indentationPrefix = initialIndentation == null ? "" : initialIndentation;
    }

    protected String getLineSeparator() {
        if (this.cfg instanceof FormattingConfig2) {
            return ((FormattingConfig2)this.cfg).getLineSeparatorInfo().getLineSeparator();
        }
        return System.getProperty("line.separator");
    }

    protected void addLineEntry(EObject grammarElement, String value, boolean isHidden) throws IOException {
        Line newLine;
        Pair<Integer, RuleCall> hiddenTokenDefCall1 = this.findTopmostHiddenTokenDef();
        Set<AbstractFormattingConfig.ElementLocator> locators = this.collectLocators(grammarElement);
        Pair<Integer, RuleCall> hiddenTokenDefCall2 = this.findTopmostHiddenTokenDef();
        ParserRule hiddenTokenDef = null;
        if (hiddenTokenDefCall1 != null && hiddenTokenDefCall2 != null) {
            hiddenTokenDef = hiddenTokenDefCall1.getFirst() < hiddenTokenDefCall2.getFirst() ? (ParserRule)hiddenTokenDefCall1.getSecond().getRule() : (ParserRule)hiddenTokenDefCall2.getSecond().getRule();
        }
        LineEntry e = this.createLineEntry(grammarElement, value, true, locators, this.preservedWS, this.indentationLevel, hiddenTokenDef);
        this.preservedWS = null;
        if (this.currentLine == null) {
            this.currentLine = this.createLine();
        }
        if ((newLine = this.currentLine.add(e)) != null) {
            this.currentLine = newLine;
        }
    }

    protected Set<AbstractFormattingConfig.ElementLocator> collectLocators(EObject ele) {
        HashSet<AbstractFormattingConfig.ElementLocator> result = Sets.newHashSet(this.activeRangeLocators);
        Set<AbstractFormattingConfig.ElementLocator> loc = Sets.newHashSet();
        if (ele instanceof AbstractElement) {
            for (AbstractFormattingConfig.ElementPattern pattern : this.matcher.matchNext((AbstractElement)ele)) {
                loc.add(pattern.getLocator());
            }
        }
        if (this.last instanceof AbstractRule && this.hiddenTokenHelper.isComment((AbstractRule)this.last) || ele instanceof AbstractRule && this.hiddenTokenHelper.isComment((AbstractRule)ele)) {
            loc = this.collectLocatorsForComments(loc, this.last, ele);
        }
        this.last = ele;
        for (AbstractFormattingConfig.ElementLocator locator : loc) {
            if (locator.getType() != AbstractFormattingConfig.LocatorType.RANGE || this.activeRangeLocators.add(locator)) continue;
            this.activeRangeLocators.remove(locator);
        }
        result.addAll(loc);
        for (AbstractFormattingConfig.ElementLocator locator : result) {
            if (locator instanceof FormattingConfig.IndentationLocatorStart) {
                ++this.indentationLevel;
                continue;
            }
            if (!(locator instanceof FormattingConfig.IndentationLocatorEnd)) continue;
            --this.indentationLevel;
        }
        return result;
    }

    protected Set<AbstractFormattingConfig.ElementLocator> collectLocatorsForComments(Collection<AbstractFormattingConfig.ElementLocator> semanticLocators, EObject left, EObject right) {
        HashSet<AbstractFormattingConfig.ElementLocator> result = Sets.newHashSet();
        for (AbstractFormattingConfig.ElementLocator semantic : semanticLocators) {
            if (!(semantic instanceof FormattingConfig.IndentationLocatorStart) && !(semantic instanceof FormattingConfig.IndentationLocatorEnd) && (semantic.getRight() == null || semantic.getRight() != right) && (semantic.getLeft() == null || semantic.getLeft() != left)) continue;
            result.add(semantic);
        }
        if (left != null) {
            result.addAll(this.cfg.getLocatorsForCommentTokensAfter(left));
        }
        if (right != null) {
            ArrayList<AbstractFormattingConfig.ElementLocator> leadingElementLocators = Lists.newArrayList(this.cfg.getLocatorsForCommentTokensBefore(right));
            Iterator i = result.iterator();
            while (i.hasNext()) {
                AbstractFormattingConfig.ElementLocator locator = (AbstractFormattingConfig.ElementLocator)i.next();
                if (locator.getType() != AbstractFormattingConfig.LocatorType.BETWEEN || leadingElementLocators.contains(locator)) continue;
                i.remove();
            }
            i = leadingElementLocators.iterator();
            while (i.hasNext()) {
                if (((AbstractFormattingConfig.ElementLocator)i.next()).getType() != AbstractFormattingConfig.LocatorType.BETWEEN) continue;
                i.remove();
            }
            result.addAll(leadingElementLocators);
        }
        return result;
    }

    protected Line createLine() {
        return this.createLine(null);
    }

    protected Line createLine(int leftover) {
        return this.createLine(null, leftover);
    }

    protected Line createLine(List<LineEntry> entries) {
        return this.createLine(entries, 0);
    }

    protected Line createLine(List<LineEntry> initialEntries, int leftover) {
        return new Line(initialEntries, leftover);
    }

    public LineEntry createLineEntry(EObject grammarElement, String value, boolean isHidden, Set<AbstractFormattingConfig.ElementLocator> beforeLocators, String leadingWS, int indent, ParserRule hiddenTokenDefition) {
        return new LineEntry(grammarElement, value, isHidden, beforeLocators, leadingWS, indent, hiddenTokenDefition);
    }

    protected Pair<Integer, RuleCall> findTopmostHiddenTokenDef() {
        return this.matcher.findTopmostRuleCall(new Predicate<RuleCall>(){

            @Override
            public boolean apply(RuleCall input) {
                return ((ParserRule)input.getRule()).isDefinesHiddenTokens();
            }
        });
    }

    @Override
    public void flush() throws IOException {
        if (this.currentLine != null) {
            this.matcher.finish();
            this.currentLine.flush();
            this.currentLine = null;
        }
        super.flush();
    }

    @Override
    public void init(ParserRule startRule) {
        if (this.matcher instanceof IElementMatcherProvider.IElementMatcherExtension) {
            ((IElementMatcherProvider.IElementMatcherExtension)this.matcher).init(startRule);
        }
    }

    @Override
    public void writeHidden(EObject grammarElement, String value) throws IOException {
        boolean isWhitespace;
        boolean bl = isWhitespace = grammarElement instanceof AbstractRule && this.hiddenTokenHelper.isWhitespace((AbstractRule)grammarElement);
        if (isWhitespace || this.cfg.getWhitespaceRule() == grammarElement) {
            this.preservedWS = this.preservedWS == null ? this.harmonizeLineSeparator(value) : this.preservedWS + this.harmonizeLineSeparator(value);
        } else {
            this.addLineEntry(grammarElement, value, true);
        }
    }

    @Override
    public void writeSemantic(EObject grammarElement, String value) throws IOException {
        this.addLineEntry(grammarElement, value, false);
    }

    protected String harmonizeLineSeparator(String value) {
        if (value != null) {
            return value.replaceAll("\r?\n", this.getLineSeparator());
        }
        return null;
    }

    protected class LineEntry {
        protected EObject grammarElement;
        protected ParserRule hiddenTokenDefinition;
        protected int indent;
        protected boolean isHidden;
        protected Set<AbstractFormattingConfig.ElementLocator> leadingLocators;
        protected String leadingWS;
        protected String value;

        public LineEntry(EObject grammarElement, String value, boolean isHidden, Set<AbstractFormattingConfig.ElementLocator> beforeLocators, String leadingWS, int indent, ParserRule hiddenTokenDefition) {
            this.grammarElement = grammarElement;
            this.value = value;
            this.isHidden = isHidden;
            this.leadingLocators = beforeLocators;
            this.indent = indent;
            this.leadingWS = leadingWS;
            this.hiddenTokenDefinition = hiddenTokenDefition;
        }

        protected int countCharactersInLastLine() {
            int lastNLIndexInLeadingWs;
            int lastNLIndex = this.value.lastIndexOf(FormattingConfigBasedStream.this.getLineSeparator());
            if (lastNLIndex >= 0) {
                return this.value.length() - lastNLIndex - FormattingConfigBasedStream.this.getLineSeparator().length();
            }
            if (FormattingConfigBasedStream.this.preserveSpaces && this.leadingWS != null && (lastNLIndexInLeadingWs = this.leadingWS.lastIndexOf(FormattingConfigBasedStream.this.getLineSeparator())) >= 0) {
                return this.leadingWS.length() - lastNLIndexInLeadingWs + this.value.length() - FormattingConfigBasedStream.this.getLineSeparator().length();
            }
            return -1;
        }

        protected int countExistingLeadingNewlines() {
            if (this.leadingWS == null) {
                return -1;
            }
            int c = 0;
            int i = -1;
            while ((i = this.leadingWS.indexOf(FormattingConfigBasedStream.this.getLineSeparator(), i + 1)) >= 0) {
                ++c;
            }
            return c;
        }

        protected boolean isBreak() {
            if (!this.isBreakable()) {
                return false;
            }
            for (AbstractFormattingConfig.ElementLocator e : this.leadingLocators) {
                if (!(e instanceof FormattingConfig.LinewrapLocator)) continue;
                if (((FormattingConfig.LinewrapLocator)e).getMinWrap() > 0) {
                    return true;
                }
                if (this.countExistingLeadingNewlines() <= 0) continue;
                return true;
            }
            return false;
        }

        protected boolean isBreakable() {
            if (this.leadingLocators == null) {
                return false;
            }
            for (AbstractFormattingConfig.ElementLocator e : this.leadingLocators) {
                if (e instanceof FormattingConfig.LinewrapLocator && ((FormattingConfig.LinewrapLocator)e).getMaxWrap() == 0) {
                    return false;
                }
                if (!(e instanceof FormattingConfig.SpaceLocator)) continue;
                return false;
            }
            return FormattingConfigBasedStream.this.hiddenTokenHelper.getWhitespaceRuleFor(this.hiddenTokenDefinition, FormattingConfigBasedStream.this.getLineSeparator()) != null;
        }

        public String toString() {
            return this.leadingLocators + " --> " + (this.leadingWS != null ? "[" + this.leadingWS + "] " : "") + this.value;
        }
    }

    protected class Line {
        protected List<LineEntry> entries;
        protected String indent = null;
        protected int lastBreakableEntryIndex;
        protected int leftover;
        protected boolean startWithNL;
        protected int totalLength;

        public Line() {
            this(null);
        }

        protected Line(int leftover) {
            this(null, leftover);
        }

        protected Line(List<LineEntry> entries) {
            this(entries, 0);
        }

        protected Line(List<LineEntry> initialEntries, int leftover) {
            this.leftover = leftover;
            this.totalLength = leftover;
            this.entries = initialEntries == null ? new ArrayList() : initialEntries;
            this.lastBreakableEntryIndex = -1;
            boolean bl = this.startWithNL = initialEntries != null || leftover > 0;
            if (initialEntries != null && initialEntries.size() > 0) {
                this.indent = this.getIndentation(((LineEntry)initialEntries.get((int)0)).indent);
            }
            for (int i = 0; i < this.entries.size(); ++i) {
                LineEntry lineEntry = this.entries.get(i);
                this.totalLength += lineEntry.value.length();
                this.addSpacesToTotalLength(lineEntry, i == 0);
                if (!lineEntry.isBreakable()) continue;
                this.lastBreakableEntryIndex = i;
            }
        }

        public Line add(LineEntry lineEntry) throws IOException {
            this.entries.add(lineEntry);
            if (this.indent == null) {
                this.indent = this.getIndentation(this.entries.get((int)0).indent);
            }
            this.addSpacesToTotalLength(lineEntry, this.entries.size() == 1);
            int lastLineLength = lineEntry.countCharactersInLastLine();
            if (lastLineLength >= 0) {
                this.flush();
                return FormattingConfigBasedStream.this.createLine(lastLineLength);
            }
            if (lineEntry.isBreakable()) {
                this.lastBreakableEntryIndex = this.entries.size() - 1;
            }
            this.totalLength += lineEntry.value.length();
            if (lineEntry.isBreak()) {
                this.lastBreakableEntryIndex = this.entries.size() - 1;
                return this.flushLine();
            }
            if (this.totalLength > FormattingConfigBasedStream.this.cfg.getCharsPerLine() && this.lastBreakableEntryIndex > 0) {
                LineEntry lastEntry = this.entries.get(this.lastBreakableEntryIndex);
                lastEntry.indent += FormattingConfigBasedStream.this.cfg.getWrappedLineIndentation();
                return this.flushLine();
            }
            return null;
        }

        protected void addSpacesToTotalLength(LineEntry lineEntry, boolean first) {
            Pair<AbstractRule, String> spaces = this.getSpaces(lineEntry, first);
            if (spaces != null) {
                int lastIndexOfNL = spaces.getSecond().lastIndexOf(FormattingConfigBasedStream.this.getLineSeparator());
                this.totalLength = lastIndexOfNL >= 0 ? (this.totalLength += spaces.getSecond().length() - lastIndexOfNL) : (this.totalLength += spaces.getSecond().length());
            }
        }

        public void flush() throws IOException {
            this.flush(FormattingConfigBasedStream.this.out, this.entries.size());
        }

        protected void flush(ITokenStream intoStream, int endIndex) throws IOException {
            for (int i = 0; i < endIndex; ++i) {
                LineEntry e = this.entries.get(i);
                Pair<AbstractRule, String> spaces = this.getSpaces(e, i == 0);
                if (spaces != null) {
                    intoStream.writeHidden(spaces.getFirst(), spaces.getSecond());
                }
                if (e.isHidden) {
                    intoStream.writeHidden(e.grammarElement, e.value);
                    continue;
                }
                intoStream.writeSemantic(e.grammarElement, e.value);
            }
        }

        protected Line flushLine() throws IOException {
            this.flush(FormattingConfigBasedStream.this.out, this.lastBreakableEntryIndex);
            return FormattingConfigBasedStream.this.createLine(Lists.newArrayList(this.entries.subList(this.lastBreakableEntryIndex, this.entries.size())));
        }

        protected String getIndentation(int indentation) {
            if (this.leftover > 0) {
                return "";
            }
            if (indentation <= 0) {
                return FormattingConfigBasedStream.this.indentationPrefix;
            }
            StringBuffer result = new StringBuffer(indentation * FormattingConfigBasedStream.this.cfg.getIndentationSpace().length() + FormattingConfigBasedStream.this.indentationPrefix.length());
            result.append(FormattingConfigBasedStream.this.indentationPrefix);
            for (int i = 0; i < indentation; ++i) {
                result.append(FormattingConfigBasedStream.this.cfg.getIndentationSpace());
            }
            return result.toString();
        }

        public Pair<AbstractRule, String> getSpaces(LineEntry entry, boolean isLineStart) {
            String space = this.getSpacesStr(entry, isLineStart);
            if (space == null) {
                return null;
            }
            AbstractRule rule = FormattingConfigBasedStream.this.hiddenTokenHelper.getWhitespaceRuleFor(entry.hiddenTokenDefinition, space);
            if (rule == null) {
                return null;
            }
            return Tuples.create(rule, space);
        }

        public String getSpacesStr(LineEntry entry, boolean isLineStart) {
            int def;
            if (FormattingConfigBasedStream.this.preserveSpaces && entry.leadingWS != null) {
                return entry.leadingWS;
            }
            if (entry.leadingLocators == null) {
                return null;
            }
            String space = null;
            for (AbstractFormattingConfig.ElementLocator leadingLocator : entry.leadingLocators) {
                if (!(leadingLocator instanceof FormattingConfig.SpaceLocator)) continue;
                String s2 = ((FormattingConfig.SpaceLocator)leadingLocator).getSpace();
                if (space != null && s2.length() <= space.length()) continue;
                space = s2;
            }
            if (space != null) {
                return space;
            }
            int min2 = def = isLineStart && this.startWithNL && this.leftover <= 0 ? 1 : 0;
            int max = def;
            boolean noWrap = false;
            for (AbstractFormattingConfig.ElementLocator leadingLocator : entry.leadingLocators) {
                if (!(leadingLocator instanceof FormattingConfig.LinewrapLocator)) continue;
                FormattingConfig.LinewrapLocator l = (FormattingConfig.LinewrapLocator)leadingLocator;
                min2 = Math.max(min2, l.getMinWrap());
                def = Math.max(def, l.getDefaultWrap());
                max = Math.max(max, l.getMaxWrap());
                if (l.getMaxWrap() != 0) continue;
                noWrap = true;
            }
            if (!noWrap) {
                int existing;
                if (min2 != max && (existing = entry.countExistingLeadingNewlines()) >= 0) {
                    def = existing;
                }
                if ((def = Math.max(min2, Math.min(def, max))) > 0) {
                    return this.wrap(def, this.indent);
                }
                if (isLineStart && this.indent.length() > 0) {
                    return this.indent;
                }
            }
            return isLineStart && !this.startWithNL ? null : " ";
        }

        public String toString() {
            TokenStringBuffer result = new TokenStringBuffer();
            try {
                this.flush(result, this.entries.size());
            }
            catch (IOException e) {
                e.printStackTrace();
                return "Error: " + e.getMessage();
            }
            return result.toString();
        }

        protected String wrap(int lines, String indent) {
            int indentLength;
            StringBuffer result = new StringBuffer(lines + indent.length());
            for (int i = 0; i < lines; ++i) {
                result.append(FormattingConfigBasedStream.this.getLineSeparator());
            }
            for (indentLength = indent.length(); FormattingConfigBasedStream.this.cfg.getCharsPerLine() * 2 / 3 < indentLength; indentLength -= FormattingConfigBasedStream.this.cfg.getCharsPerLine() / 2) {
            }
            if (indentLength != indent.length()) {
                indent = indent.substring(0, indentLength);
            }
            result.append(indent);
            return result.toString();
        }
    }
}

