/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.formatting2.regionaccess.IAstRegion;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionFinder;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractTextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeSemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.SemanticRegionInIterableFinder;
import org.eclipse.xtext.formatting2.regionaccess.internal.SemanticRegionIterable;
import org.eclipse.xtext.formatting2.regionaccess.internal.SemanticRegionMatcher;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringSemanticRegion;

public abstract class AbstractEObjectRegion
extends AbstractTextSegment
implements IEObjectRegion {
    private final ITextRegionAccess access;
    private final List<IAstRegion> children = Lists.newArrayList();
    private EObject grammarElement;
    private int indexInFeature = -2;
    private IHiddenRegion nextHidden;
    private IEObjectRegion parent;
    private IHiddenRegion previousHidden;
    private EObject semanticElement;

    public AbstractEObjectRegion(AbstractRegionAccess access) {
        this.access = access;
    }

    public void addChild(IAstRegion astRegion) {
        if (astRegion instanceof AbstractEObjectRegion) {
            ((AbstractEObjectRegion)astRegion).parent = this;
        }
        this.children.add(astRegion);
    }

    @Override
    public ISemanticRegionsFinder getAllRegionsFor() {
        return new SemanticRegionInIterableFinder(this.getAllSemanticRegions());
    }

    @Override
    public Iterable<ISemanticRegion> getAllSemanticRegions() {
        ISemanticRegion first = this.previousHidden.getNextSemanticRegion();
        ISemanticRegion last = this.nextHidden.getPreviousSemanticRegion();
        return new SemanticRegionIterable(first, last);
    }

    @Override
    public Iterable<IAstRegion> getAstRegions() {
        return this.children;
    }

    @Override
    public EStructuralFeature getContainingFeature() {
        if (this.semanticElement.eContainer() == null) {
            return null;
        }
        String feature = null;
        if (this.grammarElement instanceof Action) {
            feature = ((Action)this.grammarElement).getFeature();
        } else {
            Assignment assignment = GrammarUtil.containingAssignment(this.getGrammarElement());
            if (assignment != null) {
                feature = assignment.getFeature();
            }
        }
        if (feature == null) {
            return null;
        }
        return this.semanticElement.eContainer().eClass().getEStructuralFeature(feature);
    }

    @Override
    public IEObjectRegion getContainingRegion() {
        return this.parent;
    }

    @Override
    public EObject getGrammarElement() {
        return this.grammarElement;
    }

    @Override
    public int getIndexInContainingFeature() {
        if (this.indexInFeature < -1) {
            EStructuralFeature feature = this.getContainingFeature();
            if (feature != null && feature.isMany()) {
                ((AbstractEObjectRegion)this.parent).initChildrenFeatureIndexes();
            } else {
                this.indexInFeature = -1;
            }
        }
        return this.indexInFeature;
    }

    public IHiddenRegion getLeadingHiddenRegion() {
        return this.previousHidden;
    }

    @Override
    public int getLength() {
        return this.nextHidden.getOffset() - this.getOffset();
    }

    @Override
    public IHiddenRegion getNextHiddenRegion() {
        return this.nextHidden;
    }

    @Override
    public ISemanticRegion getNextSemanticRegion() {
        return this.nextHidden.getNextSemanticRegion();
    }

    @Override
    public ISequentialRegion getNextSequentialRegion() {
        return this.nextHidden;
    }

    @Override
    public int getOffset() {
        return this.previousHidden.getEndOffset();
    }

    @Override
    public IHiddenRegion getPreviousHiddenRegion() {
        return this.previousHidden;
    }

    @Override
    public ISemanticRegion getPreviousSemanticRegion() {
        return this.previousHidden.getPreviousSemanticRegion();
    }

    @Override
    public ISequentialRegion getPreviousSequentialRegion() {
        return this.previousHidden;
    }

    @Override
    public ISemanticRegionsFinder getRegionFor() {
        return new SemanticRegionInIterableFinder(this.getSemanticRegions());
    }

    @Override
    public EObject getSemanticElement() {
        return this.semanticElement;
    }

    @Override
    public Iterable<ISemanticRegion> getSemanticRegions() {
        return Iterables.filter(this.children, ISemanticRegion.class);
    }

    @Override
    public ITextRegionAccess getTextRegionAccess() {
        return this.access;
    }

    public IHiddenRegion getTrailingHiddenRegion() {
        return this.nextHidden;
    }

    @Override
    public ISemanticRegionFinder immediatelyFollowing() {
        return new SemanticRegionMatcher(this.getNextSemanticRegion());
    }

    @Override
    public ISemanticRegionFinder immediatelyPreceding() {
        return new SemanticRegionMatcher(this.getPreviousSemanticRegion());
    }

    protected void initChildrenFeatureIndexes() {
        EClass clazz = this.semanticElement.eClass();
        int[] indices = new int[clazz.getFeatureCount()];
        Arrays.fill(indices, 0);
        for (IAstRegion ele : this.children) {
            EStructuralFeature feat = ele.getContainingFeature();
            if (feat == null || !feat.isMany()) continue;
            int id = clazz.getFeatureID(feat);
            if (ele instanceof AbstractEObjectRegion) {
                ((AbstractEObjectRegion)ele).indexInFeature = indices[id];
            } else if (ele instanceof NodeSemanticRegion) {
                ((NodeSemanticRegion)ele).indexInFeature = indices[id];
            } else if (ele instanceof StringSemanticRegion) {
                ((StringSemanticRegion)ele).indexInFeature = indices[id];
            }
            int n = id;
            indices[n] = indices[n] + 1;
        }
    }

    protected void setGrammarElement(EObject grammarElement) {
        this.grammarElement = grammarElement;
    }

    protected void setLeadingHiddenRegion(IHiddenRegion leading) {
        this.previousHidden = leading;
    }

    protected void setSemanticElement(EObject semanticElement) {
        this.semanticElement = semanticElement;
    }

    protected void setTrailingHiddenRegion(IHiddenRegion trailing) {
        this.nextHidden = trailing;
    }
}

