/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.debug.TextRegionAccessToString;
import org.eclipse.xtext.formatting2.regionaccess.HiddenRegionPartAssociation;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionDiffBuilder;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedTextRegionAccessDiff;
import org.eclipse.xtext.formatting2.regionaccess.internal.StringBasedTextRegionAccessDiffAppender;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextRegionAccessBuildingSequencer;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.util.ITextRegion;

public class StringBasedTextRegionAccessDiffBuilder
implements ITextRegionDiffBuilder {
    private static final Logger LOG = Logger.getLogger(StringBasedTextRegionAccessDiffBuilder.class);
    private final ITextRegionAccess original;
    private List<Rewrite> rewrites = Lists.newArrayList();
    private Map<ITextSegment, String> changes = Maps.newHashMap();

    public StringBasedTextRegionAccessDiffBuilder(ITextRegionAccess base) {
        this.original = base;
    }

    protected void checkOriginal(ITextSegment segment) {
        Preconditions.checkNotNull(segment);
        Preconditions.checkArgument(this.original == segment.getTextRegionAccess());
    }

    protected List<Rewrite> createList() {
        ArrayList<Rewrite> sorted = Lists.newArrayList(this.rewrites);
        Collections.sort(sorted);
        ArrayList<Rewrite> result = Lists.newArrayListWithExpectedSize(sorted.size() * 2);
        IHiddenRegion last = this.original.regionForRootEObject().getPreviousHiddenRegion();
        for (Rewrite rw : sorted) {
            int lastOffset = last.getOffset();
            int rwOffset = rw.originalFirst.getOffset();
            if (rwOffset == lastOffset) {
                result.add(rw);
                last = rw.originalLast;
                continue;
            }
            if (rwOffset > lastOffset) {
                result.add(new Preserve(last, rw.originalFirst));
                result.add(rw);
                last = rw.originalLast;
                continue;
            }
            LOG.error("Error, conflicting document modifications.");
        }
        IHiddenRegion end = this.original.regionForRootEObject().getNextHiddenRegion();
        if (last.getOffset() < end.getOffset()) {
            result.add(new Preserve(last, end));
        }
        return result;
    }

    @Override
    public StringBasedTextRegionAccessDiff create() {
        StringBasedTextRegionAccessDiffAppender appender = this.createAppender();
        IEObjectRegion root = this.original.regionForRootEObject();
        appender.copyAndAppend(root.getPreviousHiddenRegion(), HiddenRegionPartAssociation.PREVIOUS);
        appender.copyAndAppend(root.getPreviousHiddenRegion(), HiddenRegionPartAssociation.CONTAINER);
        List<Rewrite> rws = this.createList();
        IHiddenRegion last = null;
        for (Rewrite rw : rws) {
            boolean diff = rw.isDiff();
            if (diff) {
                appender.beginDiff();
            }
            if (rw instanceof Insert) {
                Insert ins = (Insert)((Object)rw);
                IHiddenRegion f = ins.getInsertFirst();
                IHiddenRegion l = ins.getInsertLast();
                appender.copyAndAppend(f, HiddenRegionPartAssociation.NEXT);
                if (f != l) {
                    appender.copyAndAppend(f.getNextSemanticRegion(), l.getPreviousSemanticRegion());
                }
                appender.copyAndAppend(l, HiddenRegionPartAssociation.PREVIOUS);
            }
            if (diff) {
                appender.endDiff();
            }
            if (rw.originalLast != last) {
                appender.copyAndAppend(rw.originalLast, HiddenRegionPartAssociation.CONTAINER);
            }
            last = rw.originalLast;
        }
        appender.copyAndAppend(root.getNextHiddenRegion(), HiddenRegionPartAssociation.NEXT);
        StringBasedTextRegionAccessDiff result = appender.finish();
        AbstractEObjectRegion newRoot = result.regionForEObject(root.getSemanticElement());
        result.setRootEObject(newRoot);
        return result;
    }

    protected StringBasedTextRegionAccessDiffAppender createAppender() {
        return new StringBasedTextRegionAccessDiffAppender(this.original, this.changes);
    }

    @Override
    public ITextRegionAccess getOriginalTextRegionAccess() {
        return this.original;
    }

    @Override
    public boolean isModified(ITextRegion region) {
        int offset = region.getOffset();
        int endOffset = offset + region.getLength();
        for (Rewrite action : this.rewrites) {
            int rwOffset = action.originalFirst.getOffset();
            int rwEndOffset = action.originalLast.getEndOffset();
            if (rwOffset <= offset && offset < rwEndOffset) {
                return true;
            }
            if (rwOffset >= endOffset || endOffset > rwEndOffset) continue;
            return true;
        }
        return false;
    }

    @Override
    public void move(IHiddenRegion insertAt, IHiddenRegion substituteFirst, IHiddenRegion substituteLast) {
        this.checkOriginal(insertAt);
        this.checkOriginal(substituteFirst);
        this.checkOriginal(substituteLast);
        MoveSource source = new MoveSource(substituteFirst, substituteLast);
        MoveTarget target = new MoveTarget(insertAt, source);
        this.rewrites.add(source);
        this.rewrites.add(target);
    }

    @Override
    public void remove(IHiddenRegion first, IHiddenRegion last) {
        this.checkOriginal(first);
        this.checkOriginal(last);
        this.rewrites.add(new Remove(first, last));
    }

    @Override
    public void remove(ISemanticRegion region) {
        this.remove(region.getPreviousHiddenRegion(), region.getNextHiddenRegion());
    }

    @Override
    public void replace(IHiddenRegion originalFirst, IHiddenRegion originalLast, IHiddenRegion modifiedFirst, IHiddenRegion modifiedLast) {
        this.checkOriginal(originalFirst);
        this.checkOriginal(originalLast);
        this.rewrites.add(new Replace1(originalFirst, originalLast, modifiedFirst, modifiedLast));
    }

    @Override
    public void replace(IHiddenRegion originalFirst, IHiddenRegion originalLast, ITextRegionAccess acc) {
        this.checkOriginal(originalFirst);
        this.checkOriginal(originalLast);
        IEObjectRegion substituteRoot = acc.regionForRootEObject();
        IHiddenRegion substituteFirst = substituteRoot.getPreviousHiddenRegion();
        IHiddenRegion substituteLast = substituteRoot.getNextHiddenRegion();
        this.replace(originalFirst, originalLast, substituteFirst, substituteLast);
    }

    @Override
    public void replace(ISemanticRegion region, String newText) {
        Preconditions.checkNotNull(newText);
        this.checkOriginal(region);
        this.changes.put(region, newText);
    }

    @Override
    public ISequenceAcceptor replaceSequence(IHiddenRegion originalFirst, IHiddenRegion originalLast, ISerializationContext ctx, EObject root) {
        this.checkOriginal(originalFirst);
        this.checkOriginal(originalLast);
        TextRegionAccessBuildingSequencer sequenceAcceptor = new TextRegionAccessBuildingSequencer();
        this.rewrites.add(new Replace2(originalFirst, originalLast, sequenceAcceptor));
        return sequenceAcceptor.withRoot(ctx, root);
    }

    public String toString() {
        try {
            StringBasedTextRegionAccessDiff regions = this.create();
            return new TextRegionAccessToString().withRegionAccess(regions).toString();
        }
        catch (Throwable t) {
            return t.getMessage() + "\n" + Throwables.getStackTraceAsString(t);
        }
    }

    protected static class Replace2
    extends Rewrite
    implements Insert {
        private final TextRegionAccessBuildingSequencer sequencer;

        public Replace2(IHiddenRegion originalFirst, IHiddenRegion originalLast, TextRegionAccessBuildingSequencer sequencer) {
            super(originalFirst, originalLast);
            this.sequencer = sequencer;
        }

        @Override
        public IHiddenRegion getInsertFirst() {
            return this.sequencer.getRegionAccess().regionForRootEObject().getPreviousHiddenRegion();
        }

        @Override
        public IHiddenRegion getInsertLast() {
            return this.sequencer.getRegionAccess().regionForRootEObject().getNextHiddenRegion();
        }
    }

    public static abstract class Rewrite
    implements Comparable<Rewrite> {
        protected IHiddenRegion originalFirst;
        protected IHiddenRegion originalLast;

        public Rewrite(IHiddenRegion originalFirst, IHiddenRegion originalLast) {
            this.originalFirst = originalFirst;
            this.originalLast = originalLast;
        }

        public boolean isDiff() {
            return true;
        }

        @Override
        public int compareTo(Rewrite o) {
            return Integer.compare(this.originalFirst.getOffset(), o.originalFirst.getOffset());
        }
    }

    protected static class Preserve
    extends Rewrite
    implements Insert {
        public Preserve(IHiddenRegion first, IHiddenRegion last) {
            super(first, last);
        }

        @Override
        public IHiddenRegion getInsertFirst() {
            return this.originalFirst;
        }

        @Override
        public IHiddenRegion getInsertLast() {
            return this.originalLast;
        }

        @Override
        public boolean isDiff() {
            return false;
        }
    }

    protected static class Replace1
    extends Rewrite
    implements Insert {
        private final IHiddenRegion modifiedFirst;
        private final IHiddenRegion modifiedLast;

        public Replace1(IHiddenRegion originalFirst, IHiddenRegion originalLast, IHiddenRegion modifiedFirst, IHiddenRegion modifiedLast) {
            super(originalFirst, originalLast);
            this.modifiedFirst = modifiedFirst;
            this.modifiedLast = modifiedLast;
        }

        @Override
        public IHiddenRegion getInsertFirst() {
            return this.modifiedFirst;
        }

        @Override
        public IHiddenRegion getInsertLast() {
            return this.modifiedLast;
        }
    }

    protected static class Remove
    extends Rewrite {
        public Remove(IHiddenRegion originalFirst, IHiddenRegion originalLast) {
            super(originalFirst, originalLast);
        }
    }

    protected static class MoveTarget
    extends Rewrite
    implements Insert {
        private final MoveSource source;

        public MoveTarget(IHiddenRegion insertAt, MoveSource source) {
            super(insertAt, insertAt);
            this.source = source;
            this.source.target = this;
        }

        @Override
        public IHiddenRegion getInsertFirst() {
            return this.source.originalFirst;
        }

        @Override
        public IHiddenRegion getInsertLast() {
            return this.source.originalLast;
        }
    }

    protected static class MoveSource
    extends Rewrite {
        private MoveTarget target = null;

        public MoveSource(IHiddenRegion first, IHiddenRegion last) {
            super(first, last);
        }

        public MoveTarget getTarget() {
            return this.target;
        }
    }

    protected static interface Insert {
        public IHiddenRegion getInsertFirst();

        public IHiddenRegion getInsertLast();
    }
}

