/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.mwe;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.xtext.ISetup;
import org.eclipse.xtext.mwe.ISlotEntry;
import org.eclipse.xtext.mwe.ResourceDescriptionsProvider;
import org.eclipse.xtext.mwe.ResourceLoadingSlotEntry;
import org.eclipse.xtext.mwe.ResourceSetBasedSlotEntry;
import org.eclipse.xtext.mwe.SlotEntry;
import org.eclipse.xtext.mwe.Validator;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;

public abstract class AbstractReader
extends AbstractWorkflowComponent2 {
    private Set<ISlotEntry> slotEntries = Sets.newHashSet();
    private List<Injector> injectors = Lists.newArrayList();
    private Provider<ResourceSet> provider = null;
    private Validator validator = new Validator();
    private ResourceDescriptionsProvider resourceDescriptionsProvider = new ResourceDescriptionsProvider();

    public void addLoad(SlotEntry outputSlot) {
        this.slotEntries.add(outputSlot);
    }

    public void addLoadFromResourceSet(ResourceSetBasedSlotEntry outputSlot) {
        this.slotEntries.add(outputSlot);
    }

    public void addLoadResource(ResourceLoadingSlotEntry outputSlot) {
        this.slotEntries.add(outputSlot);
    }

    protected Set<ISlotEntry> getSlotEntries() {
        return this.slotEntries;
    }

    public void addRegister(ISetup setup) {
        this.injectors.add(setup.createInjectorAndDoEMFRegistration());
    }

    protected List<Injector> getInjectors() {
        return this.injectors;
    }

    public void setResourceSetProvider(Provider<ResourceSet> provider) {
        this.provider = provider;
    }

    protected Provider<ResourceSet> getResourceSetProvider() {
        return this.provider;
    }

    public void setValidate(Validator validator) {
        this.validator = validator;
    }

    protected Validator getValidator() {
        return this.validator;
    }

    protected void checkConfigurationInternal(Issues issues) {
        super.checkConfigurationInternal(issues);
        if (this.injectors.isEmpty()) {
            issues.addError((WorkflowComponent)this, "No setup has been registered (example: register=foo.bar.MyLanguageStandaloneSetup{})");
        }
        if (this.slotEntries.isEmpty()) {
            issues.addError((WorkflowComponent)this, "No slot entries configured (example: load={slot='mySlot' type='Type'}).");
        }
    }

    protected void addModelElementsToContext(WorkflowContext ctx, ResourceSet resourceSet) {
        IResourceDescriptions descriptions = this.resourceDescriptionsProvider.get(resourceSet);
        for (ISlotEntry entries : this.slotEntries) {
            entries.put(ctx, descriptions, resourceSet);
        }
    }

    protected ResourceSet getResourceSet() {
        if (this.provider != null) {
            return this.provider.get();
        }
        if (!this.injectors.isEmpty()) {
            ResourceSet instance = this.injectors.get(0).getInstance(ResourceSet.class);
            return instance;
        }
        return new ResourceSetImpl();
    }

    public void setResourceDescriptionsProvider(ResourceDescriptionsProvider resourceDescriptionsProvider) {
        this.resourceDescriptionsProvider = resourceDescriptionsProvider;
    }

    protected ResourceDescriptionsProvider getResourceDescriptionsProvider() {
        return this.resourceDescriptionsProvider;
    }

    protected IResourceServiceProvider.Registry getRegistry() {
        return IResourceServiceProvider.Registry.INSTANCE;
    }
}

