/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;

@Beta
public class LookAheadInfo {
    private final ICompositeNode rootNode;

    public LookAheadInfo(ICompositeNode rootNode) {
        Preconditions.checkArgument(rootNode.getRootNode() == rootNode);
        this.rootNode = rootNode;
    }

    public void checkConsistency() throws InconsistentLookAheadException {
        AtomicInteger currentLookAhead = new AtomicInteger();
        for (INode node : this.rootNode.getAsTreeIterable()) {
            this.checkConsistency(node, currentLookAhead);
        }
    }

    protected void checkConsistency(INode node, AtomicInteger currentLookAhead) {
        if (node instanceof ICompositeNode) {
            this.checkConsistency((ICompositeNode)node, currentLookAhead);
        } else {
            this.checkConsistency((ILeafNode)node, currentLookAhead);
        }
    }

    protected void checkConsistency(ICompositeNode node, AtomicInteger currentLookAhead) {
        ICompositeNode firstChild;
        int nodeLookAhead = node.getLookAhead();
        if (node.getGrammarElement() instanceof Action && (firstChild = (ICompositeNode)node.getFirstChild()).getLookAhead() != nodeLookAhead) {
            throw new InconsistentLookAheadException(String.format("Action nodes must have the lookahead of their first child. Expected %d but was %d at offset %d (%s)", nodeLookAhead, firstChild.getLookAhead(), node.getTotalOffset(), node.getText()));
        }
        if (nodeLookAhead > currentLookAhead.get()) {
            currentLookAhead.set(nodeLookAhead);
        } else if (nodeLookAhead < currentLookAhead.get()) {
            throw new InconsistentLookAheadException(String.format("Expected at least %d but found %d at offset %d (%s)", currentLookAhead.get(), nodeLookAhead, node.getTotalOffset(), node.getText()));
        }
    }

    protected void checkConsistency(ILeafNode node, AtomicInteger currentLookAhead) {
        if (!node.isHidden()) {
            currentLookAhead.updateAndGet(old -> old > 0 ? old - 1 : old);
        }
    }

    public static class InconsistentLookAheadException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InconsistentLookAheadException(String message, Throwable cause) {
            super(message, cause);
        }

        public InconsistentLookAheadException(String message) {
            super(message);
        }
    }
}

