/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.grammaranalysis.IGrammarNFAProvider;
import org.eclipse.xtext.grammaranalysis.impl.AbstractNFAState;
import org.eclipse.xtext.parsetree.reconstr.impl.TreeConstTransition;

public class TreeConstState
extends AbstractNFAState<TreeConstState, TreeConstTransition> {
    protected Map<TreeConstState, Integer> distances;
    protected List<TreeConstTransition> enabledOutgoing;
    protected List<TreeConstTransition> enabledOutgoingAfterReturn;
    protected Map<TreeConstState, Integer> endDistances;
    protected Status status = Status.UNKNOWN;
    protected Set<TypeRef> types;
    protected boolean typesDirty = false;

    public TreeConstState(AbstractElement element, IGrammarNFAProvider.NFABuilder<TreeConstState, TreeConstTransition> builder) {
        super(element, builder);
    }

    protected void calculateDistances(TreeConstState root, int dist) {
        if (this.distances == null) {
            this.distances = Maps.newLinkedHashMap();
        } else if (this.distances.containsKey(root) && this.distances.get(root) <= dist) {
            return;
        }
        this.distances.put(root, dist);
        if (this.isConsumingElement()) {
            root = this;
            dist = 0;
        }
        for (TreeConstTransition t : Iterables.concat(this.getOutgoing(), this.getOutgoingAfterReturn())) {
            if (t.isRuleCall()) continue;
            t.getTarget().calculateDistances(root, dist + 1);
        }
        if (this.isEndState()) {
            this.getEndDistances().put(root, dist + 1);
        }
    }

    protected Status checkForAmbigiousPaths(Set<TreeConstState> visited) {
        if (this.getStatusInternal() != Status.ENABLED || visited.contains(this)) {
            return this.getStatusInternal();
        }
        visited.add(this);
        boolean vEnd = false;
        boolean vTrans = false;
        if (this.isEndState() && this.isTransitionEnabledTo(this.getEndDistances())) {
            this.consume(this.getEndDistances());
            vEnd = true;
        }
        for (TreeConstTransition t : Iterables.concat(this.getOutgoing(), this.getOutgoingAfterReturn())) {
            if (t.isRuleCall() || t.getStatus() != Status.ENABLED) continue;
            if (t.getTarget().checkForAmbigiousPaths(visited) != Status.ENABLED || !this.isTransitionEnabledTo(t.getTarget().distances)) {
                t.setStatus(Status.AMBIGIOUS);
                continue;
            }
            this.consume(t.getTarget().distances);
            vTrans = true;
        }
        return !vEnd && !vTrans ? (this.status = Status.AMBIGIOUS) : this.getStatusInternal();
    }

    protected Status checkForDetoursAndLoops(Set<TreeConstState> visited) {
        if (visited.contains(this)) {
            return this.getStatusInternal();
        }
        visited.add(this);
        boolean vEnd = false;
        boolean vTrans = false;
        if (this.isEndState() && this.isTransitionEnabledTo(this.getEndDistances())) {
            vEnd = true;
        }
        for (TreeConstTransition t : Iterables.concat(this.getOutgoing(), this.getOutgoingAfterReturn())) {
            if (t.isRuleCall()) continue;
            if (t.getTarget().checkForDetoursAndLoops(visited) != Status.ENABLED || !this.isTransitionEnabledTo(t.getTarget().distances)) {
                t.setStatus(Status.DETOUR_OR_LOOP);
                continue;
            }
            t.setStatus(Status.ENABLED);
            vTrans = true;
        }
        return !vEnd && !vTrans ? (this.status = Status.DETOUR_OR_LOOP) : this.getStatusInternal();
    }

    protected void consume(Map<TreeConstState, Integer> dist) {
        if (this.isConsumingElement()) {
            dist.remove(this);
        } else {
            for (Map.Entry<TreeConstState, Integer> e : this.distances.entrySet()) {
                Integer i = dist.get(e.getKey());
                if (i == null || i <= e.getValue()) continue;
                dist.remove(e.getKey());
            }
        }
    }

    protected void discardMisleadingDistances(Set<TreeConstState> visited) {
        if (!visited.add(this)) {
            return;
        }
        for (TreeConstTransition t : Iterables.concat(this.getOutgoing(), this.getOutgoingAfterReturn())) {
            if (t.isRuleCall()) continue;
            t.getTarget().discardMisleadingDistances(visited);
        }
        if (this.isConsumingElement() || this.isEndState()) {
            return;
        }
        LinkedHashSet<TreeConstState> doNotRemove = Sets.newLinkedHashSet();
        for (TreeConstTransition t : Iterables.concat(this.getOutgoing(), this.getOutgoingAfterReturn())) {
            if (!t.isRuleCall()) {
                TreeConstState target = t.getTarget();
                Map<TreeConstState, Integer> targetDistances = target.distances;
                for (Map.Entry<TreeConstState, Integer> entry : targetDistances.entrySet()) {
                    Integer targetDistance = entry.getValue();
                    Integer ownDistance = this.distances.get(entry.getKey());
                    if (ownDistance != null && targetDistance < ownDistance) continue;
                    doNotRemove.add(entry.getKey());
                }
                continue;
            }
            doNotRemove.addAll(t.getTarget().distances.keySet());
        }
        this.distances.keySet().retainAll(doNotRemove);
    }

    public List<TreeConstTransition> getEnabledOutgoing() {
        if (this.enabledOutgoing == null) {
            this.enabledOutgoing = new ArrayList<TreeConstTransition>();
            for (TreeConstTransition t : this.getOutgoing()) {
                if (t.isDisabled()) continue;
                this.enabledOutgoing.add(t);
            }
        }
        return this.enabledOutgoing;
    }

    public List<TreeConstTransition> getEnabledOutgoingAfterReturn() {
        if (this.enabledOutgoingAfterReturn == null) {
            this.enabledOutgoingAfterReturn = new ArrayList<TreeConstTransition>();
            for (TreeConstTransition t : this.getOutgoingAfterReturn()) {
                if (t.isDisabled()) continue;
                this.enabledOutgoingAfterReturn.add(t);
            }
        }
        return this.enabledOutgoingAfterReturn;
    }

    protected Map<TreeConstState, Integer> getEndDistances() {
        AbstractElement rootEle = GrammarUtil.containingRule(this.element).getAlternatives();
        TreeConstState root = (TreeConstState)this.builder.getState(rootEle);
        if (root.endDistances == null) {
            root.endDistances = Maps.newLinkedHashMap();
        }
        return root.endDistances;
    }

    protected Status getStatusInternal() {
        if (this.status == Status.UNKNOWN) {
            this.status = this.isEndState() || this.getOutgoing().size() > 0 || this.getOutgoingAfterReturn().size() > 0 ? Status.ENABLED : Status.ORPHAN;
        }
        return this.status;
    }

    public Status getStatus() {
        if (this.distances == null) {
            AbstractElement rootEle = GrammarUtil.containingRule(this.element).getAlternatives();
            ((TreeConstState)this.builder.getState(rootEle)).initStatus();
        }
        return this.getStatusInternal();
    }

    public Set<TypeRef> getTypes() {
        if (this.types == null) {
            this.getStatus();
            LinkedHashMap<TreeConstState, List<TreeConstState>> map = Maps.newLinkedHashMap();
            LinkedHashSet<TreeConstState> endStates = Sets.newLinkedHashSet();
            this.initTypes(map, endStates);
            for (TreeConstState s2 : endStates) {
                s2.populateTypes(map);
            }
        }
        return this.types;
    }

    public Collection<TypeRef> getTypesToCheck() {
        LinkedHashMap<EClassifier, TypeRef> localTypes = Maps.newLinkedHashMap();
        for (TypeRef t : this.sortTypes(this.getTypes())) {
            if (t == null) continue;
            localTypes.put(t.getClassifier(), t);
        }
        List incomming = this.getIncommingWithoutRuleCalls();
        if (incomming.isEmpty()) {
            return localTypes.values();
        }
        for (TreeConstTransition t : incomming) {
            for (TypeRef r : ((TreeConstState)t.getSource()).getTypes()) {
                if (r == null || localTypes.containsKey(r.getClassifier())) continue;
                return localTypes.values();
            }
        }
        return Collections.emptyList();
    }

    protected void initStatus() {
        if (this.distances == null) {
            this.calculateDistances(this, 1);
            this.discardMisleadingDistances(new LinkedHashSet<TreeConstState>());
            this.checkForDetoursAndLoops(new LinkedHashSet<TreeConstState>());
            this.checkForAmbigiousPaths(new LinkedHashSet<TreeConstState>());
        }
    }

    protected void initTypes(Map<TreeConstState, List<TreeConstState>> map, Set<TreeConstState> endStates) {
        if (this.types != null) {
            endStates.add(this);
        } else {
            this.types = Sets.newLinkedHashSet();
            this.typesDirty = true;
            for (TreeConstTransition t : Iterables.concat(this.getOutgoing(), this.getOutgoingAfterReturn())) {
                if (t.isDisabled() || t.isRuleCall() && this.getGrammarElement() instanceof Assignment) continue;
                t.getTarget().initTypes(map, endStates);
                List<TreeConstState> orgins = map.get(t.getTarget());
                if (orgins == null) {
                    orgins = Lists.newArrayList();
                    map.put(t.getTarget(), orgins);
                }
                orgins.add(this);
            }
            if (this.element instanceof Action) {
                this.types.add(((Action)this.element).getType());
            }
            if (this.isEndState()) {
                endStates.add(this);
                if (this.element instanceof Assignment) {
                    this.types.add(GrammarUtil.containingRule(this.element).getType());
                } else if (!this.isConsumingElement()) {
                    this.types.add(null);
                }
            }
        }
    }

    protected boolean isConsumingElement() {
        return this.element instanceof Assignment || GrammarUtil.isEObjectRuleCall(this.element) || this.element instanceof Action;
    }

    public boolean isDisabled() {
        return this.getStatus() != Status.ENABLED;
    }

    protected boolean isTransitionEnabledTo(Map<TreeConstState, Integer> dist) {
        if (this.isConsumingElement()) {
            return true;
        }
        for (Map.Entry<TreeConstState, Integer> e : this.distances.entrySet()) {
            Integer i = dist.get(e.getKey());
            if (i == null || i <= e.getValue()) continue;
            return true;
        }
        return false;
    }

    protected void populateTypes(Map<TreeConstState, List<TreeConstState>> map) {
        this.typesDirty = false;
        List<TreeConstState> origins = map.get(this);
        if (origins != null) {
            for (TreeConstState origin : origins) {
                Set<TypeRef> t = this.types;
                if (origin.getGrammarElement() instanceof Action && ((Action)origin.getGrammarElement()).getFeature() != null) {
                    t = Collections.emptySet();
                } else if (t.contains(null) && origin.isConsumingElement()) {
                    t = Sets.newLinkedHashSet(t);
                    t.remove(null);
                    if (origin.getGrammarElement() instanceof Assignment) {
                        t.add(GrammarUtil.containingRule(origin.getGrammarElement()).getType());
                    }
                }
                if (!origin.getTypes().addAll(t) && !origin.typesDirty) continue;
                origin.populateTypes(map);
            }
        }
    }

    protected List<TypeRef> sortTypes(Collection<TypeRef> types) {
        ArrayList<TypeRef> result = Lists.newArrayList(types);
        Collections.sort(result, new Comparator<TypeRef>(){

            @Override
            public int compare(TypeRef o1, TypeRef o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.getClassifier().getName().compareTo(o2.getClassifier().getName());
            }
        });
        return result;
    }

    @Override
    public String toString() {
        return "";
    }

    static enum Status {
        AMBIGIOUS,
        DETOUR_OR_LOOP,
        ENABLED,
        ORPHAN,
        UNKNOWN;

    }
}

