/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.ILinker;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.resource.XtextSyntaxDiagnosticWithRange;
import org.eclipse.xtext.resource.impl.ListBasedDiagnosticConsumer;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;

public class XtextResource
extends ResourceImpl {
    public static final String OPTION_RESOLVE_ALL = XtextResource.class.getName() + ".RESOLVE_ALL";
    @Deprecated
    public static final String OPTION_FORMAT = XtextResource.class.getName() + ".FORMAT";
    @Deprecated
    public static final String OPTION_SERIALIZATION_OPTIONS = XtextResource.class.getName() + ".SERIALIZATION_OPTIONS";
    public static final String OPTION_ENCODING = XtextResource.class.getName() + ".DEFAULT_ENCODING";
    private boolean validationDisabled;
    protected volatile boolean isUpdating = false;
    private IParser parser;
    private ParserRule entryPoint;
    @Inject
    private ILinker linker;
    @Inject
    private IFragmentProvider fragmentProvider;
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    protected OperationCanceledManager operationCanceledManager;
    private long modificationStamp = Integer.MIN_VALUE;
    private IFragmentProvider.Fallback fragmentProviderFallback = new IFragmentProvider.Fallback(){

        @Override
        public String getFragment(EObject obj) {
            return XtextResource.super.getURIFragment(obj);
        }

        @Override
        public EObject getEObject(String fragment) {
            return XtextResource.super.getEObject(fragment);
        }
    };
    @Inject
    private ISerializer serializer;
    @Inject
    private IReferableElementsUnloader unloader;
    @Inject
    private IResourceServiceProvider resourceServiceProvider;
    @Inject
    private IConcreteSyntaxValidator validator;
    @Inject
    private IResourceScopeCache cache = IResourceScopeCache.NullImpl.INSTANCE;
    @Inject
    private IEncodingProvider encodingProvider;
    private String encoding;
    private IParseResult parseResult;

    public IResourceServiceProvider getResourceServiceProvider() {
        return this.resourceServiceProvider;
    }

    public void setResourceServiceProvider(IResourceServiceProvider resourceServiceProvider) {
        this.resourceServiceProvider = resourceServiceProvider;
    }

    @Inject
    protected void setInjectedParser(IParser parser) {
        this.parser = parser;
    }

    public XtextResource(URI uri) {
        super(uri);
    }

    public XtextResource() {
    }

    public IParseResult getParseResult() {
        return this.parseResult;
    }

    @Override
    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        this.setEncodingFromOptions(options);
        IParseResult result = this.entryPoint == null ? this.getParser().parse(this.createReader(inputStream)) : this.getParser().parse(this.entryPoint, this.createReader(inputStream));
        this.updateInternalState(this.parseResult, result);
    }

    protected Reader createReader(InputStream inputStream) throws IOException {
        if (inputStream instanceof LazyStringInputStream) {
            return new StringReader(((LazyStringInputStream)inputStream).getString());
        }
        return new InputStreamReader((InputStream)new BufferedInputStream(inputStream), this.getEncoding());
    }

    protected void setEncodingFromOptions(Map<?, ?> options) {
        Object encodingOption;
        if (options != null && (encodingOption = options.get(OPTION_ENCODING)) instanceof String) {
            this.encoding = (String)encodingOption;
        }
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.encodingProvider.getEncoding(this.getURI());
        }
        return this.encoding;
    }

    public void reparse(String newContent) throws IOException {
        try {
            this.isUpdating = true;
            this.clearInternalState();
            this.doLoad(new LazyStringInputStream(newContent, this.getEncoding()), null);
            this.setModified(false);
        }
        finally {
            this.isUpdating = false;
        }
    }

    protected void reattachModificationTracker(EObject element) {
        if (this.isTrackingModification() && element != null) {
            if (!element.eAdapters().contains(this.modificationTrackingAdapter)) {
                element.eAdapters().add(this.modificationTrackingAdapter);
            }
            TreeIterator<EObject> i = this.getAllProperContents(element);
            while (i.hasNext()) {
                EObject eObject = (EObject)i.next();
                if (eObject.eAdapters().contains(this.modificationTrackingAdapter)) continue;
                eObject.eAdapters().add(this.modificationTrackingAdapter);
            }
        }
    }

    @Override
    protected void doUnload() {
        super.doUnload();
        this.parseResult = null;
    }

    public void relink() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("You can't update an unloaded resource.");
        }
        try {
            this.isUpdating = true;
            this.updateInternalState(this.parseResult, this.parseResult);
        }
        finally {
            this.isUpdating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int offset, int replacedTextLength, String newText) {
        if (!this.isLoaded()) {
            throw new IllegalStateException("You can't update an unloaded resource.");
        }
        try {
            IParseResult newParseResult;
            this.isUpdating = true;
            IParseResult oldParseResult = this.parseResult;
            ReplaceRegion replaceRegion = new ReplaceRegion(new TextRegion(offset, replacedTextLength), newText);
            ParserRule oldEntryPoint = NodeModelUtils.getEntryParserRule(oldParseResult.getRootNode());
            if (this.entryPoint == null || this.entryPoint == oldEntryPoint) {
                newParseResult = this.getParser().reparse(oldParseResult, replaceRegion);
            } else {
                StringBuilder builder = new StringBuilder(oldParseResult.getRootNode().getText());
                replaceRegion.applyTo(builder);
                newParseResult = this.getParser().parse(this.entryPoint, new StringReader(builder.toString()));
            }
            this.updateInternalState(oldParseResult, newParseResult);
        }
        finally {
            this.isUpdating = false;
        }
    }

    protected void updateInternalState(IParseResult oldParseResult, IParseResult newParseResult) {
        EObject oldRootAstElement;
        if (oldParseResult != null && oldParseResult.getRootASTElement() != null && oldParseResult.getRootASTElement() != newParseResult.getRootASTElement() && (oldRootAstElement = oldParseResult.getRootASTElement()) != newParseResult.getRootASTElement()) {
            this.unload(oldRootAstElement);
            this.getContents().remove(oldRootAstElement);
        }
        this.updateInternalState(newParseResult);
    }

    protected void updateInternalState(IParseResult newParseResult) {
        this.parseResult = newParseResult;
        EObject newRootASTElement = this.parseResult.getRootASTElement();
        if (newRootASTElement != null && !this.containsRootElement(newRootASTElement)) {
            this.getContents().add(0, newRootASTElement);
        }
        this.reattachModificationTracker(newRootASTElement);
        this.clearErrorsAndWarnings();
        this.addSyntaxErrors();
        this.doLinking();
    }

    boolean containsRootElement(EObject newRootASTElement) {
        return this.getContents().contains(newRootASTElement);
    }

    protected void clearErrorsAndWarnings() {
        this.getWarnings().clear();
        this.getErrors().clear();
    }

    protected void addSyntaxErrors() {
        this.getErrors().addAll(this.createDiagnostics(this.parseResult));
    }

    protected void unload(EObject oldRootObject) {
        if (this.unloader != null) {
            this.unloader.unloadRoot(oldRootObject);
        }
    }

    protected void clearInternalState() {
        for (EObject content : this.getContents()) {
            this.unload(content);
        }
        this.getContents().clear();
        this.clearErrorsAndWarnings();
        this.parseResult = null;
    }

    protected void doLinking() {
        if (this.parseResult == null || this.parseResult.getRootASTElement() == null) {
            return;
        }
        ListBasedDiagnosticConsumer consumer = new ListBasedDiagnosticConsumer();
        this.linker.linkModel(this.parseResult.getRootASTElement(), consumer);
        if (!this.validationDisabled) {
            this.getErrors().addAll(consumer.getResult(Severity.ERROR));
            this.getWarnings().addAll(consumer.getResult(Severity.WARNING));
        }
    }

    @Override
    public EObject getEObject(String uriFragment) {
        return this.basicGetEObject(uriFragment);
    }

    protected EObject basicGetEObject(String uriFragment) {
        if (this.fragmentProvider != null) {
            EObject result = this.fragmentProvider.getEObject(this, uriFragment, this.fragmentProviderFallback);
            return result;
        }
        EObject result = super.getEObject(uriFragment);
        return result;
    }

    @Override
    public String getURIFragment(EObject object) {
        if (this.fragmentProvider != null) {
            String result = this.fragmentProvider.getFragment(object, this.fragmentProviderFallback);
            return result;
        }
        String result = XtextResource.super.getURIFragment(object);
        return result;
    }

    @Override
    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        if (this.getContents().isEmpty()) {
            throw new IllegalStateException("The Xtext resource must contain at least one element.");
        }
        SaveOptions saveOptions = SaveOptions.getOptions(options);
        this.setEncodingFromOptions(options);
        this.serializer.serialize((EObject)this.getContents().get(0), new OutputStreamWriter(outputStream, this.getEncoding()), saveOptions);
    }

    private List<Resource.Diagnostic> createDiagnostics(IParseResult parseResult) {
        if (this.validationDisabled) {
            return Collections.emptyList();
        }
        ArrayList<Resource.Diagnostic> diagnostics = new ArrayList<Resource.Diagnostic>();
        for (INode error : parseResult.getSyntaxErrors()) {
            this.addSyntaxDiagnostic(diagnostics, error);
        }
        return diagnostics;
    }

    protected void addSyntaxDiagnostic(List<Resource.Diagnostic> diagnostics, INode error) {
        String[] issueData;
        SyntaxErrorMessage syntaxErrorMessage = error.getSyntaxErrorMessage();
        if ("org.eclipse.xtext.diagnostics.Diagnostic.Syntax.Range".equals(syntaxErrorMessage.getIssueCode()) && (issueData = syntaxErrorMessage.getIssueData()).length == 1) {
            String data = issueData[0];
            int colon = data.indexOf(58);
            diagnostics.add(new XtextSyntaxDiagnosticWithRange(error, Integer.valueOf(data.substring(0, colon)), Integer.valueOf(data.substring(colon + 1)), null));
            return;
        }
        diagnostics.add(new XtextSyntaxDiagnostic(error));
    }

    public IParser getParser() {
        return this.parser;
    }

    public void setParser(IParser parser) {
        this.parser = parser;
    }

    public ParserRule getEntryPoint() {
        if (this.entryPoint == null && this.parseResult != null) {
            this.entryPoint = NodeModelUtils.getEntryParserRule(this.parseResult.getRootNode());
        }
        return this.entryPoint;
    }

    public void setEntryPoint(ParserRule parserRule) {
        this.entryPoint = parserRule;
    }

    public IConcreteSyntaxValidator getConcreteSyntaxValidator() {
        return this.validator;
    }

    public List<Diagnostic> validateConcreteSyntax() {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        IConcreteSyntaxValidator.DiagnosticListAcceptor acceptor = new IConcreteSyntaxValidator.DiagnosticListAcceptor(diagnostics);
        for (EObject obj : this.getContents()) {
            this.validator.validateRecursive(obj, acceptor, new HashMap<Object, Object>());
        }
        return diagnostics;
    }

    public ILinker getLinker() {
        return this.linker;
    }

    public void setLinker(ILinker linker) {
        this.linker = linker;
    }

    public IFragmentProvider getFragmentProvider() {
        return this.fragmentProvider;
    }

    public void setFragmentProvider(IFragmentProvider fragmentProvider) {
        this.fragmentProvider = fragmentProvider;
    }

    public ISerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(ISerializer serializer) {
        this.serializer = serializer;
    }

    public void setParseResult(IParseResult parseResult) {
        this.parseResult = parseResult;
    }

    public boolean isValidationDisabled() {
        return this.validationDisabled;
    }

    public void setValidationDisabled(boolean validationDisabled) {
        this.validationDisabled = validationDisabled;
        if (validationDisabled) {
            this.clearErrorsAndWarnings();
        }
    }

    public void setUnloader(IReferableElementsUnloader unloader) {
        this.unloader = unloader;
    }

    public IReferableElementsUnloader getUnloader() {
        return this.unloader;
    }

    public IResourceScopeCache getCache() {
        return this.cache;
    }

    public void setCache(IResourceScopeCache cache) {
        this.cache = cache;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public void setLanguageName(String languageName) {
        this.languageName = languageName;
    }

    public void setModificationStamp(long documentModificationStamp) {
        this.modificationStamp = documentModificationStamp;
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }
}

