/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.LiveShadowedChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Beta
public class LiveShadowedChunkedContainer
implements IContainer {
    private final LiveShadowedChunkedResourceDescriptions descriptions;
    private final String containerName;
    private IProjectConfig projectConfig;
    private boolean isProjectConfigSet = false;

    public LiveShadowedChunkedContainer(LiveShadowedChunkedResourceDescriptions descriptions, String containerName) {
        this.descriptions = descriptions;
        this.containerName = containerName;
    }

    protected ChunkedResourceDescriptions getChunkedResourceDescriptions() {
        return (ChunkedResourceDescriptions)this.descriptions.getGlobalDescriptions();
    }

    protected IProjectConfig getProjectConfig() {
        if (!this.isProjectConfigSet) {
            this.projectConfig = this.descriptions.getWorkspaceConfig() == null ? null : this.descriptions.getWorkspaceConfig().findProjectByName(this.containerName);
            this.isProjectConfigSet = true;
        }
        return this.projectConfig;
    }

    protected ResourceDescriptionsData getChunk() {
        ResourceDescriptionsData container = this.getChunkedResourceDescriptions().getContainer(this.containerName);
        if (container != null) {
            return container;
        }
        return new ResourceDescriptionsData(Collections.emptyList());
    }

    protected Iterable<IResourceDescription> getContainedLocalDescriptions() {
        return Iterables.filter(this.descriptions.getLocalDescriptions().getAllResourceDescriptions(), it -> this.isContained(it.getURI()));
    }

    protected boolean isContained(URI uri) {
        return this.getChunk().getResourceDescription(uri) != null || this.getProjectConfig() != null && this.getProjectConfig().findSourceFolderContaining(uri) != null;
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        return this.isContained(uri) ? this.descriptions.getResourceDescription(uri) : null;
    }

    @Override
    public int getResourceDescriptionCount() {
        return Iterables.size(this.getResourceDescriptions());
    }

    @Override
    public Iterable<IResourceDescription> getResourceDescriptions() {
        Set<URI> localURIs = this.getExistingOrRenamedResourceURIs();
        return Iterables.concat(this.getContainedLocalDescriptions(), Iterables.filter(this.getChunk().getAllResourceDescriptions(), it -> !localURIs.contains(it.getURI())));
    }

    @Override
    public boolean hasResourceDescription(URI uri) {
        return this.getChunk().getResourceDescription(uri) != null;
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects() {
        Set<URI> localURIs = this.getExistingOrRenamedResourceURIs();
        return Iterables.concat(Iterables.concat(IterableExtensions.map(this.getContainedLocalDescriptions(), it -> it.getExportedObjects())), Iterables.filter(this.getChunk().getExportedObjects(), it -> !localURIs.contains(it.getEObjectURI().trimFragment())));
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
        Set<URI> localURIs = this.getExistingOrRenamedResourceURIs();
        return Iterables.concat(Iterables.concat(IterableExtensions.map(this.getContainedLocalDescriptions(), it -> it.getExportedObjects(type, name, ignoreCase))), Iterables.filter(this.getChunk().getExportedObjects(type, name, ignoreCase), it -> !localURIs.contains(it.getEObjectURI().trimFragment())));
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        Set<URI> localURIs = this.getExistingOrRenamedResourceURIs();
        return Iterables.concat(Iterables.concat(IterableExtensions.map(this.getContainedLocalDescriptions(), it -> it.getExportedObjectsByObject(object))), Iterables.filter(this.getChunk().getExportedObjectsByObject(object), it -> !localURIs.contains(it.getEObjectURI().trimFragment())));
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        Set<URI> localURIs = this.getExistingOrRenamedResourceURIs();
        return Iterables.concat(Iterables.concat(IterableExtensions.map(this.getContainedLocalDescriptions(), it -> it.getExportedObjectsByType(type))), Iterables.filter(this.getChunk().getExportedObjectsByType(type), it -> !localURIs.contains(it.getEObjectURI().trimFragment())));
    }

    @Override
    public boolean isEmpty() {
        return IterableExtensions.isEmpty(this.getContainedLocalDescriptions()) && this.getChunk().isEmpty();
    }

    protected Set<URI> getExistingOrRenamedResourceURIs() {
        ResourceSet resourceSet = this.descriptions.getResourceSet();
        if (resourceSet instanceof ResourceSetImpl) {
            return ((ResourceSetImpl)resourceSet).getURIResourceMap().keySet();
        }
        throw new IllegalStateException("ResourceSet is not a an instance of ResourceSetImpl.");
    }
}

