/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.ResourceStorageLoadable;
import org.eclipse.xtext.resource.persistence.ResourceStorageProviderAdapter;
import org.eclipse.xtext.resource.persistence.ResourceStorageWritable;
import org.eclipse.xtext.resource.persistence.SourceLevelURIsAdapter;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ResourceStorageFacade
implements IResourceStorageFacade {
    private static final Logger LOG = Logger.getLogger(ResourceStorageFacade.class);
    @Inject
    private IContextualOutputConfigurationProvider outputConfigurationProvider;
    @Inject
    private Provider<AbstractFileSystemAccess2> fileSystemAccessProvider;
    private boolean storeNodeModel = false;

    @Override
    public boolean shouldLoadFromStorage(StorageAwareResource resource) {
        SourceLevelURIsAdapter adapter = SourceLevelURIsAdapter.findInstalledAdapter(resource.getResourceSet());
        if (adapter == null || adapter.getSourceLevelURIs().contains(resource.getURI())) {
            return false;
        }
        return this.doesStorageExist(resource);
    }

    @Override
    public ResourceStorageLoadable getOrCreateResourceStorageLoadable(StorageAwareResource resource) {
        try {
            ResourceStorageLoadable loadable;
            ResourceSet resourceSet = resource.getResourceSet();
            ResourceStorageProviderAdapter stateProvider = this.getResourceStorageProviderAdapter(resourceSet);
            if (stateProvider != null && (loadable = stateProvider.getResourceStorageLoadable(resource)) != null) {
                return loadable;
            }
            if (resourceSet.getURIConverter().exists(this.getBinaryStorageURI(resource.getURI()), Collections.emptyMap())) {
                return this.createResourceStorageLoadable(resourceSet.getURIConverter().createInputStream(this.getBinaryStorageURI(resource.getURI())));
            }
            return this.createResourceStorageLoadable(this.getFileSystemAccess(resource).readBinaryFile(this.computeOutputPath(resource)));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    protected boolean doesStorageExist(StorageAwareResource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        ResourceStorageProviderAdapter stateProvider = this.getResourceStorageProviderAdapter(resourceSet);
        if (stateProvider != null && stateProvider.getResourceStorageLoadable(resource) != null) {
            return true;
        }
        if (resourceSet.getURIConverter().exists(this.getBinaryStorageURI(resource.getURI()), Collections.emptyMap())) {
            return true;
        }
        if (resource.getURI().isArchive()) {
            return false;
        }
        URI uri = this.getFileSystemAccess(resource).getURI(this.computeOutputPath(resource));
        return uri != null && resourceSet.getURIConverter().exists(uri, null);
    }

    @Override
    public void saveResource(StorageAwareResource resource, IFileSystemAccessExtension3 fsa) {
        MyByteArrayOutputStream bout = new MyByteArrayOutputStream();
        try {
            this.createResourceStorageWritable(bout).writeResource(resource);
        }
        catch (IOException e) {
            LOG.warn("Cannot write storage for " + resource.getURI(), e);
            return;
        }
        fsa.generateFile(this.computeOutputPath(resource), new ByteArrayInputStream(bout.toByteArray(), 0, bout.length()));
    }

    @Override
    public ResourceStorageLoadable createResourceStorageLoadable(InputStream in) {
        return new ResourceStorageLoadable(in, this.isStoreNodeModel());
    }

    @Override
    public ResourceStorageWritable createResourceStorageWritable(OutputStream out) {
        return new ResourceStorageWritable(out, this.isStoreNodeModel());
    }

    protected ResourceStorageProviderAdapter getResourceStorageProviderAdapter(ResourceSet resourceSet) {
        return (ResourceStorageProviderAdapter)EcoreUtil.getExistingAdapter(resourceSet, ResourceStorageProviderAdapter.class);
    }

    protected AbstractFileSystemAccess2 getFileSystemAccess(StorageAwareResource resource) {
        AbstractFileSystemAccess2 fsa = this.fileSystemAccessProvider.get();
        fsa.setContext(resource);
        fsa.setOutputConfigurations(IterableExtensions.toMap(this.outputConfigurationProvider.getOutputConfigurations(resource), it -> it.getName()));
        return fsa;
    }

    protected String computeOutputPath(StorageAwareResource resource) {
        return this.getBinaryStorageURI(resource.getURI()).deresolve(this.getSourceContainerURI(resource), false, false, true).path();
    }

    protected URI getSourceContainerURI(StorageAwareResource resource) {
        return resource.getURI().trimSegments(1).appendSegment("");
    }

    @Override
    public boolean hasStorageFor(URI uri) {
        return new ExtensibleURIConverterImpl().exists(this.getBinaryStorageURI(uri), Collections.emptyMap());
    }

    protected URI getBinaryStorageURI(URI sourceURI) {
        return sourceURI.trimSegments(1).appendSegment("." + sourceURI.lastSegment() + "bin");
    }

    public boolean isStoreNodeModel() {
        return this.storeNodeModel;
    }

    public void setStoreNodeModel(boolean storeNodeModel) {
        this.storeNodeModel = storeNodeModel;
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private MyByteArrayOutputStream() {
        }

        @Override
        public synchronized byte[] toByteArray() {
            return this.buf;
        }

        public int length() {
            return this.count;
        }
    }
}

