/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.PortableURIs;
import org.eclipse.xtext.resource.persistence.ResourceStorageLoadable;
import org.eclipse.xtext.util.internal.Stopwatches;

public class StorageAwareResource
extends LazyLinkingResource {
    public static final String UNRESOLVABLE_FRAGMENT = "UNRESOLVABLE";
    private static final Logger LOG = Logger.getLogger(StorageAwareResource.class);
    @Inject(optional=true)
    private IResourceStorageFacade resourceStorageFacade;
    @Inject
    private PortableURIs portableURIs;
    private boolean isLoadedFromStorage = false;
    private IResourceDescription resourceDescription = null;

    @Override
    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded && !this.isLoading && this.resourceStorageFacade != null && this.resourceStorageFacade.shouldLoadFromStorage(this)) {
            LOG.debug("Loading " + this.getURI() + " from storage.");
            try {
                ResourceStorageLoadable in = this.resourceStorageFacade.getOrCreateResourceStorageLoadable(this);
                this.loadFromStorage(in);
                return;
            }
            catch (IOException e) {
                if (this.contents != null) {
                    this.contents.clear();
                }
                if (this.eAdapters != null) {
                    this.eAdapters.clear();
                }
                this.unload();
            }
        }
        super.load(options);
    }

    public void loadFromStorage(ResourceStorageLoadable storageInputStream) throws IOException {
        Preconditions.checkNotNull(storageInputStream, "storageInputStream");
        Stopwatches.StoppedTask task = Stopwatches.forTask("Loading from storage");
        task.start();
        this.isLoading = true;
        this.isLoadedFromStorage = true;
        try {
            storageInputStream.loadIntoResource(this);
            this.isLoaded = true;
        }
        finally {
            this.isLoading = false;
            task.stop();
        }
    }

    @Override
    protected void doUnload() {
        super.doUnload();
        this.isLoadedFromStorage = false;
    }

    @Override
    protected void clearInternalState() {
        this.isLoadedFromStorage = false;
        super.clearInternalState();
    }

    @Override
    public synchronized EObject getEObject(String uriFragment) {
        if (this.portableURIs.isPortableURIFragment(uriFragment)) {
            return this.portableURIs.resolve(this, uriFragment);
        }
        return super.getEObject(uriFragment);
    }

    @Override
    protected Set<String> getUnresolvableURIFragments() {
        if (this.isLoadedFromStorage) {
            return Collections.singleton(UNRESOLVABLE_FRAGMENT);
        }
        return super.getUnresolvableURIFragments();
    }

    public IResourceStorageFacade getResourceStorageFacade() {
        return this.resourceStorageFacade;
    }

    public PortableURIs getPortableURIs() {
        return this.portableURIs;
    }

    public boolean isLoadedFromStorage() {
        return this.isLoadedFromStorage;
    }

    public void setIsLoadedFromStorage(boolean isLoadedFromStorage) {
        this.isLoadedFromStorage = isLoadedFromStorage;
    }

    public IResourceDescription getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(IResourceDescription resourceDescription) {
        this.resourceDescription = resourceDescription;
    }
}

