/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import org.eclipse.xtext.util.GraphvizDotBuilder;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;

public class NfaToDot<STATE>
extends GraphvizDotBuilder {
    protected Function<STATE, String> stateFormatter;

    protected GraphvizDotBuilder.Node create(GraphvizDotBuilder.Digraph result, Nfa<STATE> nfa, STATE state) {
        GraphvizDotBuilder.Node n = new GraphvizDotBuilder.Node(this, state, this.stateToString(nfa, state));
        if (state == nfa.getStart() || state == nfa.getStop()) {
            n.setShape("box");
        }
        return n;
    }

    protected GraphvizDotBuilder.Edge create(GraphvizDotBuilder.Digraph result, Nfa<STATE> nfa, STATE from, STATE to) {
        return new GraphvizDotBuilder.Edge(this, from, to);
    }

    protected void draw(GraphvizDotBuilder.Digraph result, Nfa<STATE> nfa) {
        for (STATE s2 : new NfaUtil().collect(nfa)) {
            result.add(this.create(result, nfa, s2));
            for (STATE f : nfa.getFollowers(s2)) {
                result.add(this.create(result, nfa, s2, f));
            }
        }
    }

    @Override
    protected GraphvizDotBuilder.Props drawObject(Object obj) {
        GraphvizDotBuilder.Digraph result = new GraphvizDotBuilder.Digraph(this);
        if (obj instanceof Nfa) {
            this.draw(result, (Nfa)obj);
        }
        return result;
    }

    public NfaToDot<STATE> setStateFormatter(Function<STATE, String> stateFormatter) {
        this.stateFormatter = stateFormatter;
        return this;
    }

    protected String stateToString(Nfa<STATE> nfa, STATE state) {
        if (this.stateFormatter != null) {
            return this.stateFormatter.apply(state);
        }
        if (state == null) {
            return "null";
        }
        return state.toString();
    }
}

