/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.DeprecationUtil;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.nodemodel.BidiIterator;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAbstractWhileExpression;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.CompilationStrategyAdapter;
import org.eclipse.xtext.xbase.compiler.CompilationTemplateAdapter;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.imports.ImportedTypesCollector;
import org.eclipse.xtext.xbase.imports.StaticallyImportedMemberProvider;
import org.eclipse.xtext.xbase.imports.TypeUsages;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.SwitchConstantExpressionsInterpreter;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.services.XbaseGrammarAccess;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;
import org.eclipse.xtext.xbase.typesystem.computation.SynonymTypesProvider;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.internal.util.FeatureKinds;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerFunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.TypeReferenceVisitorWithResult;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.util.TypesOrderUtil;
import org.eclipse.xtext.xbase.util.XExpressionHelper;
import org.eclipse.xtext.xbase.util.XSwitchExpressions;
import org.eclipse.xtext.xbase.util.XbaseUsageCrossReferencer;
import org.eclipse.xtext.xbase.validation.AbstractXbaseValidator;
import org.eclipse.xtext.xbase.validation.EarlyExitValidator;
import org.eclipse.xtext.xbase.validation.ReadAndWriteTracking;
import org.eclipse.xtext.xbase.validation.ReferencedInvalidTypeFinder;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypePackage;

@ComposedChecks(validators={EarlyExitValidator.class})
public class XbaseValidator
extends AbstractXbaseValidator {
    @Inject
    private XbaseGrammarAccess grammarAccess;
    @Inject
    private XExpressionHelper expressionHelper;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    private NumberLiterals numberLiterals;
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private IImportsConfiguration importsConfiguration;
    @Inject
    private XSwitchExpressions switchExpressions;
    @Inject
    private TypesOrderUtil typesOrderUtil;
    @Inject
    private SwitchConstantExpressionsInterpreter switchConstantExpressionsInterpreter;
    @Inject
    private Provider<ImportedTypesCollector> importedTypesCollectorProvider;
    @Inject
    private StaticallyImportedMemberProvider staticallyImportedMemberProvider;
    @Inject
    private ReadAndWriteTracking readAndWriteTracking;
    @Inject
    private Primitives primitives;
    @Inject
    private JvmTypeExtensions jvmTypeExtensions;
    @Inject
    private UIStrings uiStrings;
    @Inject
    private ReferencedInvalidTypeFinder referencedInvalidTypeFinder;

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected LightweightTypeReference getActualType(EObject context, JvmIdentifiableElement element) {
        return this.typeResolver.resolveTypes(context).getActualType(element);
    }

    protected LightweightTypeReference getActualType(XExpression expression) {
        return this.typeResolver.resolveTypes(expression).getActualType(expression);
    }

    protected LightweightTypeReference getActualType(JvmIdentifiableElement identifiable) {
        return this.typeResolver.resolveTypes(identifiable).getActualType(identifiable);
    }

    protected LightweightTypeReference getExpectedType(XExpression expression) {
        return this.typeResolver.resolveTypes(expression).getExpectedType(expression);
    }

    protected void checkCast(JvmTypeReference concreteSyntax, LightweightTypeReference toType, LightweightTypeReference fromType) {
        if (toType == null || fromType == null) {
            return;
        }
        if (fromType.getType() instanceof JvmDeclaredType || fromType.isPrimitive()) {
            if ((!this.isInterface(fromType) || this.isFinal(toType)) && (!this.isInterface(toType) || this.isFinal(fromType)) && !toType.isAssignableFrom(fromType) && (this.isFinal(fromType) || this.isFinal(toType) || this.isClass(fromType) && this.isClass(toType)) && !fromType.isAssignableFrom(toType)) {
                this.error("Cannot cast from " + this.getNameOfTypes(fromType) + " to " + this.canonicalName(toType), (EObject)concreteSyntax, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_cast", new String[0]);
            }
        } else if (fromType.isPrimitiveVoid()) {
            this.error("Cannot cast from void to " + this.canonicalName(toType), (EObject)concreteSyntax, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_cast", new String[0]);
        }
        if (toType.isPrimitive() && !fromType.isPrimitive() && !fromType.isWrapper()) {
            this.error("Cannot cast from " + this.getNameOfTypes(fromType) + " to " + this.canonicalName(toType), (EObject)concreteSyntax, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_cast", new String[0]);
        }
        if (toType.getIdentifier().equals(fromType.getIdentifier())) {
            this.addIssue("Unnecessary cast from " + fromType.getHumanReadableName() + " to " + toType.getHumanReadableName(), concreteSyntax, "org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_cast");
        }
    }

    private boolean isInterface(LightweightTypeReference typeRef) {
        return this.isInterface(typeRef.getType());
    }

    private boolean isClass(LightweightTypeReference typeRef) {
        return typeRef.getType() instanceof JvmGenericType && !((JvmGenericType)typeRef.getType()).isInterface();
    }

    @Check
    protected void checkNumberFormat(XNumberLiteral literal) {
        try {
            this.numberLiterals.numberValue(literal, this.numberLiterals.getJavaType(literal));
        }
        catch (Exception e) {
            this.error("Invalid number format: " + e.getMessage(), (EStructuralFeature)XbasePackage.Literals.XNUMBER_LITERAL__VALUE, "org.eclipse.xtext.xbase.validation.IssueCodes.invalidNumberFormat", new String[0]);
        }
    }

    @Check
    public void checkTypeReferenceIsNotVoid(XExpression expression) {
        for (EObject eObject : expression.eContents()) {
            JvmTypeReference typeRef;
            if (!(eObject instanceof JvmTypeReference) || !this.isPrimitiveVoid(typeRef = (JvmTypeReference)eObject) || typeRef.eClass() == TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE && !((JvmParameterizedTypeReference)typeRef).getArguments().isEmpty()) continue;
            this.error("Primitive void cannot be used here.", (EObject)typeRef, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    protected boolean isPrimitiveVoid(JvmTypeReference typeReference) {
        return typeReference != null && typeReference.getType() != null && !typeReference.getType().eIsProxy() && typeReference.getType() instanceof JvmVoid;
    }

    @Check
    public void checkVariableIsNotInferredAsVoid(XVariableDeclaration declaration) {
        if (declaration.getType() != null) {
            return;
        }
        LightweightTypeReference variableType = this.typeResolver.resolveTypes(declaration).getActualType(declaration);
        if (variableType != null && variableType.isPrimitiveVoid()) {
            this.error("void is an invalid type for the variable " + declaration.getName(), (EObject)declaration, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkClosureParameterTypes(XClosure closure) {
        if (closure.getFormalParameters().isEmpty()) {
            return;
        }
        LightweightTypeReference closureType = this.getActualType(closure);
        if (closureType != null && closureType.isUnknown()) {
            return;
        }
        boolean checkedClosure = false;
        for (JvmFormalParameter p : closure.getFormalParameters()) {
            LightweightTypeReference parameterType;
            if (p.getParameterType() != null) continue;
            if (!checkedClosure) {
                LightweightTypeReference type = this.getExpectedType(closure);
                if (type == null) {
                    this.error("There is no context to infer the closure's argument types from. Consider typing the arguments or put the closures into a typed context.", (EObject)closure, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
                    return;
                }
                JvmOperation operation = this.getServices().getFunctionTypes().findImplementingOperation(type);
                if (operation == null) {
                    this.error("There is no context to infer the closure's argument types from. Consider typing the arguments or use the closures in a more specific context.", (EObject)closure, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
                    return;
                }
                checkedClosure = true;
            }
            if ((parameterType = this.getActualType(closure, p)) != null) continue;
            this.error("There is no context to infer the closure's argument types from. Consider typing the arguments or use the closures in a more specific context.", (EObject)closure, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
            return;
        }
    }

    @Check
    public void checkTypeArguments(XAbstractFeatureCall expression) {
        for (JvmTypeReference typeRef : expression.getTypeArguments()) {
            this.ensureNotPrimitiveNorWildcard(typeRef);
        }
    }

    @Check
    public void checkTypeArguments(XConstructorCall expression) {
        for (JvmTypeReference typeRef : expression.getTypeArguments()) {
            this.ensureNotPrimitiveNorWildcard(typeRef);
        }
    }

    protected void ensureNotPrimitiveNorWildcard(JvmTypeReference typeRef) {
        LightweightTypeReference reference = this.toLightweightTypeReference(typeRef);
        if (reference.isPrimitive()) {
            this.error("Primitives cannot be used as type arguments.", (EObject)typeRef, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
        if (reference.isWildcard()) {
            this.error("Wildcard types are not allowed in this context", (EObject)typeRef, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_wild_card", new String[0]);
        }
    }

    protected LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef) {
        return this.toLightweightTypeReference(typeRef, false);
    }

    protected LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef, boolean keepUnboundWildcardInformation) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.getServices(), typeRef);
        LightweightTypeReferenceFactory factory = new LightweightTypeReferenceFactory(owner, keepUnboundWildcardInformation);
        LightweightTypeReference reference = factory.toLightweightReference(typeRef);
        return reference;
    }

    @Check
    public void checkTypeReferenceIsNotVoid(XCasePart expression) {
        if (expression.getTypeGuard() != null && this.toLightweightTypeReference(expression.getTypeGuard()).isPrimitiveVoid()) {
            this.error("Primitive void cannot be used here.", (EObject)expression.getTypeGuard(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
        }
    }

    @Check
    public void checkReturn(XReturnExpression expr) {
        XExpression returnedExpression = expr.getExpression();
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes(expr);
        LightweightTypeReference expectedReturnType = resolvedTypes.getExpectedReturnType(expr);
        if (expectedReturnType == null) {
            return;
        }
        if (expectedReturnType.isPrimitiveVoid()) {
            if (returnedExpression != null) {
                this.error("Void functions cannot return a value.", (EObject)expr, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_return", new String[0]);
            }
        } else if (returnedExpression == null) {
            this.error("The function must return a result of type " + expectedReturnType.getHumanReadableName() + ".", (EObject)expr, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_return", new String[0]);
        } else {
            LightweightTypeReference expressionType = this.getActualType(returnedExpression);
            if (expressionType.isPrimitiveVoid()) {
                this.error("Incompatible types. Expected " + this.getNameOfTypes(expectedReturnType) + " but was " + this.canonicalName(expressionType), (EObject)returnedExpression, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
            }
        }
    }

    protected String getNameOfTypes(LightweightTypeReference expectedType) {
        final StringBuilder result = new StringBuilder(this.canonicalName(expectedType));
        this.getServices().getSynonymTypesProvider().collectSynonymTypes(expectedType, new SynonymTypesProvider.Acceptor(){

            @Override
            protected boolean accept(LightweightTypeReference synonym, int flags) {
                result.append(" or ").append(XbaseValidator.this.canonicalName(synonym));
                return true;
            }
        });
        return result.toString();
    }

    @Check
    public void checkTypes(XCatchClause catchClause) {
        LightweightTypeReference parameterType = this.getActualType(catchClause, catchClause.getDeclaredParam());
        if (parameterType != null && !parameterType.isSubtypeOf(Throwable.class)) {
            this.error("No exception of type " + parameterType.getHumanReadableName() + " can be thrown; an exception type must be a subclass of Throwable", (EObject)catchClause.getDeclaredParam(), (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__PARAMETER_TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
        }
    }

    @Check
    public void checkTypeParameterNotUsedInStaticContext(JvmTypeReference ref) {
        JvmTypeParameter typeParameter;
        if (!(!(ref.getType() instanceof JvmTypeParameter) || (typeParameter = (JvmTypeParameter)ref.getType()).getDeclarator() instanceof JvmOperation && this.isTypeParameterOfClosureImpl(ref))) {
            for (EObject currentParent = this.logicalContainerProvider.getNearestLogicalContainer(ref); currentParent != null; currentParent = currentParent.eContainer()) {
                if (currentParent == typeParameter.eContainer()) {
                    return;
                }
                if (!this.isStaticContext(currentParent)) continue;
                this.error("Cannot make a static reference to the non-static type " + typeParameter.getName(), (EObject)ref, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", new String[0]);
            }
        }
    }

    private boolean isTypeParameterOfClosureImpl(JvmTypeReference ref) {
        JvmFormalParameter parameter = EcoreUtil2.getContainerOfType(ref, JvmFormalParameter.class);
        if (parameter != null) {
            return parameter.eContainer() instanceof XClosure;
        }
        return false;
    }

    protected boolean isStaticContext(EObject element) {
        if (element instanceof JvmConstructor) {
            return false;
        }
        if (element instanceof JvmFeature) {
            return ((JvmFeature)element).isStatic();
        }
        if (element instanceof JvmDeclaredType) {
            return ((JvmDeclaredType)element).isStatic() || ((JvmDeclaredType)element).getDeclaringType() == null && !this.isLocalType(element);
        }
        return false;
    }

    protected boolean isLocalType(EObject element) {
        return element instanceof JvmGenericType && ((JvmGenericType)element).isLocal();
    }

    @Check
    public void checkTypeParameterConstraintIsValid(JvmTypeParameter typeParameter) {
        if (!typeParameter.getConstraints().isEmpty()) {
            for (JvmTypeConstraint constraint : typeParameter.getConstraints()) {
                JvmTypeReference typeReference = constraint.getTypeReference();
                if (typeReference instanceof JvmGenericArrayTypeReference) {
                    this.error(String.format("The array type %s cannot be used as a type parameter bound", typeReference.getSimpleName()), (EObject)typeReference, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type_parameter_bounds", new String[0]);
                    continue;
                }
                if (!(typeReference.getType() instanceof JvmTypeParameter) || typeParameter.getConstraints().size() <= 1) continue;
                this.error(String.format("The type parameter %s cannot be used as a type parameter bound with additional bounds", typeReference.getSimpleName()), (EObject)typeReference, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type_parameter_bounds", new String[0]);
            }
        }
    }

    public void doCheckTypeParameterForwardReference(List<JvmTypeParameter> sourceTypeParameters) {
        if (sourceTypeParameters.size() >= 1) {
            HashSet<JvmTypeParameter> allowed = Sets.newHashSet();
            for (int i = 0; i < sourceTypeParameters.size(); ++i) {
                JvmTypeParameter current = sourceTypeParameters.get(i);
                for (JvmTypeConstraint constraint : current.getConstraints()) {
                    EObject sourceElement;
                    JvmType constraintType;
                    JvmTypeReference constraintRef = constraint.getTypeReference();
                    if (constraintRef == null || (constraintType = constraintRef.getType()).eClass() != TypesPackage.Literals.JVM_TYPE_PARAMETER || (sourceElement = this.associations.getPrimarySourceElement(constraintType)) == null || sourceElement.eContainer() != current.eContainer() || allowed.contains(sourceElement)) continue;
                    this.error("Illegal forward reference to type parameter " + ((JvmTypeParameter)constraintType).getSimpleName(), (EObject)constraintRef, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.type_parameter_forward_reference", new String[0]);
                }
                allowed.add(current);
            }
        }
    }

    @Check
    public void checkAssignment(XAssignment assignment) {
        this.checkAssignment(assignment, true);
    }

    protected void checkFinalFieldInitialization(JvmGenericType type) {
        LinkedHashSet<JvmField> finalFields = Sets.newLinkedHashSet(Iterables.filter(type.getDeclaredFields(), new Predicate<JvmField>(){

            @Override
            public boolean apply(JvmField input) {
                return input.isFinal();
            }
        }));
        if (finalFields.isEmpty()) {
            return;
        }
        LinkedHashSet<JvmField> initializedFields = Sets.newLinkedHashSet(Iterables.filter(finalFields, new Predicate<JvmField>(){

            @Override
            public boolean apply(JvmField input) {
                return XbaseValidator.this.isInitialized(input);
            }
        }));
        Iterable<JvmConstructor> declaredConstructors = type.getDeclaredConstructors();
        if (Iterables.size(declaredConstructors) == 1 && this.jvmTypeExtensions.isSingleSyntheticDefaultConstructor(declaredConstructors.iterator().next())) {
            finalFields.removeAll(initializedFields);
            for (JvmField jvmField : finalFields) {
                this.reportUninitializedField(jvmField);
            }
        } else {
            for (JvmConstructor constr : declaredConstructors) {
                if (this.hasConstructorCallWithThis(constr)) continue;
                LinkedHashSet<JvmField> localInitializedFields = Sets.newLinkedHashSet(initializedFields);
                XExpression expression = this.logicalContainerProvider.getAssociatedExpression(constr);
                if (expression != null) {
                    this.checkInitializationRec(expression, finalFields, localInitializedFields, Sets.newLinkedHashSet(localInitializedFields), Sets.newHashSet(constr));
                }
                for (JvmField field : finalFields) {
                    if (localInitializedFields.contains(field) || this.readAndWriteTracking.isInitialized(field, constr)) continue;
                    this.reportUninitializedField(field, constr);
                }
            }
        }
    }

    protected boolean hasConstructorCallWithThis(JvmConstructor constr) {
        XExpression associatedExpression = this.logicalContainerProvider.getAssociatedExpression(constr);
        if (associatedExpression == null) {
            return false;
        }
        TreeIterator<EObject> contents = associatedExpression.eAllContents();
        while (contents.hasNext()) {
            XFeatureCall featureCall;
            EObject next = (EObject)contents.next();
            if (!(next instanceof XFeatureCall) || !((featureCall = (XFeatureCall)next).getFeature() instanceof JvmConstructor) || !featureCall.getConcreteSyntaxFeatureName().equals(IFeatureNames.THIS.toString())) continue;
            return true;
        }
        return false;
    }

    protected boolean isInitialized(JvmField input) {
        if (this.logicalContainerProvider.getAssociatedExpression(input) != null) {
            return true;
        }
        for (Adapter adapter : input.eAdapters()) {
            if (adapter instanceof CompilationStrategyAdapter) {
                return true;
            }
            if (!(adapter instanceof CompilationTemplateAdapter)) continue;
            return true;
        }
        return false;
    }

    protected void reportUninitializedField(JvmField field) {
    }

    protected void reportUninitializedField(JvmField field, JvmConstructor constructor) {
    }

    protected void reportFieldAlreadyInitialized(XAssignment assignment, JvmField field) {
        this.error("The final field " + field.getSimpleName() + " may already have been assigned", (EObject)assignment, null, "org.eclipse.xtext.xbase.validation.IssueCodes.field_already_initialized", new String[0]);
    }

    protected void checkInitializationRec(EObject expr, Set<JvmField> fields, Set<JvmField> initializedForSure, Set<JvmField> initializedMaybe, Set<JvmConstructor> visited) {
        block21: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block20: {
                                    if (!(expr instanceof XAssignment)) break block20;
                                    XAssignment assignment = (XAssignment)expr;
                                    if (assignment.getAssignable() != null) {
                                        this.checkInitializationRec(assignment.getAssignable(), fields, initializedForSure, initializedMaybe, visited);
                                    }
                                    if (!fields.contains(assignment.getFeature())) break block21;
                                    JvmField field = (JvmField)assignment.getFeature();
                                    if (fields.contains(field) && (initializedForSure.contains(field) || initializedMaybe.contains(field))) {
                                        this.reportFieldAlreadyInitialized(assignment, field);
                                    }
                                    initializedForSure.add(field);
                                    initializedMaybe.add(field);
                                    break block21;
                                }
                                if (!(expr instanceof XForLoopExpression)) break block22;
                                XForLoopExpression loopExpression = (XForLoopExpression)expr;
                                this.checkInitializationRec(loopExpression.getForExpression(), fields, initializedForSure, initializedMaybe, visited);
                                this.checkInitializationRec(loopExpression.getEachExpression(), fields, initializedMaybe, Sets.newLinkedHashSet(fields), visited);
                                break block21;
                            }
                            if (!(expr instanceof XBasicForLoopExpression)) break block23;
                            XBasicForLoopExpression loopExpression = (XBasicForLoopExpression)expr;
                            for (XExpression xExpression : loopExpression.getInitExpressions()) {
                                this.checkInitializationRec(xExpression, fields, initializedForSure, initializedMaybe, visited);
                            }
                            XExpression expression = loopExpression.getExpression();
                            if (expression != null) {
                                this.checkInitializationRec(expression, fields, initializedForSure, Sets.newLinkedHashSet(fields), visited);
                            }
                            for (XExpression updateExpression : loopExpression.getUpdateExpressions()) {
                                this.checkInitializationRec(updateExpression, fields, initializedMaybe, Sets.newLinkedHashSet(fields), visited);
                            }
                            this.checkInitializationRec(loopExpression.getEachExpression(), fields, initializedMaybe, Sets.newLinkedHashSet(fields), visited);
                            break block21;
                        }
                        if (!(expr instanceof XAbstractWhileExpression)) break block24;
                        XAbstractWhileExpression loopExpression = (XAbstractWhileExpression)expr;
                        this.checkInitializationRec(loopExpression.getPredicate(), fields, initializedForSure, Sets.newLinkedHashSet(fields), visited);
                        this.checkInitializationRec(loopExpression.getBody(), fields, initializedMaybe, Sets.newLinkedHashSet(fields), visited);
                        break block21;
                    }
                    if (!(expr instanceof XTryCatchFinallyExpression)) break block25;
                    XTryCatchFinallyExpression tryExpr = (XTryCatchFinallyExpression)expr;
                    this.checkInitializationRec(tryExpr.getExpression(), fields, initializedForSure, initializedMaybe, visited);
                    XExpression finallyExpression = tryExpr.getFinallyExpression();
                    if (finallyExpression == null) break block21;
                    this.checkInitializationRec(finallyExpression, fields, initializedForSure, initializedMaybe, visited);
                    break block21;
                }
                if (!(expr instanceof XIfExpression)) break block26;
                XIfExpression ifExpr = (XIfExpression)expr;
                this.checkInitializationRec(ifExpr.getIf(), fields, initializedForSure, initializedMaybe, visited);
                LinkedHashSet<JvmField> initializedThenForSure = Sets.newLinkedHashSet(initializedForSure);
                LinkedHashSet<JvmField> linkedHashSet = Sets.newLinkedHashSet(initializedMaybe);
                this.checkInitializationRec(ifExpr.getThen(), fields, initializedThenForSure, linkedHashSet, visited);
                if (ifExpr.getElse() == null) break block21;
                LinkedHashSet<JvmField> initializedElseForSure = Sets.newLinkedHashSet(initializedForSure);
                LinkedHashSet<JvmField> initializedElseMaybe = Sets.newLinkedHashSet(initializedMaybe);
                this.checkInitializationRec(ifExpr.getElse(), fields, initializedElseForSure, initializedElseMaybe, visited);
                initializedThenForSure.retainAll(initializedElseForSure);
                initializedForSure.addAll(initializedThenForSure);
                initializedMaybe.addAll(linkedHashSet);
                initializedMaybe.addAll(initializedElseMaybe);
                break block21;
            }
            if (expr instanceof XSwitchExpression) {
                XSwitchExpression switchExpr = (XSwitchExpression)expr;
                this.checkInitializationRec(switchExpr.getSwitch(), fields, initializedForSure, initializedMaybe, visited);
                LinkedHashSet<JvmField> initializedAllCasesForSure = null;
                LinkedHashSet<JvmField> linkedHashSet = Sets.newLinkedHashSet(initializedMaybe);
                for (XCasePart casepart : switchExpr.getCases()) {
                    if (casepart.getCase() != null) {
                        this.checkInitializationRec(casepart.getCase(), fields, initializedForSure, initializedMaybe, visited);
                    }
                    LinkedHashSet<JvmField> initializedInCaseForSure = Sets.newLinkedHashSet(initializedForSure);
                    LinkedHashSet<JvmField> initializedInCaseMaybe = Sets.newLinkedHashSet(initializedMaybe);
                    XExpression then = this.switchExpressions.getThen(casepart, switchExpr);
                    this.checkInitializationRec(then, fields, initializedInCaseForSure, initializedInCaseMaybe, visited);
                    if (initializedAllCasesForSure == null) {
                        initializedAllCasesForSure = initializedInCaseForSure;
                    } else {
                        initializedAllCasesForSure.retainAll(initializedInCaseForSure);
                    }
                    linkedHashSet.addAll(initializedInCaseMaybe);
                }
                if (switchExpr.getDefault() != null) {
                    LinkedHashSet<JvmField> initializedInCaseForSure = Sets.newLinkedHashSet(initializedForSure);
                    LinkedHashSet<JvmField> initializedInCaseMaybe = Sets.newLinkedHashSet(initializedMaybe);
                    this.checkInitializationRec(switchExpr.getDefault(), fields, initializedInCaseForSure, initializedInCaseMaybe, visited);
                    if (initializedAllCasesForSure == null) {
                        initializedAllCasesForSure = initializedInCaseForSure;
                    } else {
                        initializedAllCasesForSure.retainAll(initializedInCaseForSure);
                    }
                    linkedHashSet.addAll(initializedInCaseMaybe);
                    initializedForSure.addAll(initializedAllCasesForSure);
                }
                initializedMaybe.addAll(linkedHashSet);
            } else if (expr instanceof XFeatureCall) {
                HashSet<JvmConstructor> visitedCopy;
                XExpression xExpression;
                Object constructor;
                XFeatureCall xFeatureCall = (XFeatureCall)expr;
                if (xFeatureCall.getFeature() instanceof JvmConstructor && (constructor = (JvmConstructor)xFeatureCall.getFeature()).getDeclaringType() == fields.iterator().next().getDeclaringType() && (xExpression = this.logicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)constructor)) != null && (visitedCopy = Sets.newHashSet(visited)).add((JvmConstructor)constructor)) {
                    this.checkInitializationRec(xExpression, fields, initializedForSure, initializedMaybe, visitedCopy);
                }
                for (EObject eObject : expr.eContents()) {
                    this.checkInitializationRec(eObject, fields, initializedForSure, initializedMaybe, visited);
                }
            } else {
                if (this.isLocalClassSemantics(expr)) {
                    return;
                }
                for (EObject child : expr.eContents()) {
                    this.checkInitializationRec(child, fields, initializedForSure, initializedMaybe, visited);
                }
            }
        }
    }

    @Check
    public void checkVariableDeclaration(XVariableDeclaration declaration) {
        if (declaration.getRight() == null) {
            if (!declaration.isWriteable()) {
                this.error("Value must be initialized", (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__WRITEABLE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.missing_initialization", new String[0]);
            }
            if (declaration.getType() == null) {
                this.error("Type cannot be derived", (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.missing_type", new String[0]);
            }
        }
    }

    @Check
    public void checkInnerExpressions(XExpression expr) {
        if (!this.expressionHelper.hasSideEffects(expr) && !this.isValueExpectedRecursive(expr)) {
            this.mustBeJavaStatementExpression(expr);
        }
    }

    protected boolean isValueExpectedRecursive(XExpression expr) {
        XBlockExpression blockExpression;
        EList<XExpression> expressions;
        EStructuralFeature feature = expr.eContainingFeature();
        EObject container = expr.eContainer();
        if (container instanceof XBlockExpression && (expressions = (blockExpression = (XBlockExpression)container).getExpressions()).get(expressions.size() - 1) != expr) {
            return false;
        }
        if (feature == XbasePackage.Literals.XTRY_CATCH_FINALLY_EXPRESSION__FINALLY_EXPRESSION || feature == XbasePackage.Literals.XABSTRACT_WHILE_EXPRESSION__BODY || feature == XbasePackage.Literals.XFOR_LOOP_EXPRESSION__EACH_EXPRESSION) {
            return false;
        }
        if (container instanceof XAbstractFeatureCall || container instanceof XConstructorCall || container instanceof XAssignment || container instanceof XVariableDeclaration || container instanceof XReturnExpression || container instanceof XThrowExpression || feature == XbasePackage.Literals.XFOR_LOOP_EXPRESSION__FOR_EXPRESSION || feature == XbasePackage.Literals.XSWITCH_EXPRESSION__SWITCH || feature == XbasePackage.Literals.XCASE_PART__CASE || feature == XbasePackage.Literals.XIF_EXPRESSION__IF || feature == XbasePackage.Literals.XABSTRACT_WHILE_EXPRESSION__PREDICATE || feature == XbasePackage.Literals.XBASIC_FOR_LOOP_EXPRESSION__EXPRESSION || feature == XbasePackage.Literals.XSYNCHRONIZED_EXPRESSION__PARAM) {
            return true;
        }
        if (this.isLocalClassSemantics(container) || this.logicalContainerProvider.getLogicalContainer(expr) != null) {
            LightweightTypeReference expectedReturnType = this.typeResolver.resolveTypes(expr).getExpectedReturnType(expr);
            return expectedReturnType == null || !expectedReturnType.isPrimitiveVoid();
        }
        if (container instanceof XCasePart || container instanceof XCatchClause) {
            container = container.eContainer();
        }
        if (container instanceof XExpression) {
            return this.isValueExpectedRecursive((XExpression)container);
        }
        return true;
    }

    protected void mustBeJavaStatementExpression(XExpression expr) {
        if (expr != null) {
            this.error("This expression is not allowed in this context, since it doesn't cause any side effects.", (EObject)expr, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_inner_expression", new String[0]);
        }
    }

    @Check
    public void checkCasts(XCastedExpression cast) {
        if (cast.getType() == null) {
            return;
        }
        LightweightTypeReference toType = this.toLightweightTypeReference(cast.getType());
        LightweightTypeReference fromType = this.getActualType(cast.getTarget());
        this.checkCast(cast.getType(), toType, fromType);
    }

    @Check
    public void checkTypeGuards(XCasePart casePart) {
        if (casePart.getTypeGuard() == null) {
            return;
        }
        LightweightTypeReference typeGuard = this.toLightweightTypeReference(casePart.getTypeGuard());
        if (typeGuard.isPrimitive()) {
            this.error("Primitives are not allowed as type guards", (EStructuralFeature)XbasePackage.Literals.XCASE_PART__TYPE_GUARD, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            return;
        }
        LightweightTypeReference targetTypeRef = this.getActualType(((XSwitchExpression)casePart.eContainer()).getSwitch());
        this.checkCast(casePart.getTypeGuard(), typeGuard, targetTypeRef);
    }

    @Check
    public void checkInstanceOf(XInstanceOfExpression instanceOfExpression) {
        LightweightTypeReference leftType = this.getActualType(instanceOfExpression.getExpression());
        LightweightTypeReference rightType = this.toLightweightTypeReference(instanceOfExpression.getType(), true);
        if (leftType == null || rightType == null || rightType.getType() == null || rightType.getType().eIsProxy()) {
            return;
        }
        if (this.containsTypeArgs(rightType)) {
            this.error("Cannot perform instanceof check against parameterized type " + this.getNameOfTypes(rightType), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_instanceof", new String[0]);
            return;
        }
        if (leftType.isAny() || leftType.isUnknown()) {
            return;
        }
        if (rightType.isPrimitive()) {
            this.error("Cannot perform instanceof check against primitive type " + this.getNameOfTypes(rightType), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_instanceof", new String[0]);
            return;
        }
        if (leftType.isPrimitive() || rightType.isArray() && !leftType.isArray() && !leftType.isType(Object.class) && !leftType.isType(Cloneable.class) && !leftType.isType(Serializable.class) || this.isFinal(rightType) && !this.memberOfTypeHierarchy(rightType, leftType) || this.isFinal(leftType) && !this.memberOfTypeHierarchy(leftType, rightType)) {
            this.error("Incompatible conditional operand types " + this.getNameOfTypes(leftType) + " and " + this.getNameOfTypes(rightType), null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_instanceof", new String[0]);
            return;
        }
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_instanceof") && rightType.isAssignableFrom(leftType, new TypeConformanceComputationArgument(false, false, true, true, false, false)) && rightType.getConstraintSubstitute() == rightType) {
            this.addIssueToState("org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_instanceof", "The expression of type " + this.getNameOfTypes(leftType) + " is already of type " + this.canonicalName(rightType), null);
        }
    }

    protected boolean memberOfTypeHierarchy(LightweightTypeReference type, LightweightTypeReference potentialMember) {
        return potentialMember.getConstraintSubstitute().isAssignableFrom(type, new TypeConformanceComputationArgument(false, false, false, true, false, false));
    }

    protected boolean containsTypeArgs(LightweightTypeReference instanceOfType) {
        return instanceOfType.accept(new TypeReferenceVisitorWithResult<Boolean>(){

            @Override
            protected Boolean doVisitTypeReference(LightweightTypeReference reference) {
                return Boolean.FALSE;
            }

            @Override
            protected Boolean doVisitParameterizedTypeReference(ParameterizedTypeReference reference) {
                for (LightweightTypeReference argument : reference.getTypeArguments()) {
                    if (argument.isWildcard()) {
                        if (((WildcardTypeReference)argument).isUnbounded()) continue;
                        return Boolean.TRUE;
                    }
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            protected Boolean doVisitInnerTypeReference(InnerTypeReference reference) {
                Boolean result = reference.getOuter().accept(this) != false && this.doVisitParameterizedTypeReference(reference) != false;
                return result;
            }

            @Override
            protected Boolean doVisitInnerFunctionTypeReference(InnerFunctionTypeReference reference) {
                Boolean result = reference.getOuter().accept(this) != false && this.doVisitParameterizedTypeReference(reference) != false;
                return result;
            }

            @Override
            protected Boolean doVisitArrayTypeReference(ArrayTypeReference reference) {
                return reference.getComponentType().accept(this);
            }
        });
    }

    protected boolean isFinal(LightweightTypeReference expressionTypeRef) {
        if (expressionTypeRef.isArray()) {
            return this.isFinal(expressionTypeRef.getComponentType());
        }
        if (expressionTypeRef.isPrimitive()) {
            return true;
        }
        return expressionTypeRef.getType() instanceof JvmDeclaredType && ((JvmDeclaredType)expressionTypeRef.getType()).isFinal();
    }

    @Check
    public void checkDelegateConstructorIsFirst(XFeatureCall featureCall) {
        JvmIdentifiableElement container;
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature != null && !feature.eIsProxy() && feature instanceof JvmConstructor && (container = this.logicalContainerProvider.getNearestLogicalContainer(featureCall)) != null) {
            if (container instanceof JvmConstructor) {
                EList<XExpression> expressions;
                XExpression body = this.logicalContainerProvider.getAssociatedExpression(container);
                if (body == featureCall) {
                    return;
                }
                if (body instanceof XBlockExpression && ((expressions = ((XBlockExpression)body).getExpressions()).isEmpty() || expressions.get(0) != featureCall)) {
                    this.error("Constructor call must be the first expression in a constructor", null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_invocation", new String[0]);
                }
            } else {
                this.error("Constructor call must be the first expression in a constructor", null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_invocation", new String[0]);
            }
        }
    }

    @Check
    public void checkConstructorArgumentsAreValid(XFeatureCall featureCall) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature != null && !feature.eIsProxy() && feature instanceof JvmConstructor) {
            JvmType containerType = EcoreUtil2.getContainerOfType(this.logicalContainerProvider.getNearestLogicalContainer(featureCall), JvmType.class);
            for (XExpression argument : featureCall.getFeatureCallArguments()) {
                this.checkIsValidConstructorArgument(argument, containerType);
            }
        }
    }

    protected void checkIsValidConstructorArgument(XExpression argument, JvmType containerType) {
        TreeIterator<EObject> iterator = EcoreUtil2.eAll(argument);
        while (iterator.hasNext()) {
            EObject partOfArgumentExpression = (EObject)iterator.next();
            if (partOfArgumentExpression instanceof XFeatureCall || partOfArgumentExpression instanceof XMemberFeatureCall) {
                JvmIdentifiableElement feature;
                XAbstractFeatureCall featureCall = (XAbstractFeatureCall)partOfArgumentExpression;
                XExpression actualReceiver = featureCall.getActualReceiver();
                if (!(actualReceiver instanceof XFeatureCall) || ((XFeatureCall)actualReceiver).getFeature() != containerType || (feature = featureCall.getFeature()) == null || feature.eIsProxy()) continue;
                if (feature instanceof JvmField) {
                    if (((JvmField)feature).isStatic()) continue;
                    this.error("Cannot refer to an instance field " + feature.getSimpleName() + " while explicitly invoking a constructor", partOfArgumentExpression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_argument", new String[0]);
                    continue;
                }
                if (!(feature instanceof JvmOperation) || ((JvmOperation)feature).isStatic()) continue;
                this.error("Cannot refer to an instance method while explicitly invoking a constructor", partOfArgumentExpression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_constructor_argument", new String[0]);
                continue;
            }
            if (!this.isLocalClassSemantics(partOfArgumentExpression)) continue;
            iterator.prune();
        }
    }

    @Check
    public void checkNoCircularConstructorCall(XFeatureCall featureCall) {
        JvmIdentifiableElement logicalContainer;
        JvmIdentifiableElement feature = featureCall.getFeature();
        if (feature != null && !feature.eIsProxy() && feature instanceof JvmConstructor && (logicalContainer = this.logicalContainerProvider.getNearestLogicalContainer(featureCall)) instanceof JvmConstructor) {
            JvmConstructor currentConstructor = (JvmConstructor)logicalContainer;
            JvmConstructor calledConstructor = (JvmConstructor)feature;
            HashSet<JvmConstructor> visited = Sets.newHashSet(currentConstructor);
            while (calledConstructor.getDeclaringType() == currentConstructor.getDeclaringType()) {
                if (!visited.add(calledConstructor)) {
                    this.error("Recursive constructor invocation", (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, "org.eclipse.xtext.xbase.validation.IssueCodes.circular_constructor_invocation", new String[0]);
                    return;
                }
                XExpression constructorBody = this.logicalContainerProvider.getAssociatedExpression(calledConstructor);
                if (constructorBody instanceof XBlockExpression) {
                    JvmIdentifiableElement calledFeature;
                    EList<XExpression> expressions = ((XBlockExpression)constructorBody).getExpressions();
                    if (expressions.isEmpty()) {
                        return;
                    }
                    XExpression firstInBody = (XExpression)((XBlockExpression)constructorBody).getExpressions().get(0);
                    if (firstInBody instanceof XFeatureCall && (calledFeature = ((XFeatureCall)firstInBody).getFeature()) != null && !calledFeature.eIsProxy() && calledFeature instanceof JvmConstructor) {
                        calledConstructor = (JvmConstructor)calledFeature;
                        continue;
                    }
                }
                return;
            }
        }
    }

    @Check
    public void checkNoForwardReferences(XExpression fieldInitializer) {
        JvmIdentifiableElement container = this.logicalContainerProvider.getLogicalContainer(fieldInitializer);
        if (container instanceof JvmField) {
            JvmField field = (JvmField)container;
            boolean staticField = field.isStatic();
            JvmDeclaredType declaredType = field.getDeclaringType();
            if (declaredType == null) {
                return;
            }
            HashSet<JvmField> illegalFields = Sets.newHashSet();
            for (int i = declaredType.getMembers().size() - 1; i >= 0; --i) {
                JvmMember member = (JvmMember)declaredType.getMembers().get(i);
                if (member instanceof JvmField && ((JvmField)member).isStatic() == staticField) {
                    illegalFields.add((JvmField)member);
                }
                if (member == field) break;
            }
            TreeIterator<EObject> iterator = EcoreUtil2.eAll(fieldInitializer);
            while (iterator.hasNext()) {
                EObject object = (EObject)iterator.next();
                if (object instanceof XFeatureCall) {
                    JvmIdentifiableElement feature = ((XFeatureCall)object).getFeature();
                    if (!illegalFields.contains(((XFeatureCall)object).getFeature())) continue;
                    this.error("Cannot reference the field '" + feature.getSimpleName() + "' before it is defined", object, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.illegal_forward_reference", new String[0]);
                    continue;
                }
                if (!this.isLocalClassSemantics(object)) continue;
                iterator.prune();
            }
        }
    }

    protected boolean isLocalClassSemantics(EObject object) {
        return object instanceof XClosure;
    }

    @Check
    public void checkClosureParams(XClosure closure) {
        if (closure.getDeclaredFormalParameters().size() > 6) {
            this.error("The maximum number of parameters for a closure is six.", (EObject)closure, (EStructuralFeature)XbasePackage.Literals.XCLOSURE__DECLARED_FORMAL_PARAMETERS, 6, "org.eclipse.xtext.xbase.validation.IssueCodes.too_many_params_in_closure", new String[0]);
        }
    }

    @Check
    void checkNullSafeFeatureCallWithPrimitives(XMemberFeatureCall featureCall) {
        if (featureCall.isNullSafe()) {
            if (this.getActualType(featureCall.getMemberCallTarget()).isPrimitive()) {
                this.error("Cannot use null-safe feature call on primitive receiver", (EObject)featureCall, (EStructuralFeature)XbasePackage.Literals.XMEMBER_FEATURE_CALL__NULL_SAFE, "org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive", new String[0]);
                return;
            }
            LightweightTypeReference type = this.getActualType(featureCall);
            if (type.isPrimitive() && this.isValueExpectedRecursive(featureCall)) {
                this.addIssue("Null-safe call of primitive-valued feature " + featureCall.getConcreteSyntaxFeatureName() + ", default value " + this.getDefaultValue(type) + " will be used", featureCall, "org.eclipse.xtext.xbase.validation.IssueCodes.null_safe_feature_call_on_primitive_valued_feature");
            }
        }
    }

    String getDefaultValue(LightweightTypeReference type) {
        if (type != null && type.isPrimitive()) {
            Primitives.Primitive primitiveKind = this.primitives.primitiveKind((JvmPrimitiveType)type.getType());
            if (primitiveKind == Primitives.Primitive.Boolean) {
                return "false";
            }
            return "0";
        }
        return "null";
    }

    @Check
    public void checkLocalUsageOfDeclared(XVariableDeclaration variableDeclaration) {
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unused_local_variable") && !this.isLocallyUsed(variableDeclaration, variableDeclaration.eContainer())) {
            String message = "The value of the local variable " + variableDeclaration.getName() + " is not used";
            this.addIssueToState("org.eclipse.xtext.xbase.validation.IssueCodes.unused_local_variable", message, XbasePackage.Literals.XVARIABLE_DECLARATION__NAME);
        }
    }

    @Check
    public void checkLocalUsageOfSwitchParameter(XSwitchExpression switchExpression) {
        JvmFormalParameter switchParam = switchExpression.getDeclaredParam();
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unused_local_variable") && switchParam != null && !this.isLocallyUsed(switchParam, switchExpression)) {
            String message = "The value of the local variable " + switchParam.getName() + " is not used";
            this.addIssue(message, (EObject)switchParam, (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.unused_local_variable", new String[0]);
        }
    }

    @Check
    public void checkTypeLiteral(XTypeLiteral typeLiteral) {
        if (!typeLiteral.getArrayDimensions().isEmpty() && typeLiteral.getType().getIdentifier().equals("void")) {
            this.error("'void" + Joiner.on("").join(typeLiteral.getArrayDimensions()) + "' is not a valid type", null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type", new String[0]);
        }
    }

    @Check
    public void checkImports(XImportSection importSection) {
        if (importSection.getImportDeclarations().isEmpty()) {
            return;
        }
        HashMap<String, List<XImportDeclaration>> imports = Maps.newHashMap();
        HashMap<String, List<XImportDeclaration>> staticImports = Maps.newHashMap();
        HashMap<String, List<XImportDeclaration>> extensionImports = Maps.newHashMap();
        HashMap<String, JvmType> importedNames = Maps.newHashMap();
        this.populateMaps(importSection, imports, staticImports, extensionImports, importedNames);
        this.checkConflicts(importSection, imports, importedNames);
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.import_unsued")) {
            XtextResource xtextResource = (XtextResource)importSection.eResource();
            ImportedTypesCollector importedTypesCollector = this.importedTypesCollectorProvider.get();
            TypeUsages typeUsages = importedTypesCollector.collectTypeUsages(xtextResource);
            for (JvmMember member : typeUsages.getStaticImports()) {
                if (typeUsages.getExtensionImports().contains(member)) {
                    if (this.removeStaticImport(extensionImports, member)) continue;
                    this.removeStaticImport(staticImports, member);
                    continue;
                }
                if (this.removeStaticImport(staticImports, member)) continue;
                this.removeStaticImport(extensionImports, member);
            }
            for (JvmMember member : typeUsages.getExtensionImports()) {
                this.removeStaticImport(extensionImports, member);
            }
            for (JvmDeclaredType type : typeUsages.getSimpleName2Types().values()) {
                if (this.removeTypeImport(imports, type)) continue;
                for (JvmType key : importedNames.values()) {
                    if (!this.isNestedTypeOf(key, type)) continue;
                    this.removeTypeImport(imports, key);
                }
            }
            this.addImportUnusedIssues(imports);
            this.addImportUnusedIssues(staticImports);
            this.addImportUnusedIssues(extensionImports);
        }
    }

    private boolean isNestedTypeOf(JvmType child, JvmDeclaredType parent) {
        if (child instanceof JvmMember) {
            JvmMember member = (JvmMember)((Object)child);
            return member.getDeclaringType() == parent;
        }
        return false;
    }

    private boolean removeStaticImport(Map<String, List<XImportDeclaration>> staticImports, JvmMember member) {
        JvmDeclaredType declaringType = member.getDeclaringType();
        String identifier = declaringType.getIdentifier();
        List<XImportDeclaration> list = staticImports.get(identifier);
        if (list == null) {
            return false;
        }
        if (list.size() == 1) {
            staticImports.remove(identifier);
            return true;
        }
        int indexToRemove = -1;
        for (int i = 0; i < list.size(); ++i) {
            XImportDeclaration staticImportDeclaration = list.get(i);
            if (staticImportDeclaration.isWildcard()) {
                if (indexToRemove != -1) continue;
                indexToRemove = i;
                continue;
            }
            if (!Objects.equal(member.getSimpleName(), staticImportDeclaration.getMemberName())) continue;
            indexToRemove = i;
            break;
        }
        if (indexToRemove == -1) {
            indexToRemove = 0;
        }
        list.remove(indexToRemove);
        return true;
    }

    private boolean removeTypeImport(Map<String, List<XImportDeclaration>> imports, JvmType declaringType) {
        String identifier = declaringType.getIdentifier();
        List<XImportDeclaration> list = imports.get(identifier);
        if (list == null) {
            return false;
        }
        if (list.size() == 1) {
            imports.remove(identifier);
            return true;
        }
        list.remove(0);
        return true;
    }

    protected void addImportUnusedIssues(Map<String, List<XImportDeclaration>> imports) {
        for (List<XImportDeclaration> importDeclarations : imports.values()) {
            for (XImportDeclaration importDeclaration : importDeclarations) {
                this.addIssue("The import '" + importDeclaration.getImportedName() + "' is never used.", importDeclaration, "org.eclipse.xtext.xbase.validation.IssueCodes.import_unsued");
            }
        }
    }

    protected void checkConflicts(XImportSection importSection, Map<String, List<XImportDeclaration>> imports, Map<String, JvmType> importedNames) {
        for (JvmDeclaredType declaredType : this.importsConfiguration.getLocallyDefinedTypes((XtextResource)importSection.eResource())) {
            List<XImportDeclaration> list;
            JvmType importedType;
            if (!importedNames.containsKey(declaredType.getSimpleName()) || (importedType = importedNames.get(declaredType.getSimpleName())) == declaredType || importedType.eResource() == importSection.eResource() || (list = imports.get(importedType.getIdentifier())) == null) continue;
            for (XImportDeclaration importDeclaration : list) {
                this.error("The import '" + importedType.getIdentifier() + "' conflicts with a type defined in the same file", (EObject)importDeclaration, null, "org.eclipse.xtext.xbase.validation.IssueCodes.import_conflict", new String[0]);
            }
        }
    }

    protected void populateMaps(XImportSection importSection, Map<String, List<XImportDeclaration>> imports, Map<String, List<XImportDeclaration>> staticImports, Map<String, List<XImportDeclaration>> extensionImports, Map<String, JvmType> importedNames) {
        for (XImportDeclaration imp : importSection.getImportDeclarations()) {
            Iterable<JvmFeature> allFeatures;
            if (imp.getImportedNamespace() != null) {
                this.addIssue("The use of wildcard imports is deprecated.", imp, "org.eclipse.xtext.xbase.validation.IssueCodes.import_wildcard_deprecated");
                continue;
            }
            JvmDeclaredType importedType = imp.getImportedType();
            if (importedType == null || importedType.eIsProxy()) continue;
            Map<String, List<XImportDeclaration>> map = imp.isStatic() ? (imp.isExtension() ? extensionImports : staticImports) : imports;
            List<XImportDeclaration> list = map.get(importedType.getIdentifier());
            if (list != null) {
                list.add(imp);
                continue;
            }
            list = Lists.newArrayListWithCapacity(2);
            list.add(imp);
            map.put(importedType.getIdentifier(), list);
            if (!imp.isStatic()) {
                JvmType currentType = importedType;
                String currentSuffix = currentType.getSimpleName();
                JvmType collidingImport = importedNames.put(currentSuffix, importedType);
                if (collidingImport != null) {
                    this.error("The import '" + importedType.getIdentifier() + "' collides with the import '" + collidingImport.getIdentifier() + "'.", (EObject)imp, null, "org.eclipse.xtext.xbase.validation.IssueCodes.import_collision", new String[0]);
                }
                while (currentType.eContainer() instanceof JvmType) {
                    currentSuffix = (currentType = (JvmType)currentType.eContainer()).getSimpleName() + "$" + currentSuffix;
                    JvmType collidingImport2 = importedNames.put(currentSuffix, importedType);
                    if (collidingImport2 == null) continue;
                    this.error("The import '" + importedType.getIdentifier() + "' collides with the import '" + collidingImport2.getIdentifier() + "'.", (EObject)imp, null, "org.eclipse.xtext.xbase.validation.IssueCodes.import_collision", new String[0]);
                }
                continue;
            }
            if (imp.isWildcard() || (allFeatures = this.staticallyImportedMemberProvider.getAllFeatures(imp)).iterator().hasNext()) continue;
            this.addIssue("The import " + imp.getImportedName() + " cannot be resolved.", imp, "org.eclipse.xtext.xbase.validation.IssueCodes.import_unresolved");
        }
    }

    @Check
    public void checkPrimitiveComparedToNull(XBinaryOperation binaryOperation) {
        LightweightTypeReference leftType;
        String operatorSymbol = binaryOperation.getConcreteSyntaxFeatureName();
        XExpression left = binaryOperation.getLeftOperand();
        XExpression right = binaryOperation.getRightOperand();
        if (right != null && right.eClass() == XbasePackage.Literals.XNULL_LITERAL || left != null && left.eClass() == XbasePackage.Literals.XNULL_LITERAL) {
            LightweightTypeReference leftType2;
            boolean equalsComparison;
            boolean bl = equalsComparison = this.expressionHelper.isOperatorFromExtension(binaryOperation, operatorSymbol, OperatorMapping.EQUALS, ObjectExtensions.class) || this.expressionHelper.isOperatorFromExtension(binaryOperation, operatorSymbol, OperatorMapping.NOT_EQUALS, ObjectExtensions.class);
            if (equalsComparison || this.expressionHelper.isOperatorFromExtension(binaryOperation, operatorSymbol, OperatorMapping.TRIPLE_NOT_EQUALS, ObjectExtensions.class) || this.expressionHelper.isOperatorFromExtension(binaryOperation, operatorSymbol, OperatorMapping.TRIPLE_EQUALS, ObjectExtensions.class)) {
                LightweightTypeReference rightType;
                LightweightTypeReference leftType3;
                if (right instanceof XNullLiteral && (leftType3 = this.getActualType(left)) != null) {
                    if (leftType3.isPrimitive()) {
                        this.error("The operator '" + operatorSymbol + "' is undefined for the argument types " + leftType3.getHumanReadableName() + " and null", (EObject)binaryOperation, null, "org.eclipse.xtext.xbase.validation.IssueCodes.primitive_compared_to_null", new String[0]);
                    } else if (equalsComparison) {
                        this.addIssue("The operator '" + operatorSymbol + "' should be replaced by '" + operatorSymbol + "=' when null is one of the arguments.", (EObject)binaryOperation, (EStructuralFeature)XbasePackage.eINSTANCE.getXAbstractFeatureCall_Feature(), "org.eclipse.xtext.xbase.validation.IssueCodes.equals_with_null", operatorSymbol);
                    }
                }
                if (left instanceof XNullLiteral && (rightType = this.getActualType(right)) != null) {
                    if (rightType.isPrimitive()) {
                        this.error("The operator '" + operatorSymbol + "' is undefined for the argument types null and " + rightType.getHumanReadableName(), (EObject)binaryOperation, null, "org.eclipse.xtext.xbase.validation.IssueCodes.primitive_compared_to_null", new String[0]);
                    } else if (equalsComparison && !(right instanceof XNullLiteral)) {
                        this.addIssue("The operator '" + operatorSymbol + "' should be replaced by '" + operatorSymbol + "=' when null is one of the arguments.", (EObject)binaryOperation, (EStructuralFeature)XbasePackage.eINSTANCE.getXAbstractFeatureCall_Feature(), "org.eclipse.xtext.xbase.validation.IssueCodes.equals_with_null", operatorSymbol);
                    }
                }
            } else if (this.expressionHelper.isOperatorFromExtension(binaryOperation, operatorSymbol, OperatorMapping.ELVIS, ObjectExtensions.class) && (leftType2 = this.getActualType(left)).isPrimitive()) {
                this.error("The operator '" + operatorSymbol + "' is undefined for arguments of type " + leftType2.getHumanReadableName(), (EObject)binaryOperation, null, "org.eclipse.xtext.xbase.validation.IssueCodes.primitive_compared_to_null", new String[0]);
            }
        } else if (this.expressionHelper.isOperatorFromExtension(binaryOperation, operatorSymbol, OperatorMapping.ELVIS, ObjectExtensions.class) && (leftType = this.getActualType(left)).isPrimitive()) {
            this.error("The operator '" + operatorSymbol + "' is undefined for arguments of type " + leftType.getHumanReadableName(), (EObject)binaryOperation, null, "org.eclipse.xtext.xbase.validation.IssueCodes.primitive_compared_to_null", new String[0]);
        }
    }

    protected boolean isLocallyUsed(EObject target, EObject containerToFindUsage) {
        if (this.readAndWriteTracking.isRead(target)) {
            return true;
        }
        Collection<EStructuralFeature.Setting> usages = XbaseUsageCrossReferencer.find(target, containerToFindUsage);
        if (target instanceof XVariableDeclaration || target instanceof JvmField) {
            for (EStructuralFeature.Setting usage : usages) {
                EObject object = usage.getEObject();
                if (object instanceof XAssignment) {
                    XAssignment assignment = (XAssignment)object;
                    if (assignment.getFeature() == target) continue;
                    return true;
                }
                return true;
            }
            return false;
        }
        if (!(target instanceof JvmOperation) || ((JvmOperation)target).getVisibility() != JvmVisibility.PRIVATE) {
            return !usages.isEmpty();
        }
        EObject targetSourceElem = this.associations.getPrimarySourceElement(target);
        for (EStructuralFeature.Setting s2 : usages) {
            if (s2.getEObject() instanceof XAbstractFeatureCall) {
                XAbstractFeatureCall fc = (XAbstractFeatureCall)s2.getEObject();
                if (fc.getFeature() == target && EcoreUtil.isAncestor(targetSourceElem, (EObject)fc)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    protected List<EPackage> getEPackages() {
        return Lists.newArrayList(XbasePackage.eINSTANCE, XtypePackage.eINSTANCE, TypesPackage.eINSTANCE);
    }

    protected String canonicalName(LightweightTypeReference typeRef) {
        return typeRef == null ? "<null>" : typeRef.getHumanReadableName();
    }

    protected boolean isInterface(JvmType type) {
        return type instanceof JvmGenericType && ((JvmGenericType)type).isInterface();
    }

    protected XExpressionHelper getExpressionHelper() {
        return this.expressionHelper;
    }

    @Check
    public void checkNoJavaStyleTypeCasting(XBlockExpression blockExpression) {
        if (this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.java_style_type_cast")) {
            return;
        }
        if (blockExpression.getExpressions().size() <= 1) {
            return;
        }
        ICompositeNode node = NodeModelUtils.getNode(blockExpression);
        if (node == null) {
            return;
        }
        INode expressionNode = null;
        for (INode child : node.getChildren()) {
            if (this.isSemicolon(child)) {
                expressionNode = null;
                continue;
            }
            if (!this.isXExpressionInsideBlock(child)) continue;
            if (expressionNode != null) {
                this.checkNoJavaStyleTypeCasting(expressionNode);
            }
            expressionNode = child;
        }
    }

    protected boolean isXExpressionInsideBlock(INode child) {
        return child.getGrammarElement() == this.grammarAccess.getXBlockExpressionAccess().getExpressionsXExpressionOrVarDeclarationParserRuleCall_2_0_0() || child.getGrammarElement() == this.grammarAccess.getXExpressionInClosureAccess().getExpressionsXExpressionOrVarDeclarationParserRuleCall_1_0_0();
    }

    protected boolean isSemicolon(INode child) {
        return child.getGrammarElement() == this.grammarAccess.getXBlockExpressionAccess().getSemicolonKeyword_2_1() || child.getGrammarElement() == this.grammarAccess.getXExpressionInClosureAccess().getSemicolonKeyword_1_1();
    }

    protected void checkNoJavaStyleTypeCasting(INode node) {
        XAbstractFeatureCall featureCall;
        INode expressionNode;
        EObject semanticObject;
        BidiIterator iterator = node.getAsTreeIterable().reverse().iterator();
        ILeafNode child = this.getFirstLeafNode((BidiTreeIterator<INode>)iterator);
        if (child != null && child.getGrammarElement() == this.grammarAccess.getXParenthesizedExpressionAccess().getRightParenthesisKeyword_2() && ((semanticObject = NodeModelUtils.findActualSemanticObjectFor(expressionNode = this.getNode((BidiTreeIterator<INode>)iterator, this.grammarAccess.getXParenthesizedExpressionAccess().getXExpressionParserRuleCall_1()))) instanceof XFeatureCall || semanticObject instanceof XMemberFeatureCall) && (featureCall = (XAbstractFeatureCall)semanticObject).isTypeLiteral()) {
            ICompositeNode parenthesizedNode = child.getParent();
            ITextRegion parenthesizedRegion = parenthesizedNode.getTextRegion();
            this.addIssue("Use 'as' keyword for type casting.", (EObject)featureCall, parenthesizedRegion.getOffset(), parenthesizedRegion.getLength(), "org.eclipse.xtext.xbase.validation.IssueCodes.java_style_type_cast");
        }
    }

    protected INode getNode(BidiTreeIterator<INode> iterator, EObject ... grammarElements) {
        while (iterator.hasNext()) {
            INode node = iterator.next();
            EObject grammarElement = node.getGrammarElement();
            for (EObject expectedGrammarElement : grammarElements) {
                if (grammarElement != expectedGrammarElement) continue;
                return node;
            }
        }
        return null;
    }

    protected ILeafNode getFirstLeafNode(BidiTreeIterator<INode> iterator) {
        while (iterator.hasNext()) {
            INode child = iterator.next();
            if (this.isHidden(child) || !(child instanceof ILeafNode)) continue;
            return (ILeafNode)child;
        }
        return null;
    }

    protected boolean isHidden(INode child) {
        return child instanceof ILeafNode && ((ILeafNode)child).isHidden();
    }

    @Check
    public void checkRedundantCase(XSwitchExpression switchExpression) {
        XCasePart casePart = IterableExtensions.last(switchExpression.getCases());
        if (casePart == null || !casePart.isFallThrough() || casePart.getThen() != null) {
            return;
        }
        if (switchExpression.getDefault() == null) {
            this.error("Redundant case.", (EObject)casePart, null, "org.eclipse.xtext.xbase.validation.IssueCodes.redundant_case", new String[0]);
        } else {
            this.warning("Redundant case.", (EObject)casePart, null, "org.eclipse.xtext.xbase.validation.IssueCodes.redundant_case", new String[0]);
        }
    }

    @Check
    public void checkDuplicatedCases(XSwitchExpression switchExpression) {
        LightweightTypeReference switchType = this.typeResolver.resolveTypes(switchExpression).getActualType(switchExpression.getSwitch());
        if (switchType == null || switchType.isType(Boolean.TYPE) || switchType.isUnknown()) {
            return;
        }
        HashMap typeGuards = Maps.newHashMap();
        for (XCasePart casePart : switchExpression.getCases()) {
            XExpression caseExpression = casePart.getCase();
            if (caseExpression == null) continue;
            String typeGuardName = switchType.getType().getQualifiedName();
            JvmTypeReference typeGuard = casePart.getTypeGuard();
            if (typeGuard != null) {
                typeGuardName = typeGuard.getQualifiedName();
            }
            try {
                HashMultimap<Object, XCasePart> duplicatedCases;
                Object result = this.switchConstantExpressionsInterpreter.evaluate(caseExpression, true);
                if (result instanceof JvmTypeReference) {
                    JvmTypeReference jvmTypeReference = (JvmTypeReference)result;
                    result = jvmTypeReference.getType();
                }
                if ((duplicatedCases = (HashMultimap<Object, XCasePart>)typeGuards.get(typeGuardName)) == null) {
                    duplicatedCases = HashMultimap.create();
                    typeGuards.put(typeGuardName, duplicatedCases);
                }
                duplicatedCases.put(result, casePart);
            }
            catch (ConstantExpressionEvaluationException constantExpressionEvaluationException) {}
        }
        for (Multimap duplicatedCases : typeGuards.values()) {
            for (Object result : duplicatedCases.keySet()) {
                Collection cases = duplicatedCases.get(result);
                if (cases.size() <= 1) continue;
                for (XCasePart casePart : cases) {
                    this.error("Duplicate case", (EObject)casePart.getCase(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_case", new String[0]);
                }
            }
        }
    }

    @Check
    public void checkTypeGuardsOrder(XSwitchExpression expression) {
        if (this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_case")) {
            return;
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.getServices(), expression);
        ArrayList<LightweightTypeReference> previousTypeReferences = new ArrayList<LightweightTypeReference>();
        for (XCasePart casePart : expression.getCases()) {
            LightweightTypeReference actualType;
            JvmTypeReference typeGuard = casePart.getTypeGuard();
            if (typeGuard == null || (actualType = owner.toLightweightTypeReference(typeGuard)) == null) continue;
            if (this.isHandled(actualType, previousTypeReferences)) {
                this.addIssue("Unreachable code: The case can never match. It is already handled by a previous condition.", typeGuard, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_case");
                continue;
            }
            if (casePart.getCase() != null) continue;
            previousTypeReferences.add(actualType);
        }
    }

    @Check
    public void checkTypeGuardsOrderWithGenerics(XSwitchExpression expression) {
        if (this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_case")) {
            return;
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.getServices(), expression);
        ArrayList<LightweightTypeReference> previousTypeReferences = new ArrayList<LightweightTypeReference>();
        for (XCasePart casePart : expression.getCases()) {
            LightweightTypeReference typeReference;
            LightweightTypeReference actualType;
            JvmTypeReference typeGuard = casePart.getTypeGuard();
            if (typeGuard == null || (actualType = (typeReference = owner.toLightweightTypeReference(typeGuard)).getRawTypeReference()) == null || typeReference == actualType) continue;
            if (this.isHandled(actualType, previousTypeReferences)) {
                this.addIssue("Unreachable code: The case can never match. It is already handled by a previous condition (with the same type erasure).", typeGuard, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_case");
                continue;
            }
            if (casePart.getCase() != null) continue;
            previousTypeReferences.add(actualType);
        }
    }

    @Check
    public void checkInstanceOfOrder(XIfExpression expression) {
        XIfExpression container;
        if (this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_instance_of")) {
            return;
        }
        if (expression.eContainer() instanceof XIfExpression && (container = (XIfExpression)expression.eContainer()).getElse() == expression) {
            return;
        }
        List<XExpression> ifParts = this.collectIfParts(expression, new ArrayList<XExpression>());
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.getServices(), expression);
        HashMultimap<JvmIdentifiableElement, LightweightTypeReference> previousTypeReferences = HashMultimap.create();
        for (XExpression ifPart : ifParts) {
            JvmTypeReference type;
            LightweightTypeReference actualType;
            XAbstractFeatureCall featureCall;
            JvmIdentifiableElement feature;
            XInstanceOfExpression instanceOfExpression;
            if (!(ifPart instanceof XInstanceOfExpression) || !((instanceOfExpression = (XInstanceOfExpression)ifPart).getExpression() instanceof XAbstractFeatureCall) || !((feature = (featureCall = (XAbstractFeatureCall)instanceOfExpression.getExpression()).getFeature()) instanceof XVariableDeclaration) && !(feature instanceof JvmField) && !(feature instanceof JvmFormalParameter) || (actualType = owner.toLightweightTypeReference(type = instanceOfExpression.getType())) == null) continue;
            if (this.isHandled(actualType, previousTypeReferences.get(feature))) {
                this.addIssue("Unreachable code: The if condition can never match. It is already handled by a previous condition.", type, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_instance_of");
                continue;
            }
            previousTypeReferences.put(feature, actualType);
        }
    }

    private List<XExpression> collectIfParts(XIfExpression expression, List<XExpression> result) {
        result.add(expression.getIf());
        if (expression.getElse() instanceof XIfExpression) {
            this.collectIfParts((XIfExpression)expression.getElse(), result);
        }
        return result;
    }

    @Check
    public void checkCatchClausesOrder(XTryCatchFinallyExpression expression) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.getServices(), expression);
        ArrayList<LightweightTypeReference> previousTypeReferences = new ArrayList<LightweightTypeReference>();
        for (XCatchClause catchClause : expression.getCatchClauses()) {
            LightweightTypeReference actualTypeReference = owner.toLightweightTypeReference(catchClause.getDeclaredParam().getParameterType());
            if (actualTypeReference == null) continue;
            if (this.isHandled(actualTypeReference, previousTypeReferences)) {
                this.error("Unreachable code: The catch block can never match. It is already handled by a previous condition.", (EObject)catchClause.getDeclaredParam().getParameterType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_catch_block", new String[0]);
                continue;
            }
            previousTypeReferences.add(actualTypeReference);
        }
    }

    protected boolean isHandled(LightweightTypeReference actualTypeReference, Collection<LightweightTypeReference> collection) {
        return this.typesOrderUtil.isHandled(actualTypeReference, collection);
    }

    @Check
    public void checkIncompleteCasesOnEnum(XSwitchExpression switchExpression) {
        if (this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.incomplete_cases_on_enum")) {
            return;
        }
        if (switchExpression.getDefault() != null) {
            return;
        }
        LightweightTypeReference switchType = this.switchExpressions.getSwitchVariableType(switchExpression);
        if (switchType == null || switchType.isUnknown()) {
            return;
        }
        if (!switchType.isSubtypeOf(Enum.class) || !(switchType.getType() instanceof JvmEnumerationType)) {
            return;
        }
        JvmEnumerationType enumerationType = (JvmEnumerationType)switchType.getType();
        List<String> expectedEnumerationLiterals = IterableExtensions.toList(IterableExtensions.map(enumerationType.getLiterals(), new Functions.Function1<JvmEnumerationLiteral, String>(){

            @Override
            public String apply(JvmEnumerationLiteral enumerationLiteral) {
                return enumerationLiteral.getSimpleName();
            }
        }));
        for (XCasePart casePart : switchExpression.getCases()) {
            if (!this.switchExpressions.isJavaCaseExpression(switchExpression, casePart)) {
                return;
            }
            try {
                Object result = this.switchConstantExpressionsInterpreter.evaluate(casePart.getCase());
                if (!(result instanceof JvmEnumerationLiteral)) {
                    return;
                }
                JvmEnumerationLiteral enumerationLiteral = (JvmEnumerationLiteral)result;
                expectedEnumerationLiterals.remove(enumerationLiteral.getSimpleName());
            }
            catch (ConstantExpressionEvaluationException result) {}
        }
        if (expectedEnumerationLiterals.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (expectedEnumerationLiterals.size() == 1) {
            builder.append("The enum constant ");
        } else {
            builder.append("The enum constants ");
        }
        ListIterator<String> enumLiteralIter = expectedEnumerationLiterals.listIterator();
        while (enumLiteralIter.hasNext()) {
            String expectedEnumerationLiteral = enumLiteralIter.next();
            if (enumLiteralIter.previousIndex() > 0) {
                if (enumLiteralIter.nextIndex() == expectedEnumerationLiterals.size()) {
                    builder.append(" and ");
                } else {
                    builder.append(", ");
                }
            }
            builder.append(expectedEnumerationLiteral);
        }
        if (expectedEnumerationLiterals.size() == 1) {
            builder.append(" needs a corresponding case label in this enum switch on ");
        } else {
            builder.append(" need corresponding case labels in this enum switch on ");
        }
        builder.append(enumerationType.getQualifiedName());
        String message = builder.toString();
        this.addIssue(message, (EObject)switchExpression.getSwitch(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.incomplete_cases_on_enum", expectedEnumerationLiterals.toArray(new String[0]));
    }

    @Check
    public void checkAssignment(XBinaryOperation binaryOperation) {
        if (binaryOperation.isReassignFirstArgument()) {
            XExpression leftOperand = binaryOperation.getLeftOperand();
            this.checkAssignment(leftOperand, false);
        }
    }

    @Check
    public void checkOperandTypesForTripleEquals(XBinaryOperation binaryOperation) {
        if (this.isTripleEqualsOperation(binaryOperation)) {
            LightweightTypeReference left = this.getActualType(binaryOperation.getLeftOperand());
            LightweightTypeReference right = this.getActualType(binaryOperation.getRightOperand());
            if (left.isArray() != right.isArray()) {
                if (left.isArray() ? right.isAny() || right.isType(Object.class) || right.isType(Serializable.class) || right.isType(Cloneable.class) : left.isAny() || left.isType(Object.class) || left.isType(Serializable.class) || left.isType(Cloneable.class)) {
                    return;
                }
                this.error("Incompatible operand types " + left.getHumanReadableName() + " and " + right.getHumanReadableName(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_operand_types", new String[0]);
            }
        }
    }

    protected boolean isTripleEqualsOperation(XBinaryOperation binaryOperation) {
        String syntax = binaryOperation.getConcreteSyntaxFeatureName();
        return syntax.equals(OperatorMapping.TRIPLE_EQUALS.toString()) || syntax.equals(OperatorMapping.TRIPLE_NOT_EQUALS.toString());
    }

    @Check
    public void checkAssignment(XPostfixOperation postfixOperation) {
        if (this.expressionHelper.isGetAndAssign(postfixOperation)) {
            XExpression firstArgument = (XExpression)postfixOperation.getActualArguments().get(0);
            this.checkAssignment(firstArgument, false);
        }
    }

    @Check
    public void checkExplicitOperationCall(XFeatureCall featureCall) {
        if (featureCall.getFeature() instanceof JvmOperation && !featureCall.isExplicitOperationCallOrBuilderSyntax() && featureCall.getFeature().getSimpleName().equals(featureCall.getConcreteSyntaxFeatureName())) {
            this.addIssue("Method call without parentheses", (EObject)featureCall, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, "org.eclipse.xtext.xbase.validation.IssueCodes.operation_without_parentheses", new String[0]);
        }
    }

    @Check
    public void checkExplicitOperationCall(XMemberFeatureCall featureCall) {
        if (featureCall.getFeature() instanceof JvmOperation && !featureCall.isExplicitOperationCallOrBuilderSyntax() && featureCall.getFeature().getSimpleName().equals(featureCall.getConcreteSyntaxFeatureName())) {
            this.addIssue("Method call without parentheses", (EObject)featureCall, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, "org.eclipse.xtext.xbase.validation.IssueCodes.operation_without_parentheses", new String[0]);
        }
    }

    @Check
    public void checkExplicitOperationCall(XConstructorCall constructorCall) {
        if (!constructorCall.isExplicitConstructorCall() && constructorCall.getArguments().isEmpty()) {
            this.addIssue("Constructor call without parentheses", constructorCall, "org.eclipse.xtext.xbase.validation.IssueCodes.operation_without_parentheses");
        }
    }

    protected void checkAssignment(XExpression expression, boolean simpleAssignment) {
        this.checkAssignment(expression, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, simpleAssignment);
    }

    protected void checkAssignment(XExpression expression, EStructuralFeature feature, boolean simpleAssignment) {
        if (!(expression instanceof XAbstractFeatureCall)) {
            this.error("The left-hand side of an assignment must be a variable", (EObject)expression, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_no_variable", new String[0]);
            return;
        }
        XAbstractFeatureCall assignment = (XAbstractFeatureCall)expression;
        JvmIdentifiableElement assignmentFeature = assignment.getFeature();
        if (assignmentFeature instanceof XVariableDeclaration) {
            XVariableDeclaration variableDeclaration = (XVariableDeclaration)assignmentFeature;
            if (variableDeclaration.isWriteable()) {
                return;
            }
            this.error("Assignment to final variable", (EObject)expression, feature, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final", new String[0]);
        } else if (assignmentFeature instanceof JvmFormalParameter) {
            this.error("Assignment to final parameter", (EObject)expression, feature, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final", new String[0]);
        } else if (assignmentFeature instanceof JvmField) {
            JvmIdentifiableElement container;
            JvmField field = (JvmField)assignmentFeature;
            if (!field.isFinal()) {
                return;
            }
            if (simpleAssignment && (container = this.logicalContainerProvider.getNearestLogicalContainer(assignment)) != null && container instanceof JvmConstructor) {
                JvmConstructor constructor = (JvmConstructor)container;
                if (field.getDeclaringType() == constructor.getDeclaringType()) {
                    return;
                }
            }
            this.error("Assignment to final field", (EObject)expression, feature, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_final", new String[0]);
        } else if (!simpleAssignment) {
            this.error("The left-hand side of an assignment must be a variable", (EObject)expression, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.assignment_to_no_variable", new String[0]);
        }
    }

    protected ILogicalContainerProvider getLogicalContainerProvider() {
        return this.logicalContainerProvider;
    }

    private String getQualifiedSimpleName(JvmIdentifiableElement element) {
        if (element.eContainer() instanceof JvmType) {
            return this.getQualifiedSimpleName((JvmIdentifiableElement)element.eContainer()) + "." + element.getSimpleName();
        }
        return element.getSimpleName();
    }

    protected void checkDeprecated(JvmIdentifiableElement object, EObject source, EStructuralFeature structuralFeature) {
        JvmMember member;
        if (object instanceof JvmMember && object.eResource() != source.eResource() && DeprecationUtil.isTransitivelyDeprecatedMember(member = (JvmMember)object)) {
            JvmMember containingMember;
            JvmIdentifiableElement logicalContainer = this.getLogicalContainerProvider().getNearestLogicalContainer(source);
            if (logicalContainer != null && DeprecationUtil.isTransitivelyDeprecatedMember(containingMember = EcoreUtil2.getContainerOfType(logicalContainer, JvmMember.class))) {
                return;
            }
            String message = null;
            if (member instanceof JvmOperation) {
                JvmIdentifiableElement container = (JvmIdentifiableElement)member.eContainer();
                message = String.format("The %s %s%s from the %s %s is deprecated", FeatureKinds.getTypeName(member), object.getSimpleName(), this.uiStrings.parameters(member), FeatureKinds.getTypeName(container), this.getQualifiedSimpleName(container));
            } else if (member instanceof JvmField) {
                JvmIdentifiableElement container = (JvmIdentifiableElement)member.eContainer();
                message = String.format("The %s %s.%s is deprecated", FeatureKinds.getTypeName(member), this.getQualifiedSimpleName(container), object.getSimpleName());
            } else {
                message = member instanceof JvmConstructor ? String.format("The %s %s%s is deprecated", FeatureKinds.getTypeName(member), this.getQualifiedSimpleName(member.getDeclaringType()), this.uiStrings.parameters(member)) : String.format("The %s %s is deprecated", FeatureKinds.getTypeName(member), this.getQualifiedSimpleName(object));
            }
            this.addIssue(message, source, structuralFeature, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference", new String[0]);
        }
    }

    @Check
    public void checkDeprecated(JvmParameterizedTypeReference type) {
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference")) {
            JvmType jvmType = type.getType();
            this.checkDeprecated(jvmType, type, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        }
    }

    @Check
    public void checkDeprecated(XImportDeclaration decl) {
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference")) {
            JvmDeclaredType jvmType = decl.getImportedType();
            this.checkDeprecated(jvmType, decl, XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE);
        }
    }

    @Check
    public void checkDeprecated(XAbstractFeatureCall expression) {
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference")) {
            JvmIdentifiableElement feature = expression.getFeature();
            this.checkDeprecated(feature, expression, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
        }
    }

    @Check
    public void checkDeprecated(XConstructorCall expression) {
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference")) {
            JvmConstructor constructor = expression.getConstructor();
            this.checkDeprecated(constructor, expression, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR);
        }
    }

    @Check
    public void checkDeprecated(XTypeLiteral expression) {
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.deprecated_member_reference")) {
            JvmType jvmType = expression.getType();
            this.checkDeprecated(jvmType, expression, XbasePackage.Literals.XTYPE_LITERAL__TYPE);
        }
    }

    @Check
    public void checkReferInvalidTypes(XAbstractFeatureCall featureCall) {
        this.checkReferInvalidTypes(featureCall.getFeature(), featureCall, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
    }

    @Check
    public void checkReferInvalidTypes(XConstructorCall constructorCall) {
        this.checkReferInvalidTypes(constructorCall.getConstructor(), constructorCall, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR);
    }

    protected void checkReferInvalidTypes(JvmIdentifiableElement element, EObject source, EReference structuralFeature) {
        LightweightTypeReference referencedInvalidType = this.referencedInvalidTypeFinder.findReferencedInvalidType(element);
        String message = this.getReferInvalidTypeMessage(element, referencedInvalidType);
        if (message != null) {
            this.error(message, source, (EStructuralFeature)structuralFeature, "org.eclipse.xtext.xbase.validation.IssueCodes.refer_invalid_types", new String[0]);
        }
    }

    protected String getReferInvalidTypeMessage(JvmIdentifiableElement element, LightweightTypeReference referencedInvalidType) {
        if (referencedInvalidType == null) {
            return null;
        }
        if (referencedInvalidType.isPrimitiveVoid()) {
            if (element instanceof JvmField) {
                JvmField field = (JvmField)element;
                return String.format("The %s %s.%s has an illegal argument type", FeatureKinds.getTypeName(field), this.getQualifiedSimpleName(field.getDeclaringType()), field.getSimpleName());
            }
            if (element instanceof JvmOperation) {
                JvmOperation operation = (JvmOperation)element;
                return String.format("The %s %s%s from the %s %s has an illegal argument type", FeatureKinds.getTypeName(operation), operation.getSimpleName(), this.uiStrings.parameters(operation), FeatureKinds.getTypeName(operation.getDeclaringType()), this.getQualifiedSimpleName(operation.getDeclaringType()));
            }
            if (element instanceof JvmConstructor) {
                JvmConstructor constructor = (JvmConstructor)element;
                return String.format("The %s %s%s has an illegal argument type", FeatureKinds.getTypeName(constructor), this.getQualifiedSimpleName(constructor.getDeclaringType()), this.uiStrings.parameters(constructor));
            }
        }
        if (referencedInvalidType.isUnknown()) {
            if (element instanceof JvmField) {
                JvmField field = (JvmField)element;
                return String.format("The %s %s.%s refers to the missing type %s", FeatureKinds.getTypeName(field), this.getQualifiedSimpleName(field.getDeclaringType()), field.getSimpleName(), referencedInvalidType.getHumanReadableName());
            }
            if (element instanceof JvmOperation) {
                JvmOperation operation = (JvmOperation)element;
                return String.format("The %s %s%s from the %s %s refers to the missing type %s", FeatureKinds.getTypeName(operation), operation.getSimpleName(), this.uiStrings.parameters(operation), FeatureKinds.getTypeName(operation.getDeclaringType()), this.getQualifiedSimpleName(operation.getDeclaringType()), referencedInvalidType.getHumanReadableName());
            }
            if (element instanceof JvmConstructor) {
                JvmConstructor constructor = (JvmConstructor)element;
                return String.format("The %s %s%s refers to the missing type %s", FeatureKinds.getTypeName(constructor), this.getQualifiedSimpleName(constructor.getDeclaringType()), this.uiStrings.parameters(constructor), referencedInvalidType.getHumanReadableName());
            }
        }
        return null;
    }
}

