/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.conversion.impl.KeywordAlternativeConverter;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;

@Singleton
public class XtextValueConverters
extends DefaultTerminalConverters {
    @Inject
    private Provider<KeywordAlternativeConverter> validIDConverter;

    @ValueConverter(rule="ValidID")
    public IValueConverter<String> ValidID() {
        return this.validIDConverter.get();
    }

    @ValueConverter(rule="GrammarID")
    public IValueConverter<String> GrammarID() {
        return new AbstractNullSafeConverter<String>(){

            @Override
            protected String internalToValue(String string, INode node) throws ValueConverterException {
                if (node != null) {
                    StringBuilder result = new StringBuilder();
                    for (ILeafNode leaf : node.getLeafNodes()) {
                        if (leaf.isHidden()) continue;
                        if (leaf.getGrammarElement() instanceof Keyword) {
                            result.append(leaf.getText());
                            continue;
                        }
                        result.append(XtextValueConverters.this.ID().toValue(leaf.getText(), leaf));
                    }
                    return result.toString();
                }
                String[] splitted = string.split("\\.");
                StringBuilder result = new StringBuilder(string.length());
                for (int i = 0; i < splitted.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(XtextValueConverters.this.ID().toValue(splitted[i], null));
                }
                return result.toString();
            }

            @Override
            protected String internalToString(String value) {
                String[] splitted = value.split("\\.");
                StringBuilder result = new StringBuilder(value.length());
                for (int i = 0; i < splitted.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(XtextValueConverters.this.ID().toString(splitted[i]));
                }
                return result.toString();
            }
        };
    }

    @ValueConverter(rule="RuleID")
    public IValueConverter<String> RuleID() {
        return new AbstractNullSafeConverter<String>(){

            @Override
            protected String internalToValue(String string, INode node) throws ValueConverterException {
                if (node != null) {
                    StringBuilder result = new StringBuilder();
                    for (ILeafNode leaf : node.getLeafNodes()) {
                        if (leaf.isHidden()) continue;
                        if (leaf.getGrammarElement() instanceof Keyword) {
                            result.append(".");
                            continue;
                        }
                        result.append(XtextValueConverters.this.ID().toValue(leaf.getText(), leaf));
                    }
                    return result.toString();
                }
                String[] splitted = string.split("\\.");
                StringBuilder result = new StringBuilder(string.length());
                for (int i = 0; i < splitted.length; ++i) {
                    if (i != 0) {
                        result.append('.');
                    }
                    result.append(XtextValueConverters.this.ID().toValue(splitted[i], null));
                }
                return result.toString();
            }

            @Override
            protected String internalToString(String value) {
                String[] splitted = value.split("\\.");
                StringBuilder result = new StringBuilder(value.length());
                for (int i = 0; i < splitted.length; ++i) {
                    if (i != 0) {
                        result.append("::");
                    }
                    result.append(XtextValueConverters.this.ID().toString(splitted[i]));
                }
                return result.toString();
            }
        };
    }

    @ValueConverter(rule="LiteralValue")
    public IValueConverter<Boolean> LiteralValue() {
        return new AbstractNullSafeConverter<Boolean>(){

            @Override
            protected Boolean internalToValue(String string, INode node) throws ValueConverterException {
                return "+".equals(string);
            }

            @Override
            protected String internalToString(Boolean value) {
                return value != false ? "+" : "!";
            }
        };
    }
}

