/*
 * Decompiled with CFR 0.152.
 */
package es.weso.acota.core.utils;

import es.weso.acota.core.utils.ExternalizableConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ResourceLoader
implements ExternalizableConfiguration {
    protected static final int TEMP_DIR_ATTEMPTS = 10000;
    protected PropertiesConfiguration configuration = new PropertiesConfiguration();

    public ResourceLoader() {
        try {
            this.configuration.addProperty("opennlp.es.pos", (Object)this.loadTmpFile("resources/open_nlp/es/", "SpanishPOS.bin"));
            this.configuration.addProperty("opennlp.es.sent", (Object)this.loadTmpFile("resources/open_nlp/es/", "SpanishSent.bin"));
            this.configuration.addProperty("opennlp.es.tok", (Object)this.loadTmpFile("resources/open_nlp/es/", "SpanishTok.bin"));
            this.configuration.addProperty("opennlp.en.pos", (Object)this.loadTmpFile("resources/open_nlp/en/", "EnglishPOS.bin"));
            this.configuration.addProperty("opennlp.en.sent", (Object)this.loadTmpFile("resources/open_nlp/en/", "EnglishSent.bin"));
            this.configuration.addProperty("opennlp.en.tok", (Object)this.loadTmpFile("resources/open_nlp/en/", "EnglishTok.bin"));
            this.configuration.addProperty("wordnet.en.dict", (Object)this.loadTmpDirectory("resources/wordnet_30/en/", "dict/"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PropertiesConfiguration getConfiguration() {
        return this.configuration;
    }

    private String loadTmpFile(String path, String name) throws IOException {
        File tmpDir = this.createTempDir();
        tmpDir.deleteOnExit();
        String tmpPath = tmpDir.getPath();
        return this.createFile(path, tmpPath, name);
    }

    private String loadTmpDirectory(String path, String name) throws IOException {
        String[] files;
        File tmpDir = this.createTempDir();
        tmpDir.deleteOnExit();
        String tmpPath = tmpDir.getPath();
        Properties prop = new Properties();
        prop.load(this.getClass().getClassLoader().getResourceAsStream("resources/inner.acota.utils.properties"));
        for (String file : files = ((String)prop.get("wordnet_files")).split(",")) {
            this.createFile(path + name, tmpPath + "/", file.trim());
        }
        return tmpPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFile(String innerPath, String externPath, String name) throws IOException {
        innerPath = innerPath.endsWith(File.separator) ? innerPath : innerPath + File.separator;
        externPath = externPath.endsWith(File.separator) ? externPath : externPath + File.separator;
        File file = new File(externPath + name);
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(innerPath + name);
        int read = 0;
        byte[] bytes = new byte[1024];
        try {
            while ((read = inputStream.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            inputStream.close();
        }
        finally {
            out.flush();
            ((OutputStream)out).close();
        }
        return file.getAbsolutePath().toString();
    }

    private File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }
}

