/*
 * Decompiled with CFR 0.152.
 */
package es.weso.depgraphs;

import es.weso.depgraphs.Both$;
import es.weso.depgraphs.DepGraph$;
import es.weso.depgraphs.Neg$;
import es.weso.depgraphs.Pos$;
import es.weso.depgraphs.PosNeg;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3$;
import scala.collection.IterableOps;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public interface DepGraph<Node> {
    public static <Node> DepGraph<Node> makeGraph(Set<Tuple2<Node, Set<Tuple2<PosNeg, Node>>>> set) {
        return DepGraph$.MODULE$.makeGraph(set);
    }

    public Set<Node> nodes();

    public DepGraph<Node> addNode(Node var1);

    public DepGraph<Node> addEdge(Node var1, PosNeg var2, Node var3);

    public static DepGraph addPosEdge$(DepGraph $this, Object node1, Object node2) {
        return $this.addPosEdge(node1, node2);
    }

    default public DepGraph<Node> addPosEdge(Node node1, Node node2) {
        return this.addEdge(node1, Pos$.MODULE$, node2);
    }

    public static DepGraph addNegEdge$(DepGraph $this, Object node1, Object node2) {
        return $this.addNegEdge(node1, node2);
    }

    default public DepGraph<Node> addNegEdge(Node node1, Node node2) {
        return this.addEdge(node1, Neg$.MODULE$, node2);
    }

    public Either<String, Set<Tuple2<PosNeg, Node>>> outEdges(Node var1);

    public Either<String, Set<Tuple2<Node, PosNeg>>> inEdges(Node var1);

    public DepGraph<Node> empty();

    public static boolean containsNegCycle$(DepGraph $this) {
        return $this.containsNegCycle();
    }

    default public boolean containsNegCycle() {
        return !this.negCycles().isEmpty();
    }

    public Set<Set<Tuple2<Node, Node>>> negCycles();

    public static Set oddNegCycles$(DepGraph $this) {
        return $this.oddNegCycles();
    }

    default public Set<Set<Tuple2<Node, Node>>> oddNegCycles() {
        Set<Set<Tuple2<Node, Node>>> nc = this.negCycles();
        return (Set)nc.filter((Function1 & Serializable)_$1 -> this.countNegLinks((Set<Tuple2<Node, Node>>)_$1) % 2 == 1);
    }

    public static int countNegLinks$(DepGraph $this, Set nodes) {
        return $this.countNegLinks(nodes);
    }

    default public int countNegLinks(Set<Tuple2<Node, Node>> nodes) {
        int n = nodes.size();
        if (0 == n) {
            return 0;
        }
        Set negs = (Set)((IterableOps)nodes.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object n1 = tuple2._1();
                Object n2 = tuple2._2();
                return Tuple3$.MODULE$.apply(n1, n2, (Object)BoxesRunTime.boxToBoolean((boolean)this.haveNegativeLink(n1, n2)));
            }
            throw new MatchError((Object)tuple2);
        })).filter((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToBoolean((Object)_$2._3()));
        int n2 = negs.size();
        return n2;
    }

    public Option<PosNeg> edgeBetween(Node var1, Node var2);

    private boolean haveNegativeLink(Node node1, Node node2) {
        Option<PosNeg> option = this.edgeBetween(node1, node2);
        if (option instanceof Some) {
            PosNeg posNeg = (PosNeg)((Some)option).value();
            if (Neg$.MODULE$.equals(posNeg)) {
                return true;
            }
            if (Pos$.MODULE$.equals(posNeg)) {
                return false;
            }
            if (Both$.MODULE$.equals(posNeg)) {
                return true;
            }
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public String showEdges(Function1<Node, String> var1);

    public static Function1 showEdges$default$1$(DepGraph $this) {
        return $this.showEdges$default$1();
    }

    default public Function1<Node, String> showEdges$default$1() {
        return (Function1 & Serializable)x -> x.toString();
    }

    public Either<String, BoxedUnit> isomorphicWith(DepGraph<Node> var1);
}

