/*
 * Decompiled with CFR 0.152.
 */
package es.weso.schema;

import cats.effect.IO;
import cats.effect.IO$;
import es.weso.rdf.RDFReader;
import es.weso.schema.JenaShacl$;
import es.weso.schema.Schema;
import es.weso.schema.ShExSchema$;
import es.weso.schema.ShaclTQ;
import es.weso.schema.ShaclTQ$;
import es.weso.schema.ShaclexSchema$;
import es.weso.schema.ValidationTrigger$;
import es.weso.utils.FileUtils$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Schemas$ {
    public static final Schemas$ MODULE$ = new Schemas$();
    private static Schema shEx;
    private static Schema shaclex;
    private static Schema jenaShacl;
    private static ShaclTQ shaclTQ;
    private static final List<Schema> availableSchemas;
    private static final Schema defaultSchema;
    private static final String defaultSchemaName;
    private static final String defaultSchemaFormat;
    private static final List<String> availableSchemaNames;
    private static final List<String> availableFormats;
    private static final List<String> availableTriggerModes;
    private static final String defaultTriggerMode;
    private static final List<String> schemaNames;
    private static volatile byte bitmap$0;

    static {
        availableSchemas = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema[]{MODULE$.shEx(), MODULE$.shaclex(), MODULE$.jenaShacl(), MODULE$.shaclTQ()}));
        defaultSchema = MODULE$.shEx();
        defaultSchemaName = MODULE$.defaultSchema().name();
        defaultSchemaFormat = MODULE$.defaultSchema().defaultFormat();
        availableSchemaNames = MODULE$.availableSchemas().map((Function1 & Serializable)x$1 -> x$1.name());
        availableFormats = (List)((SeqOps)MODULE$.availableSchemas().map((Function1 & Serializable)x$2 -> x$2.formats()).flatten(Predef$.MODULE$.$conforms())).distinct();
        availableTriggerModes = ValidationTrigger$.MODULE$.triggerValues().map((Function1 & Serializable)x$3 -> (String)x$3._1());
        defaultTriggerMode = ValidationTrigger$.MODULE$.default().name();
        schemaNames = MODULE$.availableSchemas().map((Function1 & Serializable)x$5 -> x$5.name());
    }

    private Schema shEx$lzycompute() {
        Schemas$ schemas$ = this;
        synchronized (schemas$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                shEx = ShExSchema$.MODULE$.empty();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return shEx;
    }

    public Schema shEx() {
        return (byte)(bitmap$0 & 1) == 0 ? this.shEx$lzycompute() : shEx;
    }

    private Schema shaclex$lzycompute() {
        Schemas$ schemas$ = this;
        synchronized (schemas$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                shaclex = ShaclexSchema$.MODULE$.empty();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return shaclex;
    }

    public Schema shaclex() {
        return (byte)(bitmap$0 & 2) == 0 ? this.shaclex$lzycompute() : shaclex;
    }

    private Schema jenaShacl$lzycompute() {
        Schemas$ schemas$ = this;
        synchronized (schemas$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                jenaShacl = JenaShacl$.MODULE$.empty();
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return jenaShacl;
    }

    public Schema jenaShacl() {
        return (byte)(bitmap$0 & 4) == 0 ? this.jenaShacl$lzycompute() : jenaShacl;
    }

    private ShaclTQ shaclTQ$lzycompute() {
        Schemas$ schemas$ = this;
        synchronized (schemas$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                shaclTQ = ShaclTQ$.MODULE$.empty();
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return shaclTQ;
    }

    public ShaclTQ shaclTQ() {
        return (byte)(bitmap$0 & 8) == 0 ? this.shaclTQ$lzycompute() : shaclTQ;
    }

    public List<Schema> availableSchemas() {
        return availableSchemas;
    }

    public Schema defaultSchema() {
        return defaultSchema;
    }

    public String defaultSchemaName() {
        return defaultSchemaName;
    }

    public String defaultSchemaFormat() {
        return defaultSchemaFormat;
    }

    public List<String> availableSchemaNames() {
        return availableSchemaNames;
    }

    public List<String> availableFormats() {
        return availableFormats;
    }

    public List<String> availableTriggerModes() {
        return availableTriggerModes;
    }

    public String defaultTriggerMode() {
        return defaultTriggerMode;
    }

    public IO<Schema> lookupSchema(String schemaName) {
        IO iO;
        String string = schemaName;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            iO = IO$.MODULE$.pure((Object)this.defaultSchema());
        } else {
            List found = this.availableSchemas().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Schemas$.$anonfun$lookupSchema$1(schemaName, x$4)));
            iO = found.isEmpty() ? IO$.MODULE$.raiseError((Throwable)new RuntimeException(new StringBuilder(38).append("Schema ").append(schemaName).append(" not found. Available schemas: ").append(this.availableSchemaNames().mkString(",")).toString())) : IO$.MODULE$.pure(found.head());
        }
        return iO;
    }

    public IO<Function3<String, String, Option<String>, IO<Schema>>> getSchemaParser(String schemaName) {
        return this.lookupSchema(schemaName).map((Function1 & Serializable)schema -> (Function3 & Serializable)(str, format, base) -> schema.fromString((String)str, (String)format, (Option<String>)base));
    }

    public List<String> schemaNames() {
        return schemaNames;
    }

    public IO<Schema> fromFile(File file, String format, String schemaName, Option<String> base) {
        return FileUtils$.MODULE$.getContents(Paths.get(file.getAbsolutePath(), new String[0])).flatMap((Function1 & Serializable)cs -> MODULE$.fromString((String)cs, format, schemaName, base).map((Function1 & Serializable)schema -> schema));
    }

    public Option<String> fromFile$default$4() {
        return None$.MODULE$;
    }

    public IO<Schema> fromString(String str, String format, String schemaName, Option<String> base) {
        return this.lookupSchema(schemaName).flatMap((Function1 & Serializable)schema -> (str.length() == 0 ? IO$.MODULE$.pure((Object)schema.empty()) : schema.empty().fromString(str, format, base)).map((Function1 & Serializable)schemaParsed -> schemaParsed));
    }

    public Option<String> fromString$default$4() {
        return None$.MODULE$;
    }

    public IO<Schema> fromRDF(RDFReader rdf, String schemaName) {
        return this.lookupSchema(schemaName).flatMap((Function1 & Serializable)defaultSchema -> defaultSchema.fromRDF(rdf).map((Function1 & Serializable)schema -> schema));
    }

    public IO<Schema> fromRDFIO(RDFReader rdf, String schemaName) {
        return this.lookupSchema(schemaName).flatMap((Function1 & Serializable)defaultSchema -> defaultSchema.fromRDF(rdf).map((Function1 & Serializable)maybeRDF -> maybeRDF));
    }

    public static final /* synthetic */ boolean $anonfun$lookupSchema$1(String schemaName$1, Schema x$4) {
        return x$4.name().compareToIgnoreCase(schemaName$1) == 0;
    }

    private Schemas$() {
    }
}

