/*
 * Decompiled with CFR 0.152.
 */
package es.weso.schema;

import cats.Applicative;
import cats.effect.IO;
import cats.effect.IO$;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import es.weso.rdf.PrefixMap;
import es.weso.rdf.PrefixMap$;
import es.weso.rdf.RDFBuilder;
import es.weso.rdf.RDFReader;
import es.weso.rdf.jena.RDFAsJenaModel;
import es.weso.rdf.nodes.IRI;
import es.weso.rdf.nodes.IRI$;
import es.weso.rdf.nodes.RDFNode;
import es.weso.schema.DataFormats$;
import es.weso.schema.ErrorInfo;
import es.weso.schema.JenaShEx$;
import es.weso.schema.JenaShExException$;
import es.weso.schema.JenaShaclException$;
import es.weso.schema.RDFReport$;
import es.weso.schema.Result;
import es.weso.schema.Result$;
import es.weso.schema.Schema;
import es.weso.schema.SchemaInfo;
import es.weso.schema.SchemaInfo$;
import es.weso.schema.ShapeMapTrigger;
import es.weso.schema.ShapeMapTrigger$;
import es.weso.schema.ValidationTrigger;
import es.weso.shapemaps.Association;
import es.weso.shapemaps.IRILabel;
import es.weso.shapemaps.IRILabel$;
import es.weso.shapemaps.NodeSelector;
import es.weso.shapemaps.RDFNodeSelector;
import es.weso.shapemaps.RDFNodeSelector$;
import es.weso.shapemaps.ResultShapeMap;
import es.weso.shapemaps.ShapeMap;
import es.weso.shapemaps.ShapeMapLabel;
import java.io.Serializable;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.shex.Shex;
import org.apache.jena.shex.ShexMap;
import org.apache.jena.shex.ShexReport;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexValidator;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class JenaShEx
extends Schema
implements Product,
Serializable {
    private final ShexSchema schema;

    public static JenaShEx apply(ShexSchema shexSchema) {
        return JenaShEx$.MODULE$.apply(shexSchema);
    }

    public static JenaShEx fromProduct(Product product) {
        return JenaShEx$.MODULE$.fromProduct(product);
    }

    public static JenaShEx unapply(JenaShEx jenaShEx) {
        return JenaShEx$.MODULE$.unapply(jenaShEx);
    }

    public JenaShEx(ShexSchema schema) {
        this.schema = schema;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof JenaShEx)) return false;
        JenaShEx jenaShEx = (JenaShEx)object;
        ShexSchema shexSchema = this.schema();
        ShexSchema shexSchema2 = jenaShEx.schema();
        if (shexSchema == null) {
            if (shexSchema2 != null) {
                return false;
            }
        } else if (!shexSchema.equals(shexSchema2)) return false;
        if (!jenaShEx.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof JenaShEx;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "JenaShEx";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return this._1();
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "schema";
    }

    public ShexSchema schema() {
        return this.schema;
    }

    @Override
    public String name() {
        return "JenaShEx";
    }

    @Override
    public Seq<String> formats() {
        return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ShExC"}));
    }

    @Override
    public ValidationTrigger defaultTriggerMode() {
        return ShapeMapTrigger$.MODULE$.empty();
    }

    @Override
    public IO<Result> validate(RDFReader rdf, ValidationTrigger trigger, RDFBuilder builder) {
        IO<Result> iO;
        ValidationTrigger validationTrigger = trigger;
        if (validationTrigger instanceof ShapeMapTrigger) {
            ShapeMapTrigger sm = (ShapeMapTrigger)validationTrigger;
            RDFReader rDFReader = rdf;
            if (rDFReader instanceof RDFAsJenaModel) {
                RDFAsJenaModel rdfJena = (RDFAsJenaModel)rDFReader;
                iO = this.validateJenaShEx(rdfJena, sm, builder);
            } else {
                iO = IO$.MODULE$.apply(() -> JenaShEx.validate$$anonfun$1(rdf));
            }
        } else {
            iO = IO$.MODULE$.apply(() -> this.validate$$anonfun$2(trigger));
        }
        return iO;
    }

    private IO<Result> validateJenaShEx(RDFAsJenaModel rdf, ShapeMapTrigger sm, RDFBuilder builder) {
        return this.convertShapeMap(sm).flatMap((Function1 & Serializable)shapeMap -> ((IO)rdf.modelRef().get()).map((Function1 & Serializable)model -> {
            Graph graph = model.getGraph();
            ShexValidator validator = ShexValidator.get();
            return Tuple3$.MODULE$.apply(model, (Object)graph, (Object)validator);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Model model = (Model)tuple3._1();
            Graph graph = (Graph)tuple3._2();
            ShexValidator validator = (ShexValidator)tuple3._3();
            return IO$.MODULE$.blocking(() -> this.validateJenaShEx$$anonfun$1$$anonfun$2$$anonfun$1(shapeMap, graph, validator)).flatMap((Function1 & Serializable)report -> this.report2Result((ShexReport)report).map((Function1 & Serializable)result -> result));
        }));
    }

    private IO<ShexMap> convertShapeMap(ShapeMapTrigger sm) {
        IO builder = (IO)sm.shapeMap().associations().foldRight((Object)IO$.MODULE$.apply(JenaShEx::$anonfun$1), (Function2 & Serializable)(x$1, x$2) -> {
            IO iO;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Association a = (Association)tuple2._1();
                IO b = (IO)tuple2._2();
                NodeSelector nodeSelector = a.node();
                if (nodeSelector instanceof RDFNodeSelector) {
                    RDFNode rDFNode;
                    RDFNodeSelector rDFNodeSelector = RDFNodeSelector$.MODULE$.unapply((RDFNodeSelector)nodeSelector);
                    RDFNode node = rDFNode = rDFNodeSelector._1();
                    iO = this.cnvNode(node).flatMap((Function1 & Serializable)n -> this.cnvLabel(a.shape()).flatMap((Function1 & Serializable)lbl -> b.map((Function1 & Serializable)builder -> builder.add(n, lbl))));
                } else {
                    iO = IO$.MODULE$.raiseError((Throwable)JenaShExException$.MODULE$.apply(new java.lang.StringBuilder(49).append("convertShapeMap: not implemented node selectors: ").append(a.node()).toString()));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            return iO;
        });
        return builder.map((Function1 & Serializable)_$1 -> _$1.build());
    }

    private IO<Node> cnvNode(RDFNode node) {
        IO iO;
        RDFNode rDFNode = node;
        if (rDFNode instanceof IRI) {
            IRI i = (IRI)rDFNode;
            iO = IO$.MODULE$.pure((Object)NodeFactory.createURI((String)i.str()));
        } else {
            iO = IO$.MODULE$.raiseError((Throwable)JenaShExException$.MODULE$.apply(new java.lang.StringBuilder(37).append("cnvNode: unsupported ").append(node).append(", must be an IRI").toString()));
        }
        return iO;
    }

    private IO<Node> cnvLabel(ShapeMapLabel label) {
        IO iO;
        ShapeMapLabel shapeMapLabel = label;
        if (shapeMapLabel instanceof IRILabel) {
            IRI iRI;
            IRILabel iRILabel = IRILabel$.MODULE$.unapply((IRILabel)shapeMapLabel);
            IRI i = iRI = iRILabel._1();
            iO = IO$.MODULE$.pure((Object)NodeFactory.createURI((String)i.str()));
        } else {
            iO = IO$.MODULE$.raiseError((Throwable)JenaShExException$.MODULE$.apply(new java.lang.StringBuilder(38).append("cnvLabel: unsupported ").append(label).append(", must be an IRI").toString()));
        }
        return iO;
    }

    private IO<Result> report2Result(ShexReport report) {
        String message = report.conforms() ? "Validated" : "Not valid";
        Result result = (Result)implicits$.MODULE$.catsSyntaxApplicativeId((Object)Result$.MODULE$.apply(report.conforms(), message, (Seq<ResultShapeMap>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))), RDFReport$.MODULE$.empty(), (Seq<ErrorInfo>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))), (Option<ValidationTrigger>)None$.MODULE$, PrefixMap$.MODULE$.empty(), PrefixMap$.MODULE$.empty(), Result$.MODULE$.$lessinit$greater$default$9()));
        return (IO)ApplicativeIdOps$.MODULE$.pure$extension((Object)result, (Applicative)IO$.MODULE$.asyncForIO());
    }

    @Override
    public IO<Schema> fromString(String str, String format, Option<String> base) {
        return IO$.MODULE$.apply(() -> JenaShEx.fromString$$anonfun$1(str)).map((Function1 & Serializable)schema -> JenaShEx$.MODULE$.apply((ShexSchema)schema));
    }

    @Override
    public IO<Schema> fromRDF(RDFReader rdf) {
        RDFReader rDFReader = rdf;
        return IO$.MODULE$.raiseError((Throwable)JenaShaclException$.MODULE$.apply(new java.lang.StringBuilder(34).append("Cannot obtain ").append(this.name()).append(" from RDFReader ").append(rdf.rdfReaderName()).append(" yet").toString()));
    }

    @Override
    public IO<String> serialize(String format, Option<IRI> base) {
        return this.formats().contains((Object)format.toUpperCase()) ? IO$.MODULE$.apply(this::serialize$$anonfun$1) : IO$.MODULE$.raiseError((Throwable)JenaShExException$.MODULE$.apply(new java.lang.StringBuilder(55).append("Format ").append(format).append(" not supported to serialize ").append(this.name()).append(". Supported formats=").append(this.formats()).toString()));
    }

    @Override
    public Schema empty() {
        return JenaShEx$.MODULE$.empty();
    }

    @Override
    public List<String> shapes() {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.schema().getShapes()).asScala()).toList().map((Function1 & Serializable)s -> s.getLabel().toString());
    }

    @Override
    public PrefixMap pm() {
        Map pms = (Map)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.schema().getPrefixMap().getMapping()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String alias = (String)tuple2._1();
            String iriStr = (String)tuple2._2();
            return Tuple2$.MODULE$.apply((Object)alias, (Object)IRI$.MODULE$.apply(iriStr));
        });
        return PrefixMap$.MODULE$.fromMap(pms);
    }

    @Override
    public IO<String> convert(Option<String> targetFormat, Option<String> targetEngine, Option<IRI> base) {
        IO iO;
        Option option = targetEngine.map((Function1 & Serializable)_$2 -> _$2.toUpperCase());
        if (None$.MODULE$.equals(option)) {
            iO = this.serialize((String)targetFormat.getOrElse(JenaShEx::convert$$anonfun$2), this.serialize$default$2());
        } else if (option instanceof Some) {
            String other = (String)((Some)option).value();
            iO = IO$.MODULE$.raiseError((Throwable)JenaShaclException$.MODULE$.apply(new java.lang.StringBuilder(35).append("Conversion ").append(this.name()).append(" -> ").append(other).append(" not implemented yet").toString()));
        } else {
            throw new MatchError((Object)option);
        }
        return iO;
    }

    @Override
    public SchemaInfo info() {
        return SchemaInfo$.MODULE$.apply(this.schema().getSource(), this.name(), true, (List<String>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))));
    }

    @Override
    public IO<String> toClingo(RDFReader rdf, ShapeMap shapeMap) {
        return IO$.MODULE$.raiseError((Throwable)JenaShaclException$.MODULE$.apply(new java.lang.StringBuilder(33).append("Not implemented yet toClingo for ").append(this.name()).toString()));
    }

    public JenaShEx copy(ShexSchema schema) {
        return new JenaShEx(schema);
    }

    public ShexSchema copy$default$1() {
        return this.schema();
    }

    public ShexSchema _1() {
        return this.schema();
    }

    private static final Result validate$$anonfun$1(RDFReader rdf$1) {
        return Result$.MODULE$.errStr(new java.lang.StringBuilder(52).append("Not implemented JenaShex for non-RDFAsJenaModel ").append(rdf$1.getClass().getCanonicalName()).append(" yet").toString());
    }

    private final Result validate$$anonfun$2(ValidationTrigger trigger$1) {
        return Result$.MODULE$.errStr(new java.lang.StringBuilder(33).append("Not implemented trigger ").append(trigger$1.name()).append(" for ").append(this.name()).append(" yet").toString());
    }

    private final ShexReport validateJenaShEx$$anonfun$1$$anonfun$2$$anonfun$1(ShexMap shapeMap$1, Graph graph$1, ShexValidator validator$1) {
        return validator$1.validate(graph$1, this.schema(), shapeMap$1);
    }

    private static final ShexMap.Builder $anonfun$1() {
        return ShexMap.newBuilder();
    }

    private static final ShexSchema fromString$$anonfun$1(String str$1) {
        return Shex.schemaFromString((String)str$1);
    }

    private final String serialize$$anonfun$1() {
        StringBuilder out = new StringBuilder();
        this.schema().getShapes().forEach(se -> out.$plus$plus$eq(se.toString()));
        return out.toString();
    }

    private static final String convert$$anonfun$2() {
        return DataFormats$.MODULE$.defaultFormatName();
    }
}

