/*
 * Decompiled with CFR 0.152.
 */
package es.weso.schema;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.MonadCancel;
import es.weso.rdf.PrefixMap;
import es.weso.rdf.PrefixMap$;
import es.weso.rdf.RDFBuilder;
import es.weso.rdf.RDFReader;
import es.weso.rdf.jena.RDFAsJenaModel$;
import es.weso.rdf.nodes.IRI;
import es.weso.schema.Result;
import es.weso.schema.Result$;
import es.weso.schema.SchemaInfo;
import es.weso.schema.ValidationTrigger;
import es.weso.schema.ValidationTrigger$;
import es.weso.shapemaps.ShapeMap;
import es.weso.utils.FileUtils$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public abstract class Schema {
    public abstract String name();

    public abstract Seq<String> formats();

    public abstract IO<Result> validate(RDFReader var1, ValidationTrigger var2, RDFBuilder var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IO<Result> validate(RDFReader rdf, String triggerMode, String shapeMap, Option<String> optNode, Option<String> optShape, PrefixMap nodePrefixMap, PrefixMap shapesPrefixMap, Option<RDFBuilder> builder) {
        IO<Result> iO;
        Some base = Some$.MODULE$.apply((Object)FileUtils$.MODULE$.currentFolderURL());
        Either<String, ValidationTrigger> either = ValidationTrigger$.MODULE$.findTrigger(triggerMode, shapeMap, (Option<String>)base, optNode, optShape, nodePrefixMap, shapesPrefixMap);
        if (either instanceof Left) {
            String err = (String)((Left)either).value();
            iO = IO$.MODULE$.apply(() -> this.validate$$anonfun$1(triggerMode, err));
            return iO;
        } else {
            if (!(either instanceof Right)) throw new MatchError(either);
            ValidationTrigger trigger = (ValidationTrigger)((Right)either).value();
            Option<RDFBuilder> option = builder;
            if (None$.MODULE$.equals(option)) {
                iO = RDFAsJenaModel$.MODULE$.empty().flatMap((Function1 & Serializable)_$1 -> (IO)_$1.use((Function1 & Serializable)builder -> this.validate(rdf, trigger, (RDFBuilder)builder), (MonadCancel)IO$.MODULE$.asyncForIO()));
                return iO;
            } else {
                if (!(option instanceof Some)) throw new MatchError(option);
                RDFBuilder builder2 = (RDFBuilder)((Some)option).value();
                iO = this.validate(rdf, trigger, builder2);
            }
        }
        return iO;
    }

    public PrefixMap validate$default$6() {
        return PrefixMap$.MODULE$.empty();
    }

    public PrefixMap validate$default$7() {
        return this.pm();
    }

    public abstract IO<Schema> fromString(String var1, String var2, Option<String> var3);

    public abstract IO<Schema> fromRDF(RDFReader var1);

    public abstract IO<String> serialize(String var1, Option<IRI> var2);

    public Option<IRI> serialize$default$2() {
        return None$.MODULE$;
    }

    public String defaultFormat() {
        return (String)this.formats().head();
    }

    public abstract ValidationTrigger defaultTriggerMode();

    public abstract Schema empty();

    public abstract List<String> shapes();

    public abstract PrefixMap pm();

    public abstract IO<String> convert(Option<String> var1, Option<String> var2, Option<IRI> var3);

    public abstract SchemaInfo info();

    public abstract IO<String> toClingo(RDFReader var1, ShapeMap var2);

    private final Result validate$$anonfun$1(String triggerMode$1, String err$1) {
        return Result$.MODULE$.errStr(new StringBuilder(48).append("Cannot get trigger: ").append(err$1).append(". TriggerMode: ").append(triggerMode$1).append(", prefixMap: ").append(this.pm()).toString());
    }
}

