/*
 * Decompiled with CFR 0.152.
 */
package es.weso.rdf.sgraph;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import es.weso.rdf.PrefixMap;
import es.weso.rdf.nodes.RDFNode;
import es.weso.rdf.sgraph.Edge;
import es.weso.rdf.sgraph.Node;
import es.weso.rdf.sgraph.RDFDotPreferences;
import es.weso.rdf.sgraph.SGraph$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001\u0002\u0010 \u0001\"B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t9\u0002\u0011\t\u0012)A\u0005\u0015\"AQ\f\u0001BK\u0002\u0013\u0005a\f\u0003\u0005f\u0001\tE\t\u0015!\u0003`\u0011\u00151\u0007\u0001\"\u0001h\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015A\b\u0001\"\u0003z\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!a\u0006\u0001\t\u0003\tI\u0002C\u0005\u0002,\u0001\t\t\u0011\"\u0001\u0002.!I\u00111\u0007\u0001\u0012\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003\u0017\u0002\u0011\u0013!C\u0001\u0003\u001bB\u0011\"!\u0015\u0001\u0003\u0003%\t%a\u0015\t\u0011\u0005\r\u0004!!A\u0005\u0002eD\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u0005M\u0004!!A\u0005B\u0005U\u0004\"CAB\u0001\u0005\u0005I\u0011AAC\u0011%\ty\tAA\u0001\n\u0003\n\t\nC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0011\u0002\u0018\"I\u0011\u0011\u0014\u0001\u0002\u0002\u0013\u0005\u00131\u0014\u0005\n\u0003;\u0003\u0011\u0011!C!\u0003?;q!a) \u0011\u0003\t)K\u0002\u0004\u001f?!\u0005\u0011q\u0015\u0005\u0007Mb!\t!!-\t\u000f\u0005M\u0006\u0004\"\u0001\u00026\"I\u0011q\u0017\r\u0002\u0002\u0013\u0005\u0015\u0011\u0018\u0005\n\u0003\u007fC\u0012\u0011!CA\u0003\u0003D\u0011\"a4\u0019\u0003\u0003%I!!5\u0003\rM;%/\u00199i\u0015\t\u0001\u0013%\u0001\u0004tOJ\f\u0007\u000f\u001b\u0006\u0003E\r\n1A\u001d3g\u0015\t!S%\u0001\u0003xKN|'\"\u0001\u0014\u0002\u0005\u0015\u001c8\u0001A\n\u0006\u0001%z\u0013\b\u0010\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A:T\"A\u0019\u000b\u0005I\u001a\u0014\u0001D:dC2\fGn\\4hS:<'B\u0001\u001b6\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u001c\u0002\u0007\r|W.\u0003\u00029c\tYA*\u0019>z\u0019><w-\u001b8h!\tQ#(\u0003\u0002<W\t9\u0001K]8ek\u000e$\bCA\u001fF\u001d\tq4I\u0004\u0002@\u00056\t\u0001I\u0003\u0002BO\u00051AH]8pizJ\u0011\u0001L\u0005\u0003\t.\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\na1+\u001a:jC2L'0\u00192mK*\u0011AiK\u0001\re\u00124gj\u001c3f\u0013\u0012l\u0015\r]\u000b\u0002\u0015B!1j\u0014*Y\u001d\taU\n\u0005\u0002@W%\u0011ajK\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&aA'ba*\u0011aj\u000b\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u0006\nQA\\8eKNL!a\u0016+\u0003\u000fI#eIT8eKB\u0011\u0011LW\u0007\u0002?%\u00111l\b\u0002\u0005\u001d>$W-A\u0007sI\u001atu\u000eZ3JI6\u000b\u0007\u000fI\u0001\u0006K\u0012<Wm]\u000b\u0002?B\u0019Q\b\u00192\n\u0005\u0005<%\u0001\u0002'jgR\u0004\"!W2\n\u0005\u0011|\"\u0001B#eO\u0016\fa!\u001a3hKN\u0004\u0013A\u0002\u001fj]&$h\bF\u0002iS*\u0004\"!\u0017\u0001\t\u000b!+\u0001\u0019\u0001&\t\u000bu+\u0001\u0019A0\u0002\u000f\u0005$GMT8eKR\u0019Q\u000e\u001d:\u0011\t)r\u0007\u000eW\u0005\u0003_.\u0012a\u0001V;qY\u0016\u0014\u0004\"B9\u0007\u0001\u0004\u0011\u0016\u0001\u00028pI\u0016DQa\u001d\u0004A\u0002Q\f!\u0001]7\u0011\u0005U4X\"A\u0011\n\u0005]\f#!\u0003)sK\u001aL\u00070T1q\u0003\u0019qW\r\u001f;JIV\t!\u0010\u0005\u0002+w&\u0011Ap\u000b\u0002\u0004\u0013:$\u0018aB1eI\u0016#w-\u001a\u000b\u0003Q~Da!!\u0001\t\u0001\u0004\u0011\u0017\u0001B3eO\u0016\fQ\u0001^8E_R$B!a\u0002\u0002\u000eA\u00191*!\u0003\n\u0007\u0005-\u0011K\u0001\u0004TiJLgn\u001a\u0005\b\u0003\u001fI\u0001\u0019AA\t\u0003\u0015\u0001(/\u001a4t!\rI\u00161C\u0005\u0004\u0003+y\"!\u0005*E\r\u0012{G\u000f\u0015:fM\u0016\u0014XM\\2fg\u00061Ao\u001c&t_:,\"!a\u0007\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005)1-\u001b:dK*\u0011\u0011QE\u0001\u0003S>LA!!\u000b\u0002 \t!!j]8o\u0003\u0011\u0019w\u000e]=\u0015\u000b!\fy#!\r\t\u000f![\u0001\u0013!a\u0001\u0015\"9Ql\u0003I\u0001\u0002\u0004y\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003oQ3ASA\u001dW\t\tY\u0004\u0005\u0003\u0002>\u0005\u001dSBAA \u0015\u0011\t\t%a\u0011\u0002\u0013Ut7\r[3dW\u0016$'bAA#W\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0013q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u001fR3aXA\u001d\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u000b\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0013\u0001\u00026bm\u0006LA!a\u0003\u0002Z\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA5\u0003_\u00022AKA6\u0013\r\tig\u000b\u0002\u0004\u0003:L\b\u0002CA9!\u0005\u0005\t\u0019\u0001>\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\b\u0005\u0004\u0002z\u0005}\u0014\u0011N\u0007\u0003\u0003wR1!! ,\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAD\u0003\u001b\u00032AKAE\u0013\r\tYi\u000b\u0002\b\u0005>|G.Z1o\u0011%\t\tHEA\u0001\u0002\u0004\tI'\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA+\u0003'C\u0001\"!\u001d\u0014\u0003\u0003\u0005\rA_\u0001\tQ\u0006\u001c\bnQ8eKR\t!0\u0001\u0005u_N#(/\u001b8h)\t\t)&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000f\u000b\t\u000bC\u0005\u0002rY\t\t\u00111\u0001\u0002j\u000511k\u0012:ba\"\u0004\"!\u0017\r\u0014\taI\u0013\u0011\u0016\t\u0005\u0003W\u000by+\u0004\u0002\u0002.*!\u0011QEA/\u0013\r1\u0015Q\u0016\u000b\u0003\u0003K\u000bQ!Z7qif,\u0012\u0001[\u0001\u0006CB\u0004H.\u001f\u000b\u0006Q\u0006m\u0016Q\u0018\u0005\u0006\u0011n\u0001\rA\u0013\u0005\u0006;n\u0001\raX\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019-a3\u0011\u000b)\n)-!3\n\u0007\u0005\u001d7F\u0001\u0004PaRLwN\u001c\t\u0005U9Tu\f\u0003\u0005\u0002Nr\t\t\u00111\u0001i\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003'\u0004B!a\u0016\u0002V&!\u0011q[A-\u0005\u0019y%M[3di\u0002")
public class SGraph
implements LazyLogging,
Product,
Serializable {
    private final Map<RDFNode, Node> rdfNodeIdMap;
    private final List<Edge> edges;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Map<RDFNode, Node>, List<Edge>>> unapply(SGraph x$0) {
        return SGraph$.MODULE$.unapply(x$0);
    }

    public static SGraph apply(Map<RDFNode, Node> rdfNodeIdMap, List<Edge> edges) {
        return SGraph$.MODULE$.apply(rdfNodeIdMap, edges);
    }

    public static SGraph empty() {
        return SGraph$.MODULE$.empty();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    private Logger logger$lzycompute() {
        SGraph sGraph = this;
        synchronized (sGraph) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Map<RDFNode, Node> rdfNodeIdMap() {
        return this.rdfNodeIdMap;
    }

    public List<Edge> edges() {
        return this.edges;
    }

    public Tuple2<SGraph, Node> addNode(RDFNode node, PrefixMap pm) {
        Tuple2 tuple2;
        Option option = this.rdfNodeIdMap().get((Object)node);
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            String id = new StringBuilder(1).append("N").append(this.nextId()).toString();
            String label = pm.qualify(node);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Label: {}, node: {}\nPrefixMap: {}", new Object[]{label, node, pm});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Node n = new Node(id, label, node, pm);
            Map newMap = (Map)this.rdfNodeIdMap().updated((Object)node, (Object)n);
            tuple2 = new Tuple2((Object)this.copy((Map<RDFNode, Node>)newMap, this.copy$default$2()), (Object)n);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Node n = (Node)some.value();
            tuple2 = new Tuple2((Object)this, (Object)n);
        } else {
            throw new MatchError((Object)option);
        }
        return tuple2;
    }

    private int nextId() {
        return this.rdfNodeIdMap().size();
    }

    public SGraph addEdge(Edge edge) {
        Edge edge2 = edge;
        List x$1 = (List)this.edges().$plus$colon((Object)edge2);
        Map<RDFNode, Node> x$2 = this.copy$default$1();
        return this.copy(x$2, (List<Edge>)x$1);
    }

    public String toDot(RDFDotPreferences prefs) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        sb.append("digraph {\n");
        this.rdfNodeIdMap().values().foreach((Function1 & Serializable)node -> sb.append(new StringBuilder(1).append(node.toDot(prefs)).append("\n").toString()));
        this.edges().foreach((Function1 & Serializable)edge -> sb.append(new StringBuilder(1).append(edge.toDot(prefs)).append("\n").toString()));
        sb.append("}");
        return sb.toString();
    }

    public Json toJson() {
        return Json$.MODULE$.fromValues((Iterable)((IterableOps)this.rdfNodeIdMap().values().map((Function1 & Serializable)x$1 -> x$1.toJson())).$plus$plus((IterableOnce)this.edges().map((Function1 & Serializable)x$2 -> x$2.toJson())));
    }

    public SGraph copy(Map<RDFNode, Node> rdfNodeIdMap, List<Edge> edges) {
        return new SGraph(rdfNodeIdMap, edges);
    }

    public Map<RDFNode, Node> copy$default$1() {
        return this.rdfNodeIdMap();
    }

    public List<Edge> copy$default$2() {
        return this.edges();
    }

    public String productPrefix() {
        return "SGraph";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.rdfNodeIdMap();
                break;
            }
            case 1: {
                object = this.edges();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SGraph;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "rdfNodeIdMap";
                break;
            }
            case 1: {
                string = "edges";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SGraph)) return false;
        boolean bl = true;
        if (!bl) return false;
        SGraph sGraph = (SGraph)x$1;
        Map<RDFNode, Node> map = this.rdfNodeIdMap();
        Map<RDFNode, Node> map2 = sGraph.rdfNodeIdMap();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        List<Edge> list = this.edges();
        List<Edge> list2 = sGraph.edges();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!sGraph.canEqual(this)) return false;
        return true;
    }

    public SGraph(Map<RDFNode, Node> rdfNodeIdMap, List<Edge> edges) {
        this.rdfNodeIdMap = rdfNodeIdMap;
        this.edges = edges;
        LazyLogging.$init$((LazyLogging)this);
        Product.$init$((Product)this);
    }
}

