/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shacl.report;

import es.weso.rdf.PREFIXES$;
import es.weso.rdf.nodes.IRI;
import es.weso.rdf.nodes.Literal;
import es.weso.rdf.nodes.RDFNode;
import es.weso.rdf.nodes.StringLiteral;
import es.weso.rdf.path.SHACLPath;
import es.weso.shacl.LiteralValue;
import es.weso.shacl.MessageMap;
import es.weso.shacl.PropertyShape;
import es.weso.shacl.RefNode;
import es.weso.shacl.RefNode$;
import es.weso.shacl.Shape;
import es.weso.shacl.Value;
import es.weso.shacl.report.AbstractResult;
import es.weso.shacl.report.InfoSeverity$;
import es.weso.shacl.report.Severity;
import es.weso.shacl.report.ValidationResult;
import es.weso.shacl.validator.Attempt;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple9;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class ValidationResult$
implements scala.Serializable {
    public static ValidationResult$ MODULE$;

    static {
        new ValidationResult$();
    }

    public ValidationResult basic(String suffix, RDFNode focusNode, Attempt attempt, String msg) {
        IRI x$1 = PREFIXES$.MODULE$.sh().$plus(suffix);
        RDFNode x$2 = focusNode;
        Severity x$3 = attempt.severity();
        RDFNode x$4 = attempt.shapeRef();
        Seq x$5 = (Seq)Nil$.MODULE$;
        Option<SHACLPath> x$6 = attempt.path();
        Seq x$7 = (Seq)new .colon.colon((Object)new LiteralValue((Literal)new StringLiteral(msg)), (List)Nil$.MODULE$);
        MessageMap x$8 = attempt.messageMap();
        Seq x$9 = (Seq)Nil$.MODULE$;
        return new ValidationResult(x$2, x$3, x$1, x$6, x$4, (Seq<RDFNode>)x$5, (Seq<LiteralValue>)x$7, x$8, (Seq<AbstractResult>)x$9);
    }

    public ValidationResult notFoundShapeRef(RDFNode node, Attempt attempt, String msg) {
        return this.basic("NotFoundShapeRef", node, attempt, msg);
    }

    public ValidationResult expectedPropertyShape(RDFNode node, Attempt attempt, String msg) {
        return this.basic("ExpectedPropertyShape", node, attempt, msg);
    }

    public ValidationResult shapesFailed(RDFNode node, Shape shape, Set<Shape> ps, Attempt attempt, String msg) {
        return this.basic("ShapesFailed", node, attempt, msg).setSeverity(InfoSeverity$.MODULE$);
    }

    public ValidationResult regexError(RDFNode node, Attempt attempt, String msg) {
        return this.basic("RegEx error", node, attempt, msg);
    }

    public ValidationResult noSiblingsError(RDFNode focusNode, PropertyShape p, String msg, Attempt attempt) {
        return this.basic("noSiblingsError", focusNode, attempt, new StringBuilder(49).append("No siblings found for property shape ").append(p).append(" in schema: ").append(msg).toString());
    }

    public ValidationResult errorNode(RDFNode node, Shape shape, Attempt attempt, String msg) {
        return this.basic("NodeConstraintComponent", node, attempt, msg);
    }

    public ValidationResult classError(RDFNode focusNode, RDFNode cls, Attempt attempt) {
        return this.basic("ClassConstraintComponent", focusNode, attempt, new StringBuilder(30).append("Node ").append(focusNode).append(" doesn't belong to class ").append(cls).toString());
    }

    public ValidationResult datatypeError(RDFNode focusNode, RDFNode datatype, Attempt attempt) {
        return this.basic("DatatypeConstraintComponent", focusNode, attempt, new StringBuilder(28).append("Node ").append(focusNode).append(" doesn't have dataType ").append(datatype).toString());
    }

    public ValidationResult unsupported(RDFNode focusNode, Attempt attempt, String msg) {
        return this.basic("unsupported", focusNode, attempt, new StringBuilder(13).append("Unsupported: ").append(msg).toString());
    }

    public ValidationResult notNumeric(RDFNode focusNode, Attempt attempt) {
        return this.basic("NotNumericConstraintComponent", focusNode, attempt, new StringBuilder(46).append("NotNumeric violation. Expected ").append(focusNode).append(" to be a number").toString());
    }

    public ValidationResult minExclusiveError(RDFNode focusNode, Attempt attempt, RDFNode n) {
        return this.basic("MinExclusiveConstraintComponent", focusNode, attempt, new StringBuilder(36).append("minExclusive violation. Expected ").append(focusNode).append(" > ").append(n).toString());
    }

    public ValidationResult minInclusiveError(RDFNode focusNode, Attempt attempt, RDFNode n) {
        return this.basic("MinInclusiveConstraintComponent", focusNode, attempt, new StringBuilder(37).append("minInclusive violation. Expected ").append(focusNode).append(" >= ").append(n).toString());
    }

    public ValidationResult maxExclusiveError(RDFNode focusNode, Attempt attempt, RDFNode n) {
        return this.basic("MaxExclusiveConstraintComponent", focusNode, attempt, new StringBuilder(36).append("maxExclusive violation. Expected ").append(focusNode).append(" < ").append(n).toString());
    }

    public ValidationResult maxInclusiveError(RDFNode focusNode, Attempt attempt, RDFNode n) {
        return this.basic("MaxInclusiveConstraintComponent", focusNode, attempt, new StringBuilder(37).append("maxInclusive violation. Expected ").append(focusNode).append(" <= ").append(n).toString());
    }

    public ValidationResult minLengthError(RDFNode focusNode, Attempt attempt, int n) {
        return this.basic("MinLengthConstraintComponent", focusNode, attempt, new StringBuilder(42).append("minLength violation. Expected length(").append(focusNode).append(") >= ").append(n).toString());
    }

    public ValidationResult maxLengthError(RDFNode focusNode, Attempt attempt, int n) {
        return this.basic("MaxLengthConstraintComponent", focusNode, attempt, new StringBuilder(42).append("maxLength violation. Expected length(").append(focusNode).append(") <= ").append(n).toString());
    }

    public ValidationResult patternError(RDFNode focusNode, Attempt attempt, String p, Option<String> flags) {
        return this.basic("PatternConstraintComponent", focusNode, attempt, new StringBuilder(40).append("pattern violation. Expected ").append(focusNode).append(" to match '").append(p).append("'").append(flags.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
    }

    public ValidationResult uniqueLangError(RDFNode focusNode, Attempt attempt, SHACLPath path, Seq<RDFNode> vs) {
        return this.basic("UniqueLangConstraintComponent", focusNode, attempt, new StringBuilder(80).append("uniqueLang violation. Expected ").append(focusNode).append(" to have a unique language for path ").append(path).append(" with values ").append(vs).toString());
    }

    public ValidationResult languageInError(RDFNode focusNode, Attempt attempt, List<String> langs) {
        return this.basic("LanguageInConstraintComponent", focusNode, attempt, new StringBuilder(55).append("languageIn violation. Expected ").append(focusNode).append(" to match 'languageIn(").append(langs.mkString(",")).append(")'").toString());
    }

    public ValidationResult equalsError(RDFNode focusNode, Attempt attempt, IRI p, Set<RDFNode> vs) {
        return this.comparisonError("EqualsConstraintComponent", focusNode, attempt, p, vs);
    }

    public ValidationResult disjointError(RDFNode focusNode, Attempt attempt, IRI p, Set<RDFNode> vs) {
        return this.comparisonError("DisjointConstraintComponent", focusNode, attempt, p, vs);
    }

    public ValidationResult lessThanError(RDFNode focusNode, Attempt attempt, IRI p, Set<RDFNode> vs) {
        return this.comparisonError("LessThanConstraintComponent", focusNode, attempt, p, vs);
    }

    public ValidationResult lessThanOrEqualsError(RDFNode focusNode, Attempt attempt, IRI p, Set<RDFNode> vs) {
        return this.comparisonError("LessThanOrEqualsConstraintComponent", focusNode, attempt, p, vs);
    }

    public ValidationResult comparisonError(String name, RDFNode focusNode, Attempt attempt, IRI p, Set<RDFNode> vs) {
        return this.basic(new StringBuilder(19).append(name).append("ConstraintComponent").toString(), focusNode, attempt, new StringBuilder(44).append(name).append(" violation. Expected ").append(focusNode).append(" to match ").append(name).append(" '").append(p).append("', values: ").append(vs).toString());
    }

    public ValidationResult minCountError(RDFNode focusNode, Attempt attempt, int minCount, int count) {
        return this.basic("MinCountConstraintComponent", focusNode, attempt, new StringBuilder(41).append("MinCount violation. Expected ").append(minCount).append(", obtained: ").append(count).toString());
    }

    public ValidationResult maxCountError(RDFNode focusNode, Attempt attempt, int maxCount, int count) {
        return this.basic("MaxCountConstraintComponent", focusNode, attempt, new StringBuilder(41).append("MaxCount violation. Expected ").append(maxCount).append(", obtained: ").append(count).toString());
    }

    public ValidationResult iriKindError(RDFNode focusNode, Attempt attempt) {
        return this.basic("IriConstraintComponent", focusNode, attempt, new StringBuilder(19).append("Node ").append(focusNode).append(" is not an IRI").toString());
    }

    public ValidationResult literalKindError(RDFNode focusNode, Attempt attempt) {
        return this.basic("LiteralConstraintComponent", focusNode, attempt, new StringBuilder(22).append("Node ").append(focusNode).append(" is not a Literal").toString());
    }

    public ValidationResult bNodeKindError(RDFNode focusNode, Attempt attempt) {
        return this.basic("BNodeConstraintComponent", focusNode, attempt, new StringBuilder(25).append("Node ").append(focusNode).append(" is not a blank node").toString());
    }

    public ValidationResult bNodeOrIRIKindError(RDFNode focusNode, Attempt attempt) {
        return this.basic("BNodeOrIRIConstraintComponent", focusNode, attempt, new StringBuilder(35).append("Node ").append(focusNode).append(" is not a blank node or an IRI").toString());
    }

    public ValidationResult bNodeOrLiteralKindError(RDFNode focusNode, Attempt attempt) {
        return this.basic("BNodeOrLiteralConstraintComponent", focusNode, attempt, new StringBuilder(38).append("Node ").append(focusNode).append(" is not a blank node or a Literal").toString());
    }

    public ValidationResult iriOrLiteralKindError(RDFNode focusNode, Attempt attempt) {
        return this.basic("IriOrLiteralConstraintComponent", focusNode, attempt, new StringBuilder(31).append("Node ").append(focusNode).append(" is not a IRI or a Literal").toString());
    }

    public ValidationResult notError(RDFNode focusNode, Attempt attempt, RDFNode shape) {
        return this.basic("NotConstraintComponent", focusNode, attempt, new StringBuilder(40).append("Not violation. Expected ").append(focusNode).append(" not to satisfy ").append(RefNode$.MODULE$.showId$extension(shape)).toString());
    }

    public ValidationResult andError(RDFNode focusNode, Attempt attempt, List<RefNode> shapes) {
        return this.basic("AndConstraintComponent", focusNode, attempt, new StringBuilder(54).append("And violation. Expected ").append(focusNode).append(" to satisfy all of the shapes ").append(((TraversableOnce)shapes.map((Function1 & Serializable & scala.Serializable)x$1 -> RefNode$.MODULE$.showId$extension(((RefNode)x$1).id()), List$.MODULE$.canBuildFrom())).mkString(",")).toString());
    }

    public ValidationResult orError(RDFNode focusNode, Attempt attempt, List<RefNode> shapes) {
        return this.basic("OrConstraintComponent", focusNode, attempt, new StringBuilder(54).append("Or violation. Expected ").append(focusNode).append(" to satisfy some of the shapes ").append(((TraversableOnce)shapes.map((Function1 & Serializable & scala.Serializable)x$2 -> RefNode$.MODULE$.showId$extension(((RefNode)x$2).id()), List$.MODULE$.canBuildFrom())).mkString(",")).toString());
    }

    public ValidationResult xoneError(RDFNode focusNode, Attempt attempt, Seq<RefNode> shapes) {
        return this.basic("XoneConstraintComponent", focusNode, attempt, new StringBuilder(63).append("Xone violation. Expected ").append(focusNode).append(" to satisfy exactly one of the shapes ").append(((TraversableOnce)shapes.map((Function1 & Serializable & scala.Serializable)x$3 -> RefNode$.MODULE$.showId$extension(((RefNode)x$3).id()), Seq$.MODULE$.canBuildFrom())).mkString(",")).toString());
    }

    public ValidationResult qualifiedShapeError(RDFNode focusNode, Attempt attempt, int value, Option<Object> min, Option<Object> max) {
        return this.basic("QualifiedShapeConstraintComponent", focusNode, attempt, new StringBuilder(87).append("qualified shape error. Expected ").append(focusNode).append(" to satisfy qualifiedValueShape. Value = ").append(value).append(", min: ").append(min.map((Function1 & Serializable & scala.Serializable)x$4 -> ValidationResult$.$anonfun$qualifiedShapeError$1(BoxesRunTime.unboxToInt((Object)x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-")).append(", max: ").append(max.map((Function1 & Serializable & scala.Serializable)x$5 -> ValidationResult$.$anonfun$qualifiedShapeError$3(BoxesRunTime.unboxToInt((Object)x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-")).toString());
    }

    public ValidationResult hasValueError(RDFNode focusNode, Attempt attempt, Value value) {
        return this.basic("HasValueConstraintComponent", focusNode, attempt, new StringBuilder(33).append("HasValue error. Expected ").append(focusNode).append(" to be  ").append(value).toString());
    }

    public ValidationResult hasValueErrorNoValue(RDFNode focusNode, Attempt attempt, Value value, SHACLPath path) {
        return this.basic("HasValueConstraintComponent", focusNode, attempt, new StringBuilder(59).append("HasValue error. Missing value for path ").append(path).append(" on ").append(focusNode).append(". Value must be ").append(value).toString());
    }

    public ValidationResult hasValueErrorMoreThanOne(RDFNode focusNode, Attempt attempt, Value value, SHACLPath path, int n) {
        return this.basic("HasValueConstraintComponent", focusNode, attempt, new StringBuilder(68).append("HasValue error. More than one value (").append(n).append(") for path ").append(path).append(" on ").append(focusNode).append(". Value must be ").append(value).toString());
    }

    public ValidationResult inError(RDFNode focusNode, Attempt attempt, Seq<Value> values) {
        return this.basic("InConstraintComponent", focusNode, attempt, new StringBuilder(33).append("In violation. Expected ").append(focusNode).append(" to be in ").append(values).toString());
    }

    public ValidationResult notShapeError(RDFNode focusNode, RDFNode shapeRef, Attempt attempt) {
        return this.basic("notShape", focusNode, attempt, new StringBuilder(53).append("Not failed because ").append(focusNode).append(" has shape ").append(new RefNode(shapeRef)).append(" and it should not have").toString());
    }

    public ValidationResult closedError(RDFNode focusNode, Attempt attempt, List<IRI> allowedProperties, List<IRI> ignoredProperties, List<IRI> notAllowed) {
        return this.basic("ClosedConstraintComponent", focusNode, attempt, new StringBuilder(91).append("closed violation. ").append(focusNode).append(" has more properties than ").append(allowedProperties).append(". Extra properties found: ").append(notAllowed).append(", ignoredProperties: ").append(ignoredProperties).toString());
    }

    public ValidationResult apply(RDFNode focusNode, Severity resultSeverity, IRI sourceConstraintComponent, Option<SHACLPath> focusPath, RDFNode sourceShape, Seq<RDFNode> values, Seq<LiteralValue> message, MessageMap messageMap, Seq<AbstractResult> details) {
        return new ValidationResult(focusNode, resultSeverity, sourceConstraintComponent, focusPath, sourceShape, values, message, messageMap, details);
    }

    public Option<Tuple9<RDFNode, Severity, IRI, Option<SHACLPath>, RefNode, Seq<RDFNode>, Seq<LiteralValue>, MessageMap, Seq<AbstractResult>>> unapply(ValidationResult x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple9((Object)x$0.focusNode(), (Object)x$0.resultSeverity(), (Object)x$0.sourceConstraintComponent(), x$0.focusPath(), (Object)new RefNode(x$0.sourceShape()), x$0.values(), x$0.message(), (Object)x$0.messageMap(), x$0.details()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ String $anonfun$qualifiedShapeError$1(int x$4) {
        return Integer.toString(x$4);
    }

    public static final /* synthetic */ String $anonfun$qualifiedShapeError$3(int x$5) {
        return Integer.toString(x$5);
    }

    private ValidationResult$() {
        MODULE$ = this;
    }
}

