/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shapemaps;

import cats.Applicative;
import cats.Traverse;
import cats.implicits$;
import es.weso.rdf.PREFIXES$;
import es.weso.rdf.PrefixMap;
import es.weso.rdf.nodes.BooleanLiteral$;
import es.weso.rdf.nodes.DatatypeLiteral$;
import es.weso.rdf.nodes.DecimalLiteral$;
import es.weso.rdf.nodes.DoubleLiteral$;
import es.weso.rdf.nodes.IRI;
import es.weso.rdf.nodes.IRI$;
import es.weso.rdf.nodes.IntegerLiteral$;
import es.weso.rdf.nodes.Literal;
import es.weso.rdf.nodes.RDFNode;
import es.weso.rdf.nodes.StringLiteral$;
import es.weso.rdf.path.AlternativePath$;
import es.weso.rdf.path.InversePath$;
import es.weso.rdf.path.OneOrMorePath$;
import es.weso.rdf.path.PredicatePath$;
import es.weso.rdf.path.SHACLPath;
import es.weso.rdf.path.SequencePath$;
import es.weso.rdf.path.ZeroOrMorePath;
import es.weso.rdf.path.ZeroOrMorePath$;
import es.weso.rdf.path.ZeroOrOnePath$;
import es.weso.shapemaps.Focus$;
import es.weso.shapemaps.GenericSelector$;
import es.weso.shapemaps.NodePattern$;
import es.weso.shapemaps.NodeSelector;
import es.weso.shapemaps.Parser$;
import es.weso.shapemaps.Pattern;
import es.weso.shapemaps.RDFNodeSelector$;
import es.weso.shapemaps.SparqlSelector$;
import es.weso.shapemaps.TriplePattern;
import es.weso.shapemaps.TriplePattern$;
import es.weso.shapemaps.WildCard$;
import es.weso.shapemaps.parser.NodeSelectorBaseVisitor;
import es.weso.shapemaps.parser.NodeSelectorParser;
import es.weso.utils.FileUtils$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.matching.Regex;

public class NodeSelectorMaker
extends NodeSelectorBaseVisitor<Object> {
    private final PrefixMap nodesPrefixMap;
    private final IRI baseIRI;

    public NodeSelectorMaker(Option<String> base, PrefixMap nodesPrefixMap) {
        this.nodesPrefixMap = nodesPrefixMap;
        this.baseIRI = IRI$.MODULE$.apply((String)base.getOrElse(NodeSelectorMaker::$init$$$anonfun$1));
    }

    public IRI baseIRI() {
        return this.baseIRI;
    }

    @Override
    public Either<String, NodeSelector> visitNodeSelector(NodeSelectorParser.NodeSelectorContext ctx) {
        NodeSelectorParser.NodeSelectorContext nodeSelectorContext = ctx;
        if (this.isDefined(ctx.objectTerm())) {
            return this.visitObjectTerm(ctx.objectTerm()).map((Function1 & Serializable)node -> RDFNodeSelector$.MODULE$.apply((RDFNode)node));
        }
        if (this.isDefined(ctx.triplePattern())) {
            return this.visitTriplePattern(ctx.triplePattern());
        }
        if (this.isDefined(ctx.extended())) {
            return this.visitExtended(ctx.extended());
        }
        return Parser$.MODULE$.err(new StringBuilder(46).append("Internal error visitNodeSelector: unknown ctx ").append((Object)ctx).toString());
    }

    @Override
    public Either<String, NodeSelector> visitExtended(NodeSelectorParser.ExtendedContext ctx) {
        NodeSelectorParser.ExtendedContext extendedContext = ctx;
        if (this.isDefined(ctx.KW_SPARQL())) {
            return this.visitString(ctx.string()).map((Function1 & Serializable)str -> SparqlSelector$.MODULE$.apply((String)str));
        }
        if (this.isDefined(ctx.nodeIri())) {
            return this.visitNodeIri(ctx.nodeIri(), this.nodesPrefixMap).flatMap((Function1 & Serializable)iri -> this.visitString(ctx.string()).map((Function1 & Serializable)str -> GenericSelector$.MODULE$.apply((IRI)iri, (String)str)));
        }
        return Parser$.MODULE$.err(new StringBuilder(42).append("Internal error visitExtended: unknoen ctx ").append((Object)ctx).toString());
    }

    @Override
    public Either<String, RDFNode> visitSubjectTerm(NodeSelectorParser.SubjectTermContext ctx) {
        NodeSelectorParser.SubjectTermContext subjectTermContext = ctx;
        if (this.isDefined(ctx.nodeIri())) {
            return this.visitNodeIri(ctx.nodeIri(), this.nodesPrefixMap).map((Function1 & Serializable)iri -> iri);
        }
        if (this.isDefined(ctx.rdfType())) {
            return Parser$.MODULE$.ok(PREFIXES$.MODULE$.rdf$colontype());
        }
        throw new MatchError((Object)subjectTermContext);
    }

    @Override
    public Either<String, RDFNode> visitObjectTerm(NodeSelectorParser.ObjectTermContext ctx) {
        NodeSelectorParser.ObjectTermContext objectTermContext = ctx;
        if (this.isDefined(ctx.subjectTerm())) {
            return this.visitSubjectTerm(ctx.subjectTerm());
        }
        if (this.isDefined(ctx.literal())) {
            return this.visitLiteral(ctx.literal()).map((Function1 & Serializable)literal -> literal);
        }
        throw new MatchError((Object)objectTermContext);
    }

    public Either<String, TriplePattern> visitTriplePattern(NodeSelectorParser.TriplePatternContext ctx) {
        NodeSelectorParser.TriplePatternContext triplePatternContext = ctx;
        if (triplePatternContext instanceof NodeSelectorParser.FocusSubjectContext) {
            NodeSelectorParser.FocusSubjectContext s = (NodeSelectorParser.FocusSubjectContext)triplePatternContext;
            return this.visitPath(s.path()).flatMap((Function1 & Serializable)path -> (this.isDefined(s.objectTerm()) ? this.visitObjectTerm(s.objectTerm()).map((Function1 & Serializable)obj -> NodePattern$.MODULE$.apply((RDFNode)obj)) : Parser$.MODULE$.ok(WildCard$.MODULE$)).map((Function1 & Serializable)objectPattern -> TriplePattern$.MODULE$.apply(Focus$.MODULE$, (SHACLPath)path, (Pattern)((Object)objectPattern))));
        }
        if (triplePatternContext instanceof NodeSelectorParser.FocusObjectContext) {
            NodeSelectorParser.FocusObjectContext s = (NodeSelectorParser.FocusObjectContext)triplePatternContext;
            return this.visitPath(s.path()).flatMap((Function1 & Serializable)path -> (this.isDefined(s.subjectTerm()) ? this.visitSubjectTerm(s.subjectTerm()).map((Function1 & Serializable)subj -> NodePattern$.MODULE$.apply((RDFNode)subj)) : Parser$.MODULE$.ok(WildCard$.MODULE$)).map((Function1 & Serializable)subjectPattern -> TriplePattern$.MODULE$.apply((Pattern)((Object)subjectPattern), (SHACLPath)path, Focus$.MODULE$)));
        }
        throw new MatchError((Object)triplePatternContext);
    }

    @Override
    public Either<String, SHACLPath> visitPath(NodeSelectorParser.PathContext ctx) {
        return this.visitPathAlternative(ctx.pathAlternative());
    }

    @Override
    public Either<String, SHACLPath> visitPathAlternative(NodeSelectorParser.PathAlternativeContext ctx) {
        List r = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(ctx.pathSequence()).asScala().map((Function1 & Serializable)_$1 -> this.visitPathSequence((NodeSelectorParser.PathSequenceContext)((Object)_$1)))).toList();
        return ((Either)implicits$.MODULE$.toTraverseOps((Object)r, (Traverse)implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable)alts -> {
            if (alts.length() == 1) {
                return (SHACLPath)alts.head();
            }
            return AlternativePath$.MODULE$.apply((Seq)alts);
        });
    }

    @Override
    public Either<String, SHACLPath> visitPathSequence(NodeSelectorParser.PathSequenceContext ctx) {
        List r = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(ctx.pathEltOrInverse()).asScala().map((Function1 & Serializable)_$2 -> this.visitPathEltOrInverse((NodeSelectorParser.PathEltOrInverseContext)((Object)_$2)))).toList();
        return ((Either)implicits$.MODULE$.toTraverseOps((Object)r, (Traverse)implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable)seqs -> {
            if (seqs.length() == 1) {
                return (SHACLPath)seqs.head();
            }
            return SequencePath$.MODULE$.apply((Seq)seqs);
        });
    }

    @Override
    public Either<String, SHACLPath> visitPathEltOrInverse(NodeSelectorParser.PathEltOrInverseContext ctx) {
        return this.visitPathElt(ctx.pathElt()).map((Function1 & Serializable)pathElt -> {
            if (this.isDefined(ctx.inverse())) {
                return InversePath$.MODULE$.apply(pathElt);
            }
            return pathElt;
        });
    }

    @Override
    public Either<String, SHACLPath> visitPathElt(NodeSelectorParser.PathEltContext ctx) {
        return this.visitPathPrimary(ctx.pathPrimary()).map((Function1 & Serializable)pathPrimary -> {
            if (this.isDefined(ctx.pathMod())) {
                ZeroOrMorePath zeroOrMorePath;
                NodeSelectorParser.PathModContext pathModContext = ctx.pathMod();
                if (pathModContext instanceof NodeSelectorParser.StarContext) {
                    zeroOrMorePath = ZeroOrMorePath$.MODULE$.apply(pathPrimary);
                } else if (pathModContext instanceof NodeSelectorParser.OptionalContext) {
                    zeroOrMorePath = ZeroOrOnePath$.MODULE$.apply(pathPrimary);
                } else if (pathModContext instanceof NodeSelectorParser.PlusContext) {
                    zeroOrMorePath = OneOrMorePath$.MODULE$.apply(pathPrimary);
                } else {
                    throw new MatchError((Object)pathModContext);
                }
                return (SHACLPath)zeroOrMorePath;
            }
            return pathPrimary;
        });
    }

    @Override
    public Either<String, SHACLPath> visitPathPrimary(NodeSelectorParser.PathPrimaryContext ctx) {
        NodeSelectorParser.PathPrimaryContext pathPrimaryContext = ctx;
        if (this.isDefined(ctx.nodeIri())) {
            return this.visitNodeIri(ctx.nodeIri(), this.nodesPrefixMap).map((Function1 & Serializable)_$3 -> PredicatePath$.MODULE$.apply(_$3));
        }
        if (this.isDefined(ctx.rdfType())) {
            return Parser$.MODULE$.ok(PredicatePath$.MODULE$.apply(PREFIXES$.MODULE$.rdf$colontype()));
        }
        throw new MatchError((Object)pathPrimaryContext);
    }

    @Override
    public Either<String, Literal> visitLiteral(NodeSelectorParser.LiteralContext ctx) {
        NodeSelectorParser.LiteralContext literalContext = ctx;
        if (this.isDefined(ctx.rdfLiteral())) {
            return this.visitRdfLiteral(ctx.rdfLiteral());
        }
        if (this.isDefined(ctx.numericLiteral())) {
            return this.visitNumericLiteral(ctx.numericLiteral());
        }
        if (this.isDefined(ctx.booleanLiteral())) {
            return this.visitBooleanLiteral(ctx.booleanLiteral());
        }
        return Parser$.MODULE$.err(new StringBuilder(41).append("Internal error visitLiteral: unknown ctx ").append((Object)ctx).toString());
    }

    @Override
    public Either<String, Literal> visitRdfLiteral(NodeSelectorParser.RdfLiteralContext ctx) {
        Either<String, String> str = this.visitString(ctx.string());
        if (this.isDefined(ctx.datatype())) {
            return str.flatMap((Function1 & Serializable)s -> this.visitDatatype(ctx.datatype(), this.nodesPrefixMap).map((Function1 & Serializable)d -> DatatypeLiteral$.MODULE$.apply(s, d)));
        }
        return str.map((Function1 & Serializable)_$4 -> StringLiteral$.MODULE$.apply(_$4));
    }

    @Override
    public Either<String, Literal> visitNumericLiteral(NodeSelectorParser.NumericLiteralContext ctx) {
        NodeSelectorParser.NumericLiteralContext numericLiteralContext = ctx;
        if (this.isDefined(ctx.INTEGER())) {
            return Parser$.MODULE$.ok(IntegerLiteral$.MODULE$.apply(Integer.parseInt(ctx.INTEGER().getText())));
        }
        if (this.isDefined(ctx.DECIMAL())) {
            return Parser$.MODULE$.ok(DecimalLiteral$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(ctx.DECIMAL().getText())));
        }
        if (this.isDefined(ctx.DOUBLE())) {
            String str = ctx.DOUBLE().getText();
            return Parser$.MODULE$.ok(DoubleLiteral$.MODULE$.apply(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(str))));
        }
        return Parser$.MODULE$.err("Unknown ctx in numericLiteral");
    }

    @Override
    public Either<String, String> visitString(NodeSelectorParser.StringContext ctx) {
        if (this.isDefined(ctx.STRING_LITERAL_LONG1())) {
            return Parser$.MODULE$.ok(this.stripStringLiteralLong1(ctx.STRING_LITERAL_LONG1().getText()));
        }
        if (this.isDefined(ctx.STRING_LITERAL_LONG2())) {
            return Parser$.MODULE$.ok(this.stripStringLiteralLong2(ctx.STRING_LITERAL_LONG2().getText()));
        }
        if (this.isDefined(ctx.STRING_LITERAL1())) {
            return Parser$.MODULE$.ok(this.stripStringLiteral1(ctx.STRING_LITERAL1().getText()));
        }
        if (this.isDefined(ctx.STRING_LITERAL2())) {
            return Parser$.MODULE$.ok(this.stripStringLiteral2(ctx.STRING_LITERAL2().getText()));
        }
        return Parser$.MODULE$.err(new StringBuilder(25).append("visitString: Unknown ctx ").append(ctx.getClass().getName()).toString());
    }

    public String stripStringLiteral1(String s) {
        return s.substring(1, s.length() - 1);
    }

    public String stripStringLiteral2(String s) {
        return s.substring(1, s.length() - 1);
    }

    public String stripStringLiteralLong1(String s) {
        return s.substring(3, s.length() - 3);
    }

    public String stripStringLiteralLong2(String s) {
        return s.substring(3, s.length() - 3);
    }

    public Either<String, IRI> visitDatatype(NodeSelectorParser.DatatypeContext ctx, PrefixMap prefixMap) {
        return this.visitNodeIri(ctx.nodeIri(), prefixMap);
    }

    public Either<String, Option<IRI>> getBase() {
        return Parser$.MODULE$.ok(Some$.MODULE$.apply((Object)this.baseIRI()));
    }

    private Either<String, IRI> visitNodeIri(NodeSelectorParser.NodeIriContext ctx, PrefixMap prefixMap) {
        if (this.isDefined(ctx.IRIREF())) {
            return this.getBase().flatMap((Function1 & Serializable)base -> this.extractIRIfromIRIREF(ctx.IRIREF().getText(), (Option<IRI>)base).map((Function1 & Serializable)iri -> iri));
        }
        return this.visitPrefixedName(ctx.prefixedName()).flatMap((Function1 & Serializable)prefixedName -> this.resolve((String)prefixedName, prefixMap).map((Function1 & Serializable)iri -> iri));
    }

    public Either<String, IRI> resolve(String prefixedName, PrefixMap prefixMap) {
        Tuple2<String, String> tuple2 = this.splitPrefix(prefixedName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String prefix = (String)tuple2._1();
        String local = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)prefix, (Object)local);
        String prefix2 = (String)tuple22._1();
        String local2 = (String)tuple22._2();
        Option option = prefixMap.getIRI(prefix2);
        if (None$.MODULE$.equals(option)) {
            return Parser$.MODULE$.err(new StringBuilder(40).append("Prefix ").append(prefix2).append(" not found in current prefix map ").append(prefixMap).toString());
        }
        if (option instanceof Some) {
            IRI iri = (IRI)((Some)option).value();
            return Parser$.MODULE$.ok(iri.$plus(local2));
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<String, String> splitPrefix(String str) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(str), ':')) {
            Tuple2 tuple2 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(str), str.lastIndexOf(58));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String prefix = (String)tuple2._1();
            String name = (String)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)prefix, (Object)name);
            String prefix2 = (String)tuple22._1();
            String name2 = (String)tuple22._2();
            return Tuple2$.MODULE$.apply((Object)prefix2, (Object)StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(name2)));
        }
        return Tuple2$.MODULE$.apply((Object)"", (Object)str);
    }

    @Override
    public Either<String, String> visitPrefixedName(NodeSelectorParser.PrefixedNameContext ctx) {
        return Parser$.MODULE$.ok(ctx.getText());
    }

    public Either<String, IRI> extractIRIfromIRIREF(String d, Option<IRI> base) {
        List list;
        Option option;
        Regex iriRef = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^<(.*)>$"));
        String string = d;
        if (string != null && !(option = iriRef.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
            String string2;
            String i = string2 = (String)list.apply(0);
            return IRI$.MODULE$.fromString(i, base);
        }
        String s = string;
        return Parser$.MODULE$.err(new StringBuilder(28).append("IRIREF ").append(s).append(" does not match <...>").toString());
    }

    public Either<String, Object> getInteger(String str) {
        Object object;
        try {
            object = Parser$.MODULE$.ok(BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(str))));
        }
        catch (NumberFormatException numberFormatException) {
            object = Parser$.MODULE$.err(new StringBuilder(24).append("Cannot get integer from ").append(str).toString());
        }
        return object;
    }

    public Either<String, BigDecimal> getDecimal(String str) {
        Object object;
        try {
            object = Parser$.MODULE$.ok(package$.MODULE$.BigDecimal().apply(str));
        }
        catch (NumberFormatException numberFormatException) {
            object = Parser$.MODULE$.err(new StringBuilder(24).append("Cannot get decimal from ").append(str).toString());
        }
        return object;
    }

    public Either<String, Object> getDouble(String str) {
        Object object;
        try {
            object = Parser$.MODULE$.ok(BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(str))));
        }
        catch (NumberFormatException numberFormatException) {
            object = Parser$.MODULE$.err(new StringBuilder(23).append("Cannot get double from ").append(str).toString());
        }
        return object;
    }

    @Override
    public Either<String, Literal> visitBooleanLiteral(NodeSelectorParser.BooleanLiteralContext ctx) {
        if (this.isDefined(ctx.KW_TRUE())) {
            return Parser$.MODULE$.ok(BooleanLiteral$.MODULE$.apply(true));
        }
        return Parser$.MODULE$.ok(BooleanLiteral$.MODULE$.apply(false));
    }

    public <A> boolean isDefined(A x) {
        return x != null;
    }

    public <A, B> Either<String, List<B>> visitList(Function1<A, Either<String, B>> visitFn, java.util.List<A> ls) {
        return (Either)implicits$.MODULE$.toTraverseOps((Object)CollectionConverters$.MODULE$.ListHasAsScala(ls).asScala().toList().map(visitFn), (Traverse)implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither());
    }

    public <A, B> Either<String, Option<B>> visitOpt(Function1<A, Either<String, B>> visitFn, A v) {
        if (this.isDefined(v)) {
            return ((Either)visitFn.apply(v)).map((Function1 & Serializable)_$6 -> Some$.MODULE$.apply(_$6));
        }
        return Parser$.MODULE$.ok(None$.MODULE$);
    }

    private static final String $init$$$anonfun$1() {
        return FileUtils$.MODULE$.currentFolderURL();
    }
}

