/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shapemaps;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.implicits$;
import cats.syntax.EitherIdOps$;
import cats.syntax.EitherOps$;
import es.weso.rdf.PrefixMap;
import es.weso.rdf.nodes.IRI;
import es.weso.shapemaps.ParserErrorListener;
import es.weso.shapemaps.QueryShapeMap;
import es.weso.shapemaps.ShapeMapsMaker;
import es.weso.shapemaps.parser.ShapeMapLexer;
import es.weso.shapemaps.parser.ShapeMapParser;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;

public final class Parser$
implements Serializable {
    public static final Parser$ MODULE$ = new Parser$();

    private Parser$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Parser$.class);
    }

    public <A> Either<String, A> ok(A x) {
        return package$.MODULE$.Right().apply(x);
    }

    public <A> Either<String, A> err(String msg) {
        return package$.MODULE$.Left().apply((Object)msg);
    }

    public String removeBOM(String str) {
        String UTF8_BOM = "\ufeff";
        if (str.startsWith(UTF8_BOM)) {
            return str.substring(1);
        }
        return str;
    }

    public Either<NonEmptyList<String>, QueryShapeMap> parse(String str, Option<IRI> base, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
        String s = this.removeBOM(str);
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)));
        return this.parseReader(reader, base, nodesPrefixMap, shapesPrefixMap);
    }

    public Either<NonEmptyList<String>, QueryShapeMap> parseReader(Reader reader, Option<IRI> base, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
        CodePointCharStream input = CharStreams.fromReader((Reader)reader);
        ShapeMapLexer lexer = new ShapeMapLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ShapeMapParser parser = new ShapeMapParser((TokenStream)tokens);
        ParserErrorListener errorListener = new ParserErrorListener();
        lexer.addErrorListener(errorListener);
        parser.addErrorListener(errorListener);
        ShapeMapsMaker maker = new ShapeMapsMaker(base, nodesPrefixMap, shapesPrefixMap);
        Either builder = (Either)maker.visit((ParseTree)parser.shapeMap());
        List<String> errors = errorListener.getErrors();
        return (Either)NonEmptyList$.MODULE$.fromList(errors).fold(() -> this.parseReader$$anonfun$1(builder), (Function1 & Serializable)_$2 -> {
            NonEmptyList nonEmptyList = (NonEmptyList)implicits$.MODULE$.catsSyntaxEitherId(_$2);
            return EitherIdOps$.MODULE$.asLeft$extension((Object)nonEmptyList);
        });
    }

    private final Either parseReader$$anonfun$1(Either builder$1) {
        Either either = implicits$.MODULE$.catsSyntaxEither(builder$1);
        return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$1 -> NonEmptyList$.MODULE$.one(_$1));
    }
}

