/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shapemaps;

import cats.Applicative;
import cats.Invariant$;
import cats.Show$;
import cats.UnorderedFoldable$;
import cats.implicits$;
import es.weso.rdf.PrefixMap;
import es.weso.rdf.nodes.IRI;
import es.weso.rdf.nodes.RDFNode;
import es.weso.rdf.nodes.RDFNode$;
import es.weso.shapemaps.Association;
import es.weso.shapemaps.Association$;
import es.weso.shapemaps.FixedShapeMap;
import es.weso.shapemaps.Info;
import es.weso.shapemaps.Info$;
import es.weso.shapemaps.NodeSelector;
import es.weso.shapemaps.RDFNodeSelector;
import es.weso.shapemaps.RDFNodeSelector$;
import es.weso.shapemaps.ResultShapeMap$;
import es.weso.shapemaps.ShapeMap;
import es.weso.shapemaps.ShapeMap$;
import es.weso.shapemaps.ShapeMapLabel;
import es.weso.shapemaps.ShapeMapLabel$;
import es.weso.shapemaps.Status;
import es.weso.shapemaps.Status$Conformant$;
import es.weso.shapemaps.Status$NonConformant$;
import es.weso.utils.MapUtils$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public class ResultShapeMap
extends ShapeMap
implements Product,
Serializable {
    private final Map resultMap;
    private final PrefixMap nodesPrefixMap;
    private final PrefixMap shapesPrefixMap;
    private final List associations;

    public static ResultShapeMap apply(Map<RDFNode, Map<ShapeMapLabel, Info>> map, PrefixMap prefixMap, PrefixMap prefixMap2) {
        return ResultShapeMap$.MODULE$.apply(map, prefixMap, prefixMap2);
    }

    public static ResultShapeMap empty() {
        return ResultShapeMap$.MODULE$.empty();
    }

    public static ResultShapeMap fromFixedMap(FixedShapeMap fixedShapeMap) {
        return ResultShapeMap$.MODULE$.fromFixedMap(fixedShapeMap);
    }

    public static ResultShapeMap fromProduct(Product product) {
        return ResultShapeMap$.MODULE$.fromProduct(product);
    }

    public static ResultShapeMap unapply(ResultShapeMap resultShapeMap) {
        return ResultShapeMap$.MODULE$.unapply(resultShapeMap);
    }

    public ResultShapeMap(Map<RDFNode, Map<ShapeMapLabel, Info>> resultMap, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
        this.resultMap = resultMap;
        this.nodesPrefixMap = nodesPrefixMap;
        this.shapesPrefixMap = shapesPrefixMap;
        this.associations = resultMap.toList().flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                RDFNode node = (RDFNode)tuple2._1();
                Map labelsMap = (Map)tuple2._2();
                return labelsMap.toList().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        ShapeMapLabel shapeLabel = (ShapeMapLabel)tuple2._1();
                        Info info = (Info)tuple2._2();
                        return Association$.MODULE$.apply(RDFNodeSelector$.MODULE$.apply(node), shapeLabel, info);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ResultShapeMap)) return false;
        ResultShapeMap resultShapeMap = (ResultShapeMap)object;
        Map<RDFNode, Map<ShapeMapLabel, Info>> map = this.resultMap();
        Map<RDFNode, Map<ShapeMapLabel, Info>> map2 = resultShapeMap.resultMap();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        PrefixMap prefixMap = this.nodesPrefixMap();
        PrefixMap prefixMap2 = resultShapeMap.nodesPrefixMap();
        if (prefixMap == null) {
            if (prefixMap2 != null) {
                return false;
            }
        } else if (!prefixMap.equals(prefixMap2)) return false;
        PrefixMap prefixMap3 = this.shapesPrefixMap();
        PrefixMap prefixMap4 = resultShapeMap.shapesPrefixMap();
        if (prefixMap3 == null) {
            if (prefixMap4 != null) {
                return false;
            }
        } else if (!prefixMap3.equals(prefixMap4)) return false;
        if (!resultShapeMap.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof ResultShapeMap;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "ResultShapeMap";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "resultMap";
            }
            case 1: {
                return "nodesPrefixMap";
            }
            case 2: {
                return "shapesPrefixMap";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Map<RDFNode, Map<ShapeMapLabel, Info>> resultMap() {
        return this.resultMap;
    }

    @Override
    public PrefixMap nodesPrefixMap() {
        return this.nodesPrefixMap;
    }

    @Override
    public PrefixMap shapesPrefixMap() {
        return this.shapesPrefixMap;
    }

    public ResultShapeMap addShapesPrefixMap(PrefixMap pm) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), pm);
    }

    public ResultShapeMap addNodesPrefixMap(PrefixMap pm) {
        return this.copy(this.copy$default$1(), pm, this.copy$default$3());
    }

    public ResultShapeMap addNodeAssociations(RDFNode node, Map<ShapeMapLabel, Info> mapLabels) {
        Option option = this.resultMap().get((Object)node);
        if (None$.MODULE$.equals(option)) {
            return this.copy((Map<RDFNode, Map<ShapeMapLabel, Info>>)((Map)this.resultMap().updated((Object)node, mapLabels)), this.copy$default$2(), this.copy$default$3());
        }
        if (option instanceof Some) {
            Map vs = (Map)((Some)option).value();
            return this.copy((Map<RDFNode, Map<ShapeMapLabel, Info>>)((Map)this.resultMap().updated((Object)node, (Object)vs.$plus$plus(mapLabels))), this.copy$default$2(), this.copy$default$3());
        }
        throw new MatchError((Object)option);
    }

    public List<ShapeMapLabel> getConformantShapes(RDFNode node) {
        Option option = this.resultMap().get((Object)node);
        if (None$.MODULE$.equals(option)) {
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        if (option instanceof Some) {
            Map m = (Map)((Some)option).value();
            return m.toList().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2;
                    Tuple2 p = tuple2 = x;
                    Status status = ((Info)p._2()).status();
                    Status$Conformant$ status$Conformant$ = Status$Conformant$.MODULE$;
                    return !(status != null ? !status.equals(status$Conformant$) : status$Conformant$ != null);
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2;
                    Tuple2 p = tuple2 = x;
                    Status status = ((Info)p._2()).status();
                    Status$Conformant$ status$Conformant$ = Status$Conformant$.MODULE$;
                    if (!(status != null ? !status.equals(status$Conformant$) : status$Conformant$ != null)) {
                        return (ShapeMapLabel)p._1();
                    }
                    return function1.apply((Object)x);
                }
            });
        }
        throw new MatchError((Object)option);
    }

    public Info getInfo(RDFNode node, ShapeMapLabel shape) {
        Option option = this.resultMap().get((Object)node);
        if (None$.MODULE$.equals(option)) {
            return Info$.MODULE$.undefined(new StringBuilder(19).append("Node ").append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" not found in ").append(Show$.MODULE$.apply(ShapeMap$.MODULE$.showShapeMap()).show((Object)this)).toString());
        }
        if (option instanceof Some) {
            Map m = (Map)((Some)option).value();
            Option option2 = m.get((Object)shape);
            if (None$.MODULE$.equals(option2)) {
                return Info$.MODULE$.undefined(new StringBuilder(33).append("Node ").append(implicits$.MODULE$.toShow((Object)node, RDFNode$.MODULE$.showRDFNode()).show()).append(" has no value for shape ").append(implicits$.MODULE$.toShow((Object)shape, ShapeMapLabel$.MODULE$.showShapeMapLabel()).show()).append(" in ").append(Show$.MODULE$.apply(ShapeMap$.MODULE$.showShapeMap()).show((Object)this)).toString());
            }
            if (option2 instanceof Some) {
                Info info = (Info)((Some)option2).value();
                return info;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public List<Tuple2<ShapeMapLabel, Info>> getInfoAll() {
        return (List)this.resultMap().values().foldLeft((Object)package$.MODULE$.List().empty(), (Function2 & Serializable)(acc, nodeResult) -> (List)acc.$plus$plus((IterableOnce)nodeResult));
    }

    public boolean isAllConformant() {
        return this.getInfoAll().forall((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Info info = (Info)tuple2._2();
                Status status = info.status();
                Status$Conformant$ status$Conformant$ = Status$Conformant$.MODULE$;
                return !(status != null ? !status.equals(status$Conformant$) : status$Conformant$ != null);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public List<ShapeMapLabel> getAllConformant() {
        return this.getInfoAll().filter((Function1 & Serializable)_$1 -> {
            Status status = ((Info)_$1._2()).status();
            Status$Conformant$ status$Conformant$ = Status$Conformant$.MODULE$;
            return !(status != null ? !status.equals(status$Conformant$) : status$Conformant$ != null);
        }).map((Function1 & Serializable)_$2 -> (ShapeMapLabel)_$2._1());
    }

    public List<ShapeMapLabel> getAllNonConformant() {
        List<ShapeMapLabel> conformant = this.getAllConformant();
        return this.getInfoAll().map((Function1 & Serializable)_$3 -> (ShapeMapLabel)_$3._1()).filter((Function1 & Serializable)_$4 -> !conformant.contains(_$4));
    }

    public List<String> getAllErrors() {
        return this.getInfoAll().map((Function1 & Serializable)_$5 -> (Info)_$5._2()).filter((Function1 & Serializable)_$6 -> {
            Status status = _$6.status();
            Status$NonConformant$ status$NonConformant$ = Status$NonConformant$.MODULE$;
            return !(status != null ? !status.equals(status$NonConformant$) : status$NonConformant$ != null);
        }).map((Function1 & Serializable)_$7 -> (String)_$7.reason().getOrElse(ResultShapeMap::getAllErrors$$anonfun$3$$anonfun$1));
    }

    public List<ShapeMapLabel> getNonConformantShapes(RDFNode node) {
        Option option = this.resultMap().get((Object)node);
        if (None$.MODULE$.equals(option)) {
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        if (option instanceof Some) {
            Map m = (Map)((Some)option).value();
            return m.toList().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2;
                    Tuple2 p = tuple2 = x;
                    Status status = ((Info)p._2()).status();
                    Status$NonConformant$ status$NonConformant$ = Status$NonConformant$.MODULE$;
                    return !(status != null ? !status.equals(status$NonConformant$) : status$NonConformant$ != null);
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2;
                    Tuple2 p = tuple2 = x;
                    Status status = ((Info)p._2()).status();
                    Status$NonConformant$ status$NonConformant$ = Status$NonConformant$.MODULE$;
                    if (!(status != null ? !status.equals(status$NonConformant$) : status$NonConformant$ != null)) {
                        return (ShapeMapLabel)p._1();
                    }
                    return function1.apply((Object)x);
                }
            });
        }
        throw new MatchError((Object)option);
    }

    public Seq<ShapeMapLabel> hasShapes(RDFNode node) {
        return (Seq)this.resultMap().get((Object)node).map((Function1 & Serializable)_$8 -> _$8.keySet().toSeq()).getOrElse(ResultShapeMap::hasShapes$$anonfun$2);
    }

    public boolean containsDeclaration(RDFNode node) {
        return this.resultMap().keySet().contains((Object)node);
    }

    public boolean noSolutions() {
        return this.resultMap().isEmpty();
    }

    @Override
    public List<Association> associations() {
        return this.associations;
    }

    public Either<String, ResultShapeMap> addAssociation(Association a) {
        NodeSelector nodeSelector = a.node();
        if (nodeSelector instanceof RDFNodeSelector) {
            RDFNode rDFNode;
            RDFNodeSelector rDFNodeSelector = RDFNodeSelector$.MODULE$.unapply((RDFNodeSelector)nodeSelector);
            RDFNode node = rDFNode = rDFNodeSelector._1();
            Option option = this.resultMap().get((Object)node);
            if (None$.MODULE$.equals(option)) {
                Object[] objectArray = new Tuple2[1];
                ShapeMapLabel shapeMapLabel = (ShapeMapLabel)Predef$.MODULE$.ArrowAssoc((Object)a.shape());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)shapeMapLabel, (Object)a.info());
                return package$.MODULE$.Right().apply((Object)this.copy((Map<RDFNode, Map<ShapeMapLabel, Info>>)((Map)this.resultMap().updated((Object)node, Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))), this.copy$default$2(), this.copy$default$3()));
            }
            if (option instanceof Some) {
                Map labelsMap = (Map)((Some)option).value();
                Option option2 = labelsMap.get((Object)a.shape());
                if (None$.MODULE$.equals(option2)) {
                    return package$.MODULE$.Right().apply((Object)this.copy((Map<RDFNode, Map<ShapeMapLabel, Info>>)((Map)this.resultMap().updated((Object)node, (Object)labelsMap.updated((Object)a.shape(), (Object)a.info()))), this.copy$default$2(), this.copy$default$3()));
                }
                if (option2 instanceof Some) {
                    Info info = (Info)((Some)option2).value();
                    Status status = info.status();
                    Status status2 = a.info().status();
                    if (!(status != null ? !status.equals(status2) : status2 != null)) {
                        return package$.MODULE$.Right().apply((Object)this);
                    }
                    return package$.MODULE$.Left().apply((Object)new StringBuilder(77).append("Cannot add association with contradictory status: Association: ").append(a).append(", Labels map: ").append(labelsMap).toString());
                }
                throw new MatchError((Object)option2);
            }
            throw new MatchError((Object)option);
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(71).append("Only RDFNode's can be added as associations to fixedShapeMaps. Value = ").append(a.node()).toString());
    }

    public Either<String, Object> compareWith(ResultShapeMap other) {
        scala.collection.immutable.Set nodes2;
        scala.collection.immutable.Set nodes1 = (scala.collection.immutable.Set)this.resultMap().keySet().filter((Function1 & Serializable)_$9 -> _$9.isIRI());
        scala.collection.immutable.Set delta = (scala.collection.immutable.Set)nodes1.diff((Set)(nodes2 = (scala.collection.immutable.Set)other.resultMap().keySet().filter((Function1 & Serializable)_$10 -> _$10.isIRI()))).union((Set)nodes2.diff((Set)nodes1));
        if (delta.nonEmpty()) {
            return package$.MODULE$.Left().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(120).append("|Nodes in map1 != nodes in map2. Delta: ").append(((IterableOnceOps)delta.map((Function1 & Serializable)node -> this.nodesPrefixMap().qualify(node))).mkString(",")).append("\n            |Nodes1=").append(((IterableOnceOps)nodes1.map((Function1 & Serializable)node -> this.nodesPrefixMap().qualify(node))).mkString(",")).append("\n            |Nodes2=").append(((IterableOnceOps)nodes2.map((Function1 & Serializable)node -> this.nodesPrefixMap().qualify(node))).mkString(",")).append("\n            |Map1=").append(this).append("\n            |Map2=").append(other).toString())));
        }
        List es = ((IterableOnceOps)((IterableOps)this.resultMap().filter((Function1 & Serializable)_$11 -> !((RDFNode)_$11._1()).isBNode())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                RDFNode node = (RDFNode)tuple2._1();
                Map shapes1 = (Map)tuple2._2();
                Option option = other.resultMap().get((Object)node);
                if (None$.MODULE$.equals(option)) {
                    return package$.MODULE$.Left().apply((Object)new StringBuilder(50).append("Node ").append(this.nodesPrefixMap().qualify(node)).append(" appears in map1 with shapes ").append(shapes1).append(" but not in map2").toString());
                }
                if (option instanceof Some) {
                    Map shapes2 = (Map)((Some)option).value();
                    return this.compareShapes(node, (Map<ShapeMapLabel, Info>)shapes1, (Map<ShapeMapLabel, Info>)shapes2);
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        return this.seqEither(es).map((Function1 & Serializable)_$12 -> true);
    }

    private Either<String, Object> compareShapes(RDFNode node, Map<ShapeMapLabel, Info> shapes1, Map<ShapeMapLabel, Info> shapes2) {
        if (shapes1.keySet().count((Function1 & Serializable)_$13 -> !_$13.isBNodeLabel()) != shapes2.keySet().count((Function1 & Serializable)_$14 -> !_$14.isBNodeLabel())) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(42).append("Node ").append(node).append(" has different values. Map1: ").append(shapes1).append(", Map2: ").append(shapes2).toString());
        }
        List es = ((IterableOnceOps)((IterableOps)shapes1.filter((Function1 & Serializable)_$15 -> !((ShapeMapLabel)_$15._1()).isBNodeLabel())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ShapeMapLabel label = (ShapeMapLabel)tuple2._1();
                Info info1 = (Info)tuple2._2();
                Option option = shapes2.get((Object)label);
                if (None$.MODULE$.equals(option)) {
                    return package$.MODULE$.Left().apply((Object)new StringBuilder(84).append("Node ").append(node).append(" has label ").append(label).append(" in map1 but doesn't have that label in map2. Shapes1 = ").append(shapes1).append(", Shapes2 = ").append(shapes2).toString());
                }
                if (option instanceof Some) {
                    Info info2 = (Info)((Some)option).value();
                    Status status = info1.status();
                    Status status2 = info2.status();
                    if (!(status != null ? !status.equals(status2) : status2 != null)) {
                        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    return package$.MODULE$.Left().apply((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(116).append("|Node ").append(node).append(" is ").append(info1.status()).append(" for label ").append(label).append(" in map1 and ").append(info2.status()).append(" in map2\n                  |Reason1: ").append(info1.reason()).append("\n                  |Reason2: ").append(info2.reason()).append("\n               ").toString())));
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        Either r = this.seqEither(es);
        return r.map((Function1 & Serializable)_$16 -> true);
    }

    private <A, B> Either<String, List<B>> seqEither(List<Either<String, B>> es) {
        return (Either)implicits$.MODULE$.toTraverseOps(es, UnorderedFoldable$.MODULE$.catsTraverseForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)Invariant$.MODULE$.catsMonadErrorForEither());
    }

    private ResultShapeMap cnvResultMap(Function1<RDFNode, RDFNode> cnvNode, Function1<ShapeMapLabel, ShapeMapLabel> cnvLabel) {
        return ResultShapeMap$.MODULE$.apply((Map<RDFNode, Map<ShapeMapLabel, Info>>)MapUtils$.MODULE$.cnvMapMap(this.resultMap(), cnvNode, cnvLabel, (Function1 & Serializable)x -> (Info)Predef$.MODULE$.identity(x)), this.nodesPrefixMap(), this.shapesPrefixMap());
    }

    @Override
    public ShapeMap relativize(Option<IRI> maybeBase) {
        Option<IRI> option = maybeBase;
        if (None$.MODULE$.equals(option)) {
            return this;
        }
        if (option instanceof Some) {
            IRI base = (IRI)((Some)option).value();
            return this.cnvResultMap((Function1<RDFNode, RDFNode>)(Function1 & Serializable)_$17 -> _$17.relativize(base), (Function1<ShapeMapLabel, ShapeMapLabel>)(Function1 & Serializable)_$18 -> _$18.relativize(base));
        }
        throw new MatchError(option);
    }

    public ResultShapeMap copy(Map<RDFNode, Map<ShapeMapLabel, Info>> resultMap, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
        return new ResultShapeMap(resultMap, nodesPrefixMap, shapesPrefixMap);
    }

    public Map<RDFNode, Map<ShapeMapLabel, Info>> copy$default$1() {
        return this.resultMap();
    }

    public PrefixMap copy$default$2() {
        return this.nodesPrefixMap();
    }

    public PrefixMap copy$default$3() {
        return this.shapesPrefixMap();
    }

    public Map<RDFNode, Map<ShapeMapLabel, Info>> _1() {
        return this.resultMap();
    }

    public PrefixMap _2() {
        return this.nodesPrefixMap();
    }

    public PrefixMap _3() {
        return this.shapesPrefixMap();
    }

    private static final String getAllErrors$$anonfun$3$$anonfun$1() {
        return "Unknown error";
    }

    private static final Seq hasShapes$$anonfun$2() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }
}

