/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shapemaps;

import cats.Show;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.implicits$;
import cats.syntax.EitherOps$;
import es.weso.rdf.PrefixMap;
import es.weso.rdf.PrefixMap$;
import es.weso.rdf.RDFReader;
import es.weso.rdf.nodes.IRI;
import es.weso.rdf.nodes.RDFNode;
import es.weso.shapemaps.Association;
import es.weso.shapemaps.Association$;
import es.weso.shapemaps.FixedShapeMap;
import es.weso.shapemaps.FixedShapeMap$;
import es.weso.shapemaps.Parser$;
import es.weso.shapemaps.QueryShapeMap;
import es.weso.shapemaps.QueryShapeMap$;
import es.weso.shapemaps.RDFNodeSelector$;
import es.weso.shapemaps.ResultShapeMap;
import es.weso.shapemaps.ResultShapeMap$;
import es.weso.shapemaps.ShapeMap;
import es.weso.shapemaps.ShapeMap$ShapeMapFromPathException$;
import es.weso.shapemaps.ShapeMapFormat$;
import es.weso.utils.FileUtils$;
import fs2.Compiler;
import fs2.Compiler$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.syntax.package;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

public final class ShapeMap$
implements Serializable {
    public static final ShapeMap$ShapeMapFromPathException$ ShapeMapFromPathException;
    private static final Encoder encodeShapeMap;
    private static final Show showShapeMap;
    private static final Decoder decodeShapeMap;
    public static final ShapeMap$ MODULE$;

    private ShapeMap$() {
    }

    static {
        MODULE$ = new ShapeMap$();
        encodeShapeMap = new Encoder<ShapeMap>(){

            public final Json apply(ShapeMap a) {
                List list = (List)io.circe.syntax.package$.MODULE$.EncoderOps(a.associations());
                return package.EncoderOps$.MODULE$.asJson$extension((Object)list, (Encoder)Encoder$.MODULE$.encodeList(Association$.MODULE$.encodeAssociation()));
            }
        };
        showShapeMap = new Show<ShapeMap>(){

            public final String show(ShapeMap s) {
                return s.toString();
            }
        };
        decodeShapeMap = Decoder$.MODULE$.instance((Function1 & Serializable)c -> c.as(Decoder$.MODULE$.decodeList(Association$.MODULE$.decodeAssociation())).map((Function1 & Serializable)associations -> QueryShapeMap$.MODULE$.apply((List<Association>)associations, PrefixMap$.MODULE$.empty(), PrefixMap$.MODULE$.empty())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ShapeMap$.class);
    }

    public List<String> availableFormats() {
        return ShapeMapFormat$.MODULE$.availableFormatNames();
    }

    public ShapeMap empty() {
        return FixedShapeMap$.MODULE$.empty();
    }

    public Either<NonEmptyList<String>, ShapeMap> fromInputStream(InputStream is, String format, Option<IRI> base, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
        InputStreamReader reader = new InputStreamReader(is);
        return Parser$.MODULE$.parseReader(reader, base, nodesPrefixMap, shapesPrefixMap);
    }

    public IO<Either<NonEmptyList<String>, ShapeMap>> fromURI(String uri, String format, Option<IRI> base, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
        Try t = Try$.MODULE$.apply(() -> this.$anonfun$3(uri, format, base, nodesPrefixMap, shapesPrefixMap));
        return (IO)t.fold((Function1 & Serializable)e -> IO$.MODULE$.raiseError((Throwable)new RuntimeException(new StringBuilder(49).append("Exception obtaining URI contents. URI = ").append(uri).append(". Error: ").append(e.getLocalizedMessage()).toString())), (Function1 & Serializable)e -> IO$.MODULE$.pure(e));
    }

    public String es$weso$shapemaps$ShapeMap$$$ShapeMapFromPathException$superArg$1(NonEmptyList<String> errors, Path path, String format, Option<IRI> base, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(350).append("|Error obtaining shapeMap from path\n                                 |Errors: ").append(errors.toList().mkString("\n")).append("\n                                 |Absolute path: ").append(path.toFile().getAbsolutePath()).append("\n                                 |Format: ").append(format).append("\n                                 |Base: ").append(base.map((Function1 & Serializable)_$4 -> _$4.getLexicalForm()).getOrElse(this::ShapeMapFromPathException$superArg$1$$anonfun$2)).append("\n                                 |NodesPrefixMap: ").append(nodesPrefixMap.toString()).append("\n                                 |ShapesPrefixMap: ").append(shapesPrefixMap.toString()).append("\n                                 |").toString()));
    }

    public IO<ShapeMap> fromPath(Path path, String format, Option<IRI> base, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
        return FileUtils$.MODULE$.getContents(path).flatMap((Function1 & Serializable)str -> ((IO)this.fromString((String)str, format, base, nodesPrefixMap, shapesPrefixMap).fold((Function1 & Serializable)nes -> IO$.MODULE$.raiseError((Throwable)ShapeMap$ShapeMapFromPathException$.MODULE$.apply((NonEmptyList<String>)nes, path, format, base, nodesPrefixMap, shapesPrefixMap)), (Function1 & Serializable)sm -> IO$.MODULE$.pure(sm))).map((Function1 & Serializable)sm -> sm));
    }

    public Option<IRI> fromPath$default$3() {
        return None$.MODULE$;
    }

    public PrefixMap fromPath$default$4() {
        return PrefixMap$.MODULE$.empty();
    }

    public PrefixMap fromPath$default$5() {
        return PrefixMap$.MODULE$.empty();
    }

    public Either<NonEmptyList<String>, ShapeMap> fromString(String str, String format, Option<IRI> base, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
        String string = format.toUpperCase();
        if ("JSON".equals(string)) {
            return this.fromJson(str);
        }
        if ("COMPACT".equals(string)) {
            return this.fromCompact(str, base, nodesPrefixMap, shapesPrefixMap);
        }
        return package$.MODULE$.Left().apply((Object)NonEmptyList$.MODULE$.one((Object)"Unknown format for shapeMap"));
    }

    public Option<IRI> fromString$default$3() {
        return None$.MODULE$;
    }

    public PrefixMap fromString$default$4() {
        return PrefixMap$.MODULE$.empty();
    }

    public PrefixMap fromString$default$5() {
        return PrefixMap$.MODULE$.empty();
    }

    public Either<NonEmptyList<String>, ShapeMap> fromCompact(String str, Option<IRI> base, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
        if (str.isEmpty()) {
            return package$.MODULE$.Right().apply((Object)this.empty());
        }
        return Parser$.MODULE$.parse(str, base, nodesPrefixMap, shapesPrefixMap);
    }

    public Option<IRI> fromCompact$default$2() {
        return None$.MODULE$;
    }

    public PrefixMap fromCompact$default$3() {
        return PrefixMap$.MODULE$.empty();
    }

    public PrefixMap fromCompact$default$4() {
        return PrefixMap$.MODULE$.empty();
    }

    public Either<NonEmptyList<String>, ShapeMap> fromJson(String jsonStr) {
        Either either = implicits$.MODULE$.catsSyntaxEither(io.circe.parser.package$.MODULE$.decode(jsonStr, this.decodeShapeMap()));
        return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)s -> NonEmptyList$.MODULE$.one((Object)s.getMessage()));
    }

    public IO<ResultShapeMap> parseResultMap(String str, Option<IRI> base, RDFReader rdf, PrefixMap shapesPrefixMap) {
        return rdf.getPrefixMap().flatMap((Function1 & Serializable)rdfPrefixMap -> IO$.MODULE$.apply(() -> this.parseResultMap$$anonfun$1$$anonfun$1(str, base, shapesPrefixMap, rdfPrefixMap)).flatMap((Function1 & Serializable)queryMap -> this.fixShapeMap((ShapeMap)queryMap, rdf, (PrefixMap)rdfPrefixMap, shapesPrefixMap).map((Function1 & Serializable)fixedMap -> ResultShapeMap$.MODULE$.apply(fixedMap.shapeMap(), (PrefixMap)rdfPrefixMap, shapesPrefixMap))));
    }

    public PrefixMap parseResultMap$default$4() {
        return PrefixMap$.MODULE$.empty();
    }

    public IO<FixedShapeMap> fixShapeMap(ShapeMap shapeMap, RDFReader rdf, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
        IO empty = IO$.MODULE$.pure((Object)FixedShapeMap$.MODULE$.empty().addNodesPrefixMap(nodesPrefixMap).addShapesPrefixMap(shapesPrefixMap));
        return (IO)shapeMap.associations().foldRight((Object)empty, (Function2 & Serializable)(a, current) -> this.combine$1(rdf, (Association)a, (IO)current));
    }

    public Encoder<ShapeMap> encodeShapeMap() {
        return encodeShapeMap;
    }

    public Show<ShapeMap> showShapeMap() {
        return showShapeMap;
    }

    public Decoder<ShapeMap> decodeShapeMap() {
        return decodeShapeMap;
    }

    public List<String> formats() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"COMPACT", "JSON"}));
    }

    public String defaultFormat() {
        return (String)this.formats().head();
    }

    private final Either $anonfun$3(String uri$1, String format$1, Option base$2, PrefixMap nodesPrefixMap$1, PrefixMap shapesPrefixMap$1) {
        String contents = Source$.MODULE$.fromURL(uri$1, Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Either<NonEmptyList<String>, ShapeMap> either = this.fromString(contents, format$1, (Option<IRI>)base$2, nodesPrefixMap$1, shapesPrefixMap$1);
        return either;
    }

    private final String ShapeMapFromPathException$superArg$1$$anonfun$2() {
        return "";
    }

    private final QueryShapeMap parseResultMap$$anonfun$1$$anonfun$1(String str$2, Option base$6, PrefixMap shapesPrefixMap$5, PrefixMap rdfPrefixMap$1) {
        return (QueryShapeMap)Parser$.MODULE$.parse(str$2, (Option<IRI>)base$6, rdfPrefixMap$1, shapesPrefixMap$5).fold((Function1 & Serializable)e -> {
            throw new RuntimeException(new StringBuilder(38).append("Error parsing as ShapeMap str:").append(str$2).append("\nError: ").append(e).toString());
        }, (Function1 & Serializable)x -> (QueryShapeMap)Predef$.MODULE$.identity(x));
    }

    private final FixedShapeMap addNode$1$$anonfun$1$$anonfun$1(Association a$1, RDFNode node$1, FixedShapeMap fixed$1) {
        return (FixedShapeMap)fixed$1.addAssociation(Association$.MODULE$.apply(RDFNodeSelector$.MODULE$.apply(node$1), a$1.shape(), a$1.info())).fold((Function1 & Serializable)e -> {
            throw new RuntimeException(new StringBuilder(30).append("Error adding association: ").append(a$1).append(" to ").append(fixed$1).toString());
        }, (Function1 & Serializable)x -> (FixedShapeMap)Predef$.MODULE$.identity(x));
    }

    private final IO addNode$1(Association a, RDFNode node, IO current) {
        return current.flatMap((Function1 & Serializable)fixed -> IO$.MODULE$.apply(() -> this.addNode$1$$anonfun$1$$anonfun$1(a, node, fixed)).map((Function1 & Serializable)newShapeMap -> newShapeMap));
    }

    private final IO combine$1(RDFReader rdf$3, Association a, IO current) {
        return ((IO)a.node().select(rdf$3).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).toList()).flatMap((Function1 & Serializable)nodes -> ((IO)nodes.foldRight((Object)current, (Function2 & Serializable)(node, current) -> this.addNode$1(a, (RDFNode)node, (IO)current))).map((Function1 & Serializable)r -> r));
    }
}

