/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shapemaps;

import cats.data.NonEmptyList;
import cats.effect.IO;
import es.weso.rdf.PREFIXES$;
import es.weso.rdf.PrefixMap;
import es.weso.rdf.RDFReader;
import es.weso.rdf.nodes.BNode;
import es.weso.rdf.nodes.IRI;
import es.weso.rdf.nodes.RDFNode;
import es.weso.rdf.path.AlternativePath;
import es.weso.rdf.path.AlternativePath$;
import es.weso.rdf.path.InversePath;
import es.weso.rdf.path.InversePath$;
import es.weso.rdf.path.OneOrMorePath;
import es.weso.rdf.path.OneOrMorePath$;
import es.weso.rdf.path.PredicatePath;
import es.weso.rdf.path.PredicatePath$;
import es.weso.rdf.path.SHACLPath;
import es.weso.rdf.path.SequencePath;
import es.weso.rdf.path.SequencePath$;
import es.weso.rdf.path.ZeroOrMorePath;
import es.weso.rdf.path.ZeroOrMorePath$;
import es.weso.rdf.path.ZeroOrOnePath;
import es.weso.rdf.path.ZeroOrOnePath$;
import es.weso.shapemaps.Association;
import es.weso.shapemaps.Association$;
import es.weso.shapemaps.BNodeLabel;
import es.weso.shapemaps.BNodeLabel$;
import es.weso.shapemaps.Compact$;
import es.weso.shapemaps.CompactDetails$;
import es.weso.shapemaps.FixedShapeMap;
import es.weso.shapemaps.Focus$;
import es.weso.shapemaps.IRILabel;
import es.weso.shapemaps.IRILabel$;
import es.weso.shapemaps.Info;
import es.weso.shapemaps.JsonShapeMapFormat$;
import es.weso.shapemaps.NodePattern;
import es.weso.shapemaps.NodePattern$;
import es.weso.shapemaps.NodeSelector;
import es.weso.shapemaps.Pattern;
import es.weso.shapemaps.RDFNodeSelector;
import es.weso.shapemaps.RDFNodeSelector$;
import es.weso.shapemaps.ResultShapeMap;
import es.weso.shapemaps.ShapeMap$;
import es.weso.shapemaps.ShapeMap$ShapeMapFromPathException$;
import es.weso.shapemaps.ShapeMapFormat;
import es.weso.shapemaps.ShapeMapFormat$;
import es.weso.shapemaps.ShapeMapLabel;
import es.weso.shapemaps.SparqlSelector;
import es.weso.shapemaps.SparqlSelector$;
import es.weso.shapemaps.Start$;
import es.weso.shapemaps.Status;
import es.weso.shapemaps.Status$NonConformant$;
import es.weso.shapemaps.TriplePattern;
import es.weso.shapemaps.TriplePattern$;
import es.weso.shapemaps.WildCard$;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.Json;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.control.NoStackTrace;

public abstract class ShapeMap {
    public static List<String> availableFormats() {
        return ShapeMap$.MODULE$.availableFormats();
    }

    public static Decoder<ShapeMap> decodeShapeMap() {
        return ShapeMap$.MODULE$.decodeShapeMap();
    }

    public static String defaultFormat() {
        return ShapeMap$.MODULE$.defaultFormat();
    }

    public static ShapeMap empty() {
        return ShapeMap$.MODULE$.empty();
    }

    public static Encoder<ShapeMap> encodeShapeMap() {
        return ShapeMap$.MODULE$.encodeShapeMap();
    }

    public static IO<FixedShapeMap> fixShapeMap(ShapeMap shapeMap, RDFReader rDFReader, PrefixMap prefixMap, PrefixMap prefixMap2) {
        return ShapeMap$.MODULE$.fixShapeMap(shapeMap, rDFReader, prefixMap, prefixMap2);
    }

    public static List<String> formats() {
        return ShapeMap$.MODULE$.formats();
    }

    public static Either<NonEmptyList<String>, ShapeMap> fromCompact(String string, Option<IRI> option, PrefixMap prefixMap, PrefixMap prefixMap2) {
        return ShapeMap$.MODULE$.fromCompact(string, option, prefixMap, prefixMap2);
    }

    public static Either<NonEmptyList<String>, ShapeMap> fromInputStream(InputStream inputStream, String string, Option<IRI> option, PrefixMap prefixMap, PrefixMap prefixMap2) {
        return ShapeMap$.MODULE$.fromInputStream(inputStream, string, option, prefixMap, prefixMap2);
    }

    public static Either<NonEmptyList<String>, ShapeMap> fromJson(String string) {
        return ShapeMap$.MODULE$.fromJson(string);
    }

    public static IO<ShapeMap> fromPath(Path path, String string, Option<IRI> option, PrefixMap prefixMap, PrefixMap prefixMap2) {
        return ShapeMap$.MODULE$.fromPath(path, string, option, prefixMap, prefixMap2);
    }

    public static Either<NonEmptyList<String>, ShapeMap> fromString(String string, String string2, Option<IRI> option, PrefixMap prefixMap, PrefixMap prefixMap2) {
        return ShapeMap$.MODULE$.fromString(string, string2, option, prefixMap, prefixMap2);
    }

    public static IO<Either<NonEmptyList<String>, ShapeMap>> fromURI(String string, String string2, Option<IRI> option, PrefixMap prefixMap, PrefixMap prefixMap2) {
        return ShapeMap$.MODULE$.fromURI(string, string2, option, prefixMap, prefixMap2);
    }

    public static IO<ResultShapeMap> parseResultMap(String string, Option<IRI> option, RDFReader rDFReader, PrefixMap prefixMap) {
        return ShapeMap$.MODULE$.parseResultMap(string, option, rDFReader, prefixMap);
    }

    public static Option<IRI> fromCompact$default$2() {
        return ShapeMap$.MODULE$.fromCompact$default$2();
    }

    public static PrefixMap fromCompact$default$3() {
        return ShapeMap$.MODULE$.fromCompact$default$3();
    }

    public static Option<IRI> fromPath$default$3() {
        return ShapeMap$.MODULE$.fromPath$default$3();
    }

    public static Option<IRI> fromString$default$3() {
        return ShapeMap$.MODULE$.fromString$default$3();
    }

    public static PrefixMap fromCompact$default$4() {
        return ShapeMap$.MODULE$.fromCompact$default$4();
    }

    public static PrefixMap fromPath$default$4() {
        return ShapeMap$.MODULE$.fromPath$default$4();
    }

    public static PrefixMap fromString$default$4() {
        return ShapeMap$.MODULE$.fromString$default$4();
    }

    public static PrefixMap parseResultMap$default$4() {
        return ShapeMap$.MODULE$.parseResultMap$default$4();
    }

    public static PrefixMap fromPath$default$5() {
        return ShapeMap$.MODULE$.fromPath$default$5();
    }

    public static PrefixMap fromString$default$5() {
        return ShapeMap$.MODULE$.fromString$default$5();
    }

    public abstract List<Association> associations();

    public boolean isEmpty() {
        return this.associations().isEmpty();
    }

    public abstract PrefixMap nodesPrefixMap();

    public abstract PrefixMap shapesPrefixMap();

    public Either<String, ShapeMap> add(RDFNode node, ShapeMapLabel label) {
        return this.addAssociation(Association$.MODULE$.apply(RDFNodeSelector$.MODULE$.apply(node), label, Association$.MODULE$.$lessinit$greater$default$3()));
    }

    public abstract Either<String, ShapeMap> addAssociation(Association var1);

    public Json toJson() {
        ShapeMap shapeMap = (ShapeMap)package$.MODULE$.EncoderOps((Object)this);
        return package.EncoderOps$.MODULE$.asJson$extension((Object)shapeMap, ShapeMap$.MODULE$.encodeShapeMap());
    }

    public Either<String, String> serialize(String format, Option<IRI> base) {
        return ShapeMapFormat$.MODULE$.fromString(format).map((Function1 & Serializable)_$1 -> {
            ShapeMapFormat shapeMapFormat = _$1;
            if (Compact$.MODULE$.equals(shapeMapFormat)) {
                return this.relativize(base).showShapeMap(false);
            }
            if (JsonShapeMapFormat$.MODULE$.equals(shapeMapFormat)) {
                return this.toJson().spaces2();
            }
            if (CompactDetails$.MODULE$.equals(shapeMapFormat)) {
                return this.relativize(base).showShapeMap(true);
            }
            throw new MatchError((Object)shapeMapFormat);
        });
    }

    public Option<IRI> serialize$default$2() {
        return None$.MODULE$;
    }

    public abstract ShapeMap relativize(Option<IRI> var1);

    private String showPattern(Pattern p, PrefixMap pm) {
        Pattern pattern = p;
        if (pattern instanceof NodePattern) {
            RDFNode rDFNode;
            NodePattern nodePattern = NodePattern$.MODULE$.unapply((NodePattern)pattern);
            RDFNode node = rDFNode = nodePattern._1();
            return pm.qualify(node);
        }
        if (WildCard$.MODULE$.equals(pattern)) {
            return "_";
        }
        if (Focus$.MODULE$.equals(pattern)) {
            return "FOCUS";
        }
        throw new MatchError((Object)pattern);
    }

    private String showPath(SHACLPath path, PrefixMap pm) {
        SHACLPath sHACLPath = path;
        if (sHACLPath instanceof PredicatePath) {
            PredicatePath predicatePath = PredicatePath$.MODULE$.unapply((PredicatePath)sHACLPath);
            IRI iRI = predicatePath._1();
            IRI iRI2 = PREFIXES$.MODULE$.rdf$colontype();
            IRI iRI3 = iRI;
            if (!(iRI2 != null ? !iRI2.equals(iRI3) : iRI3 != null)) {
                return "a";
            }
            IRI iri = iRI;
            return pm.qualify((RDFNode)iri);
        }
        if (sHACLPath instanceof InversePath) {
            SHACLPath sHACLPath2;
            InversePath inversePath = InversePath$.MODULE$.unapply((InversePath)sHACLPath);
            SHACLPath path2 = sHACLPath2 = inversePath._1();
            return new StringBuilder(1).append("^").append(this.showPath(path2, pm)).toString();
        }
        if (sHACLPath instanceof SequencePath) {
            Seq seq;
            SequencePath sequencePath = SequencePath$.MODULE$.unapply((SequencePath)sHACLPath);
            Seq paths = seq = sequencePath._1();
            return ((IterableOnceOps)paths.map((Function1 & Serializable)_$2 -> this.showPath((SHACLPath)_$2, pm))).mkString("/");
        }
        if (sHACLPath instanceof AlternativePath) {
            Seq seq;
            AlternativePath alternativePath = AlternativePath$.MODULE$.unapply((AlternativePath)sHACLPath);
            Seq paths = seq = alternativePath._1();
            return ((IterableOnceOps)paths.map((Function1 & Serializable)_$3 -> this.showPath((SHACLPath)_$3, pm))).mkString("|");
        }
        if (sHACLPath instanceof OneOrMorePath) {
            SHACLPath sHACLPath3;
            OneOrMorePath oneOrMorePath = OneOrMorePath$.MODULE$.unapply((OneOrMorePath)sHACLPath);
            SHACLPath path3 = sHACLPath3 = oneOrMorePath._1();
            return new StringBuilder(1).append(this.showPath(path3, pm)).append("+").toString();
        }
        if (sHACLPath instanceof ZeroOrMorePath) {
            SHACLPath sHACLPath4;
            ZeroOrMorePath zeroOrMorePath = ZeroOrMorePath$.MODULE$.unapply((ZeroOrMorePath)sHACLPath);
            SHACLPath path4 = sHACLPath4 = zeroOrMorePath._1();
            return new StringBuilder(1).append(this.showPath(path4, pm)).append("*").toString();
        }
        if (sHACLPath instanceof ZeroOrOnePath) {
            SHACLPath sHACLPath5;
            ZeroOrOnePath zeroOrOnePath = ZeroOrOnePath$.MODULE$.unapply((ZeroOrOnePath)sHACLPath);
            SHACLPath path5 = sHACLPath5 = zeroOrOnePath._1();
            return new StringBuilder(1).append(this.showPath(path5, pm)).append("?").toString();
        }
        throw new MatchError((Object)sHACLPath);
    }

    private String showNodeSelector(NodeSelector n, PrefixMap pm) {
        NodeSelector nodeSelector = n;
        if (nodeSelector instanceof RDFNodeSelector) {
            RDFNode rDFNode;
            RDFNodeSelector rDFNodeSelector = RDFNodeSelector$.MODULE$.unapply((RDFNodeSelector)nodeSelector);
            RDFNode node = rDFNode = rDFNodeSelector._1();
            return pm.qualify(node);
        }
        if (nodeSelector instanceof TriplePattern) {
            TriplePattern triplePattern = TriplePattern$.MODULE$.unapply((TriplePattern)nodeSelector);
            Pattern pattern = triplePattern._1();
            SHACLPath sHACLPath = triplePattern._2();
            Pattern pattern2 = triplePattern._3();
            Pattern sub = pattern;
            SHACLPath path = sHACLPath;
            Pattern obj = pattern2;
            return new StringBuilder(4).append("{").append(this.showPattern(sub, pm)).append(" ").append(this.showPath(path, pm)).append(" ").append(this.showPattern(obj, pm)).append("}").toString();
        }
        if (nodeSelector instanceof SparqlSelector) {
            String string;
            SparqlSelector sparqlSelector = SparqlSelector$.MODULE$.unapply((SparqlSelector)nodeSelector);
            String query = string = sparqlSelector._1();
            return new StringBuilder(9).append("SPARQL `").append(query).append("`").toString();
        }
        throw new MatchError((Object)nodeSelector);
    }

    private String showShapeMapLabel(ShapeMapLabel label, PrefixMap pm) {
        ShapeMapLabel shapeMapLabel = label;
        if (shapeMapLabel instanceof IRILabel) {
            IRI iRI;
            IRILabel iRILabel = IRILabel$.MODULE$.unapply((IRILabel)shapeMapLabel);
            IRI iri = iRI = iRILabel._1();
            return pm.qualify((RDFNode)iri);
        }
        if (shapeMapLabel instanceof BNodeLabel) {
            BNode bNode;
            BNodeLabel bNodeLabel = BNodeLabel$.MODULE$.unapply((BNodeLabel)shapeMapLabel);
            BNode bn = bNode = bNodeLabel._1();
            return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("_:"), bn.getLexicalForm());
        }
        if (Start$.MODULE$.equals(shapeMapLabel)) {
            return "Start";
        }
        throw new MatchError((Object)shapeMapLabel);
    }

    public String showShapeMap(boolean withDetails) {
        String sep;
        String string = sep = withDetails ? ",\n" : ", ";
        if (this.associations().isEmpty()) {
            return "# Empty shape map";
        }
        return this.associations().map((Function1 & Serializable)a -> this.showAssociation((Association)a, this.nodesPrefixMap(), this.shapesPrefixMap(), withDetails)).mkString(sep);
    }

    public String toString() {
        return this.showShapeMap(false);
    }

    private String showAssociation(Association a, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap, boolean withDetails) {
        Status status = a.info().status();
        Status$NonConformant$ status$NonConformant$ = Status$NonConformant$.MODULE$;
        return new StringBuilder(1).append(this.showNodeSelector(a.node(), nodesPrefixMap)).append("@").append(!(status != null ? !status.equals(status$NonConformant$) : status$NonConformant$ != null) ? "!" : "").append(this.showShapeMapLabel(a.shape(), shapesPrefixMap)).append(withDetails ? this.showDetails(a.info()) : "").toString();
    }

    private String showDetails(Info info) {
        String tab = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 3);
        String str = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString((String)info.reason().getOrElse(ShapeMap::$anonfun$1))).map((Function1 & Serializable)line -> new StringBuilder(2).append(tab).append("# ").append((String)line).toString()).mkString("\n");
        return new StringBuilder(1).append("\n").append(str).toString();
    }

    private static final String $anonfun$1() {
        return "";
    }

    public static class ShapeMapFromPathException
    extends RuntimeException
    implements NoStackTrace,
    Product {
        private final NonEmptyList errors;
        private final Path path;
        private final String format;
        private final Option base;
        private final PrefixMap nodesPrefixMap;
        private final PrefixMap shapesPrefixMap;

        public static ShapeMapFromPathException apply(NonEmptyList<String> nonEmptyList, Path path, String string, Option<IRI> option, PrefixMap prefixMap, PrefixMap prefixMap2) {
            return ShapeMap$ShapeMapFromPathException$.MODULE$.apply(nonEmptyList, path, string, option, prefixMap, prefixMap2);
        }

        public static ShapeMapFromPathException fromProduct(Product product) {
            return ShapeMap$ShapeMapFromPathException$.MODULE$.fromProduct(product);
        }

        public static ShapeMapFromPathException unapply(ShapeMapFromPathException shapeMapFromPathException) {
            return ShapeMap$ShapeMapFromPathException$.MODULE$.unapply(shapeMapFromPathException);
        }

        public ShapeMapFromPathException(NonEmptyList<String> errors, Path path, String format, Option<IRI> base, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
            this.errors = errors;
            this.path = path;
            this.format = format;
            this.base = base;
            this.nodesPrefixMap = nodesPrefixMap;
            this.shapesPrefixMap = shapesPrefixMap;
            super(ShapeMap$.MODULE$.es$weso$shapemaps$ShapeMap$$$ShapeMapFromPathException$superArg$1(errors, path, format, base, nodesPrefixMap, shapesPrefixMap));
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ShapeMapFromPathException)) return false;
            ShapeMapFromPathException shapeMapFromPathException = (ShapeMapFromPathException)object;
            NonEmptyList<String> nonEmptyList = this.errors();
            NonEmptyList<String> nonEmptyList2 = shapeMapFromPathException.errors();
            if (nonEmptyList == null) {
                if (nonEmptyList2 != null) {
                    return false;
                }
            } else if (!nonEmptyList.equals(nonEmptyList2)) return false;
            Path path = this.path();
            Path path2 = shapeMapFromPathException.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            String string = this.format();
            String string2 = shapeMapFromPathException.format();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<IRI> option = this.base();
            Option<IRI> option2 = shapeMapFromPathException.base();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            PrefixMap prefixMap = this.nodesPrefixMap();
            PrefixMap prefixMap2 = shapeMapFromPathException.nodesPrefixMap();
            if (prefixMap == null) {
                if (prefixMap2 != null) {
                    return false;
                }
            } else if (!prefixMap.equals(prefixMap2)) return false;
            PrefixMap prefixMap3 = this.shapesPrefixMap();
            PrefixMap prefixMap4 = shapeMapFromPathException.shapesPrefixMap();
            if (prefixMap3 == null) {
                if (prefixMap4 != null) {
                    return false;
                }
            } else if (!prefixMap3.equals(prefixMap4)) return false;
            if (!shapeMapFromPathException.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ShapeMapFromPathException;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "ShapeMapFromPathException";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "errors";
                }
                case 1: {
                    return "path";
                }
                case 2: {
                    return "format";
                }
                case 3: {
                    return "base";
                }
                case 4: {
                    return "nodesPrefixMap";
                }
                case 5: {
                    return "shapesPrefixMap";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public NonEmptyList<String> errors() {
            return this.errors;
        }

        public Path path() {
            return this.path;
        }

        public String format() {
            return this.format;
        }

        public Option<IRI> base() {
            return this.base;
        }

        public PrefixMap nodesPrefixMap() {
            return this.nodesPrefixMap;
        }

        public PrefixMap shapesPrefixMap() {
            return this.shapesPrefixMap;
        }

        public ShapeMapFromPathException copy(NonEmptyList<String> errors, Path path, String format, Option<IRI> base, PrefixMap nodesPrefixMap, PrefixMap shapesPrefixMap) {
            return new ShapeMapFromPathException(errors, path, format, base, nodesPrefixMap, shapesPrefixMap);
        }

        public NonEmptyList<String> copy$default$1() {
            return this.errors();
        }

        public Path copy$default$2() {
            return this.path();
        }

        public String copy$default$3() {
            return this.format();
        }

        public Option<IRI> copy$default$4() {
            return this.base();
        }

        public PrefixMap copy$default$5() {
            return this.nodesPrefixMap();
        }

        public PrefixMap copy$default$6() {
            return this.shapesPrefixMap();
        }

        public NonEmptyList<String> _1() {
            return this.errors();
        }

        public Path _2() {
            return this.path();
        }

        public String _3() {
            return this.format();
        }

        public Option<IRI> _4() {
            return this.base();
        }

        public PrefixMap _5() {
            return this.nodesPrefixMap();
        }

        public PrefixMap _6() {
            return this.shapesPrefixMap();
        }
    }
}

