/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shex;

import es.weso.rdf.PREFIXES$;
import es.weso.rdf.nodes.BooleanLiteral;
import es.weso.rdf.nodes.DatatypeLiteral;
import es.weso.rdf.nodes.DecimalLiteral;
import es.weso.rdf.nodes.DoubleLiteral;
import es.weso.rdf.nodes.IRI;
import es.weso.rdf.nodes.IntegerLiteral;
import es.weso.rdf.nodes.Lang;
import es.weso.rdf.nodes.LangLiteral;
import es.weso.rdf.nodes.Literal;
import es.weso.rdf.nodes.StringLiteral;
import es.weso.shex.DatatypeString;
import es.weso.shex.LangString;
import es.weso.shex.ObjectValue;
import es.weso.shex.StringValue;
import scala.MatchError;
import scala.math.BigDecimal;

public final class ObjectValue$ {
    public static final ObjectValue$ MODULE$ = new ObjectValue$();

    public ObjectValue trueValue() {
        return new DatatypeString("true", PREFIXES$.MODULE$.xsd$colonboolean());
    }

    public ObjectValue falseValue() {
        return new DatatypeString("false", PREFIXES$.MODULE$.xsd$colonboolean());
    }

    public ObjectValue intValue(int n, String repr) {
        return new DatatypeString(repr, PREFIXES$.MODULE$.xsd$coloninteger());
    }

    public ObjectValue intValue(int n) {
        return this.intValue(n, Integer.toString(n));
    }

    public ObjectValue doubleValue(double d, String repr) {
        return new DatatypeString(repr, PREFIXES$.MODULE$.xsd$colondouble());
    }

    public ObjectValue decimalValue(BigDecimal d, String repr) {
        return new DatatypeString(repr, PREFIXES$.MODULE$.xsd$colondecimal());
    }

    public ObjectValue stringValue(String str) {
        return new StringValue(str);
    }

    public ObjectValue literalValue(Literal l) {
        Literal literal = l;
        if (literal instanceof DatatypeLiteral) {
            IRI dt;
            DatatypeLiteral datatypeLiteral = (DatatypeLiteral)literal;
            String lex = datatypeLiteral.lexicalForm();
            IRI iRI = dt = datatypeLiteral.dataType();
            IRI iRI2 = PREFIXES$.MODULE$.xsd$colonstring();
            if (!(iRI != null ? !iRI.equals(iRI2) : iRI2 != null)) {
                return new StringValue(lex);
            }
            return new DatatypeString(lex, dt);
        }
        if (literal instanceof IntegerLiteral) {
            IntegerLiteral integerLiteral = (IntegerLiteral)literal;
            int n = integerLiteral.int();
            String repr = integerLiteral.repr();
            return this.intValue(n, repr);
        }
        if (literal instanceof DecimalLiteral) {
            DecimalLiteral decimalLiteral = (DecimalLiteral)literal;
            BigDecimal d = decimalLiteral.decimal();
            String repr = decimalLiteral.repr();
            return this.decimalValue(d, repr);
        }
        if (literal instanceof DoubleLiteral) {
            DoubleLiteral doubleLiteral = (DoubleLiteral)literal;
            double d = doubleLiteral.double();
            String repr = doubleLiteral.repr();
            return this.doubleValue(d, repr);
        }
        if (literal instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)literal;
            String s = stringLiteral.lexicalForm();
            return new StringValue(s);
        }
        if (literal instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)literal;
            boolean b = booleanLiteral.bool();
            if (b) {
                return this.trueValue();
            }
            return this.falseValue();
        }
        if (literal instanceof LangLiteral) {
            LangLiteral langLiteral = (LangLiteral)literal;
            String lex = langLiteral.lexicalForm();
            Lang lang = langLiteral.lang();
            return new LangString(lex, lang);
        }
        throw new MatchError((Object)literal);
    }

    private ObjectValue$() {
    }
}

