/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shex;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.MonadCancel;
import cats.implicits$;
import cats.syntax.EitherOps$;
import es.weso.rdf.PrefixMap;
import es.weso.rdf.RDFBuilder;
import es.weso.rdf.RDFReader;
import es.weso.rdf.locations.Location;
import es.weso.rdf.nodes.IRI;
import es.weso.rdf.nodes.IRI$;
import es.weso.shex.Schema;
import es.weso.shex.SemAct;
import es.weso.shex.ShapeExpr;
import es.weso.shex.ShapeLabel;
import es.weso.shex.TripleExpr;
import es.weso.shex.compact.CompactShow$;
import es.weso.shex.compact.Parser$;
import es.weso.shex.implicits.decoderShEx$;
import es.weso.shex.implicits.encoderShEx$;
import es.weso.shex.shexR.RDF2ShEx$;
import es.weso.shex.shexR.ShEx2RDF$;
import es.weso.utils.FileUtils$;
import es.weso.utils.VerboseLevel;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple9;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try$;

public final class Schema$
implements Serializable {
    public static final Schema$ MODULE$ = new Schema$();

    public List<String> rdfDataFormats(RDFReader rdfReader) {
        return rdfReader.availableParseFormats().map((Function1 & Serializable)x$11 -> x$11.toUpperCase());
    }

    public Schema empty() {
        return new Schema(IRI$.MODULE$.apply(""), (Option<PrefixMap>)None$.MODULE$, (Option<IRI>)None$.MODULE$, (Option<List<SemAct>>)None$.MODULE$, (Option<ShapeExpr>)None$.MODULE$, (Option<List<ShapeExpr>>)None$.MODULE$, (Option<Map<ShapeLabel, TripleExpr>>)None$.MODULE$, (List<IRI>)Nil$.MODULE$, (Option<Map<ShapeLabel, Location>>)None$.MODULE$);
    }

    public Schema emptyWithId(IRI iri) {
        return this.empty().withId(iri);
    }

    public IO<Schema> fromIRI(IRI i, Option<IRI> base, VerboseLevel verbose, Option<Tuple2<IRI, Path>> assumeLocal) {
        URI uri = i.uri();
        String string = uri.getScheme();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (Files.exists(Paths.get(i.uri()), new LinkOption[0])) {
                String str = Source$.MODULE$.fromURI(uri, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                return this.fromString(str, "ShExC", (Option<IRI>)new Some((Object)i), this.fromString$default$4()).map((Function1 & Serializable)schema -> schema.addId(i));
            }
            IRI iriShEx = i.$plus(".shex");
            if (Files.exists(Paths.get(iriShEx.uri()), new LinkOption[0])) {
                String str = Source$.MODULE$.fromURI(iriShEx.uri(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
                return this.fromString(str, "ShExC", (Option<IRI>)new Some((Object)i), this.fromString$default$4()).map((Function1 & Serializable)schema -> schema.addId(i));
            }
            IRI iriJson = i.$plus(".json");
            if (Files.exists(Paths.get(iriJson.uri()), new LinkOption[0])) {
                String str = Source$.MODULE$.fromURI(iriJson.uri(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
                return this.fromString(str, "JSON", (Option<IRI>)new Some((Object)i), this.fromString$default$4()).map((Function1 & Serializable)schema -> schema.addId(i));
            }
            return this.err(new StringBuilder(20).append("File ").append(i).append(" does not exist").toString());
        }
        return this.getSchemaWithExts(i, (List<Tuple2<String, String>>)new .colon.colon((Object)new Tuple2((Object)"", (Object)"ShExC"), (List)new .colon.colon((Object)new Tuple2((Object)"shex", (Object)"ShExC"), (List)new .colon.colon((Object)new Tuple2((Object)"json", (Object)"JSON"), (List)Nil$.MODULE$))), base, verbose).map((Function1 & Serializable)schema -> schema.addId(i));
    }

    public Option<Tuple2<IRI, Path>> fromIRI$default$4() {
        return None$.MODULE$;
    }

    private IO<Schema> getSchemaWithExts(IRI iri, List<Tuple2<String, String>> exts, Option<IRI> base, VerboseLevel verbose) {
        List<Tuple2<String, String>> list = exts;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Tuple2 e = (Tuple2)colon2.head();
            List es = colon2.next$access$1();
            return this.getSchemaExt(iri, (Tuple2<String, String>)e, base, verbose).orElse((Function0 & Serializable)() -> MODULE$.getSchemaWithExts(iri, (List<Tuple2<String, String>>)es, base, verbose));
        }
        if (Nil$.MODULE$.equals(list)) {
            return this.err(new StringBuilder(41).append("Can not obtain schema from iri: ").append(iri).append(", Exts: ").append(exts).append(" ").toString());
        }
        throw new MatchError(list);
    }

    private IO<Schema> getSchemaExt(IRI iri, Tuple2<String, String> pair, Option<IRI> base, VerboseLevel verbose) {
        Tuple2<String, String> tuple2 = pair;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String ext = (String)tuple2._1();
        String format = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)ext, (Object)format);
        String ext2 = (String)tuple22._1();
        String format2 = (String)tuple22._2();
        String string = ext2;
        String string2 = "";
        URI uri = !(string != null ? !string.equals(string2) : string2 != null) ? iri.uri() : iri.$plus(".").$plus(ext2).uri();
        return verbose.info(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(88).append("|getSchemaExt(iri: ").append(iri).append(", ext: ").append(ext2).append(", format: ").append(format2).append("\n                           |Effective uri to deref:").append(uri).toString()))).flatMap((Function1 & Serializable)x$15 -> {
            BoxedUnit boxedUnit = x$15;
            return MODULE$.derefUri(uri, verbose).flatMap((Function1 & Serializable)str -> verbose.debug(new StringBuilder(13).append("Str obtained\n").append(StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(str)).take(2).mkString("\n")).toString()).flatMap((Function1 & Serializable)x$14 -> {
                BoxedUnit boxedUnit = x$14;
                return MODULE$.fromString((String)str, format2, base, (Option<RDFBuilder>)None$.MODULE$).flatMap((Function1 & Serializable)schema -> verbose.details(new StringBuilder(20).append("Obtained schema at ").append(uri).append("\n").append(schema).toString()).map((Function1 & Serializable)x$13 -> {
                    BoxedUnit boxedUnit = x$13;
                    return schema;
                }));
            }));
        });
    }

    public IO<Schema> fromInputStream(InputStream is, String format, Option<IRI> base, Option<RDFBuilder> maybeRDFBuilder) {
        String formatUpperCase = format.toUpperCase();
        String string = formatUpperCase;
        switch (string == null ? 0 : string.hashCode()) {
            case 78866299: {
                if (!"SHEXC".equals(string)) break;
                InputStreamReader reader = new InputStreamReader(is);
                return (IO)Parser$.MODULE$.parseSchemaReader(reader, base).fold((Function1 & Serializable)e -> MODULE$.err((String)e), (Function1 & Serializable)v -> MODULE$.ok(v));
            }
            case 78866306: {
                if (!"SHEXJ".equals(string)) break;
                return this.getContents(is).flatMap((Function1 & Serializable)str -> (IO)EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(package$.MODULE$.decode(str, decoderShEx$.MODULE$.decodeSchema())), (Function1 & Serializable)x$16 -> x$16.getMessage()).fold((Function1 & Serializable)e -> MODULE$.err((String)e), (Function1 & Serializable)v -> MODULE$.ok(v)));
            }
        }
        Option<RDFBuilder> option = maybeRDFBuilder;
        if (None$.MODULE$.equals(option)) {
            return this.err(new StringBuilder(65).append("Not implemented ShEx parser for format ").append(format).append(" and no rdfReader provided").toString());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            RDFBuilder rdfBuilder = (RDFBuilder)some.value();
            if (this.rdfDataFormats((RDFReader)rdfBuilder).contains((Object)formatUpperCase)) {
                return this.getContents(is).flatMap((Function1 & Serializable)str -> rdfBuilder.fromString(str, formatUpperCase, base).flatMap((Function1 & Serializable)x$17 -> (IO)x$17.use((Function1 & Serializable)rdf -> RDF2ShEx$.MODULE$.rdf2Schema((RDFReader)rdf).flatMap((Function1 & Serializable)eitherSchema -> ((IO)eitherSchema.fold((Function1 & Serializable)e -> MODULE$.err((String)e), (Function1 & Serializable)v -> MODULE$.ok(v))).map((Function1 & Serializable)schema -> schema)), (MonadCancel)IO$.MODULE$.asyncForIO())));
            }
            return this.err(new StringBuilder(39).append("Not implemented ShEx parser for format ").append(format).toString());
        }
        throw new MatchError(option);
    }

    public String fromInputStream$default$2() {
        return "ShExC";
    }

    public Option<IRI> fromInputStream$default$3() {
        return None$.MODULE$;
    }

    public Option<RDFBuilder> fromInputStream$default$4() {
        return None$.MODULE$;
    }

    private <A> IO<A> err(String msg) {
        return IO$.MODULE$.raiseError((Throwable)new RuntimeException(msg));
    }

    private <A> IO<A> ok(A v) {
        return IO$.MODULE$.pure(v);
    }

    public IO<String> serialize(Schema schema, String format, Option<IRI> base, RDFBuilder rdfBuilder) {
        String formatUpperCase = format.toUpperCase();
        Schema relativeSchema = schema.relativize(base);
        String string = formatUpperCase;
        switch (string == null ? 0 : string.hashCode()) {
            case 78866299: {
                if (!"SHEXC".equals(string)) break;
                return IO$.MODULE$.pure((Object)CompactShow$.MODULE$.showSchema(relativeSchema, CompactShow$.MODULE$.showSchema$default$2(), CompactShow$.MODULE$.showSchema$default$3()));
            }
            case 78866306: {
                if (!"SHEXJ".equals(string)) break;
                return IO$.MODULE$.pure((Object)package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)relativeSchema), encoderShEx$.MODULE$.encodeSchema()).spaces2());
            }
        }
        if (this.rdfDataFormats((RDFReader)rdfBuilder).contains((Object)formatUpperCase)) {
            return rdfBuilder.empty().flatMap((Function1 & Serializable)x$18 -> (IO)x$18.use((Function1 & Serializable)empty -> ShEx2RDF$.MODULE$.apply(relativeSchema, (Option<IRI>)None$.MODULE$, (RDFBuilder)empty).flatMap((Function1 & Serializable)rdf -> rdf.serialize(formatUpperCase, base).map((Function1 & Serializable)str -> str)), (MonadCancel)IO$.MODULE$.asyncForIO()));
        }
        return this.err(new StringBuilder(40).append("Not implemented conversion to ").append(format).append(". Schema: ").append(schema).toString());
    }

    public IO<Schema> fromFile(String fileName, String format, Option<IRI> base, Option<RDFBuilder> maybeRDFBuilder) {
        return FileUtils$.MODULE$.getContents(Paths.get(fileName, new String[0])).flatMap((Function1 & Serializable)cs -> MODULE$.fromString((String)cs, format, base, maybeRDFBuilder).map((Function1 & Serializable)schema -> schema));
    }

    public String fromFile$default$2() {
        return "ShExC";
    }

    public Option<IRI> fromFile$default$3() {
        return None$.MODULE$;
    }

    public Option<RDFBuilder> fromFile$default$4() {
        return None$.MODULE$;
    }

    public IO<Schema> fromString(String str, String format, Option<IRI> base, Option<RDFBuilder> maybeRDFBuilder) {
        ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes());
        return this.fromInputStream(is, format, base, maybeRDFBuilder).map((Function1 & Serializable)schema -> schema);
    }

    public String fromString$default$2() {
        return "ShExC";
    }

    public Option<IRI> fromString$default$3() {
        return None$.MODULE$;
    }

    public Option<RDFBuilder> fromString$default$4() {
        return None$.MODULE$;
    }

    private IO<String> derefUri(URI uri, VerboseLevel verbose) {
        return (IO)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            URLConnection urlCon = uri.toURL().openConnection();
            urlCon.setConnectTimeout(10000);
            urlCon.setReadTimeout(10000);
            InputStream is = urlCon.getInputStream();
            return Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
        }).fold((Function1 & Serializable)e -> {
            verbose.info(new StringBuilder(27).append("Error trying to access ").append(uri).append(": ").append(e.getMessage()).append("\n").append(e.getClass()).append("\n").toString());
            return IO$.MODULE$.raiseError(e);
        }, (Function1 & Serializable)x$19 -> IO$.MODULE$.apply((Function0 & Serializable)() -> x$19));
    }

    private IO<String> getContents(InputStream is) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString());
    }

    public Schema apply(IRI id, Option<PrefixMap> prefixes, Option<IRI> base, Option<List<SemAct>> startActs, Option<ShapeExpr> start, Option<List<ShapeExpr>> shapes, Option<Map<ShapeLabel, TripleExpr>> optTripleExprMap, List<IRI> imports, Option<Map<ShapeLabel, Location>> labelLocationMap) {
        return new Schema(id, prefixes, base, startActs, start, shapes, optTripleExprMap, imports, labelLocationMap);
    }

    public Option<Tuple9<IRI, Option<PrefixMap>, Option<IRI>, Option<List<SemAct>>, Option<ShapeExpr>, Option<List<ShapeExpr>>, Option<Map<ShapeLabel, TripleExpr>>, List<IRI>, Option<Map<ShapeLabel, Location>>>> unapply(Schema x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple9((Object)x$0.id(), x$0.prefixes(), x$0.base(), x$0.startActs(), x$0.start(), x$0.shapes(), x$0.optTripleExprMap(), x$0.imports(), x$0.labelLocationMap()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Schema$.class);
    }

    private Schema$() {
    }
}

