/*
 * Decompiled with CFR 0.152.
 */
package es.weso.shex.btValidator;

import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.data.package$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.EitherOps$;
import es.weso.rdf.RDFReader;
import es.weso.rdf.nodes.RDFNode;
import es.weso.shapemaps.ShapeMapLabel;
import es.weso.shex.Schema;
import es.weso.shex.TripleConstraint;
import es.weso.shex.TripleExpr;
import es.weso.shex.VarName;
import es.weso.shex.VarTable;
import es.weso.shex.btValidator.BtValidator;
import es.weso.shex.btValidator.ShExErr;
import es.weso.shex.btValidator.StringErr;
import es.weso.shex.btValidator.Unimplemented;
import es.weso.typing.Typing;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.util.Either;

public final class BtValidator$ {
    public static final BtValidator$ MODULE$ = new BtValidator$();

    public EitherT<Kleisli, ShExErr, RDFReader> getRDF() {
        Kleisli r = package$.MODULE$.ReaderT().ask((Applicative)IO$.MODULE$.asyncForIO());
        return EitherT$.MODULE$.liftF((Object)r.map((Function1 & Serializable)x$1 -> x$1.rdf(), (Functor)IO$.MODULE$.asyncForIO()), (Functor)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public EitherT<Kleisli, ShExErr, Schema> getSchema() {
        Kleisli r = package$.MODULE$.ReaderT().ask((Applicative)IO$.MODULE$.asyncForIO());
        return EitherT$.MODULE$.liftF((Object)r.map((Function1 & Serializable)x$2 -> x$2.schema(), (Functor)IO$.MODULE$.asyncForIO()), (Functor)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public EitherT<Kleisli, ShExErr, Typing<RDFNode, ShapeMapLabel, ShExErr, List<String>>> getTyping() {
        Kleisli r = package$.MODULE$.ReaderT().ask((Applicative)IO$.MODULE$.asyncForIO());
        return EitherT$.MODULE$.liftF((Object)r.map((Function1 & Serializable)x$3 -> x$3.typing(), (Functor)IO$.MODULE$.asyncForIO()), (Functor)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public <A> EitherT<Kleisli, ShExErr, List<A>> fromStream(Stream<IO, A> s) {
        return this.fromIO((IO)s.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).toList());
    }

    public <A> EitherT<Kleisli, ShExErr, A> fromIO(IO<A> io) {
        return EitherT$.MODULE$.liftF((Object)Kleisli$.MODULE$.liftF(io), (Functor)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public EitherT<Kleisli, ShExErr, VarTable> getVarTable() {
        Kleisli r = package$.MODULE$.ReaderT().ask((Applicative)IO$.MODULE$.asyncForIO());
        return EitherT$.MODULE$.liftF((Object)r.map((Function1 & Serializable)x$4 -> x$4.table(), (Functor)IO$.MODULE$.asyncForIO()), (Functor)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public <A> EitherT<Kleisli, ShExErr, A> local(Function1<BtValidator.Env, BtValidator.Env> f, EitherT<?, ShExErr, A> c) {
        return new EitherT((Object)((Kleisli)c.value()).local(f));
    }

    public <A> EitherT<Kleisli, ShExErr, A> localWithTable(Function1<VarTable, VarTable> f, EitherT<Kleisli, ShExErr, A> c) {
        return this.local((Function1<BtValidator.Env, BtValidator.Env>)BtValidator$.fn$1(f), c);
    }

    public <A> EitherT<Kleisli, ShExErr, A> localWithTyping(Function1<Typing<RDFNode, ShapeMapLabel, ShExErr, List<String>>, Typing<RDFNode, ShapeMapLabel, ShExErr, List<String>>> f, EitherT<Kleisli, ShExErr, A> c) {
        return this.local((Function1<BtValidator.Env, BtValidator.Env>)BtValidator$.fn$2(f), c);
    }

    public <A> EitherT<Kleisli, ShExErr, A> ok(A x) {
        return (EitherT)ApplicativeIdOps$.MODULE$.pure$extension(implicits$.MODULE$.catsSyntaxApplicativeId(x), (Applicative)EitherT$.MODULE$.catsDataMonadErrorForEitherT((Monad)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO())));
    }

    public <A> EitherT<Kleisli, ShExErr, A> err(ShExErr e) {
        return EitherT.LeftTPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.leftT(), (Object)e, (Applicative)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public <A> EitherT<Kleisli, ShExErr, A> unimplemented(String msg) {
        return this.err(new Unimplemented(msg));
    }

    public <A> EitherT<Kleisli, ShExErr, A> fromEither(Either<String, A> e) {
        return EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(e), (Function1 & Serializable)x$5 -> new StringErr((String)x$5)), (Applicative)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO()));
    }

    public EitherT<Kleisli, ShExErr, Tuple2<Typing<RDFNode, ShapeMapLabel, ShExErr, List<String>>, VarTable>> checkNodeTripleExpr(RDFNode node, TripleExpr te) {
        TripleExpr tripleExpr = te;
        if (tripleExpr instanceof TripleConstraint) {
            TripleConstraint tripleConstraint = (TripleConstraint)tripleExpr;
            return this.checkNodeTripleConstraint(node, tripleConstraint);
        }
        return this.unimplemented(new StringBuilder(21).append("checkNodeTripleExpr: ").append(te).toString());
    }

    public EitherT<Kleisli, ShExErr, Tuple2<Typing<RDFNode, ShapeMapLabel, ShExErr, List<String>>, VarTable>> checkNodeTripleConstraint(RDFNode node, TripleConstraint tc) {
        if (tc.direct()) {
            return this.getRDF().flatMap((Function1 & Serializable)rdf -> MODULE$.fromStream(rdf.triplesWithSubjectPredicate(node, tc.predicate())).flatMap((Function1 & Serializable)triples -> MODULE$.getTyping().flatMap((Function1 & Serializable)typing -> MODULE$.getVarTable().map((Function1 & Serializable)table -> {
                VarTable varTable;
                Option<VarName> option = tc.optVariableDecl();
                if (None$.MODULE$.equals(option)) {
                    varTable = table;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    String name = ((VarName)some.value()).str();
                    varTable = table.set(name, (List<RDFNode>)triples.map((Function1 & Serializable)x$6 -> x$6.obj()).toList());
                } else {
                    throw new MatchError(option);
                }
                VarTable newTable = varTable;
                return new Tuple2(typing, (Object)newTable);
            }, (Functor)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO())), (Monad)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO())), (Monad)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO())), (Monad)Kleisli$.MODULE$.catsDataMonadErrorForKleisli((MonadError)IO$.MODULE$.asyncForIO()));
        }
        return this.unimplemented("checkTripleConstraint with inverse ");
    }

    private static final Function1 fn$1(Function1 f$1) {
        return (Function1 & Serializable)e -> {
            VarTable x$1 = (VarTable)f$1.apply((Object)e.table());
            RDFReader x$2 = e.copy$default$1();
            Schema x$3 = e.copy$default$2();
            Typing<RDFNode, ShapeMapLabel, ShExErr, List<String>> x$4 = e.copy$default$3();
            return e.copy(x$2, x$3, x$4, x$1);
        };
    }

    private static final Function1 fn$2(Function1 f$2) {
        return (Function1 & Serializable)e -> {
            Typing x$1 = (Typing)f$2.apply(e.typing());
            RDFReader x$2 = e.copy$default$1();
            Schema x$3 = e.copy$default$2();
            VarTable x$4 = e.copy$default$4();
            return e.copy(x$2, x$3, (Typing<RDFNode, ShapeMapLabel, ShExErr, List<String>>)x$1, x$4);
        };
    }

    private BtValidator$() {
    }
}

